/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.images;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import javax.swing.Icon;

public class Logo
implements Icon {
    private static int DEFAULT_WIDTH = 877;
    private static int DEFAULT_HEIGHT = 958;
    private int width;
    private int height;
    private BufferedImage image;

    public Logo() {
        this.width = DEFAULT_WIDTH;
        this.height = DEFAULT_HEIGHT;
    }

    public Logo(int size) {
        this.width = size;
        this.height = size;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    public Image getImage() {
        if (this.image == null) {
            this.image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
            double coef = Math.min((double)this.width / 878.0, (double)this.height / 959.0);
            Graphics2D g2d = this.image.createGraphics();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.scale(coef, coef);
            Logo.paint(g2d);
            g2d.dispose();
        }
        return this.image;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        g.drawImage(this.getImage(), x, y, null);
    }

    private static void paint(Graphics2D g) {
        RectangularShape shape = null;
        LinkedList<AffineTransform> transformations = new LinkedList<AffineTransform>();
        transformations.offer(g.getTransform());
        g.transform(new AffineTransform(1.0666667f, 0.0f, 0.0f, 1.0666667f, 0.0f, 0.0f));
        transformations.offer(g.getTransform());
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 866.58136f, 295.00067f));
        shape = new Rectangle2D.Double(-866.2532958984375, -293.96893310546875, 821.3438720703125, 897.3438720703125);
        g.setPaint(new RadialGradientPaint(new Point2D.Double(-448.5714111328125, 384.494f), 514.7857f, new Point2D.Double(-448.5714111328125, 384.494f), new float[]{0.0f, 1.0f}, new Color[]{new Color(263172), new Color(0x333333)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(0.7985288f, 0.0f, 0.0f, 0.872094f, -97.38416f, -180.61191f)));
        g.fill(shape);
        g.setPaint(Color.BLACK);
        g.setStroke(new BasicStroke(0.6561659f, 0, 0, 4.0f));
        g.draw(shape);
        shape = new RoundRectangle2D.Double(-706.5104370117188, -237.91339111328125, 498.2328186035156, 245.23281860351562, 63.69683837890625, 63.69683837890625);
        g.setPaint(new LinearGradientPaint(new Point2D.Double(-788.5, -183.63778686523438), new Point2D.Double(-113.5, -183.63778686523438), new float[]{0.0f, 1.0f}, new Color[]{new Color(1473201), new Color(9558508)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(0.73921794f, 0.0f, 0.0f, 0.79621047f, -124.00672f, 30.917376f)));
        g.fill(shape);
        g.setPaint(Color.BLACK);
        g.setStroke(new BasicStroke(0.76718515f, 0, 0, 4.0f));
        g.draw(shape);
        shape = new RoundRectangle2D.Double(-706.5103759765625, 28.08660888671875, 498.2328186035156, 245.23281860351562, 63.69683837890625, 63.69683837890625);
        g.setPaint(new LinearGradientPaint(new Point2D.Double(-788.5, 148.36221313476562), new Point2D.Double(-113.5, 148.36221313476562), new float[]{0.0f, 1.0f}, new Color[]{new Color(1473201), new Color(9558508)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(0.7392179f, 0.0f, 0.0f, 0.7962104f, -124.00676f, 32.57547f)));
        g.fill(shape);
        g.setPaint(Color.BLACK);
        g.setStroke(new BasicStroke(0.7671851f, 0, 0, 4.0f));
        g.draw(shape);
        shape = new RoundRectangle2D.Double(-706.5103759765625, 294.0866f, 498.2328186035156, 245.23281860351562, 63.69683837890625, 63.69683837890625);
        g.setPaint(new LinearGradientPaint(new Point2D.Double(-788.5, 482.3622131347656), new Point2D.Double(-113.5, 482.3622131347656), new float[]{0.0f, 1.0f}, new Color[]{new Color(1473201), new Color(9558508)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(0.7392179f, 0.0f, 0.0f, 0.7962104f, -124.00676f, 32.64117f)));
        g.fill(shape);
        g.setPaint(Color.BLACK);
        g.draw(shape);
        shape = new Rectangle2D.Double(-820.3513793945312, -237.98419189453125, 71.20879364013672, 71.20879364013672);
        g.setPaint(Color.WHITE);
        g.fill(shape);
        g.setPaint(Color.BLACK);
        g.setStroke(new BasicStroke(0.79120874f, 0, 0, 4.0f));
        g.draw(shape);
        shape = new Rectangle2D.Double(-820.3513793945312, 119.90274047851562, 71.20879364013672, 71.20879364013672);
        g.setPaint(Color.WHITE);
        g.fill(shape);
        g.setPaint(Color.BLACK);
        g.draw(shape);
        shape = new Rectangle2D.Double(-820.3513793945312, -59.04019f, 71.20879364013672, 71.20879364013672);
        g.setPaint(Color.WHITE);
        g.fill(shape);
        g.setPaint(Color.BLACK);
        g.draw(shape);
        shape = new Rectangle2D.Double(-820.3513793945312, 294.0548095703125, 71.20879364013672, 71.20879364013672);
        g.setPaint(Color.WHITE);
        g.fill(shape);
        g.setPaint(Color.BLACK);
        g.draw(shape);
        shape = new Rectangle2D.Double(-820.3513793945312, 468.2068176269531, 71.20879364013672, 71.20879364013672);
        g.setPaint(Color.WHITE);
        g.fill(shape);
        g.setPaint(Color.BLACK);
        g.draw(shape);
        shape = new Rectangle2D.Double(-161.3174f, -237.98419189453125, 71.20879364013672, 71.20879364013672);
        g.setPaint(Color.WHITE);
        g.fill(shape);
        g.setPaint(Color.BLACK);
        g.draw(shape);
        shape = new Rectangle2D.Double(-161.3174f, 119.90274047851562, 71.20879364013672, 71.20879364013672);
        g.setPaint(Color.WHITE);
        g.fill(shape);
        g.setPaint(Color.BLACK);
        g.draw(shape);
        shape = new Rectangle2D.Double(-161.3174f, -59.04019f, 71.20879364013672, 71.20879364013672);
        g.setPaint(Color.WHITE);
        g.fill(shape);
        g.setPaint(Color.BLACK);
        g.draw(shape);
        shape = new Rectangle2D.Double(-161.3174f, 294.0548095703125, 71.20879364013672, 71.20879364013672);
        g.setPaint(Color.WHITE);
        g.fill(shape);
        g.setPaint(Color.BLACK);
        g.draw(shape);
        shape = new Rectangle2D.Double(-161.3174f, 468.2068176269531, 71.20879364013672, 71.20879364013672);
        g.setPaint(Color.WHITE);
        g.fill(shape);
        g.setPaint(Color.BLACK);
        g.draw(shape);
        g.setTransform((AffineTransform)transformations.poll());
        g.setTransform((AffineTransform)transformations.poll());
    }
}

