/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.dialogs;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.tinymediamanager.Globals;
import org.tinymediamanager.ui.EqualsLayout;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.settings.SettingsPanel;

public class SettingsDialog
extends TmmDialog {
    private static final long serialVersionUID = 2435834806519338339L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static JDialog instance;

    public static JDialog getInstance() {
        if (instance == null) {
            instance = new SettingsDialog();
        }
        return instance;
    }

    private SettingsDialog() {
        super(BUNDLE.getString("tmm.settings"), "settings");
        Rectangle bounds = MainWindow.getActiveInstance().getBounds();
        this.setBounds(bounds.x + bounds.width / 40, bounds.y + bounds.height / 20, (int)((double)bounds.width * 0.95), (int)((double)bounds.height * 0.9));
        SettingsPanel panelSettings = new SettingsPanel();
        this.getContentPane().add((Component)panelSettings, "Center");
        JPanel panelButtons = new JPanel();
        EqualsLayout layout = new EqualsLayout(5);
        layout.setMinWidth(100);
        panelButtons.setLayout(layout);
        panelButtons.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.getContentPane().add((Component)panelButtons, "South");
        JButton okButton = new JButton(BUNDLE.getString("Button.close"));
        panelButtons.add((Component)okButton, "2, 1, fill, top");
        okButton.setAction(new CloseAction());
        this.getRootPane().setDefaultButton(okButton);
    }

    @Override
    public void setVisible(boolean visible) {
        if (!visible) {
            Globals.settings.saveSettings();
        }
        super.setVisible(visible);
    }

    @Override
    public void pack() {
    }

    private class CloseAction
    extends AbstractAction {
        private static final long serialVersionUID = 2386371884117941373L;

        public CloseAction() {
            this.putValue("Name", BUNDLE.getString("Button.close"));
            this.putValue("SmallIcon", IconManager.APPLY);
            this.putValue("SwingLargeIconKey", IconManager.APPLY);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SettingsDialog.this.setVisible(false);
        }
    }
}

