/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.dialogs;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Timer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.ui.TmmUILogAppender;
import org.tinymediamanager.ui.TmmUILogCollector;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class LogDialog
extends TmmDialog
implements ActionListener {
    private static final long serialVersionUID = -5054005564554148578L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final Logger LOGGER = LoggerFactory.getLogger(LogDialog.class);
    private static final int REFRESH_PERIOD = 1000;
    private JTextArea taLogs;
    private int logByteCount = 0;
    private final Timer timerRefresh;

    public LogDialog() {
        super(BUNDLE.getString("logwindow.title"), "log");
        this.setBounds(5, 5, 1000, 590);
        this.timerRefresh = new Timer(1000, this);
        this.timerRefresh.setInitialDelay(0);
        this.getContentPane().setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC}));
        JScrollPane scrollPane = new JScrollPane();
        this.getContentPane().add((Component)scrollPane, "2, 2, fill, fill");
        this.taLogs = new JTextArea();
        scrollPane.setViewportView(this.taLogs);
        this.taLogs.setEditable(false);
        this.taLogs.setWrapStyleWord(true);
        this.taLogs.setLineWrap(true);
        this.taLogs.setText(TmmUILogCollector.instance.getLogOutput().getContent());
        JButton btnClose = new JButton(BUNDLE.getString("Button.close"));
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LogDialog.this.setVisible(false);
            }
        });
        this.getContentPane().add((Component)btnClose, "2, 4, right, default");
        this.timerRefresh.start();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.timerRefresh) {
            this.updateApplicationLog();
        }
    }

    @Override
    public void pack() {
    }

    private void updateApplicationLog() {
        boolean append = this.logByteCount > 0;
        TmmUILogAppender.LogOutput logOutput = TmmUILogCollector.instance.getLogOutput(this.logByteCount);
        this.logByteCount = logOutput.getByteCount();
        String content = logOutput.getContent();
        if (content.length() > 0) {
            if (append) {
                Document doc = this.taLogs.getDocument();
                try {
                    doc.insertString(doc.getLength(), content, null);
                }
                catch (BadLocationException ble) {
                    LOGGER.error("bad location: ", (Throwable)ble);
                }
            } else {
                this.taLogs.setText(content);
            }
            this.taLogs.setCaretPosition(this.taLogs.getText().length());
        }
    }
}

