/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class ZebraJTable
extends JTable {
    private static final long serialVersionUID = -5461344983450088208L;
    private static final Color EVEN_ROW_COLOR = new Color(241, 245, 250);
    private static final Color TABLE_GRID_COLOR = new Color(0xD9D9D9);
    private static final CellRendererPane CELL_RENDER_PANE = new CellRendererPane();
    private ArrayList<TableColumn> indexedColumns = new ArrayList();
    private Map<Object, TableColumn> hiddenColumns = new HashMap<Object, TableColumn>();

    public ZebraJTable() {
        this.init();
    }

    public ZebraJTable(TableModel dm) {
        this.setModel(dm);
        this.init();
    }

    private void init() {
        this.setAutoResizeMode(2);
        this.setTableHeader(this.createTableHeader());
        this.getTableHeader().setReorderingAllowed(false);
        this.setOpaque(false);
        this.setNewFontSize(this.getFont().getSize());
        this.setGridColor(TABLE_GRID_COLOR);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setShowGrid(false);
        Enumeration<TableColumn> enumeration = this.columnModel.getColumns();
        while (enumeration.hasMoreElements()) {
            this.indexedColumns.add(enumeration.nextElement());
        }
    }

    public void setNewFontSize(float size) {
        this.setFont(this.getFont().deriveFont(size));
        FontMetrics fm = this.getFontMetrics(this.getFont());
        this.setRowHeight(fm.getHeight() + 4);
    }

    private JTableHeader createTableHeader() {
        return new JTableHeader(this.getColumnModel()){
            private static final long serialVersionUID = -7676154270682107643L;

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                JViewport viewport = (JViewport)this.table.getParent();
                if (viewport != null && this.table.getWidth() < viewport.getWidth()) {
                    int x = this.table.getWidth();
                    int width = viewport.getWidth() - this.table.getWidth();
                    ZebraJTable.paintHeader(g, this.getTable(), x, width);
                }
            }
        };
    }

    private static void paintHeader(Graphics g, JTable table, int x, int width) {
        TableCellRenderer renderer = table.getTableHeader().getDefaultRenderer();
        Component component = renderer.getTableCellRendererComponent(table, "", false, false, -1, 0);
        component.setBounds(0, 0, width, table.getTableHeader().getHeight());
        ((JComponent)component).setOpaque(false);
        CELL_RENDER_PANE.paintComponent(g, component, null, x, 0, width, table.getTableHeader().getHeight(), true);
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component component = super.prepareRenderer(renderer, row, column);
        if (component instanceof JComponent) {
            ((JComponent)component).setOpaque(this.getSelectionModel().isSelectedIndex(row));
        }
        return component;
    }

    public void hideColumn(Object identifier) {
        int index = this.columnModel.getColumnIndex(identifier);
        TableColumn column = this.columnModel.getColumn(index);
        if (this.hiddenColumns.put(identifier, column) != null) {
            throw new IllegalArgumentException("Duplicate column name.");
        }
        this.columnModel.removeColumn(column);
    }

    public void showColumn(Object identifier) {
        TableColumn tableCloumn = this.hiddenColumns.remove(identifier);
        if (tableCloumn != null) {
            int index;
            int originIndex = this.indexedColumns.indexOf(tableCloumn);
            int newIndex = 0;
            Enumeration<TableColumn> enumeration = this.columnModel.getColumns();
            while (enumeration.hasMoreElements() && (index = this.indexedColumns.indexOf(enumeration.nextElement())) <= originIndex) {
                ++newIndex;
            }
            this.columnModel.addColumn(tableCloumn);
            int lastColumn = this.columnModel.getColumnCount() - 1;
            if (newIndex < lastColumn) {
                this.columnModel.moveColumn(lastColumn, newIndex);
            }
        }
    }

    public static JScrollPane createStripedJScrollPane(JTable table) {
        JScrollPane scrollPane = new JScrollPane(table);
        scrollPane.setViewport(new StripedViewport(table));
        scrollPane.getViewport().setView(table);
        scrollPane.setCorner("UPPER_RIGHT_CORNER", ZebraJTable.createCornerComponent(table));
        return scrollPane;
    }

    private static JComponent createCornerComponent(final JTable table) {
        return new JComponent(){
            private static final long serialVersionUID = -6612112068796852330L;

            @Override
            protected void paintComponent(Graphics g) {
                ZebraJTable.paintHeader(g, table, 0, this.getWidth());
            }
        };
    }

    private static class StripedViewport
    extends JViewport {
        private static final long serialVersionUID = 7213871940348239879L;
        private final JTable fTable;

        private StripedViewport(JTable table) {
            this.fTable = table;
            this.setOpaque(false);
            this.initListeners();
        }

        private void initListeners() {
            PropertyChangeListener listener = this.createTableColumnWidthListener();
            for (int i = 0; i < this.fTable.getColumnModel().getColumnCount(); ++i) {
                this.fTable.getColumnModel().getColumn(i).addPropertyChangeListener(listener);
            }
        }

        private PropertyChangeListener createTableColumnWidthListener() {
            return new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    StripedViewport.this.repaint();
                }
            };
        }

        @Override
        protected void paintComponent(Graphics g) {
            this.paintStripedBackground(g);
            this.paintVerticalGridLines(g);
            super.paintComponent(g);
        }

        private void paintStripedBackground(Graphics g) {
            int currentRow;
            Point viewPosition = this.getViewPosition();
            g.translate(0, -viewPosition.y);
            int rowAtPoint = this.fTable.rowAtPoint(g.getClipBounds().getLocation());
            int topY = rowAtPoint < 0 ? g.getClipBounds().y : this.fTable.getCellRect((int)rowAtPoint, (int)0, (boolean)true).y;
            int n = currentRow = rowAtPoint < 0 ? 0 : rowAtPoint;
            while (topY < g.getClipBounds().y + g.getClipBounds().height) {
                int bottomY = topY + this.fTable.getRowHeight(currentRow);
                g.setColor(this.getRowColor(currentRow));
                g.fillRect(g.getClipBounds().x, topY, g.getClipBounds().width, bottomY);
                topY = bottomY;
                ++currentRow;
            }
            g.translate(0, viewPosition.y);
        }

        @Override
        public void setViewPosition(Point p) {
            super.setViewPosition(p);
            this.repaint();
        }

        private Color getRowColor(int row) {
            return row % 2 == 0 ? EVEN_ROW_COLOR : Color.WHITE;
        }

        private void paintVerticalGridLines(Graphics g) {
            int offset = this.getViewPosition().x;
            int x = -offset;
            for (int i = 0; i < this.fTable.getColumnCount(); ++i) {
                TableColumn column = this.fTable.getColumnModel().getColumn(i);
                if ((x += column.getWidth()) < 0) continue;
                g.setColor(TABLE_GRID_COLOR);
                g.drawLine(x - 1, g.getClipBounds().y, x - 1, this.getHeight());
            }
        }
    }
}

