/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.ui.components.TaskListComponent;

public class PopupPane
extends JScrollPane {
    private static final long serialVersionUID = 4151412495928010232L;
    private JPanel view;
    private HashSet<TaskListComponent> listComponents;

    public PopupPane() {
        this.setName("progresspopup");
        this.setVerticalScrollBarPolicy(20);
        this.setHorizontalScrollBarPolicy(31);
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        this.listComponents = new HashSet();
        this.view = new JPanel();
        this.setViewportView(this.view);
        GridLayout grid = new GridLayout(0, 1);
        grid.setHgap(0);
        grid.setVgap(0);
        this.view.setLayout(grid);
        this.view.setBorder(BorderFactory.createEmptyBorder());
    }

    public void addListComponent(TaskListComponent lst) {
        this.listComponents.add(lst);
        if (this.view.getComponentCount() > 0) {
            JComponent previous = (JComponent)this.view.getComponent(this.view.getComponentCount() - 1);
            previous.setBorder(new BottomLineBorder());
        }
        lst.setBorder(BorderFactory.createEmptyBorder());
        this.view.add(lst);
        if (this.listComponents.size() > 5) {
            this.setVerticalScrollBarPolicy(22);
        } else {
            this.setVerticalScrollBarPolicy(21);
        }
    }

    public void removeListComponent(TmmTaskHandle handle) {
        Iterator<TaskListComponent> it = this.listComponents.iterator();
        while (it.hasNext()) {
            TaskListComponent comp = it.next();
            if (comp.getHandle() != handle) continue;
            this.view.remove(comp);
            it.remove();
            break;
        }
        if (this.listComponents.size() > 5) {
            this.setVerticalScrollBarPolicy(22);
        } else {
            this.setVerticalScrollBarPolicy(21);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        int count = this.view.getComponentCount();
        int height = count > 0 ? this.view.getComponent((int)0).getPreferredSize().height : 0;
        int offset = count > 5 ? height * 5 + 5 : count * height + 5;
        return new Dimension(count > 5 ? 422 : 402, offset);
    }

    private class BottomLineBorder
    implements Border {
        private Insets ins = new Insets(0, 0, 1, 0);
        private Color col = new Color(221, 229, 248);

        @Override
        public Insets getBorderInsets(Component c) {
            return this.ins;
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Color old = g.getColor();
            g.setColor(this.col);
            g.drawRect(x, y + height - 2, width, 1);
            g.setColor(old);
        }
    }
}

