/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.IMessageListener;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.ui.UTF8Control;

public class TmmUIMessageCollector
extends AbstractModelObject
implements IMessageListener {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    public static final TmmUIMessageCollector instance = new TmmUIMessageCollector();
    private final EventList<Message> messages = GlazedLists.threadSafeList((EventList)new BasicEventList());
    private int newMessages = 0;

    private TmmUIMessageCollector() {
    }

    @Override
    public void pushMessage(final Message message) {
        if (message.getMessageLevel() == Message.MessageLevel.SEVERE) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String sender = "";
                    try {
                        sender = Utils.replacePlaceholders(BUNDLE.getString(message.getMessageSender().toString()), message.getSenderParams());
                    }
                    catch (Exception e) {
                        sender = String.valueOf(message.getMessageSender());
                    }
                    String text = "";
                    try {
                        text = Utils.replacePlaceholders(BUNDLE.getString(message.getMessageId()), message.getIdParams());
                    }
                    catch (Exception e) {
                        text = String.valueOf(message.getMessageId());
                    }
                    JOptionPane.showMessageDialog(null, text, sender, 0);
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TmmUIMessageCollector.this.messages.add((Object)message);
                    int oldValue = TmmUIMessageCollector.this.newMessages;
                    TmmUIMessageCollector.this.newMessages++;
                    TmmUIMessageCollector.this.firePropertyChange("messages", oldValue, TmmUIMessageCollector.this.newMessages);
                }
            });
        }
    }

    public int getMessageCount() {
        return this.messages.size();
    }

    public int getNewMessagesCount() {
        return this.newMessages;
    }

    public void resetNewMessageCount() {
        int oldValue = this.newMessages;
        this.newMessages = 0;
        this.firePropertyChange("messages", oldValue, this.newMessages);
    }

    public EventList<Message> getMessages() {
        return this.messages;
    }
}

