/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui;

import java.awt.Desktop;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.components.NativeFileChooser;

public class TmmUIHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmmUIHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Path selectDirectory(String title, String initialPath) {
        if (SystemUtils.IS_OS_MAC || SystemUtils.IS_OS_MAC_OSX) {
            try {
                Path path = TmmUIHelper.openDirectoryDialog(title, initialPath);
                return path;
            }
            catch (Error | Exception e) {
                LOGGER.warn("cannot open AWT directory chooser" + e.getMessage());
            }
            finally {
                System.setProperty("apple.awt.fileDialogForDirectories", "false");
            }
        }
        return TmmUIHelper.openJFileChooser(1, title, initialPath, true, null, null);
    }

    private static Path openDirectoryDialog(String title, String initialPath) throws Exception, Error {
        Path path;
        System.setProperty("apple.awt.fileDialogForDirectories", "true");
        FileDialog chooser = new FileDialog((Frame)MainWindow.getFrame(), title);
        if (StringUtils.isNotBlank((CharSequence)initialPath) && Files.exists(path = Paths.get(initialPath, new String[0]), new LinkOption[0])) {
            chooser.setDirectory(path.toFile().getAbsolutePath());
        }
        chooser.setVisible(true);
        System.setProperty("apple.awt.fileDialogForDirectories", "false");
        if (StringUtils.isNotEmpty((CharSequence)chooser.getFile())) {
            return Paths.get(chooser.getDirectory(), chooser.getFile());
        }
        return null;
    }

    private static Path openJFileChooser(int mode, String dialogTitle, String initialPath, boolean open, String filename, FileNameExtensionFilter filter) {
        Path path;
        JFileChooser fileChooser = null;
        if ("true".equals(System.getProperty("tmm.legacy.filechooser"))) {
            fileChooser = new JFileChooser();
        } else if (StringUtils.isNotBlank((CharSequence)initialPath) && Files.exists(path = Paths.get(initialPath, new String[0]), new LinkOption[0])) {
            fileChooser = new NativeFileChooser(path.toFile());
        }
        if (fileChooser == null) {
            fileChooser = new NativeFileChooser();
        }
        fileChooser.setFileSelectionMode(mode);
        fileChooser.setDialogTitle(dialogTitle);
        int result = -1;
        if (open) {
            result = fileChooser.showOpenDialog(MainWindow.getFrame());
        } else {
            if (StringUtils.isNotBlank((CharSequence)filename)) {
                fileChooser.setSelectedFile(new File(filename));
                fileChooser.setFileFilter(filter);
            }
            result = fileChooser.showSaveDialog(MainWindow.getFrame());
        }
        if (result == 0) {
            return fileChooser.getSelectedFile().toPath();
        }
        return null;
    }

    public static Path selectFile(String title, String initialPath) {
        if (SystemUtils.IS_OS_MAC || SystemUtils.IS_OS_MAC_OSX) {
            try {
                return TmmUIHelper.openFileDialog(title, initialPath, 0, null);
            }
            catch (Exception e) {
                LOGGER.warn("cannot open AWT filechooser" + e.getMessage());
            }
            catch (Error e) {
                LOGGER.warn("cannot open AWT filechooser" + e.getMessage());
            }
        }
        return TmmUIHelper.openJFileChooser(0, title, initialPath, true, null, null);
    }

    private static Path openFileDialog(String title, String initialPath, int mode, String filename) throws Exception, Error {
        Path path;
        FileDialog chooser = new FileDialog((Frame)MainWindow.getFrame(), title, mode);
        if (StringUtils.isNotBlank((CharSequence)initialPath) && Files.exists(path = Paths.get(initialPath, new String[0]), new LinkOption[0])) {
            chooser.setDirectory(path.toFile().getAbsolutePath());
        }
        if (mode == 1) {
            chooser.setFile(filename);
        }
        chooser.setVisible(true);
        if (StringUtils.isNotEmpty((CharSequence)chooser.getFile())) {
            return Paths.get(chooser.getDirectory(), chooser.getFile());
        }
        return null;
    }

    public static Path saveFile(String title, String initialPath, String filename, FileNameExtensionFilter filter) {
        if (SystemUtils.IS_OS_MAC || SystemUtils.IS_OS_MAC_OSX) {
            try {
                return TmmUIHelper.openFileDialog(title, initialPath, 1, filename);
            }
            catch (Exception e) {
                LOGGER.warn("cannot open AWT filechooser" + e.getMessage());
            }
            catch (Error e) {
                LOGGER.warn("cannot open AWT filechooser" + e.getMessage());
            }
        }
        return TmmUIHelper.openJFileChooser(0, title, initialPath, false, filename, filter);
    }

    public static void openFile(Path file) throws Exception {
        String fileType = "." + FilenameUtils.getExtension((String)file.getFileName().toString());
        String abs = file.toAbsolutePath().toString();
        if (StringUtils.isNotBlank((CharSequence)Globals.settings.getMediaPlayer()) && Globals.settings.getAllSupportedFileTypes().contains(fileType)) {
            if (SystemUtils.IS_OS_MAC_OSX) {
                Runtime.getRuntime().exec(new String[]{"open", Globals.settings.getMediaPlayer(), "--args", abs});
            } else {
                Runtime.getRuntime().exec(new String[]{Globals.settings.getMediaPlayer(), abs});
            }
        } else if (SystemUtils.IS_OS_WINDOWS) {
            Runtime.getRuntime().exec(new String[]{"explorer", abs});
        } else if (SystemUtils.IS_OS_LINUX) {
            boolean started = false;
            try {
                Runtime.getRuntime().exec(new String[]{"xdg-open", abs});
                started = true;
            }
            catch (IOException e) {
                // empty catch block
            }
            if (!started) {
                try {
                    Runtime.getRuntime().exec(new String[]{"kde-open", abs});
                    started = true;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (!started) {
                try {
                    Runtime.getRuntime().exec(new String[]{"gnome-open", abs});
                    started = true;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (!started && Desktop.isDesktopSupported()) {
                Desktop.getDesktop().open(file.toFile());
            }
        } else if (Desktop.isDesktopSupported()) {
            Desktop.getDesktop().open(file.toFile());
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public static void browseUrl(String url) throws Exception {
        if (Desktop.isDesktopSupported()) {
            Desktop.getDesktop().browse(new URI(url));
        } else if (SystemUtils.IS_OS_LINUX) {
            boolean started = false;
            try {
                Runtime.getRuntime().exec(new String[]{"gnome-open", url});
                started = true;
            }
            catch (IOException e) {
                // empty catch block
            }
            if (!started) {
                try {
                    Runtime.getRuntime().exec(new String[]{"kde-open", url});
                    started = true;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (!started) {
                try {
                    Runtime.getRuntime().exec(new String[]{"xdg-open", url});
                    started = true;
                }
                catch (IOException iOException) {}
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }
}

