/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.thirdparty.upnp;

import java.io.IOException;
import org.fourthline.cling.binding.LocalServiceBindingException;
import org.fourthline.cling.binding.annotations.AnnotationLocalServiceBinder;
import org.fourthline.cling.model.DefaultServiceManager;
import org.fourthline.cling.model.ServiceManager;
import org.fourthline.cling.model.ValidationException;
import org.fourthline.cling.model.meta.DeviceDetails;
import org.fourthline.cling.model.meta.DeviceIdentity;
import org.fourthline.cling.model.meta.LocalDevice;
import org.fourthline.cling.model.meta.LocalService;
import org.fourthline.cling.model.meta.ManufacturerDetails;
import org.fourthline.cling.model.meta.ModelDetails;
import org.fourthline.cling.model.types.DeviceType;
import org.fourthline.cling.model.types.UDADeviceType;
import org.fourthline.cling.model.types.UDN;
import org.fourthline.cling.support.connectionmanager.ConnectionManagerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.ReleaseInfo;
import org.tinymediamanager.thirdparty.NetworkUtil;
import org.tinymediamanager.thirdparty.upnp.ContentDirectoryService;
import org.tinymediamanager.thirdparty.upnp.Upnp;

public class MediaServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaServer.class);

    public static LocalDevice createDevice() throws ValidationException, LocalServiceBindingException, IOException {
        DeviceIdentity identity = new DeviceIdentity(UDN.uniqueSystemIdentifier((String)"tinyMediaManager"));
        UDADeviceType type = new UDADeviceType("MediaServer", 1);
        String hostname = NetworkUtil.getMachineHostname();
        if (hostname == null) {
            hostname = Upnp.IP;
        }
        DeviceDetails details = new DeviceDetails("tinyMediaManager (" + hostname + ")", new ManufacturerDetails("tinyMediaManager", "http://www.tinymediamanager.org/"), new ModelDetails("tinyMediaManager", "tinyMediaManager - Media Server", ReleaseInfo.getVersion()));
        LOGGER.info("Hello, i'm " + identity.getUdn().getIdentifierString());
        LocalService cds = new AnnotationLocalServiceBinder().read(ContentDirectoryService.class);
        cds.setManager((ServiceManager)new DefaultServiceManager(cds, ContentDirectoryService.class));
        LocalService cms = new AnnotationLocalServiceBinder().read(ConnectionManagerService.class);
        cms.setManager((ServiceManager)new DefaultServiceManager(cms, ConnectionManagerService.class));
        return new LocalDevice(identity, (DeviceType)type, details, new LocalService[]{cds, cms});
    }
}

