/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.thirdparty;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.thirdparty.MediaInfo;
import org.w3c.dom.Element;

@XmlRootElement(name="Mediainfo")
public class MediaInfoXMLParser {
    @XmlElement(name="File")
    public List<MiFile> files;
    private long filesize = 0L;
    private int duration = 0;
    private Set<String> lang = new HashSet<String>();
    private static final String LANG_ID = "Language/String";

    public void snapshot() {
        this.filesize = 0L;
        this.duration = 0;
        for (MiFile file : this.files) {
            file.snapshot();
            this.filesize += file.getFilesize();
            this.duration += file.getDuration();
            this.lang.addAll(file.getLang());
        }
    }

    public long getFilesize() {
        return this.filesize;
    }

    public int getDuration() {
        return this.duration;
    }

    public MiFile getBiggestFile() {
        String curLang;
        LinkedHashMap info;
        long biggest = 0L;
        long longest = 0L;
        MiFile biggestFile = null;
        for (MiFile f : this.files) {
            if (f.getFilesize() == 0L) {
                if ((long)f.getDuration() <= longest) continue;
                longest = f.getDuration();
                biggestFile = f;
                continue;
            }
            if (f.getFilesize() <= biggest || f.getFilesize() <= 0x100000L) continue;
            biggest = f.getFilesize();
            biggestFile = f;
        }
        List<Map<String, String>> stream = biggestFile.snapshot.get((Object)MediaInfo.StreamKind.Audio);
        if (stream != null && (info = (LinkedHashMap)stream.get(0)) != null && StringUtils.isEmpty((CharSequence)(curLang = (String)info.get(LANG_ID)))) {
            info.put(LANG_ID, StringUtils.join(this.lang, (String)" / "));
        }
        return biggestFile;
    }

    static class MiTrack {
        @XmlAttribute
        public String type;
        @XmlAnyElement
        public List<Element> elements;

        MiTrack() {
        }
    }

    public static class MiFile {
        @XmlElement(name="track")
        public List<MiTrack> tracks;
        @XmlTransient
        public Map<MediaInfo.StreamKind, List<Map<String, String>>> snapshot;
        private long filesize = 0L;
        private long streamsize = 0L;
        private int duration = 0;
        private String filename = "";
        private Set<String> lang = new HashSet<String>();

        public Set<String> getLang() {
            return this.lang;
        }

        public long getFilesize() {
            return this.filesize > this.streamsize ? this.filesize : this.streamsize;
        }

        public int getDuration() {
            return this.duration;
        }

        public void snapshot() {
            this.filesize = 0L;
            this.streamsize = 0L;
            this.duration = 0;
            boolean addLang = false;
            if (this.snapshot == null) {
                this.snapshot = new EnumMap<MediaInfo.StreamKind, List<Map<String, String>>>(MediaInfo.StreamKind.class);
                MediaInfo.StreamKind currentKind = null;
                ArrayList streamInfoList = new ArrayList(this.tracks.size());
                for (MiTrack track : this.tracks) {
                    if (MediaInfo.StreamKind.valueOf(track.type) != currentKind) {
                        streamInfoList = new ArrayList(this.tracks.size());
                        if (currentKind == MediaInfo.StreamKind.Audio) {
                            addLang = true;
                        }
                    }
                    currentKind = MediaInfo.StreamKind.valueOf(track.type);
                    LinkedHashMap<String, String> streamInfo = new LinkedHashMap<String, String>();
                    for (Element elem : track.elements) {
                        String[] l;
                        int i = 0;
                        String ename = elem.getNodeName();
                        String key = this.getMappedKey(elem.getNodeName());
                        while (streamInfo.containsKey(key)) {
                            key = ename + "/String";
                            if (i > 0) {
                                key = key + i;
                            }
                            ++i;
                        }
                        if (key.equals(MediaInfoXMLParser.LANG_ID) && MediaInfo.StreamKind.Audio == currentKind) {
                            this.lang.add(elem.getTextContent());
                        }
                        if (key.equals("Audio_Language_List") && (l = StringUtils.split((String)elem.getTextContent())) != null) {
                            for (String s : l) {
                                this.lang.add(s);
                            }
                        }
                        if (key.equals("FileSize")) {
                            this.filesize += Long.parseLong(elem.getTextContent());
                        }
                        if (key.equals("Stream_size")) {
                            this.streamsize += Long.parseLong(elem.getTextContent());
                        }
                        if (key.equals("Complete_name") && MediaInfo.StreamKind.General == currentKind) {
                            this.filename = elem.getTextContent();
                        }
                        if (key.equals("Duration") && MediaInfo.StreamKind.General == currentKind) {
                            try {
                                Double d = Double.parseDouble(elem.getTextContent());
                                this.duration += d.intValue() / 1000;
                            }
                            catch (NumberFormatException ignore) {
                                // empty catch block
                            }
                        }
                        streamInfo.put(key, elem.getTextContent());
                        if (!key.equals(this.getMappedKey(key))) {
                            streamInfo.put(this.getMappedKey(key), elem.getTextContent());
                        }
                        if (!addLang) continue;
                        addLang = false;
                        String curLang = (String)streamInfo.get(MediaInfoXMLParser.LANG_ID);
                        if (!StringUtils.isEmpty((CharSequence)curLang)) continue;
                        streamInfo.put(MediaInfoXMLParser.LANG_ID, StringUtils.join(this.lang, (String)" / "));
                    }
                    streamInfoList.add(streamInfo);
                    this.snapshot.put(MediaInfo.StreamKind.valueOf(track.type), streamInfoList);
                }
            }
            if (!this.filename.isEmpty()) {
                MediaFile mf;
                Path p = Paths.get(this.filename, new String[0]);
                if (p.getNameCount() == 0) {
                    p = p.resolve("/iso/dummy.vob");
                }
                if ((mf = new MediaFile(p)).getType() != MediaFileType.VIDEO && !mf.getExtension().equalsIgnoreCase("mpls")) {
                    this.snapshot = new EnumMap<MediaInfo.StreamKind, List<Map<String, String>>>(MediaInfo.StreamKind.class);
                    this.duration = 0;
                }
            }
        }

        private String getMappedKey(String key) {
            String k = key;
            switch (key) {
                case "Codec/String": {
                    k = "CodecID/Hint";
                    break;
                }
                case "Count_of_audio_streams": {
                    k = "AudioCount";
                    break;
                }
                case "Count_of_text_streams": {
                    k = "TextCount";
                    break;
                }
                case "Count_of_video_streams": {
                    k = "VideoCount";
                    break;
                }
                case "Count_of_menu_streams": {
                    k = "MenuCount";
                    break;
                }
                case "Channel_s_": {
                    k = "Channel(s)";
                    break;
                }
                case "Bit_rate": {
                    k = "BitRate";
                    break;
                }
                case "File_size": {
                    k = "FileSize";
                    break;
                }
                case "Overall_bit_rate": {
                    k = "OverallBitRate";
                    break;
                }
                case "Count_of_stream_of_this_kind": {
                    k = "StreamCount";
                    break;
                }
                case "Codec_Extensions_usually_used": {
                    k = "Codec/Extensions";
                    break;
                }
                case "Scan_type": {
                    k = "ScanType";
                    break;
                }
            }
            return k;
        }
    }
}

