/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.testing;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.testing.FakeTmmTask;

public class FakeTmmTaskAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(FakeTmmTaskAction.class);
    private int amount = 0;
    private int workUnits = 0;
    private String type = "";

    public FakeTmmTaskAction(String type, int amount, int workUnits) {
        this.amount = amount;
        this.workUnits = workUnits;
        this.type = type;
        this.putValue("Name", "TASK: add " + amount + " " + type + " task (" + workUnits + " workUnits)");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        for (int i = 1; i <= this.amount; ++i) {
            FakeTmmTask task = new FakeTmmTask(this.type + i, this.workUnits, TmmTaskHandle.TaskType.MAIN_TASK);
            switch (this.type) {
                case "download": {
                    TmmTaskManager.getInstance().addDownloadTask(task);
                    break;
                }
                case "image": {
                    TmmTaskManager.getInstance().addImageDownloadTask(task);
                    break;
                }
                case "main": {
                    break;
                }
                default: {
                    TmmTaskManager.getInstance().addUnnamedTask(task);
                }
            }
            LOGGER.info("added " + this.type + " task " + i);
        }
    }
}

