/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.entities;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.io.File;
import java.nio.file.Path;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaEntityImageFetcherTask;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.MediaSource;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowMediaFileComparator;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.connector.TvShowEpisodeToXbmcNfoConnector;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowActor;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaCastMember;
import org.tinymediamanager.scraper.util.StrgUtils;

public class TvShowEpisode
extends MediaEntity
implements Comparable<TvShowEpisode> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowEpisode.class);
    private static final Comparator<MediaFile> MEDIA_FILE_COMPARATOR = new TvShowMediaFileComparator();
    @JsonProperty
    private int episode = -1;
    @JsonProperty
    private int season = -1;
    @JsonProperty
    private int dvdSeason = -1;
    @JsonProperty
    private int dvdEpisode = -1;
    @JsonProperty
    private int displaySeason = -1;
    @JsonProperty
    private int displayEpisode = -1;
    @JsonProperty
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
    private Date firstAired = null;
    @JsonProperty
    private String director = "";
    @JsonProperty
    private String writer = "";
    @JsonProperty
    private boolean disc = false;
    @JsonProperty
    private boolean multiEpisode = false;
    @JsonProperty
    private boolean watched = false;
    @JsonProperty
    private boolean subtitles = false;
    @JsonProperty
    private boolean isDvdOrder = false;
    @JsonProperty
    private UUID tvShowId = null;
    @JsonProperty
    private MediaSource mediaSource = MediaSource.UNKNOWN;
    @JsonProperty
    private List<TvShowActor> actors = new CopyOnWriteArrayList<TvShowActor>();
    @JsonProperty
    private List<String> tags = new CopyOnWriteArrayList<String>();
    private TvShow tvShow = null;
    private Date lastWatched = null;

    public TvShowEpisode() {
    }

    public void merge(TvShowEpisode other) {
        if (other == null) {
            return;
        }
        super.merge(other);
        this.episode = this.episode < 0 ? other.getEpisode() : this.episode;
        this.season = this.season < 0 ? other.getSeason() : this.season;
        this.dvdSeason = this.dvdSeason < 0 ? other.getDvdSeason() : this.dvdSeason;
        this.dvdEpisode = this.dvdEpisode < 0 ? other.getDvdEpisode() : this.dvdEpisode;
        this.displaySeason = this.displaySeason < 0 ? other.getDisplaySeason() : this.displaySeason;
        this.displayEpisode = this.displayEpisode < 0 ? other.getDisplayEpisode() : this.displayEpisode;
        this.firstAired = this.firstAired == null ? other.getFirstAired() : this.firstAired;
        this.mediaSource = this.mediaSource == MediaSource.UNKNOWN ? other.getMediaSource() : MediaSource.UNKNOWN;
        this.director = StringUtils.isEmpty((CharSequence)this.director) ? other.getDirector() : this.director;
        this.writer = StringUtils.isEmpty((CharSequence)this.writer) ? other.getWriter() : this.writer;
        for (String key : other.getTags()) {
            if (this.tags.contains(key)) continue;
            this.tags.add(key);
        }
        for (TvShowActor actor : other.getActors()) {
            if (this.actors.contains(actor)) continue;
            this.actors.add(actor);
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    @Override
    protected Comparator<MediaFile> getMediaFileComparator() {
        return MEDIA_FILE_COMPARATOR;
    }

    public void replacePathForRenamedFolder(Path oldPath, Path newPath) {
        String p = this.getPathNIO().toAbsolutePath().toString();
        p = p.replace(oldPath.toAbsolutePath().toString(), newPath.toAbsolutePath().toString());
        this.setPath(p);
    }

    public TvShowEpisode(TvShowEpisode source) {
        this.tvShow = source.tvShow;
        for (MediaFile mediaFile : source.getMediaFiles()) {
            this.addToMediaFiles(new MediaFile(mediaFile));
        }
        this.path = new String(source.path);
        this.title = new String(source.title);
        this.originalTitle = new String(source.originalTitle);
        this.year = new String(source.year);
        this.plot = new String(source.plot);
        this.rating = source.rating;
        for (Map.Entry entry : source.artworkUrlMap.entrySet()) {
            this.artworkUrlMap.put(entry.getKey(), new String((String)entry.getValue()));
        }
        this.dateAdded = new Date(source.dateAdded.getTime());
        this.scraped = source.scraped;
        this.ids.putAll(source.ids);
        this.episode = source.episode;
        this.season = source.season;
        this.dvdEpisode = source.dvdEpisode;
        this.dvdSeason = source.dvdSeason;
        this.isDvdOrder = source.isDvdOrder;
        if (source.firstAired != null) {
            this.firstAired = new Date(source.firstAired.getTime());
        }
        this.director = source.director;
        this.writer = source.writer;
        this.disc = source.disc;
        this.watched = source.watched;
        this.votes = source.votes;
        this.subtitles = source.subtitles;
        this.actors.addAll(source.actors);
    }

    public Date getFirstAired() {
        return this.firstAired;
    }

    @JsonIgnore
    public void setFirstAired(Date newValue) {
        Date oldValue = this.firstAired;
        this.firstAired = newValue;
        this.firePropertyChange("firstAired", oldValue, newValue);
        this.firePropertyChange("firstAiredAsString", oldValue, newValue);
    }

    public TvShowSeason getTvShowSeason() {
        if (this.tvShow == null) {
            return null;
        }
        return this.tvShow.getSeasonForEpisode(this);
    }

    public void setTvShowSeason() {
    }

    public boolean isDisc() {
        return this.disc;
    }

    public void setDisc(boolean disc) {
        this.disc = disc;
    }

    public boolean isMultiEpisode() {
        return this.multiEpisode;
    }

    public void setMultiEpisode(boolean multiEpisode) {
        this.multiEpisode = multiEpisode;
    }

    public String getFirstAiredFormatted() {
        if (this.firstAired == null) {
            return "";
        }
        return new SimpleDateFormat("yyyy-MM-dd").format(this.firstAired);
    }

    public String getFirstAiredAsString() {
        if (this.firstAired == null) {
            return "";
        }
        return SimpleDateFormat.getDateInstance(2, Locale.getDefault()).format(this.firstAired);
    }

    public void setFirstAired(String aired) {
        try {
            this.setFirstAired(StrgUtils.parseDate((String)aired));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public TvShow getTvShow() {
        return this.tvShow;
    }

    public void setTvShow(TvShow newValue) {
        TvShow oldValue = this.tvShow;
        this.tvShow = newValue;
        this.tvShowId = this.tvShow.getDbId();
        this.firePropertyChange("tvShow", oldValue, newValue);
    }

    public UUID getTvShowDbId() {
        return this.tvShowId;
    }

    public int getEpisode() {
        if (this.isDvdOrder) {
            return this.dvdEpisode;
        }
        return this.episode;
    }

    public int getSeason() {
        if (this.isDvdOrder) {
            return this.dvdSeason;
        }
        return this.season;
    }

    public void setEpisode(int newValue) {
        if (this.isDvdOrder) {
            this.setDvdEpisode(newValue);
        } else {
            this.setAiredEpisode(newValue);
        }
        this.firePropertyChange("titleForUi", "", newValue);
    }

    public void setAiredEpisode(int newValue) {
        int oldValue = this.episode;
        this.episode = newValue;
        if (!this.isDvdOrder) {
            this.firePropertyChange("episode", oldValue, newValue);
        }
        this.firePropertyChange("airedEpisode", oldValue, newValue);
    }

    public int getAiredEpisode() {
        return this.episode;
    }

    @Override
    public void setTitle(String newValue) {
        super.setTitle(newValue);
        this.firePropertyChange("titleForUi", "", newValue);
    }

    public void setSeason(int newValue) {
        if (this.isDvdOrder) {
            this.setDvdSeason(newValue);
        } else {
            this.setAiredSeason(newValue);
        }
        this.firePropertyChange("titleForUi", "", newValue);
    }

    public void setAiredSeason(int newValue) {
        int oldValue = this.season;
        this.season = newValue;
        if (!this.isDvdOrder) {
            this.firePropertyChange("season", oldValue, newValue);
        }
        this.firePropertyChange("airedSeason", oldValue, newValue);
    }

    public int getAiredSeason() {
        return this.season;
    }

    public String getTitleForUi() {
        StringBuilder titleForUi = new StringBuilder();
        int episode = this.getEpisode();
        int season = this.getSeason();
        if (episode > 0 && season > 0) {
            titleForUi.append(String.format("S%02dE%02d - ", season, episode));
        }
        titleForUi.append(this.title);
        return titleForUi.toString();
    }

    @Override
    public void initializeAfterLoading() {
        super.initializeAfterLoading();
        Utils.removeEmptyStringsFromList(this.tags);
    }

    public void writeThumbImage() {
        String thumbUrl = this.getArtworkUrl(MediaFileType.THUMB);
        if (StringUtils.isNotEmpty((CharSequence)thumbUrl)) {
            String filename;
            boolean firstImage = true;
            MediaFile mf = this.getMediaFiles(MediaFileType.VIDEO).get(0);
            String basename = FilenameUtils.getBaseName((String)mf.getFilename());
            switch (TvShowModuleManager.SETTINGS.getTvShowEpisodeThumbFilename()) {
                case FILENAME_THUMB_POSTFIX: {
                    filename = basename + "-thumb." + FilenameUtils.getExtension((String)thumbUrl);
                    break;
                }
                case FILENAME_THUMB: {
                    filename = basename + "." + FilenameUtils.getExtension((String)thumbUrl);
                    break;
                }
                case FILENAME_THUMB_TBN: {
                    filename = basename + ".tbn";
                    break;
                }
                default: {
                    filename = "";
                }
            }
            if (this.isDisc()) {
                filename = "thumb." + FilenameUtils.getExtension((String)thumbUrl);
            }
            if (StringUtils.isBlank((CharSequence)thumbUrl) || StringUtils.isBlank((CharSequence)filename)) {
                return;
            }
            MediaEntityImageFetcherTask task = new MediaEntityImageFetcherTask(this, thumbUrl, MediaArtwork.MediaArtworkType.THUMB, filename, firstImage);
            TmmTaskManager.getInstance().addImageDownloadTask(task);
        }
    }

    public void setMetadata(MediaMetadata metadata) {
        if (metadata == null) {
            LOGGER.error("metadata was null");
            return;
        }
        boolean writeNewThumb = false;
        this.setTitle(metadata.getTitle());
        this.setPlot(metadata.getPlot());
        this.setIds(metadata.getIds());
        this.setAiredSeason(metadata.getSeasonNumber());
        this.setAiredEpisode(metadata.getEpisodeNumber());
        this.setDvdSeason(metadata.getDvdSeasonNumber());
        this.setDvdEpisode(metadata.getDvdEpisodeNumber());
        this.setFirstAired(metadata.getReleaseDate());
        this.setDisplaySeason(metadata.getDisplaySeasonNumber());
        this.setDisplayEpisode(metadata.getDisplayEpisodeNumber());
        this.setRating(metadata.getRating());
        this.setVotes(metadata.getVoteCount());
        ArrayList<TvShowActor> actors = new ArrayList<TvShowActor>();
        String director = "";
        String writer = "";
        for (MediaCastMember member : metadata.getCastMembers()) {
            switch (member.getType()) {
                case ACTOR: {
                    TvShowActor actor = new TvShowActor();
                    actor.setName(member.getName());
                    actor.setCharacter(member.getCharacter());
                    actor.setThumbUrl(member.getImageUrl());
                    actors.add(actor);
                    break;
                }
                case DIRECTOR: {
                    if (!StringUtils.isEmpty((CharSequence)director)) {
                        director = director + ", ";
                    }
                    director = director + member.getName();
                    break;
                }
                case WRITER: {
                    if (!StringUtils.isEmpty((CharSequence)writer)) {
                        writer = writer + ", ";
                    }
                    writer = writer + member.getName();
                    break;
                }
            }
        }
        this.setActors(actors);
        this.setDirector(director);
        this.setWriter(writer);
        Iterator i$ = metadata.getMediaArt(MediaArtwork.MediaArtworkType.THUMB).iterator();
        if (i$.hasNext()) {
            MediaArtwork ma = (MediaArtwork)i$.next();
            this.setArtworkUrl(ma.getDefaultUrl(), MediaFileType.THUMB);
            writeNewThumb = true;
        }
        this.writeNFO();
        this.saveToDb();
        if (writeNewThumb) {
            this.writeThumbImage();
        }
    }

    public void writeNFO() {
        ArrayList<TvShowEpisode> episodesInNfo = new ArrayList<TvShowEpisode>(1);
        LOGGER.debug("write nfo: " + this.getTvShow().getTitle() + " S" + this.getSeason() + "E" + this.getEpisode());
        for (MediaFile mf : this.getMediaFiles(MediaFileType.VIDEO)) {
            ArrayList<TvShowEpisode> eps = new ArrayList<TvShowEpisode>(TvShowList.getInstance().getTvEpisodesByFile(this.tvShow, mf.getFile()));
            for (TvShowEpisode ep : eps) {
                if (episodesInNfo.contains(ep)) continue;
                episodesInNfo.add(ep);
            }
        }
        TvShowEpisodeToXbmcNfoConnector.setData(episodesInNfo);
    }

    public Boolean getHasNfoFile() {
        List<MediaFile> nfos = this.getMediaFiles(MediaFileType.NFO);
        if (nfos != null && nfos.size() > 0) {
            return true;
        }
        return false;
    }

    public Boolean getHasImages() {
        if (StringUtils.isNotEmpty((CharSequence)this.getArtworkFilename(MediaFileType.THUMB))) {
            return true;
        }
        return false;
    }

    public String getWriter() {
        return this.writer;
    }

    public void setDirector(String newValue) {
        String oldValue = this.director;
        this.director = newValue;
        this.firePropertyChange("director", oldValue, newValue);
    }

    public void setWriter(String newValue) {
        String oldValue = this.writer;
        this.writer = newValue;
        this.firePropertyChange("writer", oldValue, newValue);
    }

    public String getDirector() {
        return this.director;
    }

    public void addActor(TvShowActor obj) {
        if (StringUtils.isBlank((CharSequence)obj.getEntityRoot())) {
            obj.setEntityRoot(this.getPathNIO());
        }
        this.actors.add(obj);
        this.firePropertyChange("actors", null, this.getActors());
    }

    public List<TvShowActor> getActors() {
        ArrayList<TvShowActor> allActors = new ArrayList<TvShowActor>();
        if (this.tvShow != null) {
            allActors.addAll(this.tvShow.getActors());
        }
        allActors.addAll(this.actors);
        return allActors;
    }

    public List<TvShowActor> getGuests() {
        ArrayList<TvShowActor> allActors = new ArrayList<TvShowActor>();
        allActors.addAll(this.actors);
        return allActors;
    }

    public void removeActor(TvShowActor obj) {
        this.actors.remove(obj);
        this.firePropertyChange("actors", null, this.getActors());
    }

    @JsonSetter
    public void setActors(List<TvShowActor> newActors) {
        ArrayList<TvShowActor> tvShowActors = new ArrayList<TvShowActor>();
        if (this.getTvShow() != null) {
            tvShowActors.addAll(this.getTvShow().getActors());
        }
        for (TvShowActor actor : newActors) {
            if (tvShowActors.contains(actor) || this.actors.contains(actor)) continue;
            this.actors.add(actor);
        }
        for (int i = this.actors.size() - 1; i >= 0; --i) {
            TvShowActor actor;
            actor = this.actors.get(i);
            if (newActors.contains(actor) && !tvShowActors.contains(actor)) continue;
            this.actors.remove(actor);
        }
        for (TvShowActor actor : this.actors) {
            if (!StringUtils.isBlank((CharSequence)actor.getEntityRoot())) continue;
            actor.setEntityRoot(this.getPathNIO());
        }
        this.firePropertyChange("actors", null, this.getActors());
    }

    public boolean isWatched() {
        return this.watched;
    }

    public void setWatched(boolean newValue) {
        boolean oldValue = this.watched;
        this.watched = newValue;
        this.firePropertyChange("watched", oldValue, newValue);
    }

    public Date getLastWatched() {
        return this.lastWatched;
    }

    public void setLastWatched(Date lastWatched) {
        this.lastWatched = lastWatched;
    }

    public static List<TvShowEpisode> parseNFO(File episodeFile) {
        ArrayList<TvShowEpisode> episodes = new ArrayList<TvShowEpisode>(1);
        String filename = episodeFile.getParent() + File.separator + FilenameUtils.getBaseName((String)episodeFile.getName()) + ".nfo";
        episodes.addAll(TvShowEpisodeToXbmcNfoConnector.getData(new File(filename)));
        return episodes;
    }

    public static List<TvShowEpisode> parseNFO(MediaFile episodeFile) {
        ArrayList<TvShowEpisode> episodes = new ArrayList<TvShowEpisode>(1);
        episodes.addAll(TvShowEpisodeToXbmcNfoConnector.getData(episodeFile.getFile()));
        return episodes;
    }

    public String getMediaInfoVideoFormat() {
        List<MediaFile> videos = this.getMediaFiles(MediaFileType.VIDEO);
        if (videos.size() > 0) {
            MediaFile mediaFile = videos.get(0);
            return mediaFile.getVideoFormat();
        }
        return "";
    }

    public String getMediaInfoVideoCodec() {
        List<MediaFile> videos = this.getMediaFiles(MediaFileType.VIDEO);
        if (videos.size() > 0) {
            MediaFile mediaFile = videos.get(0);
            return mediaFile.getVideoCodec();
        }
        return "";
    }

    public String getMediaInfoAudioCodecAndChannels() {
        List<MediaFile> videos = this.getMediaFiles(MediaFileType.VIDEO);
        if (videos.size() > 0) {
            MediaFile mediaFile = videos.get(0);
            return mediaFile.getAudioCodec() + "_" + mediaFile.getAudioChannels();
        }
        return "";
    }

    public List<MediaFile> getVideoFiles() {
        return this.getMediaFiles(MediaFileType.VIDEO);
    }

    public MediaFile getFirstVideoFile() {
        List<MediaFile> videoFiles = this.getVideoFiles();
        if (!videoFiles.isEmpty()) {
            return videoFiles.get(0);
        }
        return null;
    }

    public List<Path> getImagesToCache() {
        ArrayList<Path> filesToCache = new ArrayList<Path>();
        for (MediaFile mf : new ArrayList<MediaFile>(this.getMediaFiles())) {
            if (!mf.isGraphic()) continue;
            filesToCache.add(mf.getFileAsPath());
        }
        return filesToCache;
    }

    @Override
    public int compareTo(TvShowEpisode otherTvShowEpisode) {
        if (this.getTvShow() != otherTvShowEpisode.getTvShow()) {
            return this.getTvShow().getTitle().compareTo(otherTvShowEpisode.getTvShow().getTitle());
        }
        if (this.getSeason() != otherTvShowEpisode.getSeason()) {
            return this.getSeason() - otherTvShowEpisode.getSeason();
        }
        if (this.getEpisode() != otherTvShowEpisode.getEpisode()) {
            return this.getEpisode() - otherTvShowEpisode.getEpisode();
        }
        String filename1 = "";
        try {
            filename1 = this.getMediaFiles(MediaFileType.VIDEO).get(0).getFilename();
        }
        catch (Exception ignored) {
            // empty catch block
        }
        String filename2 = "";
        try {
            filename2 = otherTvShowEpisode.getMediaFiles(MediaFileType.VIDEO).get(0).getFilename();
        }
        catch (Exception ignored) {
            // empty catch block
        }
        return filename1.compareTo(filename2);
    }

    public List<MediaFile> getMediaFilesContainingAudioStreams() {
        ArrayList<MediaFile> mediaFilesWithAudioStreams = new ArrayList<MediaFile>(1);
        List<MediaFile> videoFiles = this.getMediaFiles(MediaFileType.VIDEO);
        if (videoFiles.size() > 0) {
            MediaFile videoFile = videoFiles.get(0);
            mediaFilesWithAudioStreams.add(videoFile);
        }
        for (MediaFile audioFile : this.getMediaFiles(MediaFileType.AUDIO)) {
            mediaFilesWithAudioStreams.add(audioFile);
        }
        return mediaFilesWithAudioStreams;
    }

    public List<MediaFile> getMediaFilesContainingSubtitles() {
        ArrayList<MediaFile> mediaFilesWithSubtitles = new ArrayList<MediaFile>(1);
        for (MediaFile mediaFile : this.getMediaFiles(MediaFileType.VIDEO, MediaFileType.SUBTITLE)) {
            if (!mediaFile.hasSubtitles()) continue;
            mediaFilesWithSubtitles.add(mediaFile);
        }
        return mediaFilesWithSubtitles;
    }

    public boolean hasSubtitles() {
        if (this.subtitles) {
            return true;
        }
        if (this.getMediaFiles(MediaFileType.SUBTITLE).size() > 0) {
            return true;
        }
        for (MediaFile mf : this.getMediaFiles(MediaFileType.VIDEO)) {
            if (!mf.hasSubtitles()) continue;
            return true;
        }
        return false;
    }

    public void setSubtitles(boolean sub) {
        this.subtitles = sub;
    }

    public int getRuntimeFromMediaFiles() {
        int runtime = 0;
        for (MediaFile mf : this.getMediaFiles(MediaFileType.VIDEO)) {
            runtime += mf.getDuration();
        }
        return runtime;
    }

    public int getRuntimeFromMediaFilesInMinutes() {
        return this.getRuntimeFromMediaFiles() / 60;
    }

    @Override
    public synchronized void callbackForWrittenArtwork(MediaArtwork.MediaArtworkType type) {
    }

    @Override
    public void saveToDb() {
        TvShowList.getInstance().persistEpisode(this);
    }

    @Override
    public void deleteFromDb() {
        TvShowList.getInstance().removeEpisodeFromDb(this);
    }

    void setPosterChanged() {
        this.firePropertyChange("seasonPoster", null, "");
    }

    @Override
    public boolean isScraped() {
        if (!this.scraped && !this.plot.isEmpty() && this.firstAired != null && this.getSeason() > -1 && this.getEpisode() > -1) {
            return true;
        }
        return this.scraped;
    }

    public void addToTags(String newTag) {
        if (StringUtils.isBlank((CharSequence)newTag)) {
            return;
        }
        for (String tag : this.tags) {
            if (!tag.equals(newTag)) continue;
            return;
        }
        this.tags.add(newTag);
        this.firePropertyChange("tag", null, newTag);
        this.firePropertyChange("tagsAsString", null, newTag);
    }

    public void removeFromTags(String removeTag) {
        this.tags.remove(removeTag);
        this.firePropertyChange("tag", null, removeTag);
        this.firePropertyChange("tagsAsString", null, removeTag);
    }

    @JsonSetter
    public void setTags(List<String> newTags) {
        for (String tag : newTags) {
            if (this.tags.contains(tag)) continue;
            this.tags.add(tag);
        }
        for (int i = this.tags.size() - 1; i >= 0; --i) {
            String tag;
            tag = this.tags.get(i);
            if (newTags.contains(tag)) continue;
            this.tags.remove(tag);
        }
        this.firePropertyChange("tag", null, newTags);
        this.firePropertyChange("tagsAsString", null, newTags);
    }

    public String getTagAsString() {
        StringBuilder sb = new StringBuilder();
        for (String tag : this.tags) {
            if (!StringUtils.isEmpty((CharSequence)sb)) {
                sb.append(", ");
            }
            sb.append(tag);
        }
        return sb.toString();
    }

    public String getTvdbId() {
        Object obj = this.ids.get("tvdb");
        if (obj == null) {
            return "";
        }
        return obj.toString();
    }

    public List<String> getTags() {
        return this.tags;
    }

    public int getDvdSeason() {
        return this.dvdSeason;
    }

    public void setDvdSeason(int newValue) {
        int oldValue = this.dvdSeason;
        this.dvdSeason = newValue;
        if (this.isDvdOrder) {
            this.firePropertyChange("season", oldValue, newValue);
        }
        this.firePropertyChange("dvdSeason", oldValue, newValue);
    }

    public int getDvdEpisode() {
        return this.dvdEpisode;
    }

    public void setDvdEpisode(int newValue) {
        int oldValue = this.dvdEpisode;
        this.dvdEpisode = newValue;
        if (this.isDvdOrder) {
            this.firePropertyChange("episode", oldValue, newValue);
        }
        this.firePropertyChange("dvdEpisode", oldValue, newValue);
    }

    public void setDisplaySeason(int newValue) {
        int oldValue = this.displaySeason;
        this.displaySeason = newValue;
        this.firePropertyChange("displaySeason", oldValue, newValue);
    }

    public int getDisplaySeason() {
        return this.displaySeason;
    }

    public void setDisplayEpisode(int newValue) {
        int oldValue = this.displayEpisode;
        this.displayEpisode = newValue;
        this.firePropertyChange("displayEpisode", oldValue, newValue);
    }

    public int getDisplayEpisode() {
        return this.displayEpisode;
    }

    public boolean isDvdOrder() {
        return this.isDvdOrder;
    }

    public void setDvdOrder(boolean newValue) {
        boolean oldValue = this.isDvdOrder;
        this.isDvdOrder = newValue;
        this.firePropertyChange("dvdOrder", oldValue, newValue);
    }

    public MediaSource getMediaSource() {
        return this.mediaSource;
    }

    public void setMediaSource(MediaSource newValue) {
        MediaSource oldValue = this.mediaSource;
        this.mediaSource = newValue;
        this.firePropertyChange("mediaSource", (Object)oldValue, (Object)newValue);
    }

    public String getVideoBasenameWithoutStacking() {
        MediaFile mf = this.getMediaFiles(MediaFileType.VIDEO).get(0);
        return FilenameUtils.getBaseName((String)mf.getFilenameWithoutStacking());
    }

    public boolean deleteFilesSafely() {
        boolean result = true;
        List<MediaFile> mediaFiles = this.getMediaFiles();
        for (MediaFile mf : mediaFiles) {
            if (mf.deleteSafely(this.tvShow.getDataSource())) continue;
            result = false;
        }
        return result;
    }
}

