/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.entities;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FilenameFilter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.tvshow.TvShowArtworkHelper;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowMediaFileComparator;
import org.tinymediamanager.core.tvshow.TvShowScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.connector.TvShowToXbmcNfoConnector;
import org.tinymediamanager.core.tvshow.entities.TvShowActor;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.entities.Certification;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaCastMember;
import org.tinymediamanager.scraper.entities.MediaGenres;
import org.tinymediamanager.scraper.util.StrgUtils;

public class TvShow
extends MediaEntity {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShow.class);
    private static final Comparator<MediaFile> MEDIA_FILE_COMPARATOR = new TvShowMediaFileComparator();
    @JsonProperty
    private String dataSource = "";
    @JsonProperty
    private String director = "";
    @JsonProperty
    private String writer = "";
    @JsonProperty
    private int runtime = 0;
    @JsonProperty
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
    private Date firstAired = null;
    @JsonProperty
    private String status = "";
    @JsonProperty
    private boolean watched = false;
    @JsonProperty
    private String sortTitle = "";
    @JsonProperty
    private Certification certification = Certification.NOT_RATED;
    @JsonProperty
    private List<String> genres = new CopyOnWriteArrayList<String>();
    @JsonProperty
    private List<String> tags = new CopyOnWriteArrayList<String>();
    @JsonProperty
    private HashMap<Integer, String> seasonPosterUrlMap = new HashMap(0);
    @JsonProperty
    private List<TvShowActor> actors = new CopyOnWriteArrayList<TvShowActor>();
    private List<TvShowEpisode> episodes = new CopyOnWriteArrayList<TvShowEpisode>();
    private HashMap<Integer, MediaFile> seasonPosters = new HashMap(0);
    private List<TvShowSeason> seasons = new CopyOnWriteArrayList<TvShowSeason>();
    private List<MediaGenres> genresForAccess = new CopyOnWriteArrayList<MediaGenres>();
    private String titleSortable = "";
    private Date lastWatched = null;
    private PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("tag".equals(evt.getPropertyName()) && evt.getSource() instanceof TvShowEpisode) {
                TvShow.this.firePropertyChange(evt);
            }
        }
    };

    @Override
    protected Comparator<MediaFile> getMediaFileComparator() {
        return MEDIA_FILE_COMPARATOR;
    }

    @Override
    public void initializeAfterLoading() {
        super.initializeAfterLoading();
        Utils.removeEmptyStringsFromList(this.tags);
        Utils.removeEmptyStringsFromList(this.genres);
        for (String genre : new ArrayList<String>(this.genres)) {
            this.addGenre(MediaGenres.getGenre((String)genre));
        }
        Pattern pattern = Pattern.compile("(?i)season([0-9]{1,4})-poster\\..{2,4}");
        for (MediaFile mf : this.getMediaFiles(MediaFileType.SEASON_POSTER)) {
            if (mf.getFilename().startsWith("season-specials-poster")) {
                this.seasonPosters.put(0, mf);
                continue;
            }
            Matcher matcher = pattern.matcher(mf.getFilename());
            if (!matcher.matches()) continue;
            try {
                int season = Integer.parseInt(matcher.group(1));
                this.seasonPosters.put(season, mf);
            }
            catch (Exception ignored) {}
        }
        for (TvShowEpisode episode : this.episodes) {
            episode.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    public void merge(TvShow other) {
        super.merge(other);
        for (TvShowEpisode ep : this.episodes) {
            TvShowEpisode otherEP = other.getEpisode(ep.getSeason(), ep.getEpisode());
            ep.merge(otherEP);
        }
        for (TvShowEpisode otherEp : other.getEpisodes()) {
            TvShowEpisode ourEP = this.getEpisode(otherEp.getSeason(), otherEp.getEpisode());
            if (ourEP != null) continue;
            TvShowEpisode clone = new TvShowEpisode(otherEp);
            clone.setTvShow(this);
            this.addEpisode(clone);
        }
    }

    @Override
    public void setTitle(String newValue) {
        String oldValue = this.title;
        super.setTitle(newValue);
        oldValue = this.titleSortable;
        this.titleSortable = "";
        this.firePropertyChange("titleSortable", oldValue, this.titleSortable);
    }

    public String getTitleSortable() {
        if (StringUtils.isEmpty((CharSequence)this.titleSortable)) {
            this.titleSortable = Utils.getSortableName(this.getTitle());
        }
        return this.titleSortable;
    }

    public void clearTitleSortable() {
        this.titleSortable = "";
    }

    public String getSortTitle() {
        return this.sortTitle;
    }

    public void setSortTitle(String newValue) {
        String oldValue = this.sortTitle;
        this.sortTitle = newValue;
        this.firePropertyChange("sortTitle", oldValue, newValue);
    }

    public List<TvShowEpisode> getEpisodes() {
        return this.episodes;
    }

    public void addEpisode(TvShowEpisode episode) {
        int oldValue = this.episodes.size();
        this.episodes.add(episode);
        episode.addPropertyChangeListener(this.propertyChangeListener);
        this.addToSeason(episode);
        Utils.sortList(this.episodes);
        this.firePropertyChange("addedEpisode", null, episode);
        this.firePropertyChange("episodeCount", oldValue, this.episodes.size());
    }

    public int getEpisodeCount() {
        return this.episodes.size();
    }

    private void addToSeason(TvShowEpisode episode) {
        TvShowSeason season = this.getSeasonForEpisode(episode);
        season.addEpisode(episode);
    }

    private void removeFromSeason(TvShowEpisode episode) {
        TvShowSeason season = this.getSeasonForEpisode(episode);
        season.removeEpisode(episode);
    }

    public synchronized TvShowSeason getSeasonForEpisode(TvShowEpisode episode) {
        TvShowSeason season = null;
        for (TvShowSeason s : this.seasons) {
            if (s.getSeason() != episode.getSeason()) continue;
            season = s;
            break;
        }
        if (season == null) {
            int oldValue = this.seasons.size();
            season = new TvShowSeason(episode.getSeason(), this);
            this.seasons.add(season);
            this.firePropertyChange("season", null, season);
            this.firePropertyChange("seasonCount", oldValue, this.seasons.size());
        }
        return season;
    }

    public int getSeasonCount() {
        return this.seasons.size();
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String newValue) {
        String oldValue = this.dataSource;
        this.dataSource = newValue;
        this.firePropertyChange("dataSource", oldValue, newValue);
    }

    public void removeAllEpisodes() {
        int oldValue = this.episodes.size();
        if (this.episodes.size() > 0) {
            for (int i = this.episodes.size() - 1; i >= 0; --i) {
                TvShowEpisode episode = this.episodes.get(i);
                this.episodes.remove(episode);
                episode.removePropertyChangeListener(this.propertyChangeListener);
                TvShowList.getInstance().removeEpisodeFromDb(episode);
            }
        }
        this.firePropertyChange("episodeCount", oldValue, this.episodes.size());
    }

    public void removeEpisode(TvShowEpisode episode) {
        if (this.episodes.contains(episode)) {
            int oldValue = this.episodes.size();
            this.episodes.remove(episode);
            episode.removePropertyChangeListener(this.propertyChangeListener);
            this.removeFromSeason(episode);
            TvShowList.getInstance().removeEpisodeFromDb(episode);
            this.saveToDb();
            this.firePropertyChange("removedEpisode", null, episode);
            this.firePropertyChange("episodeCount", oldValue, this.episodes.size());
        }
    }

    public void deleteEpisode(TvShowEpisode episode) {
        if (this.episodes.contains(episode)) {
            int oldValue = this.episodes.size();
            episode.deleteFilesSafely();
            this.episodes.remove(episode);
            episode.removePropertyChangeListener(this.propertyChangeListener);
            this.removeFromSeason(episode);
            TvShowList.getInstance().removeEpisodeFromDb(episode);
            this.saveToDb();
            this.firePropertyChange("removedEpisode", null, episode);
            this.firePropertyChange("episodeCount", oldValue, this.episodes.size());
        }
    }

    public List<TvShowSeason> getSeasons() {
        return this.seasons;
    }

    public List<MediaGenres> getGenres() {
        return this.genresForAccess;
    }

    public void addGenre(MediaGenres newValue) {
        if (!this.genresForAccess.contains(newValue)) {
            this.genresForAccess.add(newValue);
            if (!this.genres.contains(newValue.name())) {
                this.genres.add(newValue.name());
            }
            this.firePropertyChange("genre", null, newValue);
            this.firePropertyChange("genresAsString", null, newValue);
        }
    }

    @JsonSetter
    public void setGenres(List<MediaGenres> genres) {
        for (MediaGenres genre : genres) {
            if (this.genresForAccess.contains(genre)) continue;
            this.genresForAccess.add(genre);
            if (this.genres.contains(genre.name())) continue;
            this.genres.add(genre.name());
        }
        for (int i = this.genresForAccess.size() - 1; i >= 0; --i) {
            MediaGenres genre;
            genre = this.genresForAccess.get(i);
            if (genres.contains(genre)) continue;
            this.genresForAccess.remove(genre);
            this.genres.remove(genre.name());
        }
        this.firePropertyChange("genre", null, genres);
        this.firePropertyChange("genresAsString", null, genres);
    }

    public void removeGenre(MediaGenres genre) {
        if (this.genresForAccess.contains(genre)) {
            this.genresForAccess.remove(genre);
            this.genres.remove(genre.name());
            this.firePropertyChange("genre", null, genre);
            this.firePropertyChange("genresAsString", null, genre);
        }
    }

    public String getGenresAsString() {
        StringBuilder sb = new StringBuilder();
        for (MediaGenres genre : this.genresForAccess) {
            if (!StringUtils.isEmpty((CharSequence)sb)) {
                sb.append(", ");
            }
            sb.append(genre != null ? genre.getLocalizedName() : "null");
        }
        return sb.toString();
    }

    public void setMetadata(MediaMetadata metadata, TvShowScraperMetadataConfig config) {
        if (metadata == null) {
            LOGGER.error("metadata was null");
            return;
        }
        if (StringUtils.isEmpty((CharSequence)metadata.getTitle())) {
            LOGGER.warn("wanted to save empty metadata for " + this.getTitle());
            return;
        }
        for (Map.Entry entry : metadata.getIds().entrySet()) {
            this.setId((String)entry.getKey(), entry.getValue().toString());
        }
        if (config.isTitle()) {
            this.setTitle(metadata.getTitle());
        }
        if (config.isPlot()) {
            this.setPlot(metadata.getPlot());
        }
        if (config.isYear()) {
            if (metadata.getYear() != 0) {
                this.setYear(Integer.toString(metadata.getYear()));
            } else {
                this.setYear("");
            }
        }
        if (config.isRating()) {
            this.setRating(metadata.getRating());
            this.setVotes(metadata.getVoteCount());
        }
        if (config.isAired()) {
            this.setFirstAired(metadata.getReleaseDate());
        }
        if (config.isStatus()) {
            this.setStatus(metadata.getStatus());
        }
        if (config.isRuntime()) {
            this.setRuntime(metadata.getRuntime());
        }
        if (config.isCast()) {
            this.setProductionCompany(StringUtils.join((Iterable)metadata.getProductionCompanies(), (String)", "));
            ArrayList<TvShowActor> actors = new ArrayList<TvShowActor>();
            String director = "";
            String writer = "";
            for (MediaCastMember member : metadata.getCastMembers()) {
                switch (member.getType()) {
                    case ACTOR: {
                        TvShowActor actor = new TvShowActor();
                        actor.setName(member.getName());
                        actor.setCharacter(member.getCharacter());
                        actor.setThumbUrl(member.getImageUrl());
                        actors.add(actor);
                        break;
                    }
                    case DIRECTOR: {
                        if (!StringUtils.isEmpty((CharSequence)director)) {
                            director = director + ", ";
                        }
                        director = director + member.getName();
                        break;
                    }
                    case WRITER: {
                        if (!StringUtils.isEmpty((CharSequence)writer)) {
                            writer = writer + ", ";
                        }
                        writer = writer + member.getName();
                        break;
                    }
                }
            }
            this.setActors(actors);
            this.setDirector(director);
            this.setWriter(writer);
        }
        if (config.isCertification() && metadata.getCertifications().size() > 0) {
            this.setCertification((Certification)metadata.getCertifications().get(0));
        }
        if (config.isGenres()) {
            this.setGenres(metadata.getGenres());
        }
        this.setScraped(true);
        this.writeNFO();
        this.saveToDb();
    }

    public void setArtwork(List<MediaArtwork> artwork, TvShowScraperMetadataConfig config) {
        if (config.isArtwork()) {
            for (MediaArtwork art : artwork) {
                if (art.getType() != MediaArtwork.MediaArtworkType.POSTER) continue;
                this.setArtworkUrl(art.getDefaultUrl(), MediaFileType.POSTER);
                TvShowArtworkHelper.downloadArtwork(this, MediaFileType.POSTER);
                break;
            }
            for (MediaArtwork art : artwork) {
                if (art.getType() != MediaArtwork.MediaArtworkType.BACKGROUND) continue;
                this.setArtworkUrl(art.getDefaultUrl(), MediaFileType.FANART);
                TvShowArtworkHelper.downloadArtwork(this, MediaFileType.FANART);
                break;
            }
            for (MediaArtwork art : artwork) {
                if (art.getType() != MediaArtwork.MediaArtworkType.BANNER) continue;
                this.setArtworkUrl(art.getDefaultUrl(), MediaFileType.BANNER);
                TvShowArtworkHelper.downloadArtwork(this, MediaFileType.BANNER);
                break;
            }
            for (MediaArtwork art : artwork) {
                if (art.getType() != MediaArtwork.MediaArtworkType.LOGO) continue;
                this.setArtworkUrl(art.getDefaultUrl(), MediaFileType.LOGO);
                TvShowArtworkHelper.downloadArtwork(this, MediaFileType.LOGO);
                break;
            }
            for (MediaArtwork art : artwork) {
                if (art.getType() != MediaArtwork.MediaArtworkType.CLEARLOGO) continue;
                this.setArtworkUrl(art.getDefaultUrl(), MediaFileType.CLEARLOGO);
                TvShowArtworkHelper.downloadArtwork(this, MediaFileType.CLEARLOGO);
                break;
            }
            for (MediaArtwork art : artwork) {
                if (art.getType() != MediaArtwork.MediaArtworkType.CLEARART) continue;
                this.setArtworkUrl(art.getDefaultUrl(), MediaFileType.CLEARART);
                TvShowArtworkHelper.downloadArtwork(this, MediaFileType.CLEARART);
                break;
            }
            for (MediaArtwork art : artwork) {
                if (art.getType() != MediaArtwork.MediaArtworkType.THUMB) continue;
                this.setArtworkUrl(art.getDefaultUrl(), MediaFileType.THUMB);
                TvShowArtworkHelper.downloadArtwork(this, MediaFileType.THUMB);
                break;
            }
            HashMap<Integer, String> seasonPosters = new HashMap<Integer, String>();
            for (MediaArtwork art : artwork) {
                String url;
                if (art.getType() != MediaArtwork.MediaArtworkType.SEASON || art.getSeason() < 0 || !StringUtils.isBlank((CharSequence)(url = (String)seasonPosters.get(art.getSeason())))) continue;
                this.setSeasonPosterUrl(art.getSeason(), art.getDefaultUrl());
                TvShowArtworkHelper.downloadSeasonPoster(this, art.getSeason());
                seasonPosters.put(art.getSeason(), art.getDefaultUrl());
            }
            this.saveToDb();
        }
    }

    public void downloadArtwork(MediaFileType type) {
        TvShowArtworkHelper.downloadArtwork(this, type);
    }

    public void downloadSeasonPoster(int season) {
        TvShowArtworkHelper.downloadSeasonPoster(this, season);
    }

    public void writeNFO() {
        TvShowToXbmcNfoConnector.setData(this);
        this.firePropertyChange("hasNfoFile", false, true);
    }

    public Boolean getHasNfoFile() {
        List<MediaFile> nfos = this.getMediaFiles(MediaFileType.NFO);
        if (nfos != null && nfos.size() > 0) {
            return true;
        }
        return false;
    }

    public Boolean getHasImages() {
        if (!StringUtils.isEmpty((CharSequence)this.getArtworkFilename(MediaFileType.POSTER)) && !StringUtils.isEmpty((CharSequence)this.getArtworkFilename(MediaFileType.FANART))) {
            return true;
        }
        return false;
    }

    public String getImdbId() {
        return this.getIdAsString("imdb");
    }

    public void setImdbId(String newValue) {
        this.setId("imdb", newValue);
    }

    public String getTvdbId() {
        return this.getIdAsString("tvdb");
    }

    public void setTvdbId(String newValue) {
        this.setId("tvdb", newValue);
    }

    public int getTraktId() {
        return this.getIdAsInt("trakt");
    }

    public void setTraktId(int newValue) {
        this.setId("trakt", newValue);
    }

    public Date getFirstAired() {
        return this.firstAired;
    }

    @JsonIgnore
    public void setFirstAired(Date newValue) {
        Date oldValue = this.firstAired;
        this.firstAired = newValue;
        this.firePropertyChange("firstAired", oldValue, newValue);
        this.firePropertyChange("firstAiredAsString", oldValue, newValue);
    }

    public String getFirstAiredFormatted() {
        if (this.firstAired == null) {
            return "";
        }
        return new SimpleDateFormat("yyyy-MM-dd").format(this.firstAired);
    }

    public String getFirstAiredAsString() {
        if (this.firstAired == null) {
            return "";
        }
        return SimpleDateFormat.getDateInstance(2, Locale.getDefault()).format(this.firstAired);
    }

    public void setFirstAired(String aired) {
        try {
            this.setFirstAired(StrgUtils.parseDate((String)aired));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String newValue) {
        String oldValue = this.status;
        this.status = newValue;
        this.firePropertyChange("status", oldValue, newValue);
    }

    public void addToTags(String newTag) {
        if (StringUtils.isBlank((CharSequence)newTag)) {
            return;
        }
        for (String tag : this.tags) {
            if (!tag.equals(newTag)) continue;
            return;
        }
        this.tags.add(newTag);
        this.firePropertyChange("tag", null, newTag);
        this.firePropertyChange("tagsAsString", null, newTag);
    }

    public void removeFromTags(String removeTag) {
        this.tags.remove(removeTag);
        this.firePropertyChange("tag", null, removeTag);
        this.firePropertyChange("tagsAsString", null, removeTag);
    }

    @JsonSetter
    public void setTags(List<String> newTags) {
        for (String tag : newTags) {
            if (this.tags.contains(tag)) continue;
            this.tags.add(tag);
        }
        for (int i = this.tags.size() - 1; i >= 0; --i) {
            String tag;
            tag = this.tags.get(i);
            if (newTags.contains(tag)) continue;
            this.tags.remove(tag);
        }
        this.firePropertyChange("tag", null, newTags);
        this.firePropertyChange("tagsAsString", null, newTags);
    }

    public String getTagAsString() {
        StringBuilder sb = new StringBuilder();
        for (String tag : this.tags) {
            if (!StringUtils.isEmpty((CharSequence)sb)) {
                sb.append(", ");
            }
            sb.append(tag);
        }
        return sb.toString();
    }

    public List<String> getTags() {
        return this.tags;
    }

    public String getDirector() {
        return this.director;
    }

    public String getWriter() {
        return this.writer;
    }

    public void setDirector(String newValue) {
        String oldValue = this.director;
        this.director = newValue;
        this.firePropertyChange("director", oldValue, newValue);
    }

    public void setWriter(String newValue) {
        String oldValue = this.writer;
        this.writer = newValue;
        this.firePropertyChange("writer", oldValue, newValue);
    }

    public int getRuntime() {
        return this.runtime;
    }

    public void setRuntime(int newValue) {
        int oldValue = this.runtime;
        this.runtime = newValue;
        this.firePropertyChange("runtime", oldValue, newValue);
    }

    public void addActor(TvShowActor obj) {
        if (StringUtils.isBlank((CharSequence)obj.getEntityRoot())) {
            obj.setEntityRoot(this.getPathNIO());
        }
        this.actors.add(obj);
        this.firePropertyChange("actors", null, this.getActors());
    }

    public List<TvShowActor> getActors() {
        return this.actors;
    }

    public void removeActor(TvShowActor obj) {
        this.actors.remove(obj);
        this.firePropertyChange("actors", null, this.getActors());
    }

    @JsonSetter
    public void setActors(List<TvShowActor> newActors) {
        for (TvShowActor actor : newActors) {
            if (this.actors.contains(actor)) continue;
            this.actors.add(actor);
        }
        for (int i = this.actors.size() - 1; i >= 0; --i) {
            TvShowActor actor;
            actor = this.actors.get(i);
            if (newActors.contains(actor)) continue;
            this.actors.remove(actor);
        }
        for (TvShowActor actor : this.actors) {
            if (!StringUtils.isBlank((CharSequence)actor.getEntityRoot())) continue;
            actor.setEntityRoot(this.getPathNIO());
        }
        this.firePropertyChange("actors", null, this.getActors());
    }

    public Certification getCertification() {
        return this.certification;
    }

    public void setCertification(Certification newValue) {
        this.certification = newValue;
        this.firePropertyChange("certification", null, newValue);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static TvShow parseNFO(File tvShowDirectory) {
        LOGGER.debug("try to find a nfo for " + tvShowDirectory.getPath());
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (name.toLowerCase(Locale.ROOT).startsWith(".")) {
                    return false;
                }
                return name.toLowerCase(Locale.ROOT).endsWith("nfo");
            }
        };
        TvShow tvShow = null;
        File[] nfoFiles = tvShowDirectory.listFiles(filter);
        if (nfoFiles == null) {
            return tvShow;
        }
        for (File file : nfoFiles) {
            tvShow = TvShowToXbmcNfoConnector.getData(file);
            if (tvShow != null) {
                tvShow.setPath(tvShowDirectory.getPath());
                tvShow.addToMediaFiles(new MediaFile(file, MediaFileType.NFO));
                break;
            }
            LOGGER.debug("did not find tv show informations in nfo");
        }
        return tvShow;
    }

    public List<TvShowEpisode> getEpisodesToScrape() {
        ArrayList<TvShowEpisode> episodes = new ArrayList<TvShowEpisode>();
        for (TvShowEpisode episode : new ArrayList<TvShowEpisode>(this.episodes)) {
            if (episode.getFirstAired() == null && (episode.getSeason() <= -1 || episode.getEpisode() <= -1)) continue;
            episodes.add(episode);
        }
        return episodes;
    }

    public boolean isWatched() {
        return this.watched;
    }

    public void setWatched(boolean newValue) {
        boolean oldValue = this.watched;
        this.watched = newValue;
        this.firePropertyChange("watched", oldValue, newValue);
    }

    public Date getLastWatched() {
        return this.lastWatched;
    }

    public void setLastWatched(Date lastWatched) {
        this.lastWatched = lastWatched;
    }

    public String getSeasonPosterUrl(int season) {
        String url = this.seasonPosterUrlMap.get(season);
        if (StringUtils.isBlank((CharSequence)url)) {
            return "";
        }
        return url;
    }

    public void setSeasonPosterUrl(int season, String url) {
        this.seasonPosterUrlMap.put(season, url);
    }

    String getSeasonPoster(int season) {
        MediaFile poster = this.seasonPosters.get(season);
        if (poster == null) {
            return "";
        }
        return poster.getFile().getAbsolutePath();
    }

    Dimension getSeasonPosterSize(int season) {
        MediaFile seasonPoster = this.seasonPosters.get(season);
        if (seasonPoster != null) {
            return new Dimension(seasonPoster.getVideoWidth(), seasonPoster.getVideoHeight());
        }
        return new Dimension(0, 0);
    }

    public void setSeasonPoster(int season, File file) {
        MediaFile mf = new MediaFile(file, MediaFileType.SEASON_POSTER);
        this.setSeasonPoster(season, mf);
    }

    public void setSeasonPoster(int season, MediaFile mf) {
        MediaFile oldMf = this.seasonPosters.get(season);
        if (oldMf != null && oldMf.equals(mf)) {
            return;
        }
        mf.gatherMediaInformation();
        this.addToMediaFiles(mf);
        if (this.seasonPosters.containsKey(season)) {
            this.seasonPosters.remove(season);
        }
        this.seasonPosters.put(season, mf);
    }

    void clearSeasonPoster(int season) {
        MediaFile mf = this.seasonPosters.get(season);
        if (mf != null) {
            this.removeFromMediaFiles(mf);
        }
        this.seasonPosters.remove(season);
    }

    public List<MediaFile> getEpisodesMediaFiles() {
        ArrayList<MediaFile> mediaFiles = new ArrayList<MediaFile>();
        for (TvShowEpisode episode : new ArrayList<TvShowEpisode>(this.episodes)) {
            for (MediaFile mf : episode.getMediaFiles()) {
                if (mediaFiles.contains(mf)) continue;
                mediaFiles.add(mf);
            }
        }
        return mediaFiles;
    }

    public List<Path> getImagesToCache() {
        ArrayList<Path> filesToCache = new ArrayList<Path>();
        for (MediaFile mf : new ArrayList<MediaFile>(this.getMediaFiles())) {
            if (!mf.isGraphic()) continue;
            filesToCache.add(mf.getFileAsPath());
        }
        for (TvShowEpisode episode : new ArrayList<TvShowEpisode>(this.episodes)) {
            filesToCache.addAll(episode.getImagesToCache());
        }
        return filesToCache;
    }

    @Override
    public synchronized void callbackForWrittenArtwork(MediaArtwork.MediaArtworkType type) {
    }

    @Override
    public void saveToDb() {
        TvShowList.getInstance().persistTvShow(this);
    }

    @Override
    public void deleteFromDb() {
        TvShowList.getInstance().removeTvShow(this);
    }

    public TvShowEpisode getEpisode(int season, int episode) {
        TvShowEpisode ep = null;
        for (TvShowEpisode e : new ArrayList<TvShowEpisode>(this.episodes)) {
            if (e.getSeason() != season || e.getEpisode() != episode) continue;
            ep = e;
            break;
        }
        return ep;
    }

    public boolean hasNewlyAddedEpisodes() {
        for (TvShowEpisode episode : new ArrayList<TvShowEpisode>(this.episodes)) {
            if (!episode.isNewlyAdded()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isScraped() {
        if (!(this.scraped || this.plot.isEmpty() || this.year.isEmpty() || this.year.equals("0") || this.genres == null || this.genres.size() == 0 || this.actors == null || this.actors.size() == 0)) {
            return true;
        }
        return this.scraped;
    }

    public boolean deleteFilesSafely() {
        return Utils.deleteDirectorySafely(Paths.get(this.getPath(), new String[0]), this.getDataSource());
    }

    @Deprecated
    @JsonSetter
    public void setStudio(String studio) {
        this.setProductionCompany(studio);
    }
}

