/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.connector;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowActor;
import org.tinymediamanager.scraper.entities.Certification;
import org.tinymediamanager.scraper.entities.MediaGenres;
import org.tinymediamanager.scraper.util.ParserUtils;

@XmlRootElement(name="tvshow")
@XmlType(propOrder={"title", "sorttitle", "year", "rating", "votes", "plot", "mpaa", "episodeguide", "id", "imdbid", "genres", "tags", "premiered", "status", "studio", "thumb", "actors", "unsupportedElements"})
public class TvShowToXbmcNfoConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowToXbmcNfoConnector.class);
    private static JAXBContext context = TvShowToXbmcNfoConnector.initContext();
    private String id = "";
    private String imdbid = "";
    private String title = "";
    private String sorttitle = "";
    private float rating = 0.0f;
    private int votes = 0;
    private String year = "";
    private String plot = "";
    private String mpaa = "";
    private String premiered = "";
    @XmlElement(name="studio")
    private List<String> studio = null;
    private String status = "";
    private EpisodeGuide episodeguide;
    @XmlAnyElement(lax=true)
    private List<Object> actors;
    @XmlElement(name="genre")
    private List<String> genres = new ArrayList<String>();
    @XmlElement(name="tag")
    private List<String> tags;
    @XmlAnyElement(lax=true)
    private List<Object> unsupportedElements;
    @XmlElement
    List<Thumb> thumb;

    private static JAXBContext initContext() {
        try {
            return JAXBContext.newInstance((Class[])new Class[]{TvShowToXbmcNfoConnector.class, Actor.class});
        }
        catch (JAXBException e) {
            LOGGER.error(e.getMessage());
            return null;
        }
    }

    public TvShowToXbmcNfoConnector() {
        this.actors = new ArrayList<Object>();
        this.tags = new ArrayList<String>();
        this.episodeguide = new EpisodeGuide();
        this.unsupportedElements = new ArrayList<Object>();
    }

    public static void setData(TvShow tvShow) {
        if (context == null) {
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)tvShow, "message.nfo.writeerror", new String[]{":", "Context is null"}));
            return;
        }
        TvShowToXbmcNfoConnector xbmc = null;
        ArrayList<Object> unsupportedTags = new ArrayList<Object>();
        String nfoFilename = "tvshow.nfo";
        File nfoFile = new File(tvShow.getPath(), nfoFilename);
        if (nfoFile.exists()) {
            try {
                Unmarshaller um = context.createUnmarshaller();
                InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(nfoFile), "UTF-8");
                xbmc = (TvShowToXbmcNfoConnector)um.unmarshal((Reader)in);
            }
            catch (Exception e) {
                LOGGER.error("failed to parse " + nfoFile.getAbsolutePath() + "; " + e.getMessage());
            }
        }
        if (xbmc == null) {
            xbmc = new TvShowToXbmcNfoConnector();
        } else {
            for (Object obj : xbmc.actors) {
                if (obj instanceof Actor) continue;
                unsupportedTags.add(obj);
            }
        }
        String tvdbid = tvShow.getIdAsString("tvdb");
        if (StringUtils.isNotBlank((CharSequence)tvdbid)) {
            xbmc.setId(tvdbid);
            xbmc.episodeguide.url.cache = tvdbid + ".xml";
            xbmc.episodeguide.url.url = "http://www.thetvdb.com/api/1D62F2F90030C444/series/" + tvdbid + "/all/" + TvShowModuleManager.SETTINGS.getScraperLanguage().name() + ".xml";
        }
        xbmc.setImdbid(tvShow.getIdAsString("imdb"));
        xbmc.setTitle(tvShow.getTitle());
        xbmc.setSorttitle(tvShow.getSortTitle());
        xbmc.setRating(tvShow.getRating());
        xbmc.setVotes(tvShow.getVotes());
        xbmc.setPlot(tvShow.getPlot());
        xbmc.setYear(tvShow.getYear());
        if (tvShow.getCertification() != null) {
            xbmc.setMpaa(tvShow.getCertification().getName());
        }
        xbmc.setPremiered(tvShow.getFirstAiredFormatted());
        if (StringUtils.isNotEmpty((CharSequence)tvShow.getProductionCompany())) {
            xbmc.studio = Arrays.asList(tvShow.getProductionCompany().split("\\s*[,\\/]\\s*"));
        }
        xbmc.setStatus(tvShow.getStatus());
        xbmc.genres.clear();
        for (MediaGenres genre : tvShow.getGenres()) {
            xbmc.addGenre(genre.toString());
        }
        xbmc.actors.clear();
        for (TvShowActor actor : tvShow.getActors()) {
            xbmc.addActor(actor.getName(), actor.getCharacter(), actor.getThumbUrl());
        }
        xbmc.tags.clear();
        for (String tag : tvShow.getTags()) {
            xbmc.tags.add(tag);
        }
        xbmc.unsupportedElements.addAll(unsupportedTags);
        try {
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.encoding", (Object)"UTF-8");
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String dat = formatter.format((Object)new Date());
            String comment = "<!-- created on " + dat + " - tinyMediaManager " + Globals.settings.getVersion() + " -->\n";
            m.setProperty("com.sun.xml.internal.bind.xmlHeaders", (Object)comment);
            StringWriter w = new StringWriter();
            m.marshal((Object)xbmc, (Writer)w);
            StringBuilder sb = new StringBuilder(((Object)w).toString());
            ((Writer)w).close();
            if (SystemUtils.IS_OS_WINDOWS) {
                sb = new StringBuilder(sb.toString().replaceAll("(?<!\r)\n", "\r\n"));
            }
            FileUtils.write((File)nfoFile, (CharSequence)sb, (String)"UTF-8");
            tvShow.removeAllMediaFiles(MediaFileType.NFO);
            tvShow.addToMediaFiles(new MediaFile(nfoFile));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error(nfoFile.getAbsolutePath() + " " + e.getMessage());
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)tvShow, "message.nfo.writeerror", new String[]{":", e.getLocalizedMessage()}));
        }
    }

    public static TvShow getData(File nfo) {
        if (context == null) {
            return null;
        }
        TvShow tvShow = null;
        try {
            TvShowToXbmcNfoConnector xbmc = TvShowToXbmcNfoConnector.parseNFO(nfo);
            tvShow = new TvShow();
            if (StringUtils.isNotBlank((CharSequence)xbmc.getId())) {
                tvShow.setTvdbId(xbmc.getId());
            }
            if (StringUtils.isNotBlank((CharSequence)xbmc.getImdbid())) {
                tvShow.setImdbId(xbmc.getImdbid());
            }
            tvShow.setTitle(xbmc.getTitle());
            tvShow.setSortTitle(xbmc.getSorttitle());
            tvShow.setRating(xbmc.getRating());
            tvShow.setVotes(xbmc.getVotes());
            tvShow.setYear(xbmc.getYear());
            tvShow.setPlot(xbmc.getPlot());
            tvShow.setCertification(Certification.findCertification((String)xbmc.getMpaa()));
            tvShow.setFirstAired(xbmc.getPremiered());
            String studio = StringUtils.join(xbmc.studio, (String)" / ");
            if (studio == null) {
                tvShow.setProductionCompany("");
            } else {
                tvShow.setProductionCompany(studio);
            }
            tvShow.setProductionCompany(tvShow.getProductionCompany().replaceAll("\\s*,\\s*", " / "));
            tvShow.setStatus(xbmc.getStatus());
            for (String genre : xbmc.getGenres()) {
                String[] genres;
                for (String g : genres = genre.split("/")) {
                    MediaGenres genreFound = MediaGenres.getGenre((String)g.trim());
                    if (genreFound == null) continue;
                    tvShow.addGenre(genreFound);
                }
            }
            for (Actor actor : xbmc.getActors()) {
                TvShowActor tvShowActor = new TvShowActor(actor.getName(), actor.getRole());
                tvShowActor.setThumbUrl(actor.getThumb());
                tvShow.addActor(tvShowActor);
            }
            for (String tag : xbmc.tags) {
                tvShow.addToTags(tag);
            }
            tvShow.addToMediaFiles(new MediaFile(nfo, MediaFileType.NFO));
        }
        catch (UnmarshalException e) {
            LOGGER.error("failed to parse " + nfo.getAbsolutePath() + " " + e.getMessage());
            return null;
        }
        catch (Exception e) {
            LOGGER.error(nfo.getAbsolutePath() + " " + e.getMessage());
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)tvShow.getTitle())) {
            return null;
        }
        return tvShow;
    }

    private static TvShowToXbmcNfoConnector parseNFO(File nfoFile) throws Exception {
        Unmarshaller um = context.createUnmarshaller();
        if (um == null) {
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, nfoFile, "message.nfo.readerror"));
            throw new Exception("could not create unmarshaller");
        }
        try {
            InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(nfoFile), "UTF-8");
            return (TvShowToXbmcNfoConnector)um.unmarshal((Reader)in);
        }
        catch (UnmarshalException e) {
            LOGGER.error("tried to unmarshal; now trying to clean xml stream");
            String completeNFO = FileUtils.readFileToString((File)nfoFile, (String)"UTF-8").trim().replaceFirst("^([\\W]+)<", "<");
            StringReader in = new StringReader(ParserUtils.cleanNfo(completeNFO));
            return (TvShowToXbmcNfoConnector)um.unmarshal((Reader)in);
        }
    }

    @XmlElement(name="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @XmlElement(name="sorttitle")
    public String getSorttitle() {
        return this.sorttitle;
    }

    public void setSorttitle(String sorttitle) {
        this.sorttitle = sorttitle;
    }

    @XmlElement(name="rating")
    public float getRating() {
        return this.rating;
    }

    @XmlElement(name="plot")
    public String getPlot() {
        return this.plot;
    }

    public void setRating(float rating) {
        this.rating = rating;
    }

    @XmlElement(name="votes")
    public int getVotes() {
        return this.votes;
    }

    public void setVotes(int votes) {
        this.votes = votes;
    }

    @XmlElement(name="year")
    public String getYear() {
        return this.year;
    }

    public void setYear(String year) {
        this.year = year;
    }

    @XmlElement(name="premiered")
    public String getPremiered() {
        return this.premiered;
    }

    public void setPremiered(String premiered) {
        this.premiered = premiered;
    }

    public void setPlot(String plot) {
        this.plot = plot;
    }

    public void addGenre(String genre) {
        this.genres.add(genre);
    }

    public List<String> getGenres() {
        return this.genres;
    }

    @XmlElement(name="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @XmlElement(name="imdbid")
    public String getImdbid() {
        return this.imdbid;
    }

    public void setImdbid(String imdbid) {
        this.imdbid = imdbid;
    }

    @XmlElement(name="mpaa")
    public String getMpaa() {
        return this.mpaa;
    }

    public void setMpaa(String mpaa) {
        this.mpaa = mpaa;
    }

    @XmlElement(name="status")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void addActor(String name, String role, String thumb) {
        Actor actor = new Actor(name, role, thumb);
        this.actors.add(actor);
    }

    public List<Actor> getActors() {
        ArrayList<Actor> pureActors = new ArrayList<Actor>();
        for (Object obj : this.actors) {
            if (!(obj instanceof Actor)) continue;
            Actor actor = (Actor)obj;
            pureActors.add(actor);
        }
        return pureActors;
    }

    public EpisodeGuide getEpisodeguide() {
        return this.episodeguide;
    }

    public void setEpisodeguide(EpisodeGuide episodeguide) {
        this.episodeguide = episodeguide;
    }

    static class EpisodeGuideUrl {
        @XmlAttribute
        String cache;
        @XmlValue
        String url;

        EpisodeGuideUrl() {
        }
    }

    static class EpisodeGuide {
        @XmlElement(name="url")
        EpisodeGuideUrl url = new EpisodeGuideUrl();

        EpisodeGuide() {
        }
    }

    static class Thumb {
        @XmlAttribute
        String type;
        @XmlAttribute
        String season;
        @XmlValue
        String thumb;

        Thumb() {
        }
    }

    @XmlRootElement(name="actor")
    public static class Actor {
        private String name;
        private String role;
        private String thumb;

        public Actor() {
        }

        public Actor(String name, String role, String thumb) {
            this.name = name;
            this.role = role;
            this.thumb = thumb;
        }

        @XmlElement(name="name")
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @XmlElement(name="role")
        public String getRole() {
            return this.role;
        }

        public void setRole(String role) {
            this.role = role;
        }

        @XmlElement(name="thumb")
        public String getThumb() {
            return this.thumb;
        }

        public void setThumb(String thumb) {
            this.thumb = thumb;
        }
    }
}

