/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.tasks;

import com.sun.jna.Platform;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.ImageCacheTask;
import org.tinymediamanager.core.MediaFileInformationFetcherTask;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.MediaSource;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieEdition;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.connector.MovieToKodiNfoConnector;
import org.tinymediamanager.core.movie.connector.MovieToMpNfoConnector;
import org.tinymediamanager.core.movie.connector.MovieToXbmcNfoConnector;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieTrailer;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.threading.TmmThreadPool;
import org.tinymediamanager.scraper.trakttv.SyncTraktTvTask;
import org.tinymediamanager.scraper.util.ParserUtils;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.tinymediamanager.thirdparty.VSMeta;
import org.tinymediamanager.ui.UTF8Control;

public class MovieUpdateDatasourceTask2
extends TmmThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieUpdateDatasourceTask2.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static long preDir = 0L;
    private static long postDir = 0L;
    private static long visFile = 0L;
    private static long preDirAll = 0L;
    private static long postDirAll = 0L;
    private static long visFileAll = 0L;
    private static final List<String> skipFolders = Arrays.asList(".", "..", "CERTIFICATE", "BACKUP", "PLAYLIST", "CLPINF", "SSIF", "AUXDATA", "AUDIO_TS", "JAR", "$RECYCLE.BIN", "RECYCLER", "SYSTEM VOLUME INFORMATION", "@EADIR");
    private static final String skipRegex = "^[.][\\w@]+.*";
    private static Pattern video3DPattern = Pattern.compile("(?i)[ ._\\(\\[-]3D[ ._\\)\\]-]?");
    private List<String> dataSources;
    private List<Movie> movieFolders = new ArrayList<Movie>();
    private MovieList movieList;
    private HashSet<Path> filesFound = new HashSet();

    public MovieUpdateDatasourceTask2() {
        super(BUNDLE.getString("update.datasource"));
        this.movieList = MovieList.getInstance();
        this.dataSources = new ArrayList<String>(MovieModuleManager.MOVIE_SETTINGS.getMovieDataSource());
    }

    public MovieUpdateDatasourceTask2(String datasource) {
        super(BUNDLE.getString("update.datasource") + " (" + datasource + ")");
        this.movieList = MovieList.getInstance();
        this.dataSources = new ArrayList<String>(1);
        this.dataSources.add(datasource);
    }

    public MovieUpdateDatasourceTask2(List<Movie> movies) {
        super(BUNDLE.getString("update.datasource"));
        this.movieList = MovieList.getInstance();
        this.dataSources = new ArrayList<String>(0);
        this.movieFolders.addAll(movies);
    }

    @Override
    public void doInBackground() {
        Utils.removeEmptyStringsFromList(this.dataSources);
        if (this.dataSources.isEmpty() && this.movieFolders.isEmpty()) {
            LOGGER.info("no datasource to update");
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, "update.datasource", "update.datasource.nonespecified"));
            return;
        }
        preDir = 0L;
        postDir = 0L;
        visFile = 0L;
        preDirAll = 0L;
        postDirAll = 0L;
        visFileAll = 0L;
        ArrayList<Path> existing = new ArrayList<Path>();
        for (Movie movie : this.movieList.getMovies()) {
            existing.add(movie.getPathNIO());
        }
        try {
            TmmTask task;
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            ArrayList<Path> imageFiles = new ArrayList<Path>();
            if (this.movieFolders.isEmpty()) {
                for (String ds : this.dataSources) {
                    LOGGER.info("Start UDS on datasource: " + ds);
                    this.initThreadPool(3, "update");
                    this.setTaskName(BUNDLE.getString("update.datasource") + " '" + ds + "'");
                    this.publishState();
                    Path path = Paths.get(ds, new String[0]);
                    if (!Files.exists(path, new LinkOption[0])) {
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"update.datasource", "update.datasource.unavailable", new String[]{ds}));
                        continue;
                    }
                    ArrayList<Path> newMovieDirs = new ArrayList<Path>();
                    ArrayList<Path> existingMovieDirs = new ArrayList<Path>();
                    List<Path> rootList = MovieUpdateDatasourceTask2.listFilesAndDirs(path);
                    if (rootList.isEmpty() && !Platform.isWindows()) {
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"update.datasource", "update.datasource.unavailable", new String[]{ds}));
                        continue;
                    }
                    ArrayList<Path> rootFiles = new ArrayList<Path>();
                    for (Path path2 : rootList) {
                        if (Files.isDirectory(path2, new LinkOption[0])) {
                            if (existing.contains(path2)) {
                                existingMovieDirs.add(path2);
                                continue;
                            }
                            newMovieDirs.add(path2);
                            continue;
                        }
                        rootFiles.add(path2);
                    }
                    rootList.clear();
                    for (Path path2 : newMovieDirs) {
                        this.searchAndParse(path.toAbsolutePath(), path2, Integer.MAX_VALUE);
                    }
                    for (Path path2 : existingMovieDirs) {
                        this.searchAndParse(path.toAbsolutePath(), path2, Integer.MAX_VALUE);
                    }
                    if (rootFiles.size() > 0) {
                        this.submitTask(new parseMultiMovieDirTask(path.toAbsolutePath(), path.toAbsolutePath(), rootFiles));
                    }
                    this.waitForCompletionOrCancel();
                    newMovieDirs.clear();
                    existingMovieDirs.clear();
                    rootFiles.clear();
                    if (this.cancel) break;
                    this.cleanup(ds);
                    this.gatherMediainfo(ds);
                    if (!this.cancel) {
                        if (!MovieModuleManager.MOVIE_SETTINGS.isBuildImageCacheOnImport()) continue;
                        for (Movie movie : this.movieList.getMovies()) {
                            if (!path.equals(Paths.get(movie.getDataSource(), new String[0]))) continue;
                            imageFiles.addAll(movie.getImagesToCache());
                        }
                        continue;
                    }
                    break;
                }
            } else {
                LOGGER.info("Start UDS for selected movies");
                this.initThreadPool(3, "update");
                this.setTaskName(BUNDLE.getString("update.datasource"));
                this.publishState();
                HashMap<Path, String> folder = new HashMap<Path, String>(this.movieFolders.size());
                for (Movie movie : this.movieFolders) {
                    folder.put(movie.getPathNIO(), movie.getDataSource());
                }
                for (Map.Entry entry : folder.entrySet()) {
                    Path dir = (Path)entry.getKey();
                    String ds = (String)entry.getValue();
                    this.submitTask(new FindMovieTask(dir, Paths.get(ds, new String[0])));
                }
                this.waitForCompletionOrCancel();
                this.cleanup(this.movieFolders);
                this.gatherMediainfo(this.movieFolders);
            }
            if (imageFiles.size() > 0) {
                task = new ImageCacheTask(imageFiles);
                TmmTaskManager.getInstance().addUnnamedTask(task);
            }
            if (MovieModuleManager.MOVIE_SETTINGS.getSyncTrakt()) {
                task = new SyncTraktTvTask(true, true, false, false);
                TmmTaskManager.getInstance().addUnnamedTask(task);
            }
            stopWatch.stop();
            LOGGER.info("Done updating datasource :) - took " + stopWatch);
            LOGGER.debug("FilesFound " + this.filesFound.size());
            LOGGER.debug("moviesFound " + this.movieList.getMovieCount());
            LOGGER.debug("PreDir " + preDir);
            LOGGER.debug("PostDir " + postDir);
            LOGGER.debug("VisFile " + visFile);
            LOGGER.debug("PreDirAll " + preDirAll);
            LOGGER.debug("PostDirAll " + postDirAll);
            LOGGER.debug("VisFileAll " + visFileAll);
        }
        catch (Exception e) {
            LOGGER.error("Thread crashed", (Throwable)e);
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, "update.datasource", "message.update.threadcrashed"));
        }
    }

    private void parseMovieDirectory(Path movieDir, Path dataSource) {
        List<Path> movieDirList = MovieUpdateDatasourceTask2.listFilesAndDirs(movieDir);
        ArrayList<Path> files = new ArrayList<Path>();
        ArrayList<Path> dirs = new ArrayList<Path>();
        HashSet<String> normalizedVideoFiles = new HashSet<String>();
        boolean isDiscFolder = false;
        boolean isMultiMovieDir = false;
        boolean videoFileFound = false;
        Path movieRoot = movieDir;
        for (Path path : movieDirList) {
            if (Utils.isRegularFile(path)) {
                files.add(path.toAbsolutePath());
                MediaFile mf = new MediaFile();
                mf.setPath(path.getParent().toString());
                mf.setFilename(path.getFileName().toString());
                mf.setType(mf.parseType());
                if (mf.getType() != MediaFileType.VIDEO) continue;
                videoFileFound = true;
                if (mf.isDiscFile()) {
                    isDiscFolder = true;
                    break;
                }
                String[] ty = ParserUtils.detectCleanMovienameAndYear(FilenameUtils.getBaseName((String)Utils.cleanStackingMarkers(mf.getFilename())));
                normalizedVideoFiles.add(ty[0] + ty[1]);
                continue;
            }
            if (!Files.isDirectory(path, new LinkOption[0])) continue;
            dirs.add(path.toAbsolutePath());
        }
        if (!videoFileFound) {
            return;
        }
        if (isDiscFolder) {
            Path relative = dataSource.relativize(movieDir);
            while (relative.toString().toUpperCase(Locale.ROOT).contains("VIDEO_TS") || relative.toString().toUpperCase(Locale.ROOT).contains("BDMV")) {
                movieDir = movieDir.getParent();
                relative = dataSource.relativize(movieDir);
            }
            movieRoot = movieDir;
        } else {
            if (normalizedVideoFiles.size() == 0) {
                return;
            }
            if (normalizedVideoFiles.size() > 1 || movieDir.equals(dataSource)) {
                isMultiMovieDir = true;
            }
        }
        if (this.cancel) {
            return;
        }
        if (isMultiMovieDir) {
            this.createMultiMovieFromDir(dataSource, movieRoot, files);
        } else {
            this.createSingleMovieFromDir(dataSource, movieRoot, isDiscFolder);
        }
    }

    private Movie parseNFOs(List<MediaFile> mfs) {
        Movie movie = null;
        for (MediaFile mf : mfs) {
            if (!mf.getType().equals((Object)MediaFileType.NFO)) continue;
            LOGGER.info("| parsing NFO " + mf.getFileAsPath());
            Movie nfo = null;
            switch (MovieModuleManager.MOVIE_SETTINGS.getMovieConnector()) {
                case XBMC: {
                    nfo = MovieToXbmcNfoConnector.getData(mf.getFileAsPath());
                    if (nfo == null) {
                        nfo = MovieToKodiNfoConnector.getData(mf.getFileAsPath());
                    }
                    if (nfo != null) break;
                    nfo = MovieToMpNfoConnector.getData(mf.getFileAsPath());
                    break;
                }
                case KODI: {
                    nfo = MovieToKodiNfoConnector.getData(mf.getFileAsPath());
                    if (nfo != null) break;
                    nfo = MovieToMpNfoConnector.getData(mf.getFileAsPath());
                    break;
                }
                case MP: {
                    nfo = MovieToMpNfoConnector.getData(mf.getFileAsPath());
                    if (nfo != null) break;
                    nfo = MovieToKodiNfoConnector.getData(mf.getFileAsPath());
                }
            }
            if (movie == null) {
                movie = nfo;
            } else {
                movie.merge(nfo);
            }
            if (movie == null || !movie.getImdbId().isEmpty()) continue;
            try {
                String imdb = Utils.readFileToString(mf.getFileAsPath());
                if ((imdb = ParserUtils.detectImdbId(imdb)).isEmpty()) continue;
                LOGGER.debug("| Found IMDB id: " + imdb);
                movie.setImdbId(imdb);
            }
            catch (IOException e) {
                LOGGER.warn("| couldn't read NFO " + mf);
            }
        }
        for (MediaFile mf : mfs) {
            if (!mf.getType().equals((Object)MediaFileType.VSMETA)) continue;
            if (movie == null) {
                movie = new Movie();
            }
            VSMeta vsmeta = new VSMeta();
            vsmeta.parseFile(mf.getFileAsPath());
            movie.merge(vsmeta.getMovie());
        }
        return movie;
    }

    private void createSingleMovieFromDir(Path dataSource, Path movieDir, boolean isDiscFolder) {
        Matcher matcher;
        LOGGER.info("Parsing single movie directory: " + movieDir + " (are we a disc folder? " + isDiscFolder + ")");
        Path relative = dataSource.relativize(movieDir);
        if (!Utils.getFolderStackingMarker(relative.toString()).isEmpty() && Utils.getFolderStackingMarker(relative.toString()).equals(movieDir.getFileName().toString())) {
            movieDir = movieDir.getParent();
        }
        Movie movie = this.movieList.getMovieByPath(movieDir);
        HashSet<Path> allFiles = MovieUpdateDatasourceTask2.getAllFilesRecursive(movieDir, 3);
        this.filesFound.add(movieDir.toAbsolutePath());
        this.filesFound.addAll(allFiles);
        ArrayList<MediaFile> mfs = new ArrayList<MediaFile>();
        for (Path file : allFiles) {
            mfs.add(new MediaFile(file));
        }
        allFiles.clear();
        if (movie == null) {
            LOGGER.debug("| movie not found; looking for NFOs");
            movie = this.parseNFOs(mfs);
            if (movie == null) {
                movie = new Movie();
            }
            movie.setNewlyAdded(true);
            movie.setDateAdded(new Date());
        }
        String bdinfoTitle = "";
        String videoName = "";
        for (MediaFile mf : mfs) {
            if (mf.getType().equals((Object)MediaFileType.TEXT)) {
                try {
                    String txtFile = Utils.readFileToString(mf.getFileAsPath());
                    String bdinfo = StrgUtils.substr((String)txtFile, (String)".*Disc Title:\\s+(.*?)[\\n\\r]");
                    if (!bdinfo.isEmpty()) {
                        LOGGER.debug("| Found Disc Title in BDInfo.txt: " + bdinfo);
                        bdinfoTitle = WordUtils.capitalizeFully((String)bdinfo);
                    }
                    String imdb = ParserUtils.detectImdbId(txtFile);
                    if (!movie.getImdbId().isEmpty() || imdb.isEmpty()) continue;
                    LOGGER.debug("| Found IMDB id: " + imdb);
                    movie.setImdbId(imdb);
                }
                catch (Exception e) {
                    LOGGER.warn("| couldn't read TXT " + mf.getFilename());
                }
                continue;
            }
            if (!mf.getType().equals((Object)MediaFileType.VIDEO)) continue;
            videoName = mf.getBasename();
        }
        if (movie.getTitle().isEmpty()) {
            String[] video = ParserUtils.detectCleanMovienameAndYear(movieDir.getFileName().toString());
            movie.setTitle(video[0]);
            if (!video[1].isEmpty()) {
                movie.setYear(video[1]);
            }
        }
        if ((matcher = video3DPattern.matcher(movieDir.getFileName().toString())).find()) {
            movie.setVideoIn3D(true);
        }
        if (movie.getEdition() == MovieEdition.NONE) {
            movie.setEdition(MovieEdition.getMovieEditionFromString(movieDir.getFileName().toString()));
        }
        movie.setPath(movieDir.toAbsolutePath().toString());
        movie.setDataSource(dataSource.toString());
        LOGGER.debug("| store movie into DB as: " + movie.getTitle());
        this.movieList.addMovie(movie);
        if (movie.getMovieSet() != null) {
            LOGGER.debug("| movie is part of a movieset");
            movie.getMovieSet().insertMovie(movie);
            this.movieList.sortMoviesInMovieSet(movie.getMovieSet());
            movie.getMovieSet().saveToDb();
        }
        this.addMediafilesToMovie(movie, mfs);
        if (movie.getArtworkFilename(MediaFileType.POSTER).isEmpty()) {
            for (MediaFile mf : mfs) {
                String vfilename;
                if (!mf.getType().equals((Object)MediaFileType.GRAPHIC)) continue;
                LOGGER.debug("| parsing unknown graphic " + mf.getFilename());
                List<MediaFile> vid = movie.getMediaFiles(MediaFileType.VIDEO);
                if (vid == null || vid.isEmpty() || !FilenameUtils.getBaseName((String)(vfilename = vid.get(0).getFilename())).equals(FilenameUtils.getBaseName((String)mf.getFilename())) && !FilenameUtils.getBaseName((String)Utils.cleanStackingMarkers(vfilename)).trim().equals(FilenameUtils.getBaseName((String)mf.getFilename())) && !movie.getTitle().equals(FilenameUtils.getBaseName((String)mf.getFilename()))) continue;
                mf.setType(MediaFileType.POSTER);
                movie.addToMediaFiles(mf);
            }
        }
        boolean isOffline = false;
        for (MediaFile mf : movie.getMediaFiles(MediaFileType.VIDEO)) {
            if (!"disc".equalsIgnoreCase(mf.getExtension())) continue;
            isOffline = true;
        }
        movie.setOffline(isOffline);
        movie.reEvaluateStacking();
        movie.saveToDb();
    }

    private void createMultiMovieFromDir(Path dataSource, Path movieDir) {
        List<Path> allFiles = MovieUpdateDatasourceTask2.listFilesOnly(movieDir);
        this.createMultiMovieFromDir(dataSource, movieDir, allFiles);
    }

    private void createMultiMovieFromDir(Path dataSource, Path movieDir, List<Path> allFiles) {
        LOGGER.info("Parsing multi  movie directory: " + movieDir);
        List<Movie> movies = this.movieList.getMoviesByPath(movieDir);
        this.filesFound.add(movieDir);
        this.filesFound.addAll(allFiles);
        ArrayList<MediaFile> mfs = new ArrayList<MediaFile>();
        for (Path file : allFiles) {
            mfs.add(new MediaFile(file));
        }
        Collections.sort(mfs, new Comparator<MediaFile>(){

            @Override
            public int compare(MediaFile file1, MediaFile file2) {
                return file2.getFileAsPath().getFileName().toString().length() - file1.getFileAsPath().getFileName().toString().length();
            }
        });
        for (MediaFile mf : this.getMediaFiles(mfs, MediaFileType.VIDEO)) {
            Movie movie = null;
            String basename = FilenameUtils.getBaseName((String)Utils.cleanStackingMarkers(mf.getFilename()));
            ArrayList<MediaFile> sameName = new ArrayList<MediaFile>();
            LOGGER.trace("UDS: basename: " + basename);
            for (MediaFile sm : mfs) {
                String smBasename = FilenameUtils.getBaseName((String)sm.getFilename());
                String smNameRegexp = Pattern.quote(basename) + "[\\s.,_-].*";
                if (!smBasename.equals(basename) && !smBasename.matches(smNameRegexp)) continue;
                if (sm.getType() == MediaFileType.GRAPHIC) {
                    sm.setType(MediaFileType.POSTER);
                }
                sameName.add(sm);
                LOGGER.trace("UDS: found matching MF: " + sm);
            }
            block3: for (Movie m : movies) {
                if (m.getMediaFiles(MediaFileType.VIDEO).contains(mf)) {
                    LOGGER.debug("| found movie '" + m.getTitle() + "' from MediaFile " + mf);
                    movie = m;
                    break;
                }
                for (MediaFile mfile : m.getMediaFiles(MediaFileType.VIDEO)) {
                    String[] mfTY;
                    String[] mfileTY = ParserUtils.detectCleanMovienameAndYear(FilenameUtils.getBaseName((String)Utils.cleanStackingMarkers(mfile.getFilename())));
                    if (!mfileTY[0].equals((mfTY = ParserUtils.detectCleanMovienameAndYear(FilenameUtils.getBaseName((String)Utils.cleanStackingMarkers(mf.getFilename()))))[0]) || !mfileTY[1].equals(mfTY[1])) continue;
                    LOGGER.debug("| found possible movie '" + m.getTitle() + "' from filename " + mf);
                    movie = m;
                    continue block3;
                }
            }
            if (movie == null) {
                movie = this.parseNFOs(sameName);
                if (movie == null) {
                    LOGGER.debug("| Create new movie from file: " + mf);
                    movie = new Movie();
                    String[] ty = ParserUtils.detectCleanMovienameAndYear(basename);
                    movie.setTitle(ty[0]);
                    if (!ty[1].isEmpty()) {
                        movie.setYear(ty[1]);
                    }
                    movie.setEdition(MovieEdition.getMovieEditionFromString(basename));
                    Matcher matcher = video3DPattern.matcher(basename);
                    if (matcher.find()) {
                        movie.setVideoIn3D(true);
                    }
                    movie.setDateAdded(new Date());
                }
                movie.setDataSource(dataSource.toString());
                movie.setNewlyAdded(true);
                movie.setPath(mf.getPath());
                this.movieList.addMovie(movie);
                movies.add(movie);
            }
            if (!Utils.isValidImdbId(movie.getImdbId())) {
                movie.setImdbId(ParserUtils.detectImdbId(mf.getFileAsPath().toString()));
            }
            if (movie.getMediaSource() == MediaSource.UNKNOWN) {
                movie.setMediaSource(MediaSource.parseMediaSource(mf.getFile().getAbsolutePath()));
            }
            LOGGER.debug("| parsing video file " + mf.getFilename());
            movie.setDateAddedFromMediaFile(mf);
            movie.setMultiMovieDir(true);
            this.addMediafilesToMovie(movie, sameName);
            mfs.removeAll(sameName);
            boolean isOffline = false;
            for (MediaFile mediaFiles : movie.getMediaFiles(MediaFileType.VIDEO)) {
                if (!"disc".equalsIgnoreCase(mediaFiles.getExtension())) continue;
                isOffline = true;
            }
            movie.setOffline(isOffline);
            if (movie.getMovieSet() != null) {
                LOGGER.debug("| movie is part of a movieset");
                movie.getMovieSet().insertMovie(movie);
                this.movieList.sortMoviesInMovieSet(movie.getMovieSet());
                movie.getMovieSet().saveToDb();
            }
            movie.saveToDb();
        }
        for (Movie m : this.movieList.getMoviesByPath(movieDir)) {
            m.reEvaluateStacking();
            m.saveToDb();
        }
    }

    private void addMediafilesToMovie(Movie movie, List<MediaFile> mediaFiles) {
        ArrayList<MediaFile> current = new ArrayList<MediaFile>(movie.getMediaFiles());
        block8: for (MediaFile mf : mediaFiles) {
            if (current.contains(mf)) continue;
            if (mf.getPath().toUpperCase(Locale.ROOT).contains("BDMV") || mf.getPath().toUpperCase(Locale.ROOT).contains("VIDEO_TS") || mf.isDiscFile()) {
                movie.setDisc(true);
                if (movie.getMediaSource() == MediaSource.UNKNOWN) {
                    movie.setMediaSource(MediaSource.parseMediaSource(mf.getPath()));
                }
            }
            if (!Utils.isValidImdbId(movie.getImdbId())) {
                movie.setImdbId(ParserUtils.detectImdbId(mf.getFileAsPath().toString()));
            }
            LOGGER.debug("| parsing " + mf.getType().name() + " " + mf.getFileAsPath());
            switch (mf.getType()) {
                case VIDEO: {
                    movie.addToMediaFiles(mf);
                    movie.setDateAddedFromMediaFile(mf);
                    if (movie.getMediaSource() != MediaSource.UNKNOWN) break;
                    movie.setMediaSource(MediaSource.parseMediaSource(mf.getFile().getAbsolutePath()));
                    break;
                }
                case TRAILER: {
                    mf.gatherMediaInformation();
                    MovieTrailer mt = new MovieTrailer();
                    mt.setName(mf.getFilename());
                    mt.setProvider("downloaded");
                    mt.setQuality(mf.getVideoFormat());
                    mt.setInNfo(false);
                    mt.setUrl(mf.getFileAsPath().toUri().toString());
                    movie.addTrailer(mt);
                    movie.addToMediaFiles(mf);
                    break;
                }
                case SUBTITLE: {
                    if (mf.isPacked()) break;
                    movie.setSubtitles(true);
                    movie.addToMediaFiles(mf);
                    break;
                }
                case FANART: {
                    if (mf.getPath().toLowerCase(Locale.ROOT).contains("extrafanart")) {
                        LOGGER.warn("problem: detected media file type FANART in extrafanart folder: " + mf.getPath());
                        continue block8;
                    }
                    movie.addToMediaFiles(mf);
                    break;
                }
                case THUMB: {
                    if (mf.getPath().toLowerCase(Locale.ROOT).contains("extrathumbs")) {
                        LOGGER.warn("| problem: detected media file type THUMB in extrathumbs folder: " + mf.getPath());
                        continue block8;
                    }
                    movie.addToMediaFiles(mf);
                    break;
                }
                case VIDEO_EXTRA: 
                case SAMPLE: 
                case NFO: 
                case TEXT: 
                case POSTER: 
                case SEASON_POSTER: 
                case EXTRAFANART: 
                case EXTRATHUMB: 
                case AUDIO: 
                case DISCART: 
                case BANNER: 
                case CLEARART: 
                case LOGO: 
                case CLEARLOGO: 
                case MEDIAINFO: 
                case VSMETA: {
                    movie.addToMediaFiles(mf);
                    break;
                }
                default: {
                    LOGGER.debug("| NOT adding unknown media file type: " + mf.getFileAsPath());
                }
            }
            if (mf.getType() == MediaFileType.GRAPHIC || mf.getType() == MediaFileType.UNKNOWN || mf.getType() == MediaFileType.NFO || movie.getMediaFiles().contains(mf)) continue;
            LOGGER.error("| Movie not added mf: " + mf.getFileAsPath());
        }
    }

    private void cleanup(String datasource) {
        this.setTaskName(BUNDLE.getString("update.cleanup"));
        this.setTaskDescription(null);
        this.setProgressDone(0);
        this.setWorkUnits(0);
        this.publishState();
        LOGGER.info("removing orphaned movies/files...");
        ArrayList<Movie> moviesToRemove = new ArrayList<Movie>();
        for (int i = this.movieList.getMovies().size() - 1; i >= 0 && !this.cancel; --i) {
            Movie movie = this.movieList.getMovies().get(i);
            if (!Paths.get(datasource, new String[0]).equals(Paths.get(movie.getDataSource(), new String[0]))) continue;
            Path movieDir = movie.getPathNIO();
            if (!this.filesFound.contains(movieDir)) {
                if (!Files.exists(movieDir, new LinkOption[0])) {
                    LOGGER.debug("movie directory '" + movieDir + "' not found, removing from DB...");
                    moviesToRemove.add(movie);
                } else {
                    LOGGER.warn("dir " + movieDir + " not in hashset, but on hdd!");
                }
            }
            if (!movie.isNewlyAdded()) {
                ArrayList<MediaFile> mediaFiles = new ArrayList<MediaFile>(movie.getMediaFiles());
                for (MediaFile mf : mediaFiles) {
                    if (this.filesFound.contains(mf.getFileAsPath())) continue;
                    if (!mf.exists()) {
                        LOGGER.debug("removing orphaned file from DB: " + mf.getFileAsPath());
                        movie.removeFromMediaFiles(mf);
                        continue;
                    }
                    LOGGER.warn("file " + mf.getFileAsPath() + " not in hashset, but on hdd!");
                }
                if (movie.getMediaFiles(MediaFileType.VIDEO).isEmpty()) {
                    LOGGER.debug("Movie (" + movie.getTitle() + ") without VIDEO files detected, removing from DB...");
                    moviesToRemove.add(movie);
                    continue;
                }
                movie.saveToDb();
                continue;
            }
            LOGGER.info("Movie (" + movie.getTitle() + ") is new - no need for cleanup");
        }
        this.movieList.removeMovies(moviesToRemove);
    }

    private void cleanup(List<Movie> movies) {
        this.setTaskName(BUNDLE.getString("update.cleanup"));
        this.setTaskDescription(null);
        this.setProgressDone(0);
        this.setWorkUnits(0);
        this.publishState();
        LOGGER.info("removing orphaned movies/files...");
        ArrayList<Movie> moviesToRemove = new ArrayList<Movie>();
        for (int i = movies.size() - 1; i >= 0 && !this.cancel; --i) {
            Movie movie = movies.get(i);
            Path movieDir = movie.getPathNIO();
            if (!this.filesFound.contains(movieDir)) {
                if (!Files.exists(movieDir, new LinkOption[0])) {
                    LOGGER.debug("movie directory '" + movieDir + "' not found, removing from DB...");
                    moviesToRemove.add(movie);
                } else {
                    LOGGER.warn("dir " + movieDir + " not in hashset, but on hdd!");
                }
            }
            if (!movie.isNewlyAdded()) {
                ArrayList<MediaFile> mediaFiles = new ArrayList<MediaFile>(movie.getMediaFiles());
                for (MediaFile mf : mediaFiles) {
                    if (this.filesFound.contains(mf.getFileAsPath())) continue;
                    if (!mf.exists()) {
                        LOGGER.debug("removing orphaned file from DB: " + mf.getFileAsPath());
                        movie.removeFromMediaFiles(mf);
                        continue;
                    }
                    LOGGER.warn("file " + mf.getFileAsPath() + " not in hashset, but on hdd!");
                }
                if (movie.getMediaFiles(MediaFileType.VIDEO).isEmpty()) {
                    LOGGER.debug("Movie (" + movie.getTitle() + ") without VIDEO files detected, removing from DB...");
                    moviesToRemove.add(movie);
                    continue;
                }
                movie.saveToDb();
                continue;
            }
            LOGGER.info("Movie (" + movie.getTitle() + ") is new - no need for cleanup");
        }
        this.movieList.removeMovies(moviesToRemove);
    }

    private void gatherMediainfo(String datasource) {
        this.setTaskName(BUNDLE.getString("update.mediainfo"));
        this.publishState();
        this.initThreadPool(1, "mediainfo");
        LOGGER.info("getting Mediainfo...");
        for (int i = this.movieList.getMovies().size() - 1; i >= 0 && !this.cancel; --i) {
            Movie movie = this.movieList.getMovies().get(i);
            if (!Paths.get(datasource, new String[0]).equals(Paths.get(movie.getDataSource(), new String[0]))) continue;
            for (MediaFile mf : new ArrayList<MediaFile>(movie.getMediaFiles())) {
                if (!StringUtils.isBlank((CharSequence)mf.getContainerFormat())) continue;
                this.submitTask(new MediaFileInformationFetcherTask(mf, (MediaEntity)movie, false));
            }
        }
        this.waitForCompletionOrCancel();
    }

    private void gatherMediainfo(List<Movie> movies) {
        this.setTaskName(BUNDLE.getString("update.mediainfo"));
        this.publishState();
        this.initThreadPool(1, "mediainfo");
        LOGGER.info("getting Mediainfo...");
        for (Movie movie : movies) {
            if (this.cancel) break;
            for (MediaFile mf : new ArrayList<MediaFile>(movie.getMediaFiles())) {
                if (!StringUtils.isBlank((CharSequence)mf.getContainerFormat())) continue;
                this.submitTask(new MediaFileInformationFetcherTask(mf, (MediaEntity)movie, false));
            }
        }
        this.waitForCompletionOrCancel();
    }

    private MediaFile getMediaFile(List<MediaFile> mfs, MediaFileType ... types) {
        MediaFile mf = null;
        for (MediaFile mediaFile : mfs) {
            boolean match = false;
            for (MediaFileType type : types) {
                if (!mediaFile.getType().equals((Object)type)) continue;
                match = true;
            }
            if (!match) continue;
            mf = new MediaFile(mediaFile);
        }
        return mf;
    }

    private List<MediaFile> getMediaFiles(List<MediaFile> mfs, MediaFileType ... types) {
        ArrayList<MediaFile> mf = new ArrayList<MediaFile>();
        for (MediaFile mediaFile : mfs) {
            boolean match = false;
            for (MediaFileType type : types) {
                if (!mediaFile.getType().equals((Object)type)) continue;
                match = true;
            }
            if (!match) continue;
            mf.add(new MediaFile(mediaFile));
        }
        return mf;
    }

    @Override
    public void callback(Object obj) {
        this.publishState(this.progressDone);
    }

    public static List<Path> listFilesOnly(Path directory) {
        ArrayList<Path> fileNames = new ArrayList<Path>();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(directory);){
            for (Path path : directoryStream) {
                if (!Utils.isRegularFile(path)) continue;
                String fn = path.getFileName().toString().toUpperCase(Locale.ROOT);
                if (!(skipFolders.contains(fn) || fn.matches(skipRegex) || MovieModuleManager.MOVIE_SETTINGS.getMovieSkipFolders().contains(path.toFile().getAbsolutePath()))) {
                    fileNames.add(path.toAbsolutePath());
                    continue;
                }
                LOGGER.debug("Skipping: " + path);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return fileNames;
    }

    public static List<Path> listFilesAndDirs(Path directory) {
        ArrayList<Path> fileNames = new ArrayList<Path>();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(directory);){
            for (Path path : directoryStream) {
                String fn = path.getFileName().toString().toUpperCase(Locale.ROOT);
                if (!(skipFolders.contains(fn) || fn.matches(skipRegex) || MovieModuleManager.MOVIE_SETTINGS.getMovieSkipFolders().contains(path.toFile().getAbsolutePath()))) {
                    fileNames.add(path.toAbsolutePath());
                    continue;
                }
                LOGGER.debug("Skipping: " + path);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return fileNames;
    }

    public static HashSet<Path> getAllFilesRecursive(Path folder, int deep) {
        folder = folder.toAbsolutePath();
        AllFilesRecursive visitor = new AllFilesRecursive();
        try {
            Files.walkFileTree(folder, EnumSet.of(FileVisitOption.FOLLOW_LINKS), deep, visitor);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return visitor.fFound;
    }

    public void searchAndParse(Path datasource, Path folder, int deep) {
        folder = folder.toAbsolutePath();
        SearchAndParseVisitor visitor = new SearchAndParseVisitor(datasource);
        try {
            Files.walkFileTree(folder, EnumSet.of(FileVisitOption.FOLLOW_LINKS), deep, visitor);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private class SearchAndParseVisitor
    implements FileVisitor<Path> {
        private Path datasource;
        private ArrayList<String> unstackedRoot = new ArrayList();
        private HashSet<Path> videofolders = new HashSet();

        protected SearchAndParseVisitor(Path datasource) {
            this.datasource = datasource;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attr) {
            visFile++;
            if (Utils.isRegularFile(attr) && !file.getFileName().toString().matches(MovieUpdateDatasourceTask2.skipRegex) && Globals.settings.getVideoFileType().contains("." + FilenameUtils.getExtension((String)file.toString()).toLowerCase(Locale.ROOT))) {
                if (file.getParent().getFileName().toString().equals("STREAM")) {
                    return FileVisitResult.CONTINUE;
                }
                this.videofolders.add(file.getParent());
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            preDir++;
            String fn = dir.getFileName().toString().toUpperCase(Locale.ROOT);
            if (skipFolders.contains(fn) || fn.matches(MovieUpdateDatasourceTask2.skipRegex) || Files.exists(dir.resolve(".tmmignore"), new LinkOption[0]) || Files.exists(dir.resolve("tmmignore"), new LinkOption[0]) || Files.exists(dir.resolve(".nomedia"), new LinkOption[0]) || MovieModuleManager.MOVIE_SETTINGS.getMovieSkipFolders().contains(dir.toFile().getAbsolutePath())) {
                LOGGER.debug("Skipping dir: " + dir);
                return FileVisitResult.SKIP_SUBTREE;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
            postDir++;
            if (MovieUpdateDatasourceTask2.this.cancel) {
                return FileVisitResult.TERMINATE;
            }
            if (this.videofolders.contains(dir)) {
                boolean update = true;
                Path relative = this.datasource.relativize(dir);
                if (!Utils.getFolderStackingMarker(relative.toString()).isEmpty() && Utils.getFolderStackingMarker(relative.toString()).equals(dir.getFileName().toString())) {
                    if (this.unstackedRoot.contains(dir.getParent().toString())) {
                        update = false;
                    } else {
                        this.unstackedRoot.add(dir.getParent().toString());
                    }
                }
                if (update) {
                    MovieUpdateDatasourceTask2.this.submitTask(new FindMovieTask(dir, this.datasource));
                }
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) {
            LOGGER.error("" + exc);
            return FileVisitResult.CONTINUE;
        }
    }

    private static class AllFilesRecursive
    extends SimpleFileVisitor<Path> {
        private HashSet<Path> fFound = new HashSet();

        private AllFilesRecursive() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attr) {
            visFileAll++;
            if (Utils.isRegularFile(attr) && !file.getFileName().toString().matches(MovieUpdateDatasourceTask2.skipRegex)) {
                this.fFound.add(file.toAbsolutePath());
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            preDirAll++;
            if (dir.getFileName() != null && (Files.exists(dir.resolve(".tmmignore"), new LinkOption[0]) || Files.exists(dir.resolve("tmmignore"), new LinkOption[0]) || Files.exists(dir.resolve(".nomedia"), new LinkOption[0]) || skipFolders.contains(dir.getFileName().toString().toUpperCase(Locale.ROOT)) || dir.getFileName().toString().matches(MovieUpdateDatasourceTask2.skipRegex)) || MovieModuleManager.MOVIE_SETTINGS.getMovieSkipFolders().contains(dir.toFile().getAbsolutePath())) {
                LOGGER.debug("Skipping dir: " + dir);
                return FileVisitResult.SKIP_SUBTREE;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
            postDirAll++;
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) {
            LOGGER.error("" + exc);
            return FileVisitResult.CONTINUE;
        }
    }

    private class parseMultiMovieDirTask
    implements Callable<Object> {
        private Path movieDir = null;
        private Path datasource = null;
        private List<Path> allFiles = null;

        public parseMultiMovieDirTask(Path dataSource, Path movieDir, List<Path> allFiles) {
            this.datasource = dataSource;
            this.movieDir = movieDir;
            this.allFiles = allFiles;
        }

        @Override
        public String call() {
            MovieUpdateDatasourceTask2.this.createMultiMovieFromDir(this.datasource, this.movieDir, this.allFiles);
            return this.movieDir.toString();
        }
    }

    private class FindMovieTask
    implements Callable<Object> {
        private Path subdir = null;
        private Path datasource = null;
        private long uniqueId;

        public FindMovieTask(Path subdir, Path datasource) {
            this.subdir = subdir;
            this.datasource = datasource;
            this.uniqueId = TmmTaskManager.getInstance().GLOB_THRD_CNT.incrementAndGet();
        }

        @Override
        public String call() {
            String name = Thread.currentThread().getName();
            if (!name.contains("-G")) {
                name = name + "-G0";
            }
            name = name.replaceAll("\\-G\\d+", "-G" + this.uniqueId);
            Thread.currentThread().setName(name);
            MovieUpdateDatasourceTask2.this.parseMovieDirectory(this.subdir, this.datasource);
            return this.subdir.toString();
        }
    }
}

