/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.CustomNullStringSerializerProvider;
import org.tinymediamanager.core.ITmmModule;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;

public class MovieModuleManager
implements ITmmModule {
    public static final MovieSettings MOVIE_SETTINGS = Globals.settings.getMovieSettings();
    private static final String MODULE_TITLE = "Movie management";
    private static final String MOVIE_DB = "movies.db";
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieModuleManager.class);
    private static MovieModuleManager instance;
    private boolean enabled = false;
    private MVStore mvStore;
    private ObjectMapper objectMapper;
    private ObjectWriter movieObjectWriter;
    private ObjectWriter movieSetObjectWriter;
    private MVMap<UUID, String> movieMap;
    private MVMap<UUID, String> movieSetMap;

    private MovieModuleManager() {
    }

    public static MovieModuleManager getInstance() {
        if (instance == null) {
            instance = new MovieModuleManager();
        }
        return instance;
    }

    @Override
    public String getModuleTitle() {
        return MODULE_TITLE;
    }

    @Override
    public void startUp() throws Exception {
        Path db = Paths.get(Settings.getInstance().getSettingsFolder(), MOVIE_DB);
        Utils.createBackupFile(db);
        Utils.deleteOldBackupFile(db, 15);
        this.mvStore = new MVStore.Builder().fileName(Paths.get(Settings.getInstance().getSettingsFolder(), MOVIE_DB).toString()).compressHigh().backgroundExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                LOGGER.error("Error in the background thread of the persistent cache", e);
            }
        }).autoCommitBufferSize(4096).open();
        this.mvStore.setAutoCommitDelay(2000);
        this.mvStore.setRetentionTime(0);
        this.mvStore.setReuseSpace(true);
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(MapperFeature.AUTO_DETECT_GETTERS, false);
        this.objectMapper.configure(MapperFeature.AUTO_DETECT_IS_GETTERS, false);
        this.objectMapper.configure(MapperFeature.AUTO_DETECT_SETTERS, false);
        this.objectMapper.configure(MapperFeature.AUTO_DETECT_FIELDS, false);
        this.objectMapper.setTimeZone(TimeZone.getDefault());
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_DEFAULT);
        this.objectMapper.setSerializerProvider((DefaultSerializerProvider)new CustomNullStringSerializerProvider());
        this.movieObjectWriter = this.objectMapper.writerFor(Movie.class);
        this.movieSetObjectWriter = this.objectMapper.writerFor(MovieSet.class);
        this.movieMap = this.mvStore.openMap("movies");
        this.movieSetMap = this.mvStore.openMap("movieSets");
        MovieList.getInstance().loadMoviesFromDatabase(this.movieMap, this.objectMapper);
        MovieList.getInstance().loadMovieSetsFromDatabase(this.movieSetMap, this.objectMapper);
        MovieList.getInstance().initDataAfterLoading();
        this.enabled = true;
    }

    @Override
    public void shutDown() throws Exception {
        this.mvStore.compactMoveChunks();
        this.mvStore.close();
        this.enabled = false;
        if (Globals.settings.isDeleteTrashOnExit()) {
            for (String ds : MOVIE_SETTINGS.getMovieDataSource()) {
                Path file = Paths.get(ds, ".deletedByTMM");
                Utils.deleteDirectoryRecursive(file);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void dump(Movie movie) {
        try {
            JSONObject jsonObject = new JSONObject(this.movieObjectWriter.writeValueAsString((Object)movie));
            LOGGER.info("Dumping Movie:\n" + jsonObject.toString(4));
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Cannot parse JSON!", (Throwable)e);
        }
    }

    public void dump(MovieSet movieSet) {
        try {
            JSONObject jsonObject = new JSONObject(this.movieSetObjectWriter.writeValueAsString((Object)movieSet));
            LOGGER.info("Dumping MovieSet:\n" + jsonObject.toString(4));
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Cannot parse JSON!", (Throwable)e);
        }
    }

    void persistMovie(Movie movie) throws Exception {
        String oldValue;
        String newValue = this.movieObjectWriter.writeValueAsString((Object)movie);
        if (!StringUtils.equals((CharSequence)newValue, (CharSequence)(oldValue = (String)this.movieMap.get((Object)movie.getDbId())))) {
            this.movieMap.put((Object)movie.getDbId(), (Object)newValue);
        }
    }

    void removeMovieFromDb(Movie movie) throws Exception {
        this.movieMap.remove((Object)movie.getDbId());
    }

    void persistMovieSet(MovieSet movieSet) throws Exception {
        String oldValue;
        String newValue = this.movieSetObjectWriter.writeValueAsString((Object)movieSet);
        if (!StringUtils.equals((CharSequence)newValue, (CharSequence)(oldValue = (String)this.movieMap.get((Object)movieSet.getDbId())))) {
            this.movieSetMap.put((Object)movieSet.getDbId(), (Object)newValue);
        }
    }

    void removeMovieSetFromDb(MovieSet movieSet) throws Exception {
        this.movieSetMap.remove((Object)movieSet.getDbId());
    }

    @Override
    public void initializeDatabase() throws Exception {
        Utils.deleteFileSafely(Paths.get(Settings.getInstance().getSettingsFolder(), MOVIE_DB));
    }
}

