/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.stephenc.javaisotools.loopfs.iso9660.Iso9660FileEntry;
import com.github.stephenc.javaisotools.loopfs.iso9660.Iso9660FileSystem;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFileAudioStream;
import org.tinymediamanager.core.entities.MediaFileSubtitle;
import org.tinymediamanager.scraper.util.LanguageUtils;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.tinymediamanager.thirdparty.MediaInfo;
import org.tinymediamanager.thirdparty.MediaInfoXMLParser;

public class MediaFile
extends AbstractModelObject
implements Comparable<MediaFile> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaFile.class);
    private static final String PATH = "path";
    private static final String FILENAME = "filename";
    private static final String FILESIZE = "filesize";
    private static final String FILESIZE_IN_MB = "filesizeInMegabytes";
    private static final List<String> PLEX_EXTRA_FOLDERS = Arrays.asList("behind the scenes", "behindthescenes", "deleted scenes", "deletedscenes", "featurettes", "interviews", "scenes", "shorts");
    private static Pattern moviesetPattern = Pattern.compile("(?i)movieset-(poster|fanart|banner|disc|discart|logo|clearlogo|clearart|thumb)\\..{2,4}");
    private static Pattern posterPattern = Pattern.compile("(?i)(.*-poster|poster|folder|movie|.*-cover|cover)\\..{2,4}");
    private static Pattern fanartPattern = Pattern.compile("(?i)(.*-fanart|.*\\.fanart|fanart)[0-9]{0,2}\\..{2,4}");
    private static Pattern bannerPattern = Pattern.compile("(?i)(.*-banner|banner)\\..{2,4}");
    private static Pattern thumbPattern = Pattern.compile("(?i)(.*-thumb|thumb)[0-9]{0,2}\\..{2,4}");
    private static Pattern seasonPattern = Pattern.compile("(?i)season([0-9]{0,2}|-specials)-poster\\..{2,4}");
    private static Pattern logoPattern = Pattern.compile("(?i)(.*-logo|logo)\\..{2,4}");
    private static Pattern clearlogoPattern = Pattern.compile("(?i)(.*-clearlogo|clearlogo)\\..{2,4}");
    private static Pattern discartPattern = Pattern.compile("(?i)(.*-discart|discart|.*-disc|disc)\\.(jpg|jpeg|png|tbn)");
    private static Pattern clearartPattern = Pattern.compile("(?i)(.*-clearart|clearart)\\..{2,4}");
    public static final String VIDEO_FORMAT_480P = "480p";
    public static final String VIDEO_FORMAT_576P = "576p";
    public static final String VIDEO_FORMAT_540P = "540p";
    public static final String VIDEO_FORMAT_720P = "720p";
    public static final String VIDEO_FORMAT_1080P = "1080p";
    public static final String VIDEO_FORMAT_4K = "4k";
    public static final String VIDEO_FORMAT_8K = "8k";
    public static final String VIDEO_FORMAT_SD = "SD";
    public static final String VIDEO_FORMAT_HD = "HD";
    public static final String VIDEO_3D = "3D";
    public static final String VIDEO_3D_SBS = "3D SBS";
    public static final String VIDEO_3D_TAB = "3D TAB";
    public static final String VIDEO_3D_HSBS = "3D HSBS";
    public static final String VIDEO_3D_HTAB = "3D HTAB";
    @JsonProperty
    private MediaFileType type = MediaFileType.UNKNOWN;
    @JsonProperty
    private String path = "";
    @JsonProperty
    private String filename = "";
    @JsonProperty
    private long filesize = 0L;
    @JsonProperty
    private long filedate = 0L;
    @JsonProperty
    private String videoCodec = "";
    @JsonProperty
    private String containerFormat = "";
    @JsonProperty
    private String exactVideoFormat = "";
    @JsonProperty
    private String video3DFormat = "";
    @JsonProperty
    private int videoWidth = 0;
    @JsonProperty
    private int videoHeight = 0;
    @JsonProperty
    private int overallBitRate = 0;
    @JsonProperty
    private int durationInSecs = 0;
    @JsonProperty
    private int stacking = 0;
    @JsonProperty
    private String stackingMarker = "";
    @JsonProperty
    private List<MediaFileAudioStream> audioStreams = new CopyOnWriteArrayList<MediaFileAudioStream>();
    @JsonProperty
    private List<MediaFileSubtitle> subtitles = new CopyOnWriteArrayList<MediaFileSubtitle>();
    private MediaInfo mediaInfo;
    private Map<MediaInfo.StreamKind, List<Map<String, String>>> miSnapshot = null;
    private Path file = null;
    private boolean isISO = false;

    public MediaFile(MediaFile clone) {
        this.path = new String(clone.path);
        this.filename = new String(clone.filename);
        this.filesize = clone.filesize;
        this.filedate = clone.filedate;
        this.videoCodec = new String(clone.videoCodec);
        this.containerFormat = new String(clone.containerFormat);
        this.exactVideoFormat = new String(clone.exactVideoFormat);
        this.video3DFormat = new String(clone.video3DFormat);
        this.videoHeight = clone.videoHeight;
        this.videoWidth = clone.videoWidth;
        this.overallBitRate = clone.overallBitRate;
        this.durationInSecs = clone.durationInSecs;
        this.stacking = clone.stacking;
        this.stackingMarker = clone.stackingMarker;
        this.type = clone.type;
        this.audioStreams.addAll(clone.audioStreams);
        this.subtitles.addAll(clone.subtitles);
    }

    public MediaFile() {
        this.path = "";
        this.filename = "";
    }

    @Deprecated
    public MediaFile(File f) {
        this(f.toPath(), null);
    }

    public MediaFile(Path f) {
        this(f, null);
    }

    @Deprecated
    public MediaFile(File f, MediaFileType type) {
        this(f.toPath(), type);
    }

    public MediaFile(Path f, MediaFileType type) {
        this.path = f.getParent().toString();
        this.filename = f.getFileName().toString();
        this.file = f.toAbsolutePath();
        this.type = type == null ? this.parseType() : type;
        if (!this.isValidMediainfoFormat() && StringUtils.isBlank((CharSequence)this.getContainerFormat())) {
            this.setContainerFormat(this.getExtension());
        }
    }

    private void gatherSubtitleInformation() {
        MediaFileSubtitle sub = new MediaFileSubtitle();
        String shortname = this.getBasename().toLowerCase(Locale.ROOT);
        if (shortname.contains("forced")) {
            sub.setForced(true);
            shortname = shortname.replaceAll("\\p{Punct}*forced", "");
        }
        sub.setLanguage(this.parseLanguageFromString(shortname));
        if (sub.getLanguage().isEmpty() && this.filename.endsWith(".sub")) {
            try {
                String line;
                File idx = new File(this.path, this.filename.replaceFirst("sub$", "idx"));
                BufferedReader br = new BufferedReader(new FileReader(idx));
                while ((line = br.readLine()) != null) {
                    String lang = "";
                    if (line.startsWith("id:")) {
                        lang = StrgUtils.substr((String)line, (String)"id: (.*?),");
                    }
                    if (line.startsWith("# alt:")) {
                        lang = StrgUtils.substr((String)line, (String)"^# alt: (.*?)$");
                    }
                    if (lang.isEmpty()) continue;
                    sub.setLanguage(LanguageUtils.getIso3LanguageFromLocalizedString((String)lang));
                    break;
                }
                br.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        sub.setCodec(this.getExtension());
        this.subtitles.clear();
        this.subtitles.add(sub);
    }

    public MediaFileType parseType() {
        String ext = this.getExtension().toLowerCase(Locale.ROOT);
        String basename = FilenameUtils.getBaseName((String)this.getFilename());
        String foldername = FilenameUtils.getBaseName((String)this.getPath()).toLowerCase(Locale.ROOT);
        if (ext.equals("nfo")) {
            return MediaFileType.NFO;
        }
        if (ext.equals("vsmeta")) {
            return MediaFileType.VSMETA;
        }
        if (basename.endsWith("-mediainfo") && "xml".equals(ext)) {
            return MediaFileType.MEDIAINFO;
        }
        if (ext.equals("jpg") || ext.equals("jpeg") || ext.equals("png") || ext.equals("tbn") || ext.equals("gif")) {
            return this.parseImageType();
        }
        if (Globals.settings.getAudioFileType().contains("." + ext)) {
            return MediaFileType.AUDIO;
        }
        if (Globals.settings.getSubtitleFileType().contains("." + ext)) {
            return MediaFileType.SUBTITLE;
        }
        if (Globals.settings.getVideoFileType().contains("." + ext)) {
            if (this.getFilename().contains(".EXTRAS.") || basename.matches("(?i).*[_.-]+extra[s]?$") || basename.matches("(?i).*[-]+extra[s]?[-].*") || foldername.equalsIgnoreCase("extras") || foldername.equalsIgnoreCase("extra") || basename.matches("(?i).*[-](behindthescenes|deleted|featurette|interview|scene|short)$") || PLEX_EXTRA_FOLDERS.contains(foldername)) {
                return MediaFileType.VIDEO_EXTRA;
            }
            if (basename.matches("(?i).*[_.-]*trailer?$") || foldername.equalsIgnoreCase("trailer") || foldername.equalsIgnoreCase("trailers")) {
                return MediaFileType.TRAILER;
            }
            if (basename.matches("(?i).*[_.-]*sample$") || foldername.equalsIgnoreCase("sample")) {
                return MediaFileType.SAMPLE;
            }
            return MediaFileType.VIDEO;
        }
        if (ext.equals("txt")) {
            return MediaFileType.TEXT;
        }
        return MediaFileType.UNKNOWN;
    }

    private MediaFileType parseImageType() {
        String name = this.getFilename();
        Matcher matcher = moviesetPattern.matcher(name);
        if (matcher.matches()) {
            return MediaFileType.GRAPHIC;
        }
        matcher = seasonPattern.matcher(name);
        if (matcher.matches()) {
            return MediaFileType.SEASON_POSTER;
        }
        matcher = posterPattern.matcher(name);
        if (matcher.matches()) {
            return MediaFileType.POSTER;
        }
        matcher = fanartPattern.matcher(name);
        if (matcher.matches()) {
            if (this.getPath().endsWith("extrafanart")) {
                return MediaFileType.EXTRAFANART;
            }
            return MediaFileType.FANART;
        }
        matcher = bannerPattern.matcher(name);
        if (matcher.matches()) {
            return MediaFileType.BANNER;
        }
        matcher = thumbPattern.matcher(name);
        if (matcher.matches()) {
            if (this.getPath().endsWith("extrathumbs")) {
                return MediaFileType.EXTRATHUMB;
            }
            return MediaFileType.THUMB;
        }
        matcher = clearartPattern.matcher(name);
        if (matcher.matches()) {
            return MediaFileType.CLEARART;
        }
        matcher = logoPattern.matcher(name);
        if (matcher.matches()) {
            return MediaFileType.LOGO;
        }
        matcher = clearlogoPattern.matcher(name);
        if (matcher.matches()) {
            return MediaFileType.CLEARLOGO;
        }
        matcher = discartPattern.matcher(name);
        if (matcher.matches()) {
            return MediaFileType.DISCART;
        }
        return MediaFileType.GRAPHIC;
    }

    public boolean isPacked() {
        String ext = this.getExtension().toLowerCase(Locale.ROOT);
        return ext.equals("zip") || ext.equals("rar") || ext.equals("7z") || ext.matches("r\\d+");
    }

    public boolean isGraphic() {
        switch (this.type) {
            case GRAPHIC: 
            case BANNER: 
            case FANART: 
            case POSTER: 
            case THUMB: 
            case LOGO: 
            case CLEARLOGO: 
            case CLEARART: 
            case SEASON_POSTER: 
            case EXTRAFANART: 
            case EXTRATHUMB: 
            case DISCART: {
                return true;
            }
        }
        return false;
    }

    public boolean isVideo() {
        return this.type.equals((Object)MediaFileType.VIDEO) || this.type.equals((Object)MediaFileType.VIDEO_EXTRA) || this.type.equals((Object)MediaFileType.TRAILER) || this.type.equals((Object)MediaFileType.SAMPLE);
    }

    public boolean isDiscFile() {
        return this.isBlurayFile() || this.isDVDFile();
    }

    public boolean isDVDFile() {
        String name = this.getFilename().toLowerCase(Locale.ROOT);
        return name.matches("(video_ts|vts_\\d\\d_\\d)\\.(vob|bup|ifo)");
    }

    public boolean isBlurayFile() {
        String name = this.getFilename().toLowerCase(Locale.ROOT);
        return name.matches("(index\\.bdmv|movieobject\\.bdmv|\\d{5}\\.m2ts)");
    }

    @Deprecated
    public File getFile() {
        if (this.file == null) {
            this.file = this.getFileAsPath();
        }
        return this.file.toFile();
    }

    public Path getFileAsPath() {
        if (this.file == null) {
            Path f = Paths.get(this.path, this.filename);
            this.file = f.toAbsolutePath();
        }
        return this.file;
    }

    public void setFile(Path file) {
        this.setFilename(file.getFileName().toString());
        this.setPath(file.toAbsolutePath().getParent().toString());
        this.file = file.toAbsolutePath();
    }

    private void invalidateFileHandle() {
        if (this.file != null) {
            this.file = null;
        }
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String newValue) {
        String oldValue = this.path;
        this.path = newValue;
        this.invalidateFileHandle();
        this.firePropertyChange(PATH, oldValue, newValue);
    }

    public void replacePathForRenamedFolder(Path oldPath, Path newPath) {
        String p = this.getPath();
        p = p.replace(oldPath.toAbsolutePath().toString(), newPath.toAbsolutePath().toString());
        this.setPath(p);
    }

    public String getFilename() {
        return this.filename;
    }

    public String getFilenameWithoutStacking() {
        if (this.stackingMarker.isEmpty()) {
            return this.filename;
        }
        return this.filename.replaceAll("[ _.-]*" + this.stackingMarker, "");
    }

    public void setFilename(String newValue) {
        String oldValue = this.filename;
        this.filename = newValue;
        this.invalidateFileHandle();
        this.firePropertyChange(FILENAME, oldValue, newValue);
    }

    public String getExtension() {
        return FilenameUtils.getExtension((String)this.filename);
    }

    public String getBasename() {
        return FilenameUtils.getBaseName((String)this.filename);
    }

    public long getFiledate() {
        return this.filedate;
    }

    public long getFilesize() {
        return this.filesize;
    }

    public void setFilesize(long newValue) {
        long oldValue = this.filesize;
        this.filesize = newValue;
        this.firePropertyChange(FILESIZE, oldValue, newValue);
        this.firePropertyChange(FILESIZE_IN_MB, oldValue, newValue);
    }

    public String getFilesizeInMegabytes() {
        DecimalFormat df = new DecimalFormat("#0.00");
        return df.format((double)this.filesize / 1048576.0) + " M";
    }

    public MediaFileType getType() {
        return this.type;
    }

    public void setType(MediaFileType type) {
        this.type = type;
    }

    public int getStacking() {
        return this.stacking;
    }

    public void setStacking(int stacking) {
        this.stacking = stacking;
    }

    public String getStackingMarker() {
        return this.stackingMarker;
    }

    public void setStackingMarker(String stackingMarker) {
        this.stackingMarker = stackingMarker;
    }

    public void removeStackingInformation() {
        this.setStacking(0);
        this.setStackingMarker("");
    }

    public void detectStackingInformation() {
        this.stacking = Utils.getStackingNumber(this.filename);
        if (this.stacking == 0) {
            this.stacking = Utils.getStackingNumber(FilenameUtils.getBaseName((String)this.getPath()));
        }
        this.stackingMarker = Utils.getStackingMarker(this.filename);
        if (this.stackingMarker.isEmpty()) {
            this.stackingMarker = Utils.getFolderStackingMarker(FilenameUtils.getBaseName((String)this.getPath()));
        }
    }

    public List<MediaFileSubtitle> getSubtitles() {
        return this.subtitles;
    }

    public String getSubtitlesAsString() {
        StringBuilder sb = new StringBuilder();
        LinkedHashSet<MediaFileSubtitle> cleansub = new LinkedHashSet<MediaFileSubtitle>(this.subtitles);
        for (MediaFileSubtitle sub : cleansub) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(sub.getLanguage());
        }
        return sb.toString();
    }

    public void setSubtitles(List<MediaFileSubtitle> subtitles) {
        this.subtitles = subtitles;
    }

    public void addSubtitle(MediaFileSubtitle subtitle) {
        if (!this.subtitles.contains(subtitle)) {
            this.subtitles.add(subtitle);
        }
    }

    public void clearAllSubtitles() {
        this.subtitles.clear();
    }

    public boolean hasSubtitles() {
        return this.subtitles != null && this.subtitles.size() > 0;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    private void getMediaInfoSnapshot() {
        if (this.mediaInfo == null) {
            this.mediaInfo = new MediaInfo();
        }
        if (this.miSnapshot == null) {
            try {
                if (!this.mediaInfo.open(this.getFileAsPath())) {
                    LOGGER.error("Mediainfo could not open file: " + this.getFileAsPath());
                    this.closeMediaInfo();
                } else {
                    this.miSnapshot = this.mediaInfo.snapshot();
                }
            }
            catch (Error | Exception e) {
                LOGGER.error("Mediainfo could not open file: " + this.getFileAsPath() + "; " + e.getMessage());
                this.closeMediaInfo();
            }
        }
    }

    private void closeMediaInfo() {
        if (this.mediaInfo != null) {
            this.mediaInfo.close();
            this.mediaInfo = null;
        }
        this.miSnapshot = null;
    }

    private String getMediaInfo(MediaInfo.StreamKind streamKind, int streamNumber, String ... keys) {
        if (this.miSnapshot == null) {
            this.getMediaInfoSnapshot();
        }
        if (this.miSnapshot != null) {
            for (String key : keys) {
                String value;
                LinkedHashMap info;
                List<Map<String, String>> stream = this.miSnapshot.get((Object)streamKind);
                if (stream == null || (info = (LinkedHashMap)stream.get(streamNumber)) == null || (value = (String)info.get(key)) == null || value.length() <= 0) continue;
                return value;
            }
        }
        return "";
    }

    public static boolean isEmptyValue(Object object) {
        return object == null || object.toString().length() == 0;
    }

    public String getVideoCodec() {
        return this.videoCodec;
    }

    public void setVideoCodec(String newValue) {
        if ("avc".equalsIgnoreCase(newValue) || "x264".equalsIgnoreCase(newValue)) {
            newValue = "h264";
        }
        String oldValue = this.videoCodec;
        this.videoCodec = newValue;
        this.firePropertyChange("videoCodec", oldValue, newValue);
    }

    public String getAudioCodec() {
        String codec = "";
        MediaFileAudioStream highestStream = this.getBestAudioStream();
        if (highestStream != null) {
            codec = highestStream.getCodec();
        }
        return codec;
    }

    private MediaFileAudioStream getBestAudioStream() {
        MediaFileAudioStream highestStream = null;
        for (MediaFileAudioStream stream : this.audioStreams) {
            if (highestStream == null) {
                highestStream = stream;
                continue;
            }
            if (highestStream.getChannelsAsInt() >= stream.getChannelsAsInt()) continue;
            highestStream = stream;
        }
        return highestStream;
    }

    public String getAudioLanguage() {
        String language = "";
        MediaFileAudioStream highestStream = this.getBestAudioStream();
        if (highestStream != null) {
            language = highestStream.getLanguage();
        }
        return language;
    }

    public String getContainerFormat() {
        return this.containerFormat;
    }

    public void setContainerFormatDirect() {
        String extensions = this.getMediaInfo(MediaInfo.StreamKind.General, 0, "Codec/Extensions", "Format");
        this.setContainerFormat(StringUtils.isEmpty((CharSequence)extensions) ? "" : new Scanner(extensions).next().toLowerCase(Locale.ROOT));
    }

    public void setContainerFormat(String newValue) {
        String oldValue = this.containerFormat;
        this.containerFormat = newValue;
        this.firePropertyChange("containerFormat", oldValue, newValue);
    }

    public String getVideoFormat() {
        int w = this.getVideoWidth();
        int h = this.getVideoHeight();
        if (w == 0 || h == 0) {
            return "";
        }
        if (w <= this.blur(720) && h <= this.blur(480)) {
            return VIDEO_FORMAT_480P;
        }
        if (w <= this.blur(776) && h <= this.blur(592)) {
            return VIDEO_FORMAT_576P;
        }
        if (w <= this.blur(960) && h <= this.blur(544)) {
            return VIDEO_FORMAT_540P;
        }
        if (w <= this.blur(1280) && h <= this.blur(720)) {
            return VIDEO_FORMAT_720P;
        }
        if (w <= this.blur(1920) && h <= this.blur(1080)) {
            return VIDEO_FORMAT_1080P;
        }
        if (w <= this.blur(3840) && h <= this.blur(2160)) {
            return VIDEO_FORMAT_4K;
        }
        return VIDEO_FORMAT_8K;
    }

    private int blur(int res) {
        return res + res / 100;
    }

    public String getExactVideoFormat() {
        return this.exactVideoFormat;
    }

    public void setExactVideoFormat(String newValue) {
        String oldValue = this.exactVideoFormat;
        this.exactVideoFormat = newValue;
        this.firePropertyChange("exactVideoFormat", oldValue, newValue);
    }

    public String getAudioChannels() {
        String channels = "";
        MediaFileAudioStream highestStream = this.getBestAudioStream();
        if (highestStream != null) {
            channels = highestStream.getChannels();
        }
        return channels;
    }

    public String getVideoResolution() {
        if (this.videoWidth == 0 || this.videoHeight == 0) {
            return "";
        }
        return this.videoWidth + "x" + this.videoHeight;
    }

    public int getVideoWidth() {
        return this.videoWidth;
    }

    public int getVideoHeight() {
        return this.videoHeight;
    }

    public void setVideoWidth(int newValue) {
        int oldValue = this.videoWidth;
        this.videoWidth = newValue;
        this.firePropertyChange("videoWidth", oldValue, newValue);
        this.firePropertyChange("videoFormat", oldValue, newValue);
    }

    public void setVideoHeight(int newValue) {
        int oldValue = this.videoHeight;
        this.videoHeight = newValue;
        this.firePropertyChange("videoHeight", oldValue, newValue);
        this.firePropertyChange("videoFormat", oldValue, newValue);
    }

    public Boolean isWidescreen() {
        if (this.videoWidth == 0 || this.videoHeight == 0) {
            return false;
        }
        return (float)this.videoWidth / (float)this.videoHeight > 1.37f;
    }

    public Float getAspectRatio() {
        Float ret = Float.valueOf(0.0f);
        if (this.videoWidth == 0 || this.videoHeight == 0) {
            return ret;
        }
        Float ar = Float.valueOf((float)this.videoWidth / (float)this.videoHeight);
        ret = ar.floatValue() < 1.3499f ? Float.valueOf(1.33f) : (ar.floatValue() < 1.508f ? Float.valueOf(1.37f) : (ar.floatValue() < 1.719f ? Float.valueOf(1.66f) : (ar.floatValue() < 1.8147f ? Float.valueOf(1.78f) : (ar.floatValue() < 2.0174f ? Float.valueOf(1.85f) : (ar.floatValue() < 2.2738f ? Float.valueOf(2.2f) : (ar.floatValue() < 2.3749f ? Float.valueOf(2.35f) : (ar.floatValue() < 2.4739f ? Float.valueOf(2.4f) : (ar.floatValue() < 2.6529f ? Float.valueOf(2.55f) : Float.valueOf(2.76f)))))))));
        return ret;
    }

    public String getVideoDefinitionCategory() {
        if (this.videoWidth == 0 || this.videoHeight == 0) {
            return "";
        }
        return this.videoWidth >= 1280 || this.videoHeight >= 720 ? VIDEO_FORMAT_HD : VIDEO_FORMAT_SD;
    }

    public int getOverallBitRate() {
        return this.overallBitRate;
    }

    public void setOverallBitRate(int newValue) {
        int oldValue = this.overallBitRate;
        this.overallBitRate = newValue;
        this.firePropertyChange("overallBitRate", oldValue, newValue);
        this.firePropertyChange("bitRateInKbps", oldValue, newValue);
    }

    public String getBiteRateInKbps() {
        return this.overallBitRate + " kbps";
    }

    public int getDuration() {
        return this.durationInSecs;
    }

    public int getDurationInMinutes() {
        return this.durationInSecs / 60;
    }

    public String getDurationHM() {
        if (this.durationInSecs == 0) {
            return "";
        }
        long h = TimeUnit.SECONDS.toHours(this.durationInSecs);
        long m = TimeUnit.SECONDS.toMinutes((long)this.durationInSecs - TimeUnit.HOURS.toSeconds(h));
        long s = TimeUnit.SECONDS.toSeconds((long)this.durationInSecs - TimeUnit.HOURS.toSeconds(h) - TimeUnit.MINUTES.toSeconds(m));
        if (s > 30L) {
            ++m;
        }
        return h + "h " + String.format("%02d", m) + "m";
    }

    public String getDurationHHMMSS() {
        if (this.durationInSecs == 0) {
            return "";
        }
        long h = TimeUnit.SECONDS.toHours(this.durationInSecs);
        long m = TimeUnit.SECONDS.toMinutes((long)this.durationInSecs - TimeUnit.HOURS.toSeconds(h));
        long s = TimeUnit.SECONDS.toSeconds((long)this.durationInSecs - TimeUnit.HOURS.toSeconds(h) - TimeUnit.MINUTES.toSeconds(m));
        return String.format("%02d:%02d:%02d", h, m, s);
    }

    public String getDurationShort() {
        if (this.durationInSecs == 0) {
            return "";
        }
        long h = TimeUnit.SECONDS.toHours(this.durationInSecs);
        long m = TimeUnit.SECONDS.toMinutes((long)this.durationInSecs - TimeUnit.HOURS.toSeconds(h));
        long s = TimeUnit.SECONDS.toSeconds((long)this.durationInSecs - TimeUnit.HOURS.toSeconds(h) - TimeUnit.MINUTES.toSeconds(m));
        if (h > 0L) {
            return String.format("%d:%02d:%02d", h, m, s);
        }
        if (m > 0L) {
            return String.format("%d:%02d", m, s);
        }
        return String.format("%d", s);
    }

    public void setDuration(int newValue) {
        int oldValue = this.durationInSecs;
        this.durationInSecs = newValue;
        this.firePropertyChange("duration", oldValue, newValue);
        this.firePropertyChange("durationHM", oldValue, newValue);
        this.firePropertyChange("durationHHMMSS", oldValue, newValue);
    }

    public List<MediaFileAudioStream> getAudioStreams() {
        return this.audioStreams;
    }

    public void setAudioStreams(List<MediaFileAudioStream> audioStreams) {
        this.audioStreams = audioStreams;
    }

    public String getCombinedCodecs() {
        StringBuilder sb = new StringBuilder(this.videoCodec);
        for (MediaFileAudioStream audioStream : this.audioStreams) {
            if (sb.length() > 0) {
                sb.append(" / ");
            }
            sb.append(audioStream.getCodec());
        }
        return sb.toString();
    }

    public String getVideo3DFormat() {
        return this.video3DFormat;
    }

    public void setVideo3DFormat(String video3DFormat) {
        this.video3DFormat = video3DFormat;
    }

    private long getMediaInfoSnapshotFromISO() {
        Path xmlFile = Paths.get(this.path, this.filename.replaceFirst("\\.iso$", "-mediainfo.xml"));
        if (Files.exists(xmlFile, new LinkOption[0])) {
            try {
                LOGGER.info("ISO: try to parse " + xmlFile);
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{MediaInfoXMLParser.class});
                Unmarshaller um = context.createUnmarshaller();
                MediaInfoXMLParser xml = new MediaInfoXMLParser();
                BufferedReader in = Files.newBufferedReader(xmlFile, StandardCharsets.UTF_8);
                xml = (MediaInfoXMLParser)um.unmarshal((Reader)in);
                ((Reader)in).close();
                xml.snapshot();
                this.setMiSnapshot(xml.getBiggestFile().snapshot);
                this.setDuration(xml.getDuration());
                return xml.getFilesize();
            }
            catch (Exception e) {
                LOGGER.warn("ISO: Unable to parse " + xmlFile, (Throwable)e);
            }
        }
        if (this.miSnapshot == null) {
            int BUFFER_SIZE = 65536;
            Iso9660FileSystem image = null;
            try {
                LOGGER.trace("ISO: Open");
                image = new Iso9660FileSystem(this.getFileAsPath().toFile(), true);
                int dur = 0;
                long siz = 0L;
                long biggest = 0L;
                for (Iso9660FileEntry entry : image) {
                    MediaFile mf;
                    LOGGER.trace("ISO: got entry " + entry.getName() + " size:" + entry.getSize());
                    siz += entry.getSize();
                    if (entry.getSize() <= 5000L || (mf = new MediaFile(Paths.get(this.getFileAsPath().toString(), entry.getPath()))).getType() != MediaFileType.VIDEO || !mf.isDiscFile()) continue;
                    mf.setFilesize(entry.getSize());
                    MediaInfo fileMI = new MediaInfo();
                    try {
                        int From_Buffer_Size;
                        byte[] From_Buffer = new byte[BUFFER_SIZE];
                        fileMI.openBufferInit(entry.getSize(), 0L);
                        long pos = 0L;
                        do {
                            From_Buffer_Size = image.readBytes(entry, pos, From_Buffer, 0, BUFFER_SIZE);
                            pos += (long)From_Buffer_Size;
                            int Result2 = fileMI.openBufferContinue(From_Buffer, From_Buffer_Size);
                            if ((Result2 & 8) == 8) break;
                            if (fileMI.openBufferContinueGoToGet() == -1L) continue;
                            pos = fileMI.openBufferContinueGoToGet();
                            LOGGER.trace("ISO: Seek to " + pos);
                            fileMI.openBufferInit(entry.getSize(), pos);
                        } while (From_Buffer_Size > 0);
                        LOGGER.trace("ISO: finalize");
                        fileMI.openBufferFinalize();
                        Map<MediaInfo.StreamKind, List<Map<String, String>>> tempSnapshot = fileMI.snapshot();
                        fileMI.close();
                        mf.setMiSnapshot(tempSnapshot);
                        mf.gatherMediaInformation();
                        if (entry.getSize() > biggest) {
                            biggest = entry.getSize();
                            this.miSnapshot = tempSnapshot;
                        }
                        LOGGER.trace("ISO: file duration:" + mf.getDurationHHMMSS() + "  accumulated min:" + (dur += mf.getDuration()) / 60);
                    }
                    catch (Error | Exception e) {
                        LOGGER.error("Mediainfo could not open file STREAM", e);
                        fileMI.close();
                    }
                }
                this.setDuration(dur);
                LOGGER.trace("ISO: final duration:" + this.getDurationHHMMSS());
                image.close();
                return siz;
            }
            catch (Exception e) {
                LOGGER.error("Mediainfo could not open STREAM - trying fallback", (Throwable)e);
                try {
                    if (image != null) {
                        image.close();
                        image = null;
                    }
                }
                catch (IOException e1) {
                    LOGGER.warn("Uh-oh. Cannot close disc image :(", (Throwable)e);
                }
                this.closeMediaInfo();
                this.getMediaInfoSnapshot();
            }
        }
        return 0L;
    }

    @Deprecated
    public void setMediaInfo(MediaInfo mediaInfo) {
        this.mediaInfo = mediaInfo;
    }

    @Deprecated
    public void setMiSnapshot(Map<MediaInfo.StreamKind, List<Map<String, String>>> miSnapshot) {
        this.miSnapshot = miSnapshot;
    }

    public void gatherMediaInformation() {
        this.gatherMediaInformation(false);
    }

    public void gatherMediaInformation(boolean force) {
        block66: {
            if (!this.isValidMediainfoFormat()) {
                if (StringUtils.isBlank((CharSequence)this.getContainerFormat())) {
                    this.setContainerFormat(this.getExtension());
                }
                return;
            }
            if (!force && !this.getContainerFormat().isEmpty()) {
                return;
            }
            if (this.getType() == MediaFileType.SUBTITLE) {
                this.gatherSubtitleInformation();
            }
            try {
                BasicFileAttributes attrs = Files.readAttributes(this.getFileAsPath(), BasicFileAttributes.class, new LinkOption[0]);
                this.filedate = attrs.lastModifiedTime().toMillis();
                this.setFilesize(attrs.size());
            }
            catch (IOException e) {
                if (this.miSnapshot != null) break block66;
                LOGGER.warn("could not get file information (size/date): " + e.getMessage());
            }
        }
        if (this.getFilesize() == 0L) {
            LOGGER.warn("0 Byte file detected: " + this.filename);
            this.setContainerFormat(this.getExtension());
            return;
        }
        if (this.type == MediaFileType.SUBTITLE || this.type == MediaFileType.NFO) {
            this.setContainerFormat(this.getExtension());
            return;
        }
        LOGGER.debug("start MediaInfo for " + this.getFileAsPath());
        long discFilesSizes = 0L;
        if (this.isISO) {
            discFilesSizes = this.getMediaInfoSnapshotFromISO();
        } else {
            this.getMediaInfoSnapshot();
        }
        if (this.miSnapshot == null) {
            LOGGER.error("error getting MediaInfo for " + this.filename);
            this.setContainerFormat(this.getExtension());
            this.closeMediaInfo();
            return;
        }
        LOGGER.trace("got MI");
        String height = "";
        String scanType = "";
        String width = "";
        String videoCodec = "";
        switch (this.type) {
            case VIDEO: 
            case VIDEO_EXTRA: 
            case SAMPLE: 
            case TRAILER: {
                String audioCodec;
                AbstractModelObject stream;
                String cnt;
                int streams;
                height = this.getMediaInfo(MediaInfo.StreamKind.Video, 0, "Height");
                scanType = this.getMediaInfo(MediaInfo.StreamKind.Video, 0, "ScanType");
                width = this.getMediaInfo(MediaInfo.StreamKind.Video, 0, "Width");
                videoCodec = this.getMediaInfo(MediaInfo.StreamKind.Video, 0, "CodecID/Hint", "Format");
                if (StringUtils.containsIgnoreCase((CharSequence)videoCodec, (CharSequence)"Microsoft")) {
                    videoCodec = this.getMediaInfo(MediaInfo.StreamKind.Video, 0, "Format");
                }
                if ((streams = 0) == 0) {
                    cnt = this.getMediaInfo(MediaInfo.StreamKind.General, 0, "AudioCount");
                    try {
                        streams = Integer.parseInt(cnt);
                    }
                    catch (Exception e) {
                        streams = 0;
                    }
                }
                if (streams == 0) {
                    cnt = this.getMediaInfo(MediaInfo.StreamKind.Audio, 0, "StreamCount");
                    try {
                        streams = Integer.parseInt(cnt);
                    }
                    catch (Exception e) {
                        streams = 0;
                    }
                }
                this.audioStreams.clear();
                for (int i = 0; i < streams; ++i) {
                    stream = new MediaFileAudioStream();
                    audioCodec = this.getMediaInfo(MediaInfo.StreamKind.Audio, i, "CodecID/Hint", "Format");
                    audioCodec = audioCodec.replaceAll("\\p{Punct}", "");
                    String audioAddition = this.getMediaInfo(MediaInfo.StreamKind.Audio, i, "Format_Profile");
                    if ("dts".equalsIgnoreCase(audioCodec) && StringUtils.isNotBlank((CharSequence)audioAddition)) {
                        if (audioAddition.contains("ES")) {
                            audioCodec = "DTSHD-ES";
                        }
                        if (audioAddition.contains("HRA")) {
                            audioCodec = "DTSHD-HRA";
                        }
                        if (audioAddition.contains("MA")) {
                            audioCodec = "DTSHD-MA";
                        }
                    }
                    ((MediaFileAudioStream)stream).setCodec(audioCodec);
                    String channels = this.getMediaInfo(MediaInfo.StreamKind.Audio, i, "Channel(s)_Original", "Channel(s)");
                    ((MediaFileAudioStream)stream).setChannels(StringUtils.isEmpty((CharSequence)channels) ? "" : channels + "ch");
                    try {
                        String br = this.getMediaInfo(MediaInfo.StreamKind.Audio, i, "BitRate");
                        ((MediaFileAudioStream)stream).setBitrate(Integer.parseInt(br) / 1024);
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                    String language = this.getMediaInfo(MediaInfo.StreamKind.Audio, i, "Language/String", "Language");
                    if (language.isEmpty()) {
                        if (!this.isDiscFile()) {
                            String shortname = this.getBasename().toLowerCase(Locale.ROOT);
                            ((MediaFileAudioStream)stream).setLanguage(this.parseLanguageFromString(shortname));
                        }
                    } else {
                        ((MediaFileAudioStream)stream).setLanguage(this.parseLanguageFromString(language));
                    }
                    this.audioStreams.add((MediaFileAudioStream)stream);
                }
                streams = 0;
                if (streams == 0) {
                    String cnt2 = this.getMediaInfo(MediaInfo.StreamKind.General, 0, "TextCount");
                    try {
                        streams = Integer.parseInt(cnt2);
                    }
                    catch (Exception e) {
                        streams = 0;
                    }
                }
                if (streams == 0) {
                    String cnt3 = this.getMediaInfo(MediaInfo.StreamKind.Text, 0, "StreamCount");
                    try {
                        streams = Integer.parseInt(cnt3);
                    }
                    catch (Exception e) {
                        streams = 0;
                    }
                }
                this.subtitles.clear();
                for (int i = 0; i < streams; ++i) {
                    stream = new MediaFileSubtitle();
                    String codec = this.getMediaInfo(MediaInfo.StreamKind.Text, i, "CodecID/Hint", "Format");
                    ((MediaFileSubtitle)stream).setCodec(codec.replaceAll("\\p{Punct}", ""));
                    String lang = this.getMediaInfo(MediaInfo.StreamKind.Text, i, "Language/String", "Language");
                    ((MediaFileSubtitle)stream).setLanguage(this.parseLanguageFromString(lang));
                    String forced = this.getMediaInfo(MediaInfo.StreamKind.Text, i, "Forced");
                    boolean b = forced.equalsIgnoreCase("true") || forced.equalsIgnoreCase("yes");
                    ((MediaFileSubtitle)stream).setForced(b);
                    this.subtitles.add((MediaFileSubtitle)stream);
                }
                String mvc = this.getMediaInfo(MediaInfo.StreamKind.Video, 0, "MultiView_Count");
                if (StringUtils.isEmpty((CharSequence)mvc) || !mvc.equals("2")) break;
                this.video3DFormat = VIDEO_3D;
                String mvl = this.getMediaInfo(MediaInfo.StreamKind.Video, 0, "MultiView_Layout").toLowerCase(Locale.ROOT);
                LOGGER.debug("3D detected :) " + mvl);
                if (!StringUtils.isEmpty((CharSequence)mvl) && mvl.contains("top") && mvl.contains("bottom")) {
                    this.video3DFormat = VIDEO_3D_TAB;
                }
                if (StringUtils.isEmpty((CharSequence)mvl) || !mvl.contains("side")) break;
                this.video3DFormat = VIDEO_3D_SBS;
                break;
            }
            case AUDIO: {
                AbstractModelObject stream = new MediaFileAudioStream();
                String audioCodec = this.getMediaInfo(MediaInfo.StreamKind.Audio, 0, "CodecID/Hint", "Format");
                ((MediaFileAudioStream)stream).setCodec(audioCodec.replaceAll("\\p{Punct}", ""));
                String channels = this.getMediaInfo(MediaInfo.StreamKind.Audio, 0, "Channel(s)");
                ((MediaFileAudioStream)stream).setChannels(StringUtils.isEmpty((CharSequence)channels) ? "" : channels + "ch");
                try {
                    String br = this.getMediaInfo(MediaInfo.StreamKind.Audio, 0, "BitRate");
                    ((MediaFileAudioStream)stream).setBitrate(Integer.parseInt(br) / 1024);
                }
                catch (Exception e) {
                    // empty catch block
                }
                String language = this.getMediaInfo(MediaInfo.StreamKind.Audio, 0, "Language/String", "Language");
                if (language.isEmpty()) {
                    String shortname = this.getBasename().toLowerCase(Locale.ROOT);
                    ((MediaFileAudioStream)stream).setLanguage(this.parseLanguageFromString(shortname));
                } else {
                    ((MediaFileAudioStream)stream).setLanguage(this.parseLanguageFromString(language));
                }
                this.audioStreams.clear();
                this.audioStreams.add((MediaFileAudioStream)stream);
                break;
            }
            case GRAPHIC: 
            case BANNER: 
            case FANART: 
            case POSTER: 
            case THUMB: 
            case LOGO: 
            case CLEARLOGO: 
            case CLEARART: 
            case SEASON_POSTER: 
            case EXTRAFANART: 
            case EXTRATHUMB: 
            case DISCART: {
                height = this.getMediaInfo(MediaInfo.StreamKind.Image, 0, "Height");
                width = this.getMediaInfo(MediaInfo.StreamKind.Image, 0, "Width");
                videoCodec = this.getMediaInfo(MediaInfo.StreamKind.Image, 0, "CodecID/Hint", "Format");
                break;
            }
            case NFO: {
                break;
            }
            default: {
                LOGGER.warn("no mediainformation handling for MediaFile type " + (Object)((Object)this.getType()) + " yet.");
            }
        }
        this.setVideoCodec(StringUtils.isEmpty((CharSequence)videoCodec) ? "" : new Scanner(videoCodec).next());
        if (this.type == MediaFileType.SUBTITLE) {
            this.setContainerFormat(this.getExtension());
        } else {
            String extensions = this.getMediaInfo(MediaInfo.StreamKind.General, 0, "Codec/Extensions", "Format");
            this.setContainerFormat(StringUtils.isBlank((CharSequence)extensions) ? "" : new Scanner(extensions).next().toLowerCase(Locale.ROOT));
            if (StringUtils.isBlank((CharSequence)this.containerFormat)) {
                this.setContainerFormat(this.getExtension());
            }
        }
        if (height.isEmpty() || scanType.isEmpty()) {
            this.setExactVideoFormat("");
        } else {
            this.setExactVideoFormat(height + Character.toLowerCase(scanType.charAt(0)));
        }
        if (!width.isEmpty()) {
            try {
                this.setVideoWidth(Integer.parseInt(width));
            }
            catch (NumberFormatException e) {
                this.setVideoWidth(0);
            }
        }
        if (!height.isEmpty()) {
            try {
                this.setVideoHeight(Integer.parseInt(height));
            }
            catch (NumberFormatException e) {
                this.setVideoHeight(0);
            }
        }
        switch (this.type) {
            case VIDEO: 
            case VIDEO_EXTRA: 
            case SAMPLE: 
            case TRAILER: 
            case AUDIO: {
                String br = this.getMediaInfo(MediaInfo.StreamKind.General, 0, "OverallBitRate");
                if (!br.isEmpty()) {
                    try {
                        this.setOverallBitRate(Integer.parseInt(br) / 1024);
                    }
                    catch (NumberFormatException e) {
                        this.setOverallBitRate(0);
                    }
                }
                if (!this.isISO) {
                    String dur = this.getMediaInfo(MediaInfo.StreamKind.General, 0, "Duration");
                    if (dur.isEmpty()) break;
                    try {
                        Double d = Double.parseDouble(dur);
                        this.setDuration(d.intValue() / 1000);
                    }
                    catch (NumberFormatException e) {
                        this.setDuration(0);
                    }
                    break;
                }
                if (discFilesSizes <= 0L || this.filesize <= 0L) break;
                long diff = Math.abs(this.filesize - discFilesSizes);
                Double ratio = (double)diff * 100.0 / (double)this.filesize;
                LOGGER.debug("ISO size:" + this.filesize + "  reportedDataSize:" + discFilesSizes + "  = diff:" + diff + " ~" + ratio.intValue() + "%");
                if (!(ratio > 10.0)) break;
                LOGGER.error("ISO file seems to have an invalid structure - ignore duration");
                this.setDuration(0);
            }
        }
        LOGGER.trace("extracted MI");
        this.closeMediaInfo();
        LOGGER.trace("closed MI");
    }

    private String parseLanguageFromString(String shortname) {
        if (StringUtils.isBlank((CharSequence)shortname)) {
            return "";
        }
        Set langArray = LanguageUtils.KEY_TO_LOCALE_MAP.keySet();
        shortname = shortname.replaceAll("(?i)Part [Ii]+", "");
        shortname = StringUtils.split((String)shortname, (char)'/')[0].trim();
        for (String s : langArray) {
            try {
                if (!shortname.equalsIgnoreCase(s) && !shortname.matches("(?i).*[ _.-]+" + s + "$")) continue;
                LOGGER.debug("found language '" + s + "' in '" + this.getFilename());
                return LanguageUtils.getIso3LanguageFromLocalizedString((String)s);
            }
            catch (Exception e) {
                LOGGER.warn("Error parsing subtitle language from locale keyset: " + s, (Throwable)e);
            }
        }
        return "";
    }

    private boolean isValidMediainfoFormat() {
        String extension = FilenameUtils.getExtension((String)this.filename).toLowerCase(Locale.ROOT);
        if ("bin".equals(extension) || "dat".equals(extension) || "img".equals(extension) || "nrg".equals(extension) || "disc".equals(extension)) {
            return false;
        }
        if ("iso".equals(extension)) {
            this.isISO = true;
            return true;
        }
        return this.type.equals((Object)MediaFileType.VIDEO) || this.type.equals((Object)MediaFileType.VIDEO_EXTRA) || this.type.equals((Object)MediaFileType.TRAILER) || this.type.equals((Object)MediaFileType.SAMPLE) || this.type.equals((Object)MediaFileType.SUBTITLE) || this.type.equals((Object)MediaFileType.AUDIO) || this.type.equals((Object)MediaFileType.NFO) || this.isGraphic();
    }

    public boolean exists() {
        return Files.exists(this.getFileAsPath(), new LinkOption[0]);
    }

    public boolean deleteSafely(String datasource) {
        return Utils.deleteFileWithBackup(this.getFileAsPath(), datasource);
    }

    public boolean equals(Object mf2) {
        if (mf2 != null && mf2 instanceof MediaFile) {
            return this.compareTo((MediaFile)mf2) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(MediaFile mf2) {
        return this.getFileAsPath().compareTo(mf2.getFileAsPath());
    }

    public int hashCode() {
        return this.getFileAsPath().hashCode();
    }
}

