Scriptname DCPlayerScriptVersionTwo extends ReferenceAlias

Actor property selfActor auto
Spell property DCNormalAttackStaggerSpell auto
Spell property DCPerfectBlockStaggerSpell auto
Spell property DCAbNPCSpell auto
Spell property DCCloakAbility auto
Keyword property WeapTypeBow auto
DCInitQuestScript property questScript auto
Idle property recoil auto
Idle property recoilLarge auto

float fStaminaBlockBase = 0.0;
float ExtraFatigueCost = 0.0
bool IsPerfectBlock = false

Auto State DefaultState
Event OnHit(ObjectReference akAggressor, Form akSource, Projectile akProjectile, bool abPowerAttack, bool abSneakAttack, bool abBashAttack, bool abHitBlocked)
Actor aggressorActor = (akAggressor As Actor)
if(selfActor == aggressorActor)
	return
elseIf(aggressorActor == None)
	return
endIf
If(questScript.DCIsTimedBlockingEnabled())
	GoToState("BusyState")

	;<<<<<<<<<<<<<<<<<<<<<<<<<<<EXTRA STAMINA COST IF BLOCKING TOO LONG, REWARD IF PERFECT BLOCK>>>>>>>>>>>>>>>>>>>>>>>>>
	If(abHitBlocked)
		If(IsPerfectBlock)
			selfActor.RestoreActorValue("Stamina", fStaminaBlockBase)
			int weaponType = aggressorActor.GetEquippedItemType(1)
			If(weaponType == 5 || weaponType == 6)
				selfActor.PlayIdle(recoil)
			EndIf
			If(!akSource.HasKeyword(WeapTypeBow))	;only stagger enemy if the perfect block was against a melee attack
				If(selfActor.GetEquippedItemType(0)>0 || selfActor.GetEquippedItemType(1)>0)		;Users of my Dual Wield Parrying mod shouldn't be able to perform timed blocks with their hands.
					If(abPowerAttack)
						If(aggressorActor.PlayIdle(recoilLarge))
						Else
							DCPerfectBlockStaggerSpell.Cast(aggressorActor, aggressorActor)
							Utility.Wait(0.6)
							Debug.SendAnimationEvent(aggressorActor, "staggerStop")
						EndIf
					Else
							DCPerfectBlockStaggerSpell.Cast(aggressorActor, aggressorActor)
							Utility.Wait(0.6)
							Debug.SendAnimationEvent(aggressorActor, "staggerStop")
					EndIf
				EndIf
			EndIf
		Else
			selfActor.DamageActorValue("Stamina", ExtraFatigueCost)
			If(selfActor.GetActorValue("Stamina") < 10)
				DCNormalAttackStaggerSpell.Cast(selfActor, selfActor)
			EndIf
		EndIf
	EndIf

	GoToState("DefaultState")
EndIf
If(!(aggressorActor.HasSpell(DCAbNPCSpell)))
	aggressorActor.AddSpell(DCAbNPCSpell)
EndIf
EndEvent
EndState

State BusyState
Event OnHit(ObjectReference akAggressor, Form akSource, Projectile akProjectile, bool abPowerAttack, bool abSneakAttack, bool abBashAttack, bool abHitBlocked)
EndEvent
EndState

Event OnPlayerLoadGame()
	questScript.GameSettingsMaintenance()
	fStaminaBlockBase = Game.GetGameSettingFloat("fStaminaBlockBase")
EndEvent

Event OnInit()
	fStaminaBlockBase = Game.GetGameSettingFloat("fStaminaBlockBase")
	RegisterForSingleUpdate(1.0)
EndEvent

Event OnUpdate()
	selfActor.AddSpell(DCCloakAbility, false)
	Utility.Wait(1.0)
	selfActor.RemoveSpell(DCCloakAbility)
	RegisterForSingleUpdate(1.0)
EndEvent

Function DCSetExtraFatigueCost(float extraCost)
	ExtraFatigueCost = extraCost
	If(extraCost <= 0)
		DCSetPerfectBlock(true)
	Else
		DCSetPerfectBlock(false)
	EndIf
EndFunction

Function DCSetPerfectBlock(bool perfectBlock)
	IsPerfectBlock = perfectBlock
EndFunction