Scriptname DCInitQuestScript extends Quest  Conditional

;||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
;=============================G A M E  S E T T I N G S=============================
;||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

;==============ARMOR SETTINGS==============
float fArmorRatingMax = -1.0
float fArmorRatingPCMax = -1.0
float fArmorScalingFactor = -1.0
float fMaxArmorRating = -1.0
;==============ARMOR SETTINGS==============

;==============ATTACK DISTANCE SETTINGS==============
float fCombatBashReach = -1.0
float fCombatDistance = -1.0
;==============ATTACK DISTANCE SETTINGS==============

;==============BLOCK SETTINGS==============
float fBlockMax = -1.0
float fBlockPowerAttackMult = -1.0
float fBlockSkillMult = -1.0
float fBlockWeaponBase = -1.0
float fBlockWeaponScaling = -1.0
float fShieldBaseFactor = -1.0
;==============BLOCK SETTINGS==============

;==============DAMAGE SETTINGS==============
float fDamagePCSkillMax = -1.0
float fDamagePCSkillMin = -1.0
float fDamageSkillMax = -1.0
float fDamageSkillMin = -1.0
;==============DAMAGE SETTINGS==============

;==============MOVEMENT SETTINGS==============
float fMoveEncumEffect = -1.0
float fMoveEncumEffectNoWeapon = -1.0
;==============MOVEMENT SETTINGS==============

;==============STAMINA SETTINGS==============
float fCombatStaminaRegenRateMult = -1.0
float fStaminaAttackWeaponMult = -1.0
float fStaminaBlockBase = -1.0
;==============STAMINA SETTINGS==============

;||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
;=============================G A M E  S E T T I N G S=============================
;||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

Actor Property playerRef auto
Perk Property playerPerk auto
Spell Property DCAbPlayerSpell auto
Spell property DCCustomizationPower auto
Spell Property DCIgnorePainSpell auto
Faction Property staggerFaction auto
GlobalVariable Property DCPreventPlayerStaggerSpamEnabled auto
GlobalVariable Property DCPreventEnemyStaggerSpamEnabled auto
GlobalVariable Property DCTimedWardingEnabledGlobal auto
GlobalVariable Property DCLocationalDamageEnabled auto
GlobalVariable Property DCLocationalDamageEnabledArchery auto

;STAGGERING
bool DCPreventPlayerStaggerSpam = true
bool DCPreventEnemyStaggerSpam = true

;OTHER FEATURES
bool DCTimedBlockingEnabled = true conditional
bool DCTimedWardingEnabled = true

;LOCATIONAL DAMAGE
bool DCLocDamageEnabled = true
bool DCLocDamageArcheryEnabled = true

bool allowStaggerNPCs = true 
bool allowStaggerPlayer = true 
bool ignorePainPotions = true conditional
bool ignorePainSpell = true 

Function SetTimedBlocking(bool b)
	DCTimedBlockingEnabled = b
EndFunction

Function SetTimedWarding(bool b)
	DCTimedWardingEnabled = b

	if(b)
		DCTimedWardingEnabledGlobal.SetValue(1)
	else
		DCTimedWardingEnabledGlobal.SetValue(0)
	EndIf
EndFunction

Function SetLocDamageMelee(bool b)
	DCLocDamageEnabled = b 
	
	if(b)
		DCLocationalDamageEnabled.setValue(1)
	else
		DCLocationalDamageEnabled.setValue(0)
	endIf
EndFunction

Function SetLocDamageRanged(bool b)
	DCLocDamageArcheryEnabled = b 

	if(b)
		DCLocationalDamageEnabledArchery.setValue(1)
	else
		DCLocationalDamageEnabledArchery.setValue(0)
	endIf
EndFunction

bool Function GetAllowStaggerNPCs()
	return allowStaggerNPCs
EndFunction

bool Function GetAllowStaggerPlayer()
	return allowStaggerPlayer
EndFunction

Function SetAllowStaggerNPCs(bool b)
	allowStaggerNPCs = b
EndFunction

Function SetAllowStaggerPlayer(bool b)
	allowStaggerPlayer = b
EndFunction

Function SetStaggerSpamPreventionPlayer(bool b)
	DCPreventPlayerStaggerSpam = b
	If(DCPreventPlayerStaggerSpam)
		DCPreventPlayerStaggerSpamEnabled.SetValue(1)
	Else
		DCPreventPlayerStaggerSpamEnabled.SetValue(0)
	EndIf
EndFunction

Function SetStaggerSpamPreventionNPCs(bool b)
	DCPreventEnemyStaggerSpam = b
	If(DCPreventEnemyStaggerSpam)
		DCPreventEnemyStaggerSpamEnabled.SetValue(1)
	Else
		DCPreventEnemyStaggerSpamEnabled.SetValue(0)
	EndIf
EndFunction

Function SetIgnorePainPotions(bool b)
	ignorePainPotions = b
EndFunction

Function SetIgnorePainSpell(bool b)
	ignorePainSpell = b
	If(ignorePainSpell)
		playerRef.AddSpell(DCIgnorePainSpell)
	Else
		playerRef.RemoveSpell(DCIgnorePainSpell)
	EndIf
EndFunction

Function DCPreventPlayerStaggerSpamFunction()
	DCPreventPlayerStaggerSpam = !DCPreventPlayerStaggerSpam
	If(DCPreventPlayerStaggerSpam)
		DCPreventPlayerStaggerSpamEnabled.SetValue(1)
	Else
		DCPreventPlayerStaggerSpamEnabled.SetValue(0)
	EndIf
EndFunction

bool Function DCIsPreventPlayerStaggerSpamEnabled()
	Return DCPreventPlayerStaggerSpam
EndFunction

Function DCPreventEnemyStaggerSpamFunction()
	DCPreventEnemyStaggerSpam = !DCPreventEnemyStaggerSpam
	If(DCPreventEnemyStaggerSpam)
		DCPreventEnemyStaggerSpamEnabled.SetValue(1)
	Else
		DCPreventEnemyStaggerSpamEnabled.SetValue(0)
	EndIf
EndFunction

bool Function DCIsPreventEnemyStaggerSpamEnabled()
	Return DCPreventEnemyStaggerSpam
EndFunction

Function DCTimedBlockingFunction()
	DCTimedBlockingEnabled = !DCTimedBlockingEnabled
	If(DCTimedBlockingEnabled)
		Debug.MessageBox("Timed blocking is now activated")
	Else
		Debug.MessageBox("Timed blocking is now deactivated")
	EndIf
EndFunction

bool Function DCIsTimedBlockingEnabled()
	Return DCTimedBlockingEnabled 
EndFunction

Function DCTimedWardingFunction()
	DCTimedWardingEnabled = !DCTimedWardingEnabled 
	If(DCTimedWardingEnabled)
		DCTimedWardingEnabledGlobal.setValue(1)
		Debug.MessageBox("Timed warding is now activated")
	Else
		DCTimedWardingEnabledGlobal.setValue(0)
		Debug.MessageBox("Timed warding is now deactivated")
	EndIf
EndFunction

bool Function DCIsTimedWardingEnabled()
	Return DCTimedWardingEnabled 
EndFunction

Function DCLocationalDamageFunction()
	DCLocDamageEnabled = !DCLocDamageEnabled
	If(DCLocDamageEnabled )
		DCLocationalDamageEnabled.setValue(1)
		Debug.MessageBox("Melee Locational Damage is now activated")
	Else
		DCLocationalDamageEnabled.setValue(0)
		Debug.MessageBox("Melee Locational Damage is now deactivated")
	EndIf
EndFunction

Function DCLocationalDamageArcheryFunction()
	DCLocDamageArcheryEnabled = !DCLocDamageArcheryEnabled
	If(DCLocDamageArcheryEnabled )
		DCLocationalDamageEnabledArchery.setValue(1)
		Debug.MessageBox("Ranged Locational Damage is now activated")
	Else
		DCLocationalDamageEnabledArchery.setValue(0)
		Debug.MessageBox("Ranged Locational Damage is now deactivated")
	EndIf
EndFunction

Function SetGameSetting(String gameSetting, float newValue)
	Game.SetGameSettingFloat(gameSetting, newValue)
	If(gameSetting == "fArmorRatingMax")
		fArmorRatingMax = newValue
	ElseIf(gameSetting == "fArmorRatingPCMax")
		fArmorRatingPCMax = newValue
	ElseIf(gameSetting == "fArmorScalingFactor")
		fArmorScalingFactor = newValue
	ElseIf(gameSetting == "fMaxArmorRating")
		fMaxArmorRating = newValue
	ElseIf(gameSetting == "fCombatBashReach")
		fCombatBashReach = newValue
	ElseIf(gameSetting == "fCombatDistance")
		fCombatDistance = newValue
	ElseIf(gameSetting == "fBlockMax")
		fBlockMax = newValue
	ElseIf(gameSetting == "fBlockPowerAttackMult")
		fBlockPowerAttackMult = newValue
	ElseIf(gameSetting == "fBlockSkillMult")
		fBlockSkillMult = newValue
	ElseIf(gameSetting == "fBlockWeaponBase")
		fBlockWeaponBase = newValue
	ElseIf(gameSetting == "fBlockWeaponScaling")
		fBlockWeaponScaling = newValue
	ElseIf(gameSetting == "fShieldBaseFactor")
		fShieldBaseFactor = newValue
	ElseIf(gameSetting == "fDamagePCSkillMax")
		fDamagePCSkillMax = newValue
	ElseIf(gameSetting == "fDamagePCSkillMin")
		fDamagePCSkillMin = newValue
	ElseIf(gameSetting == "fDamageSkillMax")
		fDamageSkillMax = newValue
	ElseIf(gameSetting == "fDamageSkillMin")
		fDamageSkillMin = newValue
	ElseIf(gameSetting == "fMoveEncumEffect")
		fMoveEncumEffect = newValue
	ElseIf(gameSetting == "fMoveEncumEffectNoWeapon")
		fMoveEncumEffectNoWeapon = newValue
	ElseIf(gameSetting == "fCombatStaminaRegenRateMult")
		fCombatStaminaRegenRateMult = newValue
	ElseIf(gameSetting == "fStaminaAttackWeaponMult")
		fStaminaAttackWeaponMult = newValue
	ElseIf(gameSetting == "fStaminaBlockBase")
		fStaminaBlockBase = newValue
	EndIf
EndFunction

Function GameSettingsMaintenance()
	If(fArmorRatingMax > -1.0)
		Game.SetGameSettingFloat("fArmorRatingMax", fArmorRatingMax )
	EndIf
	If(fArmorRatingPCMax > -1.0)
		Game.SetGameSettingFloat("fArmorRatingPCMax", fArmorRatingPCMax )
	EndIf 
	If(fArmorScalingFactor > -1.0)
		Game.SetGameSettingFloat("fArmorScalingFactor", fArmorScalingFactor )
	EndIf 
	If(fMaxArmorRating > -1.0)
		Game.SetGameSettingFloat("fMaxArmorRating", fMaxArmorRating )
	EndIf 
	If(fCombatBashReach > -1.0)
		Game.SetGameSettingFloat("fCombatBashReach", fCombatBashReach )
	EndIf 
	If(fCombatDistance > -1.0)
		Game.SetGameSettingFloat("fCombatDistance", fCombatDistance )
	EndIf 
	If(fBlockMax > -1.0)
		Game.SetGameSettingFloat("fBlockMax", fBlockMax )
	EndIf 
	If(fBlockPowerAttackMult > -1.0)
		Game.SetGameSettingFloat("fBlockPowerAttackMult", fBlockPowerAttackMult )
	EndIf 
	If(fBlockSkillMult > -1.0)
		Game.SetGameSettingFloat("fBlockSkillMult", fBlockSkillMult )
	EndIf 
	If(fBlockWeaponBase > -1.0)
		Game.SetGameSettingFloat("fBlockWeaponBase", fBlockWeaponBase )
	EndIf 
	If(fBlockWeaponScaling > -1.0)
		Game.SetGameSettingFloat("fBlockWeaponScaling", fBlockWeaponScaling )
	EndIf 
	If(fShieldBaseFactor > -1.0)
		Game.SetGameSettingFloat("fShieldBaseFactor", fShieldBaseFactor )
	EndIf 
	If(fDamagePCSkillMax > -1.0)
		Game.SetGameSettingFloat("fDamagePCSkillMax", fDamagePCSkillMax )
	EndIf 
	If(fDamagePCSkillMin > -1.0)
		Game.SetGameSettingFloat("fDamagePCSkillMin", fDamagePCSkillMin )
	EndIf 
	If(fDamageSkillMax > -1.0)
		Game.SetGameSettingFloat("fDamageSkillMax", fDamageSkillMax )
	EndIf 
	If(fDamageSkillMin > -1.0)
		Game.SetGameSettingFloat("fDamageSkillMin", fDamageSkillMin )
	EndIf 
	If(fMoveEncumEffect > -1.0)
		Game.SetGameSettingFloat("fMoveEncumEffect", fMoveEncumEffect )
	EndIf 
	If(fMoveEncumEffectNoWeapon > -1.0)
		Game.SetGameSettingFloat("fMoveEncumEffectNoWeapon", fMoveEncumEffectNoWeapon )
	EndIf 
	If(fCombatStaminaRegenRateMult > -1.0)
		Game.SetGameSettingFloat("fCombatStaminaRegenRateMult", fCombatStaminaRegenRateMult )
	EndIf
	If(fStaminaAttackWeaponMult > -1.0)
		Game.SetGameSettingFloat("fStaminaAttackWeaponMult", fStaminaAttackWeaponMult )
	EndIf 
	If(fStaminaBlockBase > -1.0)
		Game.SetGameSettingFloat("fStaminaBlockBase", fStaminaBlockBase )
	EndIf 
EndFunction