Scriptname DCEnemyFeintAIMagicEffectScript extends activemagiceffect  

Keyword property WeapTypeBow auto
Spell property DCNormalAttacksStaggerPlayerSpell auto
Faction property ForceFullBodyStagger auto

Event OnEffectStart(Actor akTarget, Actor akCaster)
	Debug.SendAnimationEvent(akTarget, "blockStop")
	Utility.Wait(0.05)
	Debug.SendAnimationEvent(akTarget, "blockStop")
	Utility.Wait(0.05)
	Debug.SendAnimationEvent(akTarget, "blockStop")
	Utility.Wait(0.05)
	Debug.SendAnimationEvent(akTarget, "blockStop")
	Utility.Wait(0.05)
	Debug.SendAnimationEvent(akTarget, "blockStart")
	Utility.Wait(0.05)
	Debug.SendAnimationEvent(akTarget, "blockStart")
	Utility.Wait(0.05)
	Debug.SendAnimationEvent(akTarget, "blockStart")
	Utility.Wait(0.05)
	Debug.SendAnimationEvent(akTarget, "blockStart")
EndEvent

Event OnHit(ObjectReference akAggressor, Form akSource, Projectile akProjectile, bool abPowerAttack, bool abSneakAttack, bool abBashAttack, bool abHitBlocked)
	If(!abHitBlocked || akSource.HasKeyword(WeapTypeBow))
		return
	EndIf
	Actor aggressorActor = akAggressor As Actor
	aggressorActor.DamageActorValue("Stamina", 4.0)
	(aggressorActor).SetFactionRank(ForceFullBodyStagger, 0)
	DCNormalAttacksStaggerPlayerSpell.Cast(aggressorActor, aggressorActor)
	Utility.Wait(0.5)
	Debug.SendAnimationEvent(aggressorActor, "staggerStop")
	(aggressorActor).RemoveFromFaction(ForceFullBodyStagger)
EndEvent