Scriptname DCCustomizationMenuEffectScript extends activemagiceffect  

Actor Property playerRef auto
Message Property DCCustomizationMenuMain auto
Message Property DCCustomizationMenuStaggering auto
Message Property DCCustomizationMenuOtherFeatures auto
Message Property DCCustomizationMenuLocationalDamage auto
DCInitQuestScript Property questScript auto
Quest Property DCInitQuest auto
Spell property DCAbPlayerSpell auto
Perk Property DCPlayerPerk auto

Event OnEffectStart(Actor akTarget, Actor akCaster)
If(akCaster== playerRef)	;Should some NPC obtain and use this scroll, do not unexpectedly pop up the menu for the player!
	int chosenOption = DCCustomizationMenuMain.Show()

	If(chosenOption==0)			;Staggering chosen
		chosenOption=-1
		chosenOption = DCCustomizationMenuStaggering.Show()
		If(chosenOption==0)		;Prevent stagger spam option chosen
			questScript.DCPreventPlayerStaggerSpamFunction()
		EndIf

	ElseIf(chosenOption==1)		;Other Features chosen
		chosenOption = DCCustomizationMenuOtherFeatures.Show()
		If(chosenOption==0)		;Toggle Timed blocking option chosen
			questScript.DCTimedBlockingFunction()
		ElseIf(chosenOption==1)	;Toggle Timed warding option chosen
			questScript.DCTimedWardingFunction()
		EndIf

	ElseIf(chosenOption==2)		;Locational Damage chosen
		chosenOption = DCCustomizationMenuLocationalDamage.Show()
		If(chosenOption == 0)		;Toggle Melee Locational Damage option chosen
			questScript.DCLocationalDamageFunction()
		ElseIf(chosenOption == 1)	;Toggle Ranged Locational Damage option chosen
			questScript.DCLocationalDamageArcheryFunction()
		EndIf

	ElseIf(chosenOption==3)			;Deactivate mod
		DCInitQuest.stop()
		playerRef.removeSpell(DCAbPlayerSpell)
		playerRef.removePerk(DCPlayerPerk)
		Debug.MessageBox("Deadly Combat's Scripts are now deactivated. Can safely disable and remove plugin.")
	ElseIf(chosenOption==4)			;Activate mod
		DCInitQuest.start()
		Debug.MessageBox("Deadly Combat's Scripts are now active again. Do not uninstall the mod before deactivating it again!")
	EndIf

EndIf
EndEvent