Scriptname DCConfigMenuScript extends SKI_ConfigBase  

;||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
;=============================G A M E  S E T T I N G S=============================
;||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

;==============ARMOR SETTINGS==============
int optionIDFArmorRatingMax
int optionIDFArmorRatingPCMax
int optionIDFArmorScalingFactor
int optionIDFMaxArmorRating
;==============ARMOR SETTINGS==============

;==============ATTACK DISTANCE SETTINGS==============
int optionIDFCombatBashReach
int optionIDFCombatDistance
;==============ATTACK DISTANCE SETTINGS==============

;==============BLOCK SETTINGS==============
int optionIDFBlockMax
int optionIDFBlockPowerAttackMult
int optionIDFBlockSkillMult
int optionIDFBlockWeaponBase
int optionIDFBlockWeaponScaling
int optionIDFShieldBaseFactor
;==============BLOCK SETTINGS==============

;==============DAMAGE SETTINGS==============
int optionIDFDamagePCSkillMax
int optionIDFDamagePCSkillMin
int optionIDFDamageSkillMax
int optionIDFDamageSkillMin
;==============DAMAGE SETTINGS==============

;==============MOVEMENT SETTINGS==============
int optionIDFMoveEncumEffect
int optionIDFMoveEncumEffectNoWeapon
;==============MOVEMENT SETTINGS==============

;==============STAMINA SETTINGS==============
int optionIDFCombatStaminaRegenRateMult
int optionIDFStaminaAttackWeaponMult
int optionIDFStaminaBlockBase
;==============STAMINA SETTINGS==============

;||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
;=============================G A M E  S E T T I N G S=============================
;||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

;||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
;==============================S T A G G E R I N G==============================
;||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

int optionIDAllowStaggerNPCs
int optionIDAllowStaggerPlayer
int optionIDStaggerSpamPreventionPlayer
int optionIDStaggerSpamPreventionNPCs
int optionIDIgnorePainPotions
int optionIDIgnorePainSpell

bool allowStaggerNPCs = true
bool allowStaggerPlayer = true
bool staggerSpamPreventionPlayer = true
bool staggerSpamPreventionNPCs = true
bool ignorePainPotions = true
bool ignorePainSpell = true

;||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
;==============================S T A G G E R I N G==============================
;||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

;||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
;============================O T H E R  F E A T U R E S============================
;||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

bool timedBlocking = true
bool timedWarding = true
bool locDamageMelee = true
bool locDamageRanged = true

int optionIDTimedBlocking
int optionIDTimedWarding
int optionIDLocDamageMelee
int optionIDLocDamageRanged

;||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
;============================O T H E R  F E A T U R E S============================
;||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

DCInitQuestScript Property mainQuest auto

Event OnConfigInit()
	Pages = new String[3]
	Pages[0] = "Game Settings"
	Pages[1] = "Staggering"
	Pages[2] = "Other Features"
EndEvent

Event OnPageReset(String page)
	If(page == "")
		LoadCustomContent("DeadlyCombat/DCOpeningMenu.dds", 126, 23)
		return
	Else
		UnloadCustomContent()
	EndIf

;=====================GAME SETTINGS MENU=====================
	If(page == "Game Settings")
		SetCursorFillMode(TOP_TO_BOTTOM)
		AddHeaderOption("Armor Settings")	
		optionIDFArmorRatingMax = AddSliderOption("NPC Armor Skill Factor", (Game.GetGameSettingFloat("fArmorRatingMax")), "{3}")		
		optionIDFArmorRatingPCMax = AddSliderOption("Player Armor Skill Factor", (Game.GetGameSettingFloat("fArmorRatingPCMax")), "{2}")	
		optionIDFArmorScalingFactor = AddSliderOption("Damage Reduction/Armor", Game.GetGameSettingFloat("fArmorScalingFactor"), "{4}%")	
		optionIDFMaxArmorRating = AddSliderOption("Max Damage Reduction", Game.GetGameSettingFloat("fMaxArmorRating"), "{0}%")		

		AddEmptyOption()

		AddHeaderOption("Block Settings")
		optionIDFBlockMax = AddSliderOption("Max Damage Reduction", 100*Game.GetGameSettingFloat("fBlockMax"), "{1}%")
		optionIDFBlockPowerAttackMult = AddSliderOption("Damage Reduction Power Attacks", Game.GetGameSettingFloat("fBlockPowerAttackMult"), "{2}")
		optionIDFBlockSkillMult = AddSliderOption("Block Skill Factor", Game.GetGameSettingFloat("fBlockSkillMult"), "{1}")
		optionIDFBlockWeaponBase = AddSliderOption("Base Damage Reduction (Weapons)", Game.GetGameSettingFloat("fBlockWeaponBase"), "{2}")
		optionIDFBlockWeaponScaling = AddSliderOption("Block Skill Factor (Weapons)", Game.GetGameSettingFloat("fBlockWeaponScaling"), "{2}")
		optionIDFShieldBaseFactor = AddSliderOption("Base Damage Reduction (Shields)", Game.GetGameSettingFloat("fShieldBaseFactor"), "{2}")

		AddEmptyOption()

		AddHeaderOption("Movement Settings")
		optionIDFMoveEncumEffect = AddSliderOption("Encumbrance factor", Game.GetGameSettingFloat("fMoveEncumEffect"), "{2}")
		optionIDFMoveEncumEffectNoWeapon = AddSliderOption("Encumbrance factor (no weapon)", Game.GetGameSettingFloat("fMoveEncumEffectNoWeapon"), "{2}")

		SetCursorPosition(1)

		AddHeaderOption("Damage Settings")
		optionIDFDamagePCSkillMax = AddSliderOption("Player Weapon Skill Factor", (Game.GetGameSettingFloat("fDamagePCSkillMax")), "{2}")
		optionIDFDamagePCSkillMin = AddSliderOption("Player Damage Mult", Game.GetGameSettingFloat("fDamagePCSkillMin"), "{2}")
		optionIDFDamageSkillMax = AddSliderOption("NPC Weapon Skill Factor", (Game.GetGameSettingFloat("fDamageSkillMax")), "{2}")
		optionIDFDamageSkillMin = AddSliderOption("NPC Damage Mult", Game.GetGameSettingFloat("fDamageSkillMin"), "{2}")

		AddEmptyOption()
		
		AddHeaderOption("Attack Distance Settings")
		optionIDFCombatBashReach = AddSliderOption("Bash Reach", Game.GetGameSettingFloat("fCombatBashReach"), "{1}")
		optionIDFCombatDistance = AddSliderOption("Attack Reach", Game.GetGameSettingFloat("fCombatDistance"), "{1}")

		AddEmptyOption()
	
		AddHeaderOption("Stamina Settings")
		optionIDFCombatStaminaRegenRateMult = AddSliderOption("Combat Stamina Regen Mult", Game.GetGameSettingFloat("fCombatStaminaRegenRateMult"), "{3}")
		optionIDFStaminaAttackWeaponMult = AddSliderOption("Power Attack Stamina Cost Mult", Game.GetGameSettingFloat("fStaminaAttackWeaponMult"), "{3}")
		optionIDFStaminaBlockBase = AddSliderOption("Block Stamina Cost", Game.GetGameSettingFloat("fStaminaBlockBase"), "{1}")

;=====================STAGGERING MENU=====================
	ElseIf(page == "Staggering")
		SetCursorFillMode(TOP_TO_BOTTOM)

		optionIDAllowStaggerNPCs = AddToggleOption("Player's Attacks stagger NPCs", allowStaggerNPCs)
		optionIDAllowStaggerPlayer = AddToggleOption("NPCs' Attacks stagger Player", allowStaggerPlayer)
		optionIDStaggerSpamPreventionPlayer = AddToggleOption("Prevent Stagger Spam Player", staggerSpamPreventionPlayer)
		optionIDStaggerSpamPreventionNPCs = AddToggleOption("Prevent Stagger Spam NPCs", staggerSpamPreventionNPCs)
		optionIDIgnorePainPotions = AddToggleOption("Adrenaline Rush Potions", ignorePainPotions)
		optionIDIgnorePainSpell = AddToggleOption("Ignore Pain Spell", ignorePainSpell)

;=====================OTHER FEATURES MENU=====================
	ElseIf(page == "Other Features")
		SetCursorFillMode(TOP_TO_BOTTOM)

		optionIDTimedBlocking = AddToggleOption("Timed Blocking", timedBlocking)
		optionIDTimedWarding = AddToggleOption("Timed Warding", timedWarding)
		optionIDLocDamageMelee = AddToggleOption("Melee Locational Damage", locDamageMelee)
		optionIDLocDamageRanged = AddToggleOption("Ranged Locational Damage", locDamageRanged)

	EndIf
EndEvent

Event OnOptionHighlight(int option)
	;GAME SETTINGS MENU
	If(option == optionIDFArmorRatingMax)
		SetInfoText("NPCs have their Armor Rating multiplied by this value when they have a Skill of 100 in the respective Armor Skill. Default Deadly Combat Value: 2.357. Default Skyrim Value: 2.5")
	ElseIf(option == optionIDFArmorRatingPCMax)
		SetInfoText("The Player has his Armor Rating multiplied by this value when he has a Skill of 100 in the respective Armor Skill. Default Deadly Combat Value: 1.32. Default Skyrim Value: 1.4")
	ElseIf(option == optionIDFArmorScalingFactor)
		SetInfoText("Every point of Armor Rating will reduce damage taken by this percentage. Default Deadly Combat Value: 0.1034. Default Skyrim Value: 0.12")
	ElseIf(option == optionIDFMaxArmorRating)
		SetInfoText("Armor will never be able to reduce damage taken by more than this percentage. Default Deadly Combat Value: 75.0. Default Skyrim Value: 80.0")
	ElseIf(option == optionIDFBlockMax )
		SetInfoText("Blocking will never be able to reduce damage taken by more than this percentage. Default Deadly Combat Value: 95. Default Skyrim Value: 70")
	ElseIf(option == optionIDFBlockPowerAttackMult )
		SetInfoText("The effectiveness of blocking is multiplied by this value when blocking Power Attacks. Default Deadly Combat Value: 0.75. Default Skyrim Value: 0.66")
	ElseIf(option == optionIDFBlockSkillMult )
		SetInfoText("This factor indicates how well the effectiveness of Blocking scales with Block Skill. Default Deadly Combat Value: 5.0. Default Skyrim Value: 2.0")
	ElseIf(option == optionIDFBlockWeaponBase )
		SetInfoText("Before considering any multipliers, blocking with Weapons will block this part of incoming damage. Default Deadly Combat Value: 0.6. Default Skyrim Value: 0.3")
	ElseIf(option == optionIDFBlockWeaponScaling )
		SetInfoText("This factor indicates how well the effectiveness of Blocking scales with Block Skill when Blocking with Weapons. Default Deadly Combat Value: 0.5. Default Skyrim Value: 0.2")
	ElseIf(option == optionIDFShieldBaseFactor )
		SetInfoText("Before considering any multipliers, blocking with Shields will block this part of incoming damage. Default Deadly Combat Value: 0.75. Default Skyrim Value: 0.45")
	ElseIf(option == optionIDFMoveEncumEffect )
		SetInfoText("This factor indicates how much you are slowed down by the weight of your worn armor when you have a weapon drawn. Default Deadly Combat Value: 0.35. Default Skyrim Value: 0.30")
	ElseIf(option == optionIDFMoveEncumEffectNoWeapon )
		SetInfoText("This factor indicates how much you are slowed down by the weight of your worn armor when you do not have a weapon drawn. Default Deadly Combat Value: 0.20. Default Skyrim Value: 0.15")
	ElseIf(option == optionIDFDamagePCSkillMax )
		SetInfoText("The Player has his Damage multiplied by this value when he has a Skill of 100 in the respective Weapon Skill. Default Deadly Combat Value: 1.9. Default Skyrim Value: 1.5")
	ElseIf(option == optionIDFDamagePCSkillMin )
		SetInfoText("The Player has his Damage multiplied by this value when he has a Skill of 0 in the respective Weapon Skill. Default Deadly Combat Value: 1.75. Default Skyrim Value: 1.0")
	ElseIf(option == optionIDFDamageSkillMax )
		SetInfoText("NPCs have their Damage multiplied by this value when they have a Skill of 100 in the respective Weapon Skill. Default Deadly Combat Value: 3.5. Default Skyrim Value: 3.0")
	ElseIf(option == optionIDFDamageSkillMin )
		SetInfoText("NPCs have their Damage multiplied by this value when they have a Skill of 0 in the respective Weapon Skill. Default Deadly Combat Value: 2.5. Default Skyrim Value: 1.0")
	ElseIf(option == optionIDFCombatBashReach )
		SetInfoText("This value indicates how many in-game units a Bash can reach. Default Deadly Combat Value: 100. Default Skyrim Value: 141")
	ElseIf(option == optionIDFCombatDistance )
		SetInfoText("This value indicates how many in-game units an Attack can reach (before addition of extra units dependent on Weapon size). Default Deadly Combat Value: 100. Default Skyrim Value: 141")
	ElseIf(option == optionIDFCombatStaminaRegenRateMult )
		SetInfoText("Stamina Regeneration Rate is multiplied by this value when in combat. Default Deadly Combat Value: 0.5. Default Skyrim Value: 0.35")
	ElseIf(option == optionIDFStaminaAttackWeaponMult )
		SetInfoText("Stamina cost of Power Attacks is multiplied by this value. Default Deadly Combat Value: 1.75. Default Skyrim Value: 1.0")
	ElseIf(option == optionIDFStaminaBlockBase )
		SetInfoText("Blocking attacks costs this amount of Stamina (before modifiers from Timed Blocking). Default Deadly Combat Value: 20. Default Skyrim Value: 0.0")

	;STAGGER MENU
	ElseIf(option == optionIDAllowStaggerNPCs)
		SetInfoText("If this option is on, the Player's normal attacks will be able to stagger NPCs.")
	ElseIf(option == optionIDAllowStaggerPlayer)
		SetInfoText("If this option is on, NPCs' normal attacks will be able to stagger the Player")
	ElseIf(option == optionIDStaggerSpamPreventionPlayer)
		SetInfoText("If this option is on, there will be a short cooldown on the Player staggering through NPCs' normal attacks in order to prevent continuously spamming Stagger effects.")
	ElseIf(option == optionIDStaggerSpamPreventionNPCs)
		SetInfoText("If this option is on, there will be a short cooldown on NPCs' staggering through the Player's normal attacks in order to prevent continuously spamming Stagger effects.")
	ElseIf(option == optionIDIgnorePainPotions)
		SetInfoText("If this option is on, Alchemy vendors all throughout Skyrim will have a new dialogue option to buy Adrenaline Rush Potions.")
	ElseIf(option == optionIDIgnorePainSpell)
		SetInfoText("If this option is on, the Player will have access to an Ignore Pain Spell in his spellbook.")

	;OTHER FEATURES MENU
	ElseIf(option == optionIDTimedBlocking)
		SetInfoText("Toggle this option to enable or disable Deadly Combat's Timed Blocking feature.")
	ElseIf(option == optionIDTimedWarding)
		SetInfoText("Toggle this option to enable or disable Deadly Combat's Timed Warding feature.")
	ElseIf(option == optionIDLocDamageMelee)
		SetInfoText("If this option is toggled on, the Player and NPCs can be affected by Locational Damage effects from melee attacks.")
	ElseIf(option == optionIDLocDamageRanged)
		SetInfoText("If this option is toggled on, the Player and NPCs can be affected by Locational Damage effects from ranged attacks.")

	EndIf
EndEvent

Event OnOptionSliderOpen(int option)
	If(option == optionIDFArmorRatingMax)
		SetSliderDialogStartValue(Game.GetGameSettingFloat("fArmorRatingMax"))
		SetSliderDialogDefaultValue(2.357)
		SetSliderDialogRange(0.5, 3.0)
		SetSliderDialogInterval(0.001)
	ElseIf(option == optionIDFArmorRatingPCMax)
		SetSliderDialogStartValue(Game.GetGameSettingFloat("fArmorRatingPCMax"))
		SetSliderDialogDefaultValue(1.32)
		SetSliderDialogRange(0.5, 3.0)
		SetSliderDialogInterval(0.01)
	ElseIf(option == optionIDFArmorScalingFactor)
		SetSliderDialogStartValue(Game.GetGameSettingFloat("fArmorScalingFactor"))
		SetSliderDialogDefaultValue(0.1034)
		SetSliderDialogRange(0.05, 0.2)
		SetSliderDialogInterval(0.0001)
	ElseIf(option == optionIDFMaxArmorRating)
		SetSliderDialogStartValue(Game.GetGameSettingFloat("fMaxArmorRating"))
		SetSliderDialogDefaultValue(75.0)
		SetSliderDialogRange(0.0, 100.0)
		SetSliderDialogInterval(1.0)
	ElseIf(option == optionIDFBlockMax )
		SetSliderDialogStartValue(100*Game.GetGameSettingFloat("fBlockMax"))
		SetSliderDialogDefaultValue(95)
		SetSliderDialogRange(0.0, 100.0)
		SetSliderDialogInterval(1.0)
	ElseIf(option == optionIDFBlockPowerAttackMult )
		SetSliderDialogStartValue(Game.GetGameSettingFloat("fBlockPowerAttackMult"))
		SetSliderDialogDefaultValue(0.75)
		SetSliderDialogRange(0.0, 1.0)
		SetSliderDialogInterval(0.01)
	ElseIf(option == optionIDFBlockSkillMult )
		SetSliderDialogStartValue(Game.GetGameSettingFloat("fBlockSkillMult"))
		SetSliderDialogDefaultValue(5)
		SetSliderDialogRange(1.0, 10.0)
		SetSliderDialogInterval(0.5)
	ElseIf(option == optionIDFBlockWeaponBase )
		SetSliderDialogStartValue(Game.GetGameSettingFloat("fBlockWeaponBase"))
		SetSliderDialogDefaultValue(0.60)
		SetSliderDialogRange(0.0, 1.0)
		SetSliderDialogInterval(0.05)
	ElseIf(option == optionIDFBlockWeaponScaling )
		SetSliderDialogStartValue(Game.GetGameSettingFloat("fBlockWeaponScaling"))
		SetSliderDialogDefaultValue(0.5)
		SetSliderDialogRange(0.0, 2.0)
		SetSliderDialogInterval(0.1)
	ElseIf(option == optionIDFShieldBaseFactor )
		SetSliderDialogStartValue(Game.GetGameSettingFloat("fShieldBaseFactor"))
		SetSliderDialogDefaultValue(0.75)
		SetSliderDialogRange(0.0, 1.50)
		SetSliderDialogInterval(0.05)
	ElseIf(option == optionIDFMoveEncumEffect )
		SetSliderDialogStartValue(Game.GetGameSettingFloat("fMoveEncumEffect"))
		SetSliderDialogDefaultValue(0.35)
		SetSliderDialogRange(0.0, 1.0)
		SetSliderDialogInterval(0.01)
	ElseIf(option == optionIDFMoveEncumEffectNoWeapon )
		SetSliderDialogStartValue(Game.GetGameSettingFloat("fMoveEncumEffectNoWeapon"))
		SetSliderDialogDefaultValue(0.2)
		SetSliderDialogRange(0.0, 1.0)
		SetSliderDialogInterval(0.01)
	ElseIf(option == optionIDFDamagePCSkillMax )
		SetSliderDialogStartValue(Game.GetGameSettingFloat("fDamagePCSkillMax"))
		SetSliderDialogDefaultValue(1.9)
		SetSliderDialogRange(1.0, 5.0)
		SetSliderDialogInterval(0.05)
	ElseIf(option == optionIDFDamagePCSkillMin )
		SetSliderDialogStartValue(Game.GetGameSettingFloat("fDamagePCSkillMin"))
		SetSliderDialogDefaultValue(1.75)
		SetSliderDialogRange(1.0, 5.0)
		SetSliderDialogInterval(0.05)
	ElseIf(option == optionIDFDamageSkillMax )
		SetSliderDialogStartValue(Game.GetGameSettingFloat("fDamageSkillMax"))
		SetSliderDialogDefaultValue(3.5)
		SetSliderDialogRange(1.0, 5.0)
		SetSliderDialogInterval(0.05)
	ElseIf(option == optionIDFDamageSkillMin )
		SetSliderDialogStartValue(Game.GetGameSettingFloat("fDamageSkillMin"))
		SetSliderDialogDefaultValue(2.5)
		SetSliderDialogRange(1.0, 5.0)
		SetSliderDialogInterval(0.05)
	ElseIf(option == optionIDFCombatBashReach )
		SetSliderDialogStartValue(Game.GetGameSettingFloat("fCombatBashReach"))
		SetSliderDialogDefaultValue(100)
		SetSliderDialogRange(90, 150)
		SetSliderDialogInterval(1.0)
	ElseIf(option == optionIDFCombatDistance )
		SetSliderDialogStartValue(Game.GetGameSettingFloat("fCombatDistance"))
		SetSliderDialogDefaultValue(100)
		SetSliderDialogRange(90, 150)
		SetSliderDialogInterval(1.0)
	ElseIf(option == optionIDFCombatStaminaRegenRateMult )
		SetSliderDialogStartValue(Game.GetGameSettingFloat("fCombatStaminaRegenRateMult"))
		SetSliderDialogDefaultValue(0.5)
		SetSliderDialogRange(0.0, 1.0)
		SetSliderDialogInterval(0.05)
	ElseIf(option == optionIDFStaminaAttackWeaponMult )
		SetSliderDialogStartValue(Game.GetGameSettingFloat("fStaminaAttackWeaponMult"))
		SetSliderDialogDefaultValue(1.75)
		SetSliderDialogRange(1.0, 3.0)
		SetSliderDialogInterval(0.05)
	ElseIf(option == optionIDFStaminaBlockBase )
		SetSliderDialogStartValue(Game.GetGameSettingFloat("fStaminaBlockBase"))
		SetSliderDialogDefaultValue(20)
		SetSliderDialogRange(0.0, 50.0)
		SetSliderDialogInterval(1.0)
	EndIf
EndEvent

Event OnOptionSliderAccept(int option, float value)
	If(option == optionIDFArmorRatingMax)
		mainQuest.SetGameSetting("fArmorRatingMax", value)
		SetSliderOptionValue(optionIDFArmorRatingMax, value, "{3}")
	ElseIf(option == optionIDFArmorRatingPCMax)
		mainQuest.SetGameSetting("fArmorRatingPCMax", value)
		SetSliderOptionValue(optionIDFArmorRatingPCMax, value, "{2}")
	ElseIf(option == optionIDFArmorScalingFactor)
		mainQuest.SetGameSetting("fArmorScalingFactor", value)
		SetSliderOptionValue(optionIDFArmorScalingFactor, value, "{4}%")
	ElseIf(option == optionIDFMaxArmorRating)
		mainQuest.SetGameSetting("fMaxArmorRating", value)
		SetSliderOptionValue(optionIDFMaxArmorRating, value, "{0}%")
	ElseIf(option == optionIDFBlockMax )
		mainQuest.SetGameSetting("fBlockMax", value/100)
		SetSliderOptionValue(optionIDFBlockMax , value, "{1}%")
	ElseIf(option == optionIDFBlockPowerAttackMult )
		mainQuest.SetGameSetting("fBlockPowerAttackMult", value)
		SetSliderOptionValue(optionIDFBlockPowerAttackMult , value, "{2}")
	ElseIf(option == optionIDFBlockSkillMult )
		mainQuest.SetGameSetting("fBlockSkillMult", value)
		SetSliderOptionValue(optionIDFBlockSkillMult , value, "{1}")
	ElseIf(option == optionIDFBlockWeaponBase )
		mainQuest.SetGameSetting("fBlockWeaponBase", value)
		SetSliderOptionValue(optionIDFBlockWeaponBase , value, "{2}")
	ElseIf(option == optionIDFBlockWeaponScaling )
		mainQuest.SetGameSetting("fBlockWeaponScaling", value)
		SetSliderOptionValue(optionIDFBlockWeaponScaling , value, "{2}")
	ElseIf(option == optionIDFShieldBaseFactor )
		mainQuest.SetGameSetting("fShieldBaseFactor", value)
		SetSliderOptionValue(optionIDFShieldBaseFactor , value, "{2}")
	ElseIf(option == optionIDFMoveEncumEffect )
		mainQuest.SetGameSetting("fMoveEncumEffect", value)
		SetSliderOptionValue(optionIDFMoveEncumEffect , value, "{2}")
	ElseIf(option == optionIDFMoveEncumEffectNoWeapon )
		mainQuest.SetGameSetting("fMoveEncumEffectNoWeapon", value)
		SetSliderOptionValue(optionIDFMoveEncumEffectNoWeapon , value, "{2}")
	ElseIf(option == optionIDFDamagePCSkillMax )
		mainQuest.SetGameSetting("fDamagePCSkillMax", value)
		SetSliderOptionValue(optionIDFDamagePCSkillMax , value, "{2}")
	ElseIf(option == optionIDFDamagePCSkillMin )
		mainQuest.SetGameSetting("fDamagePCSkillMin", value)
		SetSliderOptionValue(optionIDFDamagePCSkillMin , value, "{2}")
	ElseIf(option == optionIDFDamageSkillMax )
		mainQuest.SetGameSetting("fDamageSkillMax", value)
		SetSliderOptionValue(optionIDFDamageSkillMax , value, "{2}")
	ElseIf(option == optionIDFDamageSkillMin )
		mainQuest.SetGameSetting("fDamageSkillMin", value)
		SetSliderOptionValue(optionIDFDamageSkillMin , value, "{2}")
	ElseIf(option == optionIDFCombatBashReach )
		mainQuest.SetGameSetting("fCombatBashReach", value)
		SetSliderOptionValue(optionIDFCombatBashReach , value, "{1}")
	ElseIf(option == optionIDFCombatDistance )
		mainQuest.SetGameSetting("fCombatDistance", value)
		SetSliderOptionValue(optionIDFCombatDistance , value, "{1}")
	ElseIf(option == optionIDFCombatStaminaRegenRateMult )
		mainQuest.SetGameSetting("fCombatStaminaRegenRateMult", value)
		SetSliderOptionValue(optionIDFCombatStaminaRegenRateMult , value, "{3}")
	ElseIf(option == optionIDFStaminaAttackWeaponMult )
		mainQuest.SetGameSetting("fStaminaAttackWeaponMult", value)
		SetSliderOptionValue(optionIDFStaminaAttackWeaponMult , value, "{3}")
	ElseIf(option == optionIDFStaminaBlockBase )
		mainQuest.SetGameSetting("fStaminaBlockBase", value)
		SetSliderOptionValue(optionIDFStaminaBlockBase , value, "{1}")
	EndIf
EndEvent

Event OnOptionDefault(int option)
	float value
	;GAME SETTINGS MENU
	If(option == optionIDFArmorRatingMax)
		value = 2.357 
		mainQuest.SetGameSetting("fArmorRatingMax", value)
		SetSliderOptionValue(optionIDFArmorRatingMax, value, "{3}")
	ElseIf(option == optionIDFArmorRatingPCMax)
		value = 1.32
		mainQuest.SetGameSetting("fArmorRatingPCMax", value)
		SetSliderOptionValue(optionIDFArmorRatingPCMax, value, "{2}")
	ElseIf(option == optionIDFArmorScalingFactor)
		value = 0.1034
		mainQuest.SetGameSetting("fArmorScalingFactor", value)
		SetSliderOptionValue(optionIDFArmorScalingFactor, value, "{4}%")
	ElseIf(option == optionIDFMaxArmorRating)
		value = 75.0
		mainQuest.SetGameSetting("fMaxArmorRating", value)
		SetSliderOptionValue(optionIDFMaxArmorRating, value, "{0}%")
	ElseIf(option == optionIDFBlockMax )
		value = 95.0
		mainQuest.SetGameSetting("fBlockMax", value/100)
		SetSliderOptionValue(optionIDFBlockMax , value, "{1}%")
	ElseIf(option == optionIDFBlockPowerAttackMult )
		value = 0.75
		mainQuest.SetGameSetting("fBlockPowerAttackMult", value)
		SetSliderOptionValue(optionIDFBlockPowerAttackMult , value, "{2}")
	ElseIf(option == optionIDFBlockSkillMult )
		value = 5
		mainQuest.SetGameSetting("fBlockSkillMult", value)
		SetSliderOptionValue(optionIDFBlockSkillMult , value, "{1}")
	ElseIf(option == optionIDFBlockWeaponBase )
		value = 0.6
		mainQuest.SetGameSetting("fBlockWeaponBase", value)
		SetSliderOptionValue(optionIDFBlockWeaponBase , value, "{2}")
	ElseIf(option == optionIDFBlockWeaponScaling )
		value = 0.5
		mainQuest.SetGameSetting("fBlockWeaponScaling", value)
		SetSliderOptionValue(optionIDFBlockWeaponScaling , value, "{2}")
	ElseIf(option == optionIDFShieldBaseFactor )
		value = 0.75
		mainQuest.SetGameSetting("fShieldBaseFactor", value)
		SetSliderOptionValue(optionIDFShieldBaseFactor , value, "{2}")
	ElseIf(option == optionIDFMoveEncumEffect )
		value = 0.35
		mainQuest.SetGameSetting("fMoveEncumEffect", value)
		SetSliderOptionValue(optionIDFMoveEncumEffect , value, "{2}")
	ElseIf(option == optionIDFMoveEncumEffectNoWeapon )
		value = 0.2
		mainQuest.SetGameSetting("fMoveEncumEffectNoWeapon", value)
		SetSliderOptionValue(optionIDFMoveEncumEffectNoWeapon , value, "{2}")
	ElseIf(option == optionIDFDamagePCSkillMax )
		value = 1.9
		mainQuest.SetGameSetting("fDamagePCSkillMax", value)
		SetSliderOptionValue(optionIDFDamagePCSkillMax , value, "{2}")
	ElseIf(option == optionIDFDamagePCSkillMin )
		value = 1.75
		mainQuest.SetGameSetting("fDamagePCSkillMin", value)
		SetSliderOptionValue(optionIDFDamagePCSkillMin , value, "{2}")
	ElseIf(option == optionIDFDamageSkillMax )
		value = 3.5
		mainQuest.SetGameSetting("fDamageSkillMax", value)
		SetSliderOptionValue(optionIDFDamageSkillMax , value, "{2}")
	ElseIf(option == optionIDFDamageSkillMin )
		value = 2.5
		mainQuest.SetGameSetting("fDamageSkillMin", value)
		SetSliderOptionValue(optionIDFDamageSkillMin , value, "{2}")
	ElseIf(option == optionIDFCombatBashReach )
		value = 100
		mainQuest.SetGameSetting("fCombatBashReach", value)
		SetSliderOptionValue(optionIDFCombatBashReach , value, "{1}")
	ElseIf(option == optionIDFCombatDistance )
		value = 100
		mainQuest.SetGameSetting("fCombatDistance", value)
		SetSliderOptionValue(optionIDFCombatDistance , value, "{1}")
	ElseIf(option == optionIDFCombatStaminaRegenRateMult )
		value = 0.5
		mainQuest.SetGameSetting("fCombatStaminaRegenRateMult", value)
		SetSliderOptionValue(optionIDFCombatStaminaRegenRateMult , value, "{3}")
	ElseIf(option == optionIDFStaminaAttackWeaponMult )
		value = 1.75
		mainQuest.SetGameSetting("fStaminaAttackWeaponMult", value)
		SetSliderOptionValue(optionIDFStaminaAttackWeaponMult , value, "{3}")
	ElseIf(option == optionIDFStaminaBlockBase )
		value = 20
		mainQuest.SetGameSetting("fStaminaBlockBase", value)
		SetSliderOptionValue(optionIDFStaminaBlockBase , value, "{1}")

	;STAGGER MENU
	ElseIf(option == optionIDAllowStaggerNPCs)
		allowStaggerNPCs = true
		SetToggleOptionValue(optionIDAllowStaggerNPCs, true)
		mainQuest.SetAllowStaggerNPCs(true)
	ElseIf(option == optionIDAllowStaggerPlayer)
		allowStaggerPlayer = true
		SetToggleOptionValue(optionIDAllowStaggerPlayer, true)
		mainQuest.SetAllowStaggerPlayer(true)
	ElseIf(option == optionIDStaggerSpamPreventionPlayer)
		staggerSpamPreventionPlayer = true
		SetToggleOptionValue(optionIDStaggerSpamPreventionPlayer, true)
		mainQuest.SetStaggerSpamPreventionPlayer(true)
	ElseIf(option == optionIDStaggerSpamPreventionNPCs)
		staggerSpamPreventionNPCs = true
		SetToggleOptionValue(optionIDStaggerSpamPreventionNPCs, true)
		mainQuest.SetStaggerSpamPreventionNPCs(true)
	ElseIf(option == optionIDIgnorePainPotions)
		ignorePainPotions = true
		SetToggleOptionValue(optionIDIgnorePainPotions, true)
		mainQuest.SetIgnorePainSpell(true)
	ElseIf(option == optionIDIgnorePainSpell)
		ignorePainSpell = true
		SetToggleOptionValue(optionIDIgnorePainSpell, true)
		mainQuest.SetIgnorePainSpell(true)

	;OTHER FEATURES MENU
	ElseIf(option == optionIDTimedBlocking)
		timedBlocking = true
		SetToggleOptionValue(optionIDTimedBlocking, timedBlocking)
		mainQuest.SetTimedBlocking(true)
	ElseIf(option == optionIDTimedWarding)
		timedWarding = true
		SetToggleOptionValue(optionIDTimedWarding, timedWarding)
		mainQuest.SetTimedWarding(true)
	ElseIf(option == optionIDLocDamageMelee)
		locDamageMelee = true
		SetToggleOptionValue(optionIDLocDamageMelee, locDamageMelee)
		mainQuest.SetLocDamageMelee(true)
	ElseIf(option == optionIDLocDamageRanged)
		locDamageRanged = true
		SetToggleOptionValue(optionIDLocDamageRanged, locDamageRanged)
		mainQuest.SetLocDamageRanged(true)
	EndIf
EndEvent

Event OnOptionSelect(int option)
	;STAGGER MENU
	If(option == optionIDAllowStaggerNPCs)
		allowStaggerNPCs = !allowStaggerNPCs 
		SetToggleOptionValue(optionIDAllowStaggerNPCs, allowStaggerNPCs)
		mainQuest.SetAllowStaggerNPCs(allowStaggerNPCs)
	ElseIf(option == optionIDAllowStaggerPlayer)
		allowStaggerPlayer = !allowStaggerPlayer 
		SetToggleOptionValue(optionIDAllowStaggerPlayer, allowStaggerPlayer)
		mainQuest.SetAllowStaggerPlayer(allowStaggerPlayer)
	ElseIf(option == optionIDStaggerSpamPreventionPlayer)
		staggerSpamPreventionPlayer = !staggerSpamPreventionPlayer 
		SetToggleOptionValue(optionIDStaggerSpamPreventionPlayer, staggerSpamPreventionPlayer)
		mainQuest.SetStaggerSpamPreventionPlayer(staggerSpamPreventionPlayer)
	ElseIf(option == optionIDStaggerSpamPreventionNPCs)
		staggerSpamPreventionNPCS = !staggerSpamPreventionNPCs 
		SetToggleOptionValue(optionIDStaggerSpamPreventionNPCs, staggerSpamPreventionNPCs)
		mainQuest.SetStaggerSpamPreventionNPCs(staggerSpamPreventionNPCs)
	ElseIf(option == optionIDIgnorePainPotions)
		ignorePainPotions = !ignorePainPotions 
		SetToggleOptionValue(optionIDIgnorePainPotions, ignorePainPotions)
		mainQuest.SetIgnorePainPotions(ignorePainPotions)
	ElseIf(option == optionIDIgnorePainSpell)
		ignorePainSpell = !ignorePainSpell 
		SetToggleOptionValue(optionIDIgnorePainSpell, ignorePainSpell)
		mainQuest.SetIgnorePainSpell(ignorePainSpell)

	;OTHER FEATURES MENU
	ElseIf(option == optionIDTimedBlocking)
		timedBlocking = !timedBlocking 
		SetToggleOptionValue(optionIDTimedBlocking, timedBlocking)
		mainQuest.SetTimedBlocking(timedBlocking)
	ElseIf(option == optionIDTimedWarding)
		timedWarding = !timedWarding 
		SetToggleOptionValue(optionIDTimedWarding, timedWarding)
		mainQuest.SetTimedWarding(timedWarding)
	ElseIf(option == optionIDLocDamageMelee)
		locDamageMelee = !locDamageMelee
		SetToggleOptionValue(optionIDLocDamageMelee, locDamageMelee)
		mainQuest.SetLocDamageMelee(locDamageMelee)
	ElseIf(option == optionIDLocDamageRanged)
		locDamageRanged = !locDamageRanged
		SetToggleOptionValue(optionIDLocDamageRanged, locDamageRanged)
		mainQuest.SetLocDamageRanged(locDamageRanged)
	EndIf
EndEvent