Scriptname DCAbTimedBlockingNPCsScript extends activemagiceffect  

bool perfectBlock
Keyword property WeapTypeBow auto
Faction property ForceFullBodyStagger auto
Spell property DCNormalAttacksStaggerPlayerSpell auto

Event OnEffectStart(Actor akTarget, Actor akCaster)
	perfectBlock=true
	RegisterForSingleUpdate(0.5)
EndEvent

Event OnUpdate()
	perfectBlock=false
EndEvent

Event OnEffectFinish(Actor akTarget, Actor akCaster)
	perfectBlock=true
EndEvent

Event OnHit(ObjectReference akAggressor, Form akSource, Projectile akProjectile, bool abPowerAttack, bool abSneakAttack, bool abBashAttack, bool abHitBlocked)
	If(!abHitBlocked || !perfectBlock || akSource.HasKeyword(WeapTypeBow))
		return
	EndIf
	Actor aggressorActor = akAggressor As Actor
	aggressorActor.DamageActorValue("Stamina", 4.0)
	(aggressorActor).SetFactionRank(ForceFullBodyStagger, 0)
	DCNormalAttacksStaggerPlayerSpell.Cast(aggressorActor, aggressorActor)
	Utility.Wait(0.5)
	Debug.SendAnimationEvent(aggressorActor, "staggerStop")
	(aggressorActor).RemoveFromFaction(ForceFullBodyStagger)
EndEvent