Scriptname DCAbPlayerMagicEffectScript extends activemagiceffect  

Actor property selfActor auto
Spell property DCAbPlayerSpell auto
Spell property DCNormalAttacksStaggerPlayerSpell auto
Spell property DCNormalAttacksStaggerPlayerSpellLight auto
Spell property DCTimedWardPreventionSpell auto
Keyword property ActorTypeGhost auto
Keyword property MagicDamageFire auto
Keyword property MagicDamageFrost auto
Keyword property MagicDamageShock auto
Keyword property MagicVampireDrain auto
Keyword property MagicWard auto
Keyword property ArmorHeavy auto
Keyword property WeapTypeBow auto
Keyword property DCPreventStaggerSpamKeyword auto
Keyword property DCIgnorePainKeyword auto
Faction property ForceFullBodyStagger auto
Idle property recoil auto
Idle property recoilLarge auto
GlobalVariable property DCPreventPlayerStaggerSpamEnabled auto
GlobalVariable property DCTimedWardingEnabled auto
DCInitQuestScript Property mainScript auto

int randomInt
int ExtraFatigueCost = 0
bool IsPerfectBlock = false

Event OnEffectStart(Actor akTarget, Actor akCaster)
	ExtraFatigueCost = 0
	IsPerfectBlock = false
	randomInt = Utility.RandomInt()
EndEvent

Auto State DefaultState
Event OnHit(ObjectReference akAggressor, Form akSource, Projectile akProjectile, bool abPowerAttack, bool abSneakAttack, bool abBashAttack, bool abHitBlocked)
If((akSource As Enchantment) || (akSource As Potion) || (akSource As Ingredient))
	return
ElseIf((selfActor == None) || akAggressor == None)
	return
ElseIf(selfActor.IsInKillMove() || (akAggressor As Actor).IsInKillMove())
	return
ElseIf(akSource As Spell)
	If(akProjectile==None)
		return
	ElseIf(!((akSource As Spell).IsHostile()))
		return
	ElseIf(selfActor.HasMagicEffectWithKeyword(MagicWard) || selfActor.HasKeyword(ActorTypeGhost) || akAggressor == selfActor || selfActor.HasMagicEffectWithKeyword(DCIgnorePainKeyword))
		return
	ElseIf((selfActor.HasMagicEffectWithKeyword(DCPreventStaggerSpamKeyword) && DCPreventPlayerStaggerSpamEnabled.GetValue() == 1) || !mainScript.GetAllowStaggerPlayer())
		return
	Else		;<<<<<<<<<<<<<<<<<MAGIC>>>>>>>>>>>>>>>>>>
		GoToState("BusyState")
		int chance
		If(!selfActor.WornHasKeyword(ArmorHeavy))
			chance=40
		EndIf
		If(randomInt<chance)
			selfActor.SetFactionRank(ForceFullBodyStagger,0)
			DCNormalAttacksStaggerPlayerSpell.Cast(selfActor, selfActor)
			selfActor.RemoveFromFaction(ForceFullBodyStagger)
			Utility.Wait(0.5)
			if(selfActor.isWeaponDrawn())
				Debug.SendAnimationEvent(selfActor, "staggerStop")
			endIf
		Else
			selfActor.RemoveFromFaction(ForceFullBodyStagger)
			DCNormalAttacksStaggerPlayerSpell.Cast(selfActor, selfActor)
			DCNormalAttacksStaggerPlayerSpellLight.Cast(selfActor,selfActor)
		EndIf
		Utility.Wait(0.6)
		DCNormalAttacksStaggerPlayerSpellLight.Cast(selfActor,selfActor)
		randomInt = Utility.RandomInt()
		GoToState("DefaultState")
		return
	EndIf
ElseIf(abHitBlocked)
	return
ElseIf(akSource == None)
	return
ElseIf(selfActor.HasMagicEffectWithKeyword(MagicWard) || selfActor.HasKeyword(ActorTypeGhost) || akAggressor == selfActor || selfActor.HasMagicEffectWithKeyword(DCIgnorePainKeyword))
	return
ElseIf((akSource As Explosion))
	return
ElseIf(selfActor.HasMagicEffectWithKeyword(DCPreventStaggerSpamKeyword) && DCPreventPlayerStaggerSpamEnabled.GetValue() == 1)
	selfActor.DamageActorValue("Stamina", 4.0)
	return
ElseIf(akSource.HasKeyword(WeapTypeBow))	;<<<<<<<<<<<<<<<<<BOW>>>>>>>>>>>>>>>>>>
		GoToState("BusyState")
		selfActor.DamageActorValue("Stamina", 4.0)

		If(!mainScript.GetAllowStaggerPlayer())
			GoToState("DefaultState")
			return
		EndIf

		int chance
		If(!selfActor.WornHasKeyword(ArmorHeavy))
			chance=50
		Else
			chance=25
		EndIf
		If(randomInt<chance)
			selfActor.SetFactionRank(ForceFullBodyStagger,0)
			DCNormalAttacksStaggerPlayerSpell.Cast(selfActor, selfActor)
			Utility.Wait(0.5)
			if(selfActor.isWeaponDrawn())
				Debug.SendAnimationEvent(selfActor, "staggerStop")
			endIf
			selfActor.RemoveFromFaction(ForceFullBodyStagger)
		Else
			selfActor.RemoveFromFaction(ForceFullBodyStagger)
			DCNormalAttacksStaggerPlayerSpell.Cast(selfActor, selfActor)
			DCNormalAttacksStaggerPlayerSpellLight.Cast(selfActor,selfActor)
		EndIf
	randomInt = Utility.RandomInt()
	GoToState("DefaultState")
	return
ElseIf(!abBashAttack && (akSource As Weapon))	;<<<<<<<<<<<<<<<<<MELEE>>>>>>>>>>>>>>>>>>
	GoToState("BusyState")
	selfActor.DamageActorValue("Stamina", 4.0)

		If(!mainScript.GetAllowStaggerPlayer())
			GoToState("DefaultState")
			return
		EndIf

	selfActor.SetFactionRank(ForceFullBodyStagger,0)
	DCNormalAttacksStaggerPlayerSpell.Cast(selfActor, selfActor)
	Utility.Wait(0.4)
	if(selfActor.isWeaponDrawn())
		Debug.SendAnimationEvent(selfActor, "staggerStop")
	endIf
	selfActor.RemoveFromFaction(ForceFullBodyStagger)
	GoToState("DefaultState")
	return
EndIf
GoToState("DefaultState")
EndEvent
EndState

State BusyState
Event OnHit(ObjectReference akAggressor, Form akSource, Projectile akProjectile, bool abPowerAttack, bool abSneakAttack, bool abBashAttack, bool abHitBlocked)
EndEvent
EndState

Event OnWardHit(ObjectReference akCaster, Spell akSpell, int aiStatus)
	If(selfActor.HasSpell(DCTimedWardPreventionSpell) || aiStatus == 0 || DCTimedWardingEnabled.GetValue() == 0)
		return
	EndIf
	akSpell.Cast(selfActor, akCaster)
EndEvent