Scriptname DCAbEnemyMagicEffect extends activemagiceffect  

int[] randomInts
Spell property DCAttackStagger auto
Spell property DCNormalAttacksStaggerPlayerSpellLight auto
Spell Property DCAbNPCSpell auto
Spell Property DCCleanupSpell auto
MagicEffect Property DCCleanupMagicEffect auto
Keyword property ActorTypeGhost auto
Keyword property MagicWard auto
Keyword property ArmorHeavy auto
Keyword property ArmorLight auto
Keyword property WeapTypeBow auto
Keyword property DCPreventStaggerSpamKeyword auto
GlobalVariable property DCPreventEnemyStaggerSpamEnabled auto
GlobalVariable property DCTimedWardingEnabled auto
Faction Property ForceFullBodyStagger auto
Spell property DCAttackStaminaCostPlayerSpell auto
Spell property DCNormalAttacksStaggerPlayerSpell auto
Spell property DCTimedWardPreventionSpell auto
DCInitQuestScript Property mainScript auto

float staggerTime = 0.5
bool sneakRolled = false
int blockingStage = 0
Actor selfActor

Event OnEffectStart(Actor akTarget, Actor akCaster)
	selfActor=akTarget
	If(!selfActor.HasMagicEffect(DCCleanupMagicEffect))
		DCCleanupSpell.Cast(selfActor, selfActor)
	EndIf
	randomInts = new int[3]
	randomInts[0] = Utility.RandomInt()
	randomInts[1] = Utility.RandomInt()
	randomInts[2] = Utility.RandomInt()
EndEvent

Auto State DefaultState
Event OnHit(ObjectReference akAggressor, Form akSource, Projectile akProjectile, bool abPowerAttack, bool abSneakAttack, bool abBashAttack, bool abHitBlocked)
If((akSource As Shout) || (akSource As Enchantment) || (akSource As Potion) || (akSource As Ingredient))
	return
ElseIf((selfActor == None) || akAggressor == None)
	return
ElseIf(!(akAggressor As Actor))
	return
ElseIf(selfActor.IsInKillMove() || (akAggressor As Actor).IsInKillMove())
	return
ElseIf(selfActor.IsDead())
	return
ElseIf(akSource As Spell)
	If(akProjectile==None)
		return
	ElseIf(!((akSource As Spell).IsHostile()))
		return
	ElseIf(selfActor.HasMagicEffectWithKeyword(MagicWard) || selfActor.HasKeyword(ActorTypeGhost) || akAggressor == selfActor)
		return
	ElseIf(selfActor.HasMagicEffectWithKeyword(DCPreventStaggerSpamKeyword) && DCPreventEnemyStaggerSpamEnabled.GetValue() == 1)
		return
	ElseIf(!mainScript.GetAllowStaggerNPCs())
		return
	Else
		staggerTime=0.5 - 0.5*(selfActor.GetActorValuePercentage("health"))
		DCMagicHitFunction((akAggressor As Actor))
		return
	EndIf
ElseIf(abHitBlocked)
	staggerTime=0.7 - 0.7*(selfActor.GetActorValuePercentage("health"))
	DCBlockedHitFunction((akAggressor As Actor), akSource)
	return
ElseIf(akSource == None)
	return
ElseIf((akSource As Explosion))
	return
ElseIf(selfActor.HasMagicEffectWithKeyword(MagicWard) || selfActor.HasKeyword(ActorTypeGhost) || akAggressor == selfActor)
	return
ElseIf((selfActor.HasMagicEffectWithKeyword(DCPreventStaggerSpamKeyword) && DCPreventEnemyStaggerSpamEnabled.GetValue() == 1) || !mainScript.GetAllowStaggerNPCs())
	DCNoStaggeringHitFunction((akAggressor As Actor))
	return
ElseIf(akSource.HasKeyword(WeapTypeBow))
	staggerTime=0.6 - 0.6*(selfActor.GetActorValuePercentage("health"))
	DCBowHitFunction((akAggressor As Actor))
	return
ElseIf(!abBashAttack && (akSource As Weapon))
	staggerTime=0.6 - 0.6*(selfActor.GetActorValuePercentage("health"))
	DCMeleeHitFunction((akAggressor As Actor))
	return
EndIf
EndEvent
EndState

State BusyState
Event OnHit(ObjectReference akAggressor, Form akSource, Projectile akProjectile, bool abPowerAttack, bool abSneakAttack, bool abBashAttack, bool abHitBlocked)
EndEvent
EndState

Function DCMagicHitFunction(Actor aggressorActor)
	GoToState("BusyState")
	int chance
	If(selfActor.GetDistance(aggressorActor) <=150)
		chance=100
	ElseIf(!selfActor.WornHasKeyword(ArmorHeavy))
		chance=40
	EndIf
	If(randomInts[0]<chance)
		DCAttackStagger.Cast(selfActor, selfActor)
		DCMagicReactionFunction(aggressorActor)
	EndIf
	randomInts[0] = Utility.RandomInt()
	randomInts[1] = Utility.RandomInt()
	randomInts[2] = Utility.RandomInt()
	GoToState("DefaultState")
EndFunction

Function DCBlockedHitFunction(Actor aggressorActor, Form akSource)
	GoToState("BusyState")
	DCAttackStaminaCostPlayerSpell.Cast(aggressorActor, aggressorActor)
	If((selfActor.GetActorValue("Stamina")) < 2)
		DCAttackStagger.Cast(selfActor, selfActor)
		Utility.Wait(staggerTime)
		Debug.SendAnimationEvent(selfActor, "staggerStop")
	EndIf
	If(blockingStage==1)
		aggressorActor.DamageActorValue("Stamina", 4.0)
		(aggressorActor).SetFactionRank(ForceFullBodyStagger, 0)
		DCNormalAttacksStaggerPlayerSpell.Cast(aggressorActor, aggressorActor)
		Utility.Wait(0.6)
		Debug.SendAnimationEvent(aggressorActor, "staggerStop")
		(aggressorActor).RemoveFromFaction(ForceFullBodyStagger)
		blockingStage=0
	EndIf
	randomInts[0] = Utility.RandomInt()
	randomInts[1] = Utility.RandomInt()
	randomInts[2] = Utility.RandomInt()
	GoToState("DefaultState")
EndFunction

Function DCBowHitFunction(Actor aggressorActor)
	GoToState("BusyState")
	int chance
	If(selfActor.GetDistance(aggressorActor) <=200)
		chance=100
	ElseIf(!selfActor.WornHasKeyword(ArmorHeavy))
		chance=90
	Else
		chance=75
	EndIf
	If(randomInts[0]<chance)
		DCAttackStagger.Cast(selfActor, selfActor)
		DCBowReactionFunction(aggressorActor)
	EndIf
	DCAttackStaminaCostPlayerSpell.Cast(aggressorActor, aggressorActor)
	DCAttackStaminaCostPlayerSpell.Cast(selfActor, selfActor)
	randomInts[0] = Utility.RandomInt()
	randomInts[1] = Utility.RandomInt()
	randomInts[2] = Utility.RandomInt()
	GoToState("DefaultState")
EndFunction

Function DCMeleeHitFunction(Actor aggressorActor)
	GoToState("BusyState")
	DCAttackStagger.Cast(selfActor, selfActor)
	DCAttackStaminaCostPlayerSpell.Cast(aggressorActor, aggressorActor)
	DCAttackStaminaCostPlayerSpell.Cast(selfActor, selfActor)
	DCMeleeReactionFunction(aggressorActor)
	randomInts[0] = Utility.RandomInt()
	randomInts[1] = Utility.RandomInt()
	randomInts[2] = Utility.RandomInt()
	GoToState("DefaultState")
EndFunction

Function DCNoStaggeringHitFunction(Actor aggressorActor)
	GoToState("BusyState")
	DCAttackStaminaCostPlayerSpell.Cast(aggressorActor, aggressorActor)
	DCAttackStaminaCostPlayerSpell.Cast(selfActor, selfActor)
	randomInts[0] = Utility.RandomInt()
	randomInts[1] = Utility.RandomInt()
	randomInts[2] = Utility.RandomInt()
	GoToState("DefaultState")
EndFunction

;<<<<<<<<<<<<<<<<<<<<<<<<<<<<BOW REACTION>>>>>>>>>>>>>>>>>>>>>>>>>>
Function DCBowReactionFunction(Actor akAggressor)
	int ArmorType=0
	If(selfActor.WornHasKeyword(ArmorHeavy))
		ArmorType=2
	ElseIf(selfActor.WornHasKeyword(ArmorLight))
		ArmorType=1
	EndIf
	If(selfActor.GetCombatTarget() == None)
		return
	EndIf
	float Distance = selfActor.GetDistance(selfActor.GetCombatTarget())
	int LevelDifference = ((selfActor.GetLevel()) - ((akAggressor).GetLevel()))
	int reactChance = (60+(LevelDifference*10))
	If(reactChance < 20)
		reactChance=20
	ElseIf(reactChance > 80)
		reactChance=80
	EndIf

Utility.Wait(staggerTime)
Debug.SendAnimationEvent(selfActor, "staggerStop")
Utility.wait(0.1)

IF(randomInts[1] <= reactChance)		;react in some way
	If(selfActor.GetEquippedItemType(0) == 10 && Distance >= 250)
		Utility.Wait(0.3)
		Debug.SendAnimationEvent(selfActor, "blockStart")
		Utility.Wait(0.05)
		Debug.SendAnimationEvent(selfActor, "blockStart")
		Utility.Wait(0.05)
		Debug.SendAnimationEvent(selfActor, "blockStart")
		Utility.Wait(0.05)
		Debug.SendAnimationEvent(selfActor, "blockStart")
		Utility.Wait(0.05)
		Debug.SendAnimationEvent(selfActor, "blockStart")
		Utility.Wait(0.05)
		Debug.SendAnimationEvent(selfActor, "blockStart")
		Utility.Wait(0.05)
		Debug.SendAnimationEvent(selfActor, "blockStart")
		Utility.Wait(0.05)
		Debug.SendAnimationEvent(selfActor, "blockStart")
		Utility.Wait(0.05)
		Debug.SendAnimationEvent(selfActor, "blockStart")
		Utility.Wait(0.05)
		Debug.SendAnimationEvent(selfActor, "blockStart")
		Utility.Wait(0.05)
		Debug.SendAnimationEvent(selfActor, "blockStart")
		Utility.Wait(0.05)
		Debug.SendAnimationEvent(selfActor, "blockStart")
		Utility.Wait(0.05)
		Debug.SendAnimationEvent(selfActor, "blockStart")
		Utility.Wait(0.05)
		Debug.SendAnimationEvent(selfActor, "blockStart")
		Utility.Wait(0.05)
		Debug.SendAnimationEvent(selfActor, "blockStart")
		Utility.Wait(0.05)
		Debug.SendAnimationEvent(selfActor, "blockStart")
		Utility.Wait(0.05)
		Debug.SendAnimationEvent(selfActor, "blockStart")
		Utility.Wait(0.05)
		Debug.SendAnimationEvent(selfActor, "blockStart")
		Utility.Wait(0.05)
		Debug.SendAnimationEvent(selfActor, "blockStart")
		Utility.Wait(0.05)
		Debug.SendAnimationEvent(selfActor, "blockStart")
		Utility.Wait(0.05)
		Debug.SendAnimationEvent(selfActor, "blockStop")
		return
	ElseIf(selfActor.GetEquippedItemType(0) == 10 && Distance <= 100)	;shield at close range, so bash
		Debug.SendAnimationEvent(selfActor, "bashStart")
		return
	ElseIf(ArmorType==1)		;Light armor, so can perform agile moves
		If(selfActor.GetEquippedItemType(1) < 7)		;Using melee weapons, so advance
			If(selfActor.GetDistance(akAggressor) >=300)	;Not too close
				If(selfActor.GetDistance(akAggressor) <=800)	;Not too far away to roll
					Debug.SendAnimationEvent(selfActor, "SneakStart")
					Debug.SendAnimationEvent(selfActor, "SneakSprintStartRoll")
					RegisterForSingleUpdate(1.0)
					sneakRolled=true
					Utility.wait(0.3)
					Debug.SendAnimationEvent(selfActor, "SneakStop")
					return
				Else		;Too far away to roll, so sprint
					Debug.SendAnimationEvent(selfActor, "SprintStart")
					Utility.wait(0.5)
					Debug.SendAnimationEvent(selfActor, "sprintStop")
					return
				EndIf
			Else		;Too close to roll, so dodge instead
				If(randomInts[2] <=50)
					Debug.SendAnimationEvent(selfActor, "DodgeLeft")
					return
				Else
					Debug.SendAnimationEvent(selfActor, "DodgeRight")
					return
				EndIf
			EndIf
		Else		;Using ranged, so just dodge sideways
			If(randomInts[2] <=50)
				Debug.SendAnimationEvent(selfActor, "DodgeLeft")
				return
			Else
				Debug.SendAnimationEvent(selfActor, "DodgeRight")
				return
			EndIf
		EndIf
	EndIf
ENDIF
EndFunction

;<<<<<<<<<<<<<<<<<<<<<<<<<<<<MAGIC REACTION>>>>>>>>>>>>>>>>>>>>>>>>>>
Function DCMagicReactionFunction(Actor akAggressor)
	int ArmorType=0
	If(selfActor.WornHasKeyword(ArmorHeavy))
		ArmorType=2
	ElseIf(selfActor.WornHasKeyword(ArmorLight))
		ArmorType=1
	EndIf
	If(selfActor.GetCombatTarget() == None)
		return
	EndIf
	float Distance = selfActor.GetDistance(selfActor.GetCombatTarget())
	int LevelDifference = ((selfActor.GetLevel()) - ((akAggressor).GetLevel()))
	int reactChance = (60+(LevelDifference*10))
	If(reactChance < 20)
		reactChance=20
	ElseIf(reactChance > 80)
		reactChance=80
	EndIf

	Utility.Wait(staggerTime)
	Debug.SendAnimationEvent(selfActor, "staggerStop")
	Utility.wait(0.1)

IF(randomInts[1] <= reactChance)		;react in some way
	If(ArmorType==1)		;Light armor, so can perform agile moves
		If(selfActor.GetEquippedItemType(1) < 7)		;Using melee weapons, so advance
			If(selfActor.GetDistance(akAggressor) >=300)	;Not too close
				If(selfActor.GetDistance(akAggressor) <=800)	;Not too far away to roll
					Debug.SendAnimationEvent(selfActor, "SneakStart")
					Debug.SendAnimationEvent(selfActor, "SneakSprintStartRoll")
					RegisterForSingleUpdate(1.0)
					sneakRolled=true
					Utility.wait(0.3)
					Debug.SendAnimationEvent(selfActor, "SneakStop")
				Else		;Too far away to roll, so sprint
					Debug.SendAnimationEvent(selfActor, "SprintStart")
					Utility.wait(0.5)
					Debug.SendAnimationEvent(selfActor, "sprintStop")
				EndIf
			Else		;Too close to roll, so dodge instead
				If(randomInts[2] <=50)
					Debug.SendAnimationEvent(selfActor, "DodgeLeft")
				Else
					Debug.SendAnimationEvent(selfActor, "DodgeRight")
				EndIf
			EndIf
		Else		;Using ranged, so just dodge sideways
			If(randomInts[2] <=50)
				Debug.SendAnimationEvent(selfActor, "DodgeLeft")
			Else
				Debug.SendAnimationEvent(selfActor, "DodgeRight")
			EndIf
		EndIf
		DCNormalAttacksStaggerPlayerSpellLight.Cast(selfActor, selfActor)
		return
	Else		;Wearing heavy armor or no armor, so don't react
		Utility.wait(0.5)
		DCNormalAttacksStaggerPlayerSpellLight.Cast(selfActor, selfActor)
		return
	EndIf
ELSE
	Utility.wait(0.5)
	DCNormalAttacksStaggerPlayerSpellLight.Cast(selfActor, selfActor)
ENDIF
EndFunction

;<<<<<<<<<<<<<<<<<<<<<<<<<<<<MELEE REACTION>>>>>>>>>>>>>>>>>>>>>>>>>>
Function DCMeleeReactionFunction(Actor akAggressor)
	int ArmorType=0
	If(selfActor.WornHasKeyword(ArmorHeavy))
		ArmorType=2
	ElseIf(selfActor.WornHasKeyword(ArmorLight))
		ArmorType=1
	EndIf
	int LevelDifference = ((selfActor.GetLevel()) - ((akAggressor).GetLevel()))
	int reactChance = (60+(LevelDifference*10))
	If(reactChance < 20)
		reactChance=20
	ElseIf(reactChance > 80)
		reactChance=80
	EndIf

Utility.Wait(staggerTime)
Debug.SendAnimationEvent(selfActor, "staggerStop")
Utility.wait(0.1)

IF(randomInts[1] <= reactChance)		;react in some way
	If(ArmorType==1)		;Light armor, so can perform agile moves
		If(selfActor.GetEquippedItemType(1) < 7)		;Using melee weapons, so can dodge sideways
			If(randomInts[2] <=25)
				Debug.SendAnimationEvent(selfActor, "DodgeLeft")
			ElseIf(randomInts[2] <= 50)
				Debug.SendAnimationEvent(selfActor, "DodgeRight")
			Else
				Debug.SendAnimationEvent(selfActor, "DodgeBack")
			EndIf
		Else		;Using ranged, so just dodge backwards
			Debug.SendAnimationEvent(selfActor, "DodgeBack")
		EndIf
	EndIf
		Utility.Wait(0.3)
		blockingStage=1
If(blockingStage==1)		
	Debug.SendAnimationEvent(selfActor, "blockStart")	
EndIf
		Utility.Wait(0.05)
If(blockingStage==1)		
	Debug.SendAnimationEvent(selfActor, "blockStart")	
EndIf
		Utility.Wait(0.05)
If(blockingStage==1)		
	Debug.SendAnimationEvent(selfActor, "blockStart")	
EndIf
		Utility.Wait(0.05)
If(blockingStage==1)		
	Debug.SendAnimationEvent(selfActor, "blockStart")	
EndIf
		Utility.Wait(0.05)
If(blockingStage==1)		
	Debug.SendAnimationEvent(selfActor, "blockStart")	
EndIf
		Utility.Wait(0.05)
If(blockingStage==1)		
	Debug.SendAnimationEvent(selfActor, "blockStart")	
EndIf
		Utility.Wait(0.05)
If(blockingStage==1)		
	Debug.SendAnimationEvent(selfActor, "blockStart")	
EndIf
		Utility.Wait(0.05)
If(blockingStage==1)		
	Debug.SendAnimationEvent(selfActor, "blockStart")	
EndIf
		Utility.Wait(0.05)
If(blockingStage==1)		
	Debug.SendAnimationEvent(selfActor, "blockStart")	
EndIf
		Utility.Wait(0.05)
If(blockingStage==1)		
	Debug.SendAnimationEvent(selfActor, "blockStart")	
	blockingStage=0
EndIf
		Utility.Wait(0.05)
If(blockingStage>0)		
	Debug.SendAnimationEvent(selfActor, "blockStart")	
EndIf
		Utility.Wait(0.05)
If(blockingStage>0)		
	Debug.SendAnimationEvent(selfActor, "blockStart")	
EndIf
		Utility.Wait(0.05)
If(blockingStage>0)		
	Debug.SendAnimationEvent(selfActor, "blockStart")	
EndIf
		Utility.Wait(0.05)
If(blockingStage>0)		
	Debug.SendAnimationEvent(selfActor, "blockStart")	
EndIf
		Utility.Wait(0.05)
If(blockingStage>0)		
	Debug.SendAnimationEvent(selfActor, "blockStart")	
EndIf
		Utility.Wait(0.05)
If(blockingStage>0)		
	Debug.SendAnimationEvent(selfActor, "blockStart")	
EndIf
		Utility.Wait(0.05)
If(blockingStage>0)		
	Debug.SendAnimationEvent(selfActor, "blockStart")	
EndIf
		Utility.Wait(0.05)
If(blockingStage>0)		
	Debug.SendAnimationEvent(selfActor, "blockStart")	
EndIf
		Utility.Wait(0.05)
If(blockingStage>0)		
	Debug.SendAnimationEvent(selfActor, "blockStart")	
EndIf
		Utility.Wait(0.05)
If(blockingStage>0)		
	Debug.SendAnimationEvent(selfActor, "blockStart")	
EndIf
	blockingStage=0
	Debug.SendAnimationEvent(selfActor, "blockStop")	
ENDIF
EndFunction

Event OnUpdate()
If(sneakRolled)
	Debug.SendAnimationEvent(GetTargetActor(), "SneakStop")
	sneakRolled=false
EndIf
EndEvent

Event OnWardHit(ObjectReference akCaster, Spell akSpell, int aiStatus)
	If(selfActor.HasSpell(DCTimedWardPreventionSpell) || aiStatus == 0 || DCTimedWardingEnabled.GetValue() == 0)
		return
	EndIf
	akSpell.Cast(selfActor, akCaster)
EndEvent

Event OnUnload()
	If(selfActor.IsDead())
		return
	EndIf
	GoToState("BusyState")
	selfActor.DispelSpell(DCAbNPCSpell)
EndEvent

Event OnDying(Actor akKiller)
	GoToState("BusyState")
	selfActor.DispelSpell(DCAbNPCSpell)
EndEvent

Event OnEffectFinish(Actor akTarget, Actor akCaster)
	GoToState("BusyState")
	selfActor.DispelSpell(DCAbNPCSpell)
EndEvent