Scriptname DCAbEnemyMagEffLocDamScript extends activemagiceffect  

int[] randomInts
int hitLoc = 0
; 1 = head
; 3 = right arm/shoulder/hand
; 4 = left arm/shoulder/hand
; 5 = chest
; 6 = back
; 7 = groin
; 8 = leg/foot

Actor selfActor
bool ragdolling = false
float genZone
float headZone
float throatZone
float shoulderZone
float heartZone
float chestZone
float armZone
float groinZone
float legZone

Actor Property playerRef auto
GlobalVariable Property DCLocationalDamageEnabled auto
GlobalVariable Property DCLocationalDamageEnabledArchery auto
GlobalVariable Property DCPlayerShotArrowAngle auto
GlobalVariable Property DCPlayerShotArrowPower auto
Keyword Property ActorTypeNPC auto
Spell Property staggerSpell auto
Spell Property disarmSpell auto
Spell Property hurtBlockingArmSpell auto

Auto State DefaultState
;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<ONHIT EVENT>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
Event OnHit(ObjectReference akAggressor, Form akSource, Projectile akProjectile, bool abPowerAttack, bool abSneakAttack, bool abBashAttack, bool abHitBlocked)
If(selfActor == None)
	return
EndIf

Actor attacker

If(akAggressor As Actor)
	attacker = akAggressor As Actor
Else
	return
EndIf

If(attacker.IsInKillMove() || selfActor.IsInKillMove())
	return
ElseIf(!attacker.hasKeyword(ActorTypeNPC))
	return
ElseIf((akSource As Spell) || (akSource As Enchantment) || (akSource As Potion) || (akSource As Ingredient) || (akSource As Explosion) || (akSource As Shout))
	return
ElseIf(selfActor.IsBleedingOut() || ragdolling)
	return
ElseIf(abBashAttack || abHitBlocked)
	return
ElseIf(selfActor.IsDead())
	return
EndIf

int attackerRightHandWeaponType = attacker.GetEquippedItemType(1)

If(attackerRightHandWeaponType == 0)
	return
EndIf

GoToState("BusyState")
float xA = playerRef.getAngleX()
float xA2 = attacker.GetAngleX()
float headingAngle = attacker.GetHeadingAngle(selfActor)
float facing = selfActor.GetHeadingAngle(attacker)
float dist = attacker.GetDistance(selfActor)
float heightDist = attacker.GetPositionZ() - selfActor.GetPositionZ()

float scale = 1 + (selfActor.GetScale() - attacker.GetScale())
genZone = 3.5*scale
throatZone = 120 - (107.5*scale)
shoulderZone = 120 - (95*scale)
heartZone = 120 - (92.75*scale)
chestZone = 120 - (63*scale)
armZone = 11.5*scale
groinZone = 120 - (50*scale)
legZone = 120 - (30*scale)

float sinHeading = Math.sin(headingAngle)
float dispHeading = dist*sinHeading

If(attackerRightHandWeaponType != 7 && attackerRightHandWeaponType != 12)	;not a bow/crossbow
	If(DCLocationalDamageEnabled.GetValue() == 0)
		GoToState("DefaultState")
		return
	endIf
	float dispVertical = (dist*Math.tan(xA)) - heightDist + ((attacker.IsSneaking() As int)*32)
	if(dispVertical < throatZone)
		hitLoc = 1
	elseif(dispVertical < shoulderZone)
		armhitCalc(3, 4, 5, genzone, facing, dispHeading)
	elseif(dispVertical < heartZone)
		if(facing > -45 && facing < 45)
			if(dispHeading < -genzone)
				if(dispHeading > -(9*scale))
					hitLoc=5
				endIf
			endIf
		endIf
		if(hitLoc == 0)
			armhitCalc(3, 4, 5, genzone, facing, dispHeading)
		endIf
	elseif(dispVertical < chestZone)
		armhitCalc(3, 4, 5, genzone, facing, dispHeading)
	elseif(dispVertical < groinZone)
		if(facing > -45 && facing < 45)
			hitLoc=7
		else
			hitLoc=8
		endIf
	else
		hitLoc=8
	endIf

	If((0.2*attacker.GetLevel() + 10 + attacker.GetActorValue("CritChance") + 10*attacker.GetActorValuePercentage("Stamina") + 2/(0.1+selfActor.GetActorValuePercentage("Stamina")))>(randomInts[0]))
		hitEffects(attacker, abPowerAttack)
	EndIf
	randomInts[0] = Utility.RandomInt()
	randomInts[1] = Utility.RandomInt()
	GoToState("DefaultState")
	return
Else										;a bow/crossbow
	If(DCLocationalDamageEnabledArchery.GetValue() == 0)
		GoToState("DefaultState")
		return
	endIf
	If(attacker == playerRef)
		xA2 = DCPlayerShotArrowAngle.GetValue()
		float shotPower = DCPlayerShotArrowPower.GetValue()
		dist += (dist*Game.GetGameSettingFloat("fArrowGravityMult"))/shotPower
	Else
		dist += (dist*Game.GetGameSettingFloat("fArrowGravityMult"))
	EndIf

	float dispVertical = (dist*Math.tan(xA2)) - heightDist + ((attacker.IsSneaking() As int)*32)
	
	if(dispVertical < throatZone)
		hitLoc=1
	elseif(dispVertical < shoulderZone)
		armhitCalc(3, 4, 5, genzone, facing, dispHeading)
	elseif(dispVertical < heartZone)
		if(facing > -45 && facing < 45)
			if(dispHeading < -genzone)
				if(dispHeading > -(9*scale))
					hitLoc=5
				endIf
			endIf
		endIf
		if(hitLoc == 0)
			armhitCalc(3, 4, 5, genzone, facing, dispHeading)
		endIf
	elseif(dispVertical < chestZone)
		armhitCalc(3, 4, 5, genzone, facing, dispHeading)
	elseif(dispVertical < groinZone)
		if(facing > -45 && facing < 45)
			hitLoc=7
		else
			hitLoc=8
		endIf
	else
		hitLoc=8
	endIf
	
	If((0.2*attacker.GetLevel() + 10 + attacker.GetActorValue("CritChance") + 10*attacker.GetActorValuePercentage("Stamina") + 2/(0.1+selfActor.GetActorValuePercentage("Stamina")))>(randomInts[0]))
		hitEffects(attacker, abPowerAttack)
	EndIf
	randomInts[0] = Utility.RandomInt()
	randomInts[1] = Utility.RandomInt()
	GoToState("DefaultState")
	return
EndIf

EndEvent
;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<ONHIT EVENT>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
EndState

State BusyState
Event OnHit(ObjectReference akAggressor, Form akSource, Projectile akProjectile, bool abPowerAttack, bool abSneakAttack, bool abBashAttack, bool abHitBlocked)
EndEvent
EndState

Function hitEffects(Actor attacker, bool abPowerAttack)
if(hitLoc == 1)
	staggerSpell.cast(selfActor, selfActor)
elseif(hitloc == 3)
	If(randomInts[1] < 25)
		disarmSpell.cast(selfActor, selfActor)
	EndIf
elseif(hitloc == 4)
	hurtBlockingArmSpell.cast(selfActor, selfActor)
elseif(hitloc == 5)
	Debug.SendAnimationEvent(selfActor, "staggerStop")
	Debug.SendAnimationEvent(selfActor, "bleedOutStart")
	Utility.Wait(0.6)
	Debug.SendAnimationEvent(selfActor, "bleedOutStop")
elseif(hitLoc == 6)
	If(randomInts[1] < 50)
		attacker.pushActorAway(selfActor, 1.5)
	EndIf
elseif(hitloc == 7)
	Debug.SendAnimationEvent(selfActor, "staggerStop")
	Debug.SendAnimationEvent(selfActor, "bleedOutStart")
	Utility.Wait(1.4)
	Debug.SendAnimationEvent(selfActor, "bleedOutStop")
elseif(hitloc == 8)
	If(selfActor.isSprinting() || selfActor.GetAnimationVariableBool("IsRecoiling") || abPowerAttack)
		attacker.pushActorAway(selfActor, 1.5) 
	EndIf
endif
selfActor.damageActorValue("stamina", 1.0)
EndFunction

Function armHitCalc(int RZ, int LZ, int MZ, float funcZone, float facing, float dispHeading)
if(facing < 45 && facing > -45)
	if(dispHeading > armZone)
		hitloc = RZ
	elseif(dispHeading < -armZone)
		hitloc = LZ
	else
		hitloc = MZ
	endif
elseif(facing < -45 && facing > -135)
	hitloc = LZ
elseif(facing > 45 && facing < 135)
	hitloc = RZ
elseif(facing <= -135 || facing >= 135)
	if(dispHeading > armZone)
		hitloc = LZ
	elseif(dispHeading < -armZone)
		hitloc = RZ
	else
		hitloc = 6
	endif
endif
EndFunction

Event OnEffectStart(Actor akTarget, Actor akCaster)
	selfActor = akTarget
	
	If(selfActor == None)
		return
	EndIf
	If(selfActor.IsDead() || selfActor.IsDisabled())
		return
	EndIf

	RegisterForAnimationEvent(selfActor, "RemoveCharacterControllerFromWorld")
	randomInts = new int[2]
	randomInts[0] = Utility.RandomInt()
	randomInts[1] = Utility.RandomInt()
EndEvent

Event OnAnimationEvent(ObjectReference akSource, string asEventName)
	If(selfActor.IsDead())
		return
	EndIf
	If(akSource == selfActor)
		If(asEventName == "RemoveCharacterControllerFromWorld")
			ragdolling=true
			RegisterForAnimationEvent(selfActor, "GetUpEnd")
		ElseIf(asEventName == "GetUpEnd")
			ragdolling = false
			Utility.wait(0.1)
			UnregisterForAnimationEvent(selfActor, "GetUpEnd")
		EndIf
	EndIf
endEvent