#
#  Project Name: MQQSecure
#  File Name:    prebuildscript.sh
#
#  Created by jourkliu on 2012-09-06.
#  Copyright 2012 Tencent. All rights reserved.
#

#exit 0

#载入配置文件
source "$SRCROOT/../configuration.sh"
date=$(date +%Y-%m-%d)

#显示当前配置信息
echo "JB_IPHONE_BUILD_NUMBER = $BUILD_NUM"
echo "JB_IPHONE_BUILD_DATE = $date"
echo "JB_IPHONE_CHANNEL_ID = $CHANNEL_ID_FOR_JB"
echo "JB_IPHONE_VERSION VERSION = $VERSION_FOR_DEB_IPHONE"
echo "JB_IPHONE_VERSION_INNER VERSION = $VERSION_FOR_DEB_IPHONE"
echo "JB_IPHONE_VERSION_PUBLIC VERSION = $VERSION_FOR_PUBLIC_IPHONE"
echo "JB_IPHONE_LC_STRING = $LC_FOR_DEB_IPHONE"
echo "JB_IPHONE_IPA_VERSION VERSION = $VERSION_FOR_IPA_IPHONE"
echo "JB_IPHONE_IPA_LC_STRING = $LC_FOR_IPA_IPHONE"
echo "JB_IPHONE_ENABLE_SOFTWAREMANAGER = $ENABLE_SOFTWAREMANAGER"

#更新ChannelInfo.plist文件ChannelId字段
defaults write "$SRCROOT/ChannelInfo" ChannelId $CHANNEL_ID_FOR_JB
plutil -convert xml1 "$SRCROOT/ChannelInfo.plist"
cp -rf "$SRCROOT/ChannelInfo.plist" "$SRCROOT/../MQQSecureInstaller/ChannelInfo.plist"

#更新MQQSecure-SB-InfoJB.plist文件CFBundleVersion和CFBundleShortVersionString字段
defaults write "$SRCROOT/QQSecure/MQQSecure-SB-InfoJB" CFBundleVersion $VERSION_FOR_DEB_IPHONE
defaults write "$SRCROOT/QQSecure/MQQSecure-SB-InfoJB" CFBundleShortVersionString $VERSION_FOR_DEB_IPHONE
defaults write "$SRCROOT/QQSecure/MQQSecure-SB-InfoJB" CFBundleBuild $BUILD_NUM
plutil -convert xml1 "$SRCROOT/QQSecure/MQQSecure-SB-InfoJB.plist"

#更新MQQSecret-Info.plist文件CFBundleVersion字段
defaults write "$SRCROOT/../MQQSecret/MQQSecret/MQQSecret-Info" CFBundleVersion $VERSION_FOR_DEB_IPHONE
plutil -convert xml1 "$SRCROOT/../MQQSecret/MQQSecret/MQQSecret-Info.plist"

#更新QSSoftwareManager-Info.plist文件CFBundleVersion字段
defaults write "$SRCROOT/../QSSoftwareManager/QSSoftwareManager/QSSoftwareManager-Info" CFBundleVersion $VERSION_FOR_DEB_IPHONE
plutil -convert xml1 "$SRCROOT/../QSSoftwareManager/QSSoftwareManager/QSSoftwareManager-Info.plist"

#更新MQQSecureInstaller-Info.plist文件CFBundleVersion字段
defaults write "$SRCROOT/../MQQSecureInstaller/MQQSecureInstaller/MQQSecureInstaller-Info" MQQBundleVersion $VERSION_FOR_IPA_IPHONE
defaults write "$SRCROOT/../MQQSecureInstaller/MQQSecureInstaller/MQQSecureInstaller-Info" MQQDEBBundleVersion $VERSION_FOR_DEB_IPHONE
defaults write "$SRCROOT/../MQQSecureInstaller/MQQSecureInstaller/MQQSecureInstaller-Info" CFBundleVersion $VERSION_FOR_PUBLIC_IPHONE
defaults write "$SRCROOT/../MQQSecureInstaller/MQQSecureInstaller/MQQSecureInstaller-Info" CFBundleShortVersionString $VERSION_FOR_PUBLIC_IPHONE
defaults write "$SRCROOT/../MQQSecureInstaller/MQQSecureInstaller/MQQSecureInstaller-Info" CFBundleBuild $BUILD_NUM
plutil -convert xml1 "$SRCROOT/../MQQSecureInstaller/MQQSecureInstaller/MQQSecureInstaller-Info.plist"

#更新updateInfo.plist文件new_versionstring、new_buildversion字段
defaults write "$SRCROOT/../MQQSecureInstaller/updateInfo" MqqsecurePackageID $DEB_PACKAGEID_FOR_JB
defaults write "$SRCROOT/../MQQSecureInstaller/updateInfo" title $UPDATETITLE_FOR_JB
defaults write "$SRCROOT/../MQQSecureInstaller/updateInfo" msg $UPDATEMSG_FOR_JB
defaults write "$SRCROOT/../MQQSecureInstaller/updateInfo" new_versionstring $VERSION_FOR_DEB_IPHONE
defaults write "$SRCROOT/../MQQSecureInstaller/updateInfo" new_buildversion $BUILD_NUM
plutil -convert xml1 "$SRCROOT/../MQQSecureInstaller/updateInfo.plist"

#更新com.qq.QSCommonCenter.plist文件Version字段信息
#defaults write "$SRCROOT/../QSShare/Public/com.qq.QSCommonCenter" Version $VERSION_FOR_DEB_IPHONE
#plutil -convert xml1 "$SRCROOT/../QSShare/Public/com.qq.QSCommonCenter.plist"

#更新MQQSecure_Prefix.pch文件预定义代码内容
sed "s/#define JB_IPHONE_VERSION           @\"[^\"]*\"/#define JB_IPHONE_VERSION           @\"$VERSION_FOR_DEB_IPHONE\"/g" "$SRCROOT/MQQSecure_Prefix.pch" > "$SRCROOT/MQQSecure_Prefix_Temp.pch"
mv "$SRCROOT/MQQSecure_Prefix_Temp.pch" "$SRCROOT/MQQSecure_Prefix.pch"
sed "s/#define JB_IPHONE_BUILD_NUMBER      @\"[^\"]*\"/#define JB_IPHONE_BUILD_NUMBER      @\"$BUILD_NUM\"/g" "$SRCROOT/MQQSecure_Prefix.pch" > "$SRCROOT/MQQSecure_Prefix_Temp.pch"
mv "$SRCROOT/MQQSecure_Prefix_Temp.pch" "$SRCROOT/MQQSecure_Prefix.pch"
sed "s/#define JB_IPHONE_BUILD_DATE        @\"[^\"]*\"/#define JB_IPHONE_BUILD_DATE        @\"$date\"/g" "$SRCROOT/MQQSecure_Prefix.pch" > "$SRCROOT/MQQSecure_Prefix_Temp.pch"
mv "$SRCROOT/MQQSecure_Prefix_Temp.pch" "$SRCROOT/MQQSecure_Prefix.pch"
sed "s/#define JB_IPHONE_LC_STRING         \"[^\"]*\"/#define JB_IPHONE_LC_STRING         \"$LC_FOR_DEB_IPHONE\"/g" "$SRCROOT/MQQSecure_Prefix.pch" > "$SRCROOT/MQQSecure_Prefix_Temp.pch"
mv "$SRCROOT/MQQSecure_Prefix_Temp.pch" "$SRCROOT/MQQSecure_Prefix.pch"

#软件游戏预定义代码内容
sed "s/#define JB_IPHONE_ENABLE_SOFTWAREMANAGER [^\"]*/#define JB_IPHONE_ENABLE_SOFTWAREMANAGER $ENABLE_SOFTWAREMANAGER/g" "$SRCROOT/MQQSecure_Prefix.pch" > "$SRCROOT/MQQSecure_Prefix_Temp.pch"
mv "$SRCROOT/MQQSecure_Prefix_Temp.pch" "$SRCROOT/MQQSecure_Prefix.pch"

sed "s/#define JB_IPHONE_ENABLE_SOFTWAREMANAGER [^\"]*/#define JB_IPHONE_ENABLE_SOFTWAREMANAGER $ENABLE_SOFTWAREMANAGER/g" "$SRCROOT/../QSSysOptm/QSSysOptm_Prefix.pch" > "$SRCROOT/QSSysOptm_Prefix_Temp.pch"
mv "$SRCROOT/QSSysOptm_Prefix_Temp.pch" "$SRCROOT/../QSSysOptm/QSSysOptm_Prefix.pch"

sed "s/#define JB_IPHONE_ENABLE_SOFTWAREMANAGER [^\"]*/#define JB_IPHONE_ENABLE_SOFTWAREMANAGER $ENABLE_SOFTWAREMANAGER/g" "$SRCROOT/../QSCenter/QSCenter_Prefix.pch" > "$SRCROOT/QSCenter_Prefix_Temp.pch"
mv "$SRCROOT/QSCenter_Prefix_Temp.pch" "$SRCROOT/../QSCenter/QSCenter_Prefix.pch"

#更新DebVersion.h文件预定义代码内容
sed "s/#define DEB_VERSION @\"[^\"]*\"/#define DEB_VERSION @\"$VERSION_FOR_DEB_IPHONE\"/g" "$SRCROOT/../Public/DebVersion.h" > "$SRCROOT/../Public/DebVersion_Temp.h"
mv "$SRCROOT/../Public/DebVersion_Temp.h" "$SRCROOT/../Public/DebVersion.h"

sed "s/#define DEB_INNER_VERSION @\"[^\"]*\"/#define DEB_INNER_VERSION @\"$VERSION_FOR_DEB_IPHONE\"/g" "$SRCROOT/../Public/DebVersion.h" > "$SRCROOT/../Public/DebVersion_Temp.h"
mv "$SRCROOT/../Public/DebVersion_Temp.h" "$SRCROOT/../Public/DebVersion.h"

sed "s/#define DEB_PUBLIC_VERSION @\"[^\"]*\"/#define DEB_PUBLIC_VERSION @\"$VERSION_FOR_PUBLIC_IPHONE\"/g" "$SRCROOT/../Public/DebVersion.h" > "$SRCROOT/../Public/DebVersion_Temp.h"
mv "$SRCROOT/../Public/DebVersion_Temp.h" "$SRCROOT/../Public/DebVersion.h"

sed "s/#define DEB_BUILD_NUMBER @\"[^\"]*\"/#define DEB_BUILD_NUMBER @\"$BUILD_NUM\"/g" "$SRCROOT/../Public/DebVersion.h" > "$SRCROOT/../Public/DebVersion_Temp.h"
mv "$SRCROOT/../Public/DebVersion_Temp.h" "$SRCROOT/../Public/DebVersion.h"

sed "s/#define DEB_LC_STRING @\"[^\"]*\"/#define DEB_LC_STRING @\"$LC_FOR_DEB_IPHONE\"/g" "$SRCROOT/../Public/DebVersion.h" > "$SRCROOT/../Public/DebVersion_Temp.h"
mv "$SRCROOT/../Public/DebVersion_Temp.h" "$SRCROOT/../Public/DebVersion.h"

sed "s/#define IPA_VERSION @\"[^\"]*\"/#define IPA_VERSION @\"$VERSION_FOR_IPA_IPHONE\"/g" "$SRCROOT/../Public/DebVersion.h" > "$SRCROOT/../Public/DebVersion_Temp.h"
mv "$SRCROOT/../Public/DebVersion_Temp.h" "$SRCROOT/../Public/DebVersion.h"

sed "s/#define IPA_LC_STRING @\"[^\"]*\"/#define IPA_LC_STRING @\"$LC_FOR_IPA_IPHONE\"/g" "$SRCROOT/../Public/DebVersion.h" > "$SRCROOT/../Public/DebVersion_Temp.h"
mv "$SRCROOT/../Public/DebVersion_Temp.h" "$SRCROOT/../Public/DebVersion.h"

#更新control文件Version字段信息
sed "s/Version: [^\"]*/Version: $VERSION_FOR_PUBLIC_IPHONE/g" "$SRCROOT/Scripts/control" > "$SRCROOT/Scripts/control_Temp"
mv "$SRCROOT/Scripts/control_Temp" "$SRCROOT/Scripts/control"

#更新QSCenter_Prefix.pch文件预定义代码内容
sed "s/#define JB_IPHONE_LC_STRING         \"[^\"]*\"/#define JB_IPHONE_LC_STRING         \"$LC_FOR_DEB_IPHONE\"/g" "$SRCROOT/../QSCenter/QSCenter_Prefix.pch" > "$SRCROOT/QSCenter_Prefix_Temp.pch"
mv "$SRCROOT/QSCenter_Prefix_Temp.pch" "$SRCROOT/../QSCenter/QSCenter_Prefix.pch"
sed "s/#define JB_IPHONE_BUILD_NUMBER      @\"[^\"]*\"/#define JB_IPHONE_BUILD_NUMBER      @\"$BUILD_NUM\"/g" "$SRCROOT/../QSCenter/QSCenter_Prefix.pch" > "$SRCROOT/QSCenter_Prefix_Temp.pch"
mv "$SRCROOT/QSCenter_Prefix_Temp.pch" "$SRCROOT/../QSCenter/QSCenter_Prefix.pch"

#更新QSSoftwareManager-Prefix文件预定义代码内容
sed "s/#define JB_IPHONE_LC_STRING         \"[^\"]*\"/#define JB_IPHONE_LC_STRING         \"$LC_FOR_DEB_IPHONE\"/g" "$SRCROOT/../QSSoftwareManager/QSSoftwareManager/QSSoftwareManager-Prefix.pch" > "$SRCROOT/QSSoftwareManager-Prefix_Temp.pch"
mv "$SRCROOT/QSSoftwareManager-Prefix_Temp.pch" "$SRCROOT/../QSSoftwareManager/QSSoftwareManager/QSSoftwareManager-Prefix.pch"
sed "s/#define JB_IPHONE_BUILD_NUMBER      @\"[^\"]*\"/#define JB_IPHONE_BUILD_NUMBER      @\"$BUILD_NUM\"/g" "$SRCROOT/../QSSoftwareManager/QSSoftwareManager/QSSoftwareManager-Prefix.pch" > "$SRCROOT/QSSoftwareManager-Prefix_Temp.pch"
mv "$SRCROOT/QSSoftwareManager-Prefix_Temp.pch" "$SRCROOT/../QSSoftwareManager/QSSoftwareManager/QSSoftwareManager-Prefix.pch"

#更新QSServiceCenter_Prefix.pch文件预定义代码内容
sed "s/#define JB_IPHONE_LC_STRING         \"[^\"]*\"/#define JB_IPHONE_LC_STRING         \"$LC_FOR_DEB_IPHONE\"/g" "$SRCROOT/../QSServiceCenter/QSServiceCenter_Prefix.pch" > "$SRCROOT/QSServiceCenter_Prefix_Temp.pch"
mv "$SRCROOT/QSServiceCenter_Prefix_Temp.pch" "$SRCROOT/../QSServiceCenter/QSServiceCenter_Prefix.pch"

#更新MQQSecureInstaller-Prefix.pch文件预定义代码内容
sed "s/#define JB_IPHONE_LC_STRING         \"[^\"]*\"/#define JB_IPHONE_LC_STRING         \"$LC_FOR_DEB_IPHONE\"/g" "$SRCROOT/../MQQSecureInstaller/MQQSecureInstaller/MQQSecureInstaller-Prefix.pch" > "$SRCROOT/MQQSecureInstaller-Prefix_Temp.pch"
mv "$SRCROOT/MQQSecureInstaller-Prefix_Temp.pch" "$SRCROOT/../MQQSecureInstaller/MQQSecureInstaller/MQQSecureInstaller-Prefix.pch"

#更新QSCommand_Prefix.pch文件预定义代码内容
sed "s/#define JB_IPHONE_LC_STRING         \"[^\"]*\"/#define JB_IPHONE_LC_STRING         \"$LC_FOR_DEB_IPHONE\"/g" "$SRCROOT/../QSCommand/QSCommand_Prefix.pch" > "$SRCROOT/QSCommand_Prefix_Temp.pch"
mv "$SRCROOT/QSCommand_Prefix_Temp.pch" "$SRCROOT/../QSCommand/QSCommand_Prefix.pch"
