TUNING = {}


function Tune(overrides)
	if overrides == nil then
		overrides = {}
	end
	
	local seg_time = 30
	local total_day_time = seg_time*16
	
	local day_segs = 10
	local dusk_segs = 4
	local night_segs = 2
	
	--default day composition. changes in winter, etc
	local day_time = seg_time * day_segs
	local dusk_time = seg_time * dusk_segs
	local night_time = seg_time * night_segs
	
	local wilson_attack = 34
	local wilson_health = 100
	local calories_per_day = 75
	
	local wilson_attack_period = .5
	-----------------------
	
	local perish_warp = 1--/200
	
	TUNING =
	{
		DEMO_TIME = total_day_time * 2 + day_time*.2,
		
	    SEG_TIME = seg_time,
	    TOTAL_DAY_TIME = total_day_time,
		DAY_SEGS_DEFAULT = day_segs,
		DUSK_SEGS_DEFAULT = dusk_segs, 
		NIGHT_SEGS_DEFAULT = night_segs,
		
		STACK_SIZE_LARGEITEM = 10,
		STACK_SIZE_MEDITEM = 20,
		STACK_SIZE_SMALLITEM = 40,
		
		GOLDENTOOLFACTOR = 4,
	
	    DARK_CUTOFF = 0,
	    DARK_SPAWNCUTOFF = 0.1,
	    WILSON_HEALTH = 100,
	    WILSON_ATTACK_PERIOD = .5,
	    WILSON_HUNGER = 150, --stomach size
	    WILSON_HUNGER_RATE = calories_per_day/total_day_time, --calories burnt per day
	    
	    
	    WILSON_SANITY = 200,
	    
	    HAMMER_LOOT_PERCENT = .5,
	    AXE_USES = 100,
	    HAMMER_USES = 75,
	    SHOVEL_USES = 25,
	    PITCHFORK_USES = 25,
	    PICKAXE_USES = 33,
	    BUGNET_USES = 10,
	    SPEAR_USES = 150,
	    SPIKE_USES = 100,
	    FISHINGROD_USES = 9,
	    TRAP_USES = 8,
	    BOOMERANG_USES = 10,
	    BOOMERANG_DISTANCE = 12,
	    NIGHTSWORD_USES = 100,
	    ICESTAFF_USES = 20,
	
	    
	    FISHING_MINWAIT = 2,
	    FISHING_MAXWAIT = 20,
	    
		RESEARCH_MACHINE_DIST = 4,
	    
	    UNARMED_DAMAGE = 10,
	    NIGHTSWORD_DAMAGE = wilson_attack*2,
	    SPIKE_DAMAGE = wilson_attack*1.5,
	    SPEAR_DAMAGE = wilson_attack,
	    AXE_DAMAGE = wilson_attack*.8,
	    PICK_DAMAGE = wilson_attack*.8,
	    BOOMERANG_DAMAGE = wilson_attack*.8,
	    TORCH_DAMAGE = wilson_attack*.5,
	    HAMMER_DAMAGE = wilson_attack*.5,
	    SHOVEL_DAMAGE = wilson_attack*.5,
	    PITCHFORK_DAMAGE = wilson_attack*.5,
	    BUGNET_DAMAGE = wilson_attack*.125,
	    FISHINGROD_DAMAGE = wilson_attack*.125,
	    TORCH_ATTACK_IGNITE_PERCENT = 1,
	
	    PIG_DAMAGE = 33,
	    PIG_HEALTH = 250,
	    PIG_ATTACK_PERIOD = 3,
	    PIG_TARGET_DIST = 16,
	    PIG_LOYALTY_MAXTIME = 2.5*total_day_time,
	    PIG_LOYALTY_PER_HUNGER = total_day_time/25,
	    PIG_MIN_POOP_PERIOD = seg_time * .5,
	    
	    WEREPIG_DAMAGE = 40,
	    WEREPIG_HEALTH = 350,
	    WEREPIG_ATTACK_PERIOD = 2,
	    
	    PIG_RUN_SPEED = 5,
	    PIG_WALK_SPEED = 3,
	    
	    WEREPIG_RUN_SPEED = 7,
	    WEREPIG_WALK_SPEED = 3,
	    
	    WILSON_WALK_SPEED = 4,
	    WILSON_RUN_SPEED = 6,
	    
	    PERD_SPAWNCHANCE = 0.1,
	    PERD_DAMAGE = 20,
	    PERD_HEALTH = 50,
	    PERD_ATTACK_PERIOD = 3,
	    PERD_RUN_SPEED = 8,
	    PERD_WALK_SPEED = 3,
	    
	    WALRUS_DAMAGE = 33,
	    WALRUS_HEALTH = 150,
	    WALRUS_ATTACK_PERIOD = 3,
	    WALRUS_ATTACK_DIST = 15,
        WALRUS_MELEE_RANGE = 5,
        WALRUS_TARGET_DIST = 10,
        WALRUS_LOSETARGET_DIST = 30,
        WALRUS_REGEN_PERIOD = total_day_time*2.5,

        LITTLE_WALRUS_DAMAGE = 22,
        LITTLE_WALRUS_HEALTH = 100,
        LITTLE_WALRUS_ATTACK_PERIOD = 3 * 1.7,
        LITTLE_WALRUS_ATTACK_DIST = 15,

        PIPE_DART_DAMAGE = 33,

	    PENGUIN_DAMAGE = 33,
	    PENGUIN_HEALTH = 150,
	    PENGUIN_ATTACK_PERIOD = 3,
	    
	    FREEZING_KILL_TIME = 120,
	    STARVE_KILL_TIME = 120,
	    HUNGRY_THRESH = .333,
	    
	    GRUEDAMAGE = wilson_health*.667,
	    
	    GHOST_DPS = wilson_health/10,
	    GHOST_RADIUS = 1.5,
	    GHOST_SPEED = 2,
	    ABIGAIL_SPEED = 4,
	    GHOST_HEALTH = 200,
	    ABIGAIL_HEALTH = 100,
	    ABIGAIL_DPS = wilson_health,
	    ABIGAIL_CHANCE = .333,
	
		EVERGREEN_GROW_TIME =
	    {
	        {base=1.5*day_time, random=0.5*day_time},   --short
	        {base=5*day_time, random=2*day_time},   --normal
	        {base=5*day_time, random=2*day_time},   --tall
	        {base=1*day_time, random=0.5*day_time}   --old
	    },
	    
	    
	    EVERGREEN_CHOPS_SMALL = 5,
	    EVERGREEN_CHOPS_NORMAL = 10,
	    EVERGREEN_CHOPS_TALL = 15,
	    
	    ROCKS_MINE = 6,  
	    
	    BEEFALO_HEALTH = 500,
	    BEEFALO_DAMAGE = 34,
	    BEEFALO_MATING_SEASON_LENGTH = 5,
	    BEEFALO_MATING_SEASON_WAIT = 10,
	    BEEFALO_TARGET_DIST = 5,
	    BEEFALO_CHASE_DIST = 30,
	    BEEFALO_FOLLOW_TIME = 30,
	    
	    BABYBEEFALO_HEALTH = 300,
	    BABYBEEFALO_GROW_TIME = {base=3*day_time, random=2*day_time},
	    
	    KOALEFANT_HEALTH = 500,
	    KOALEFANT_DAMAGE = 50,
	    KOALEFANT_TARGET_DIST = 5,
	    KOALEFANT_CHASE_DIST = 30,
	    KOALEFANT_FOLLOW_TIME = 30,
	    
	    KOALEFANT_SPAWN_DIST = 40,
	    KOALEFANT_HUNT_COOLDOWN = total_day_time*1.2,
	    KOALEFANT_HUNT_COOLDOWNDEVIATION = total_day_time*.3,
	    KOALEFANT_TRACK_ANGLE_DEVIATION = 10,
	    KOALEFANT_MIN_HUNT_DISTANCE = 300, -- you can't find a new koalefant without being at least this far from the last one
	    KOALEFANT_MAX_DIRT_DISTANCE = 200, -- if you get this far away from your dirt pile, you probably aren't going to see it any time soon, so remove it and place a new one
	
	    SPIDER_HEALTH = 100,
	    SPIDER_DAMAGE = 20,
	    SPIDER_ATTACK_PERIOD = 3,
	    SPIDER_TARGET_DIST = 4,
	    SPIDER_WAKE_RADIUS = 4,
	    SPIDER_FLAMMABILITY = .33,
	    
	    SPIDER_WALK_SPEED = 3,
	    SPIDER_RUN_SPEED = 5,
	    
	    SPIDER_WARRIOR_HEALTH = 200,
	    SPIDER_WARRIOR_DAMAGE = 20,
	    SPIDER_WARRIOR_ATTACK_PERIOD = 4,
	    SPIDER_WARRIOR_ATTACK_RANGE = 6,
	    SPIDER_WARRIOR_MELEE_RANGE = 3,
	    SPIDER_WARRIOR_TARGET_DIST = 10,
	    SPIDER_WARRIOR_WAKE_RADIUS = 6,
	    
	    SPIDER_WARRIOR_WALK_SPEED = 4,
	    SPIDER_WARRIOR_RUN_SPEED = 5,
	
	    LEIF_HEALTH = 2000,
	    LEIF_DAMAGE = 150,
	    LEIF_ATTACK_PERIOD = 3,
	    LEIF_FLAMMABILITY = .333,
	    
	    LEIF_MIN_DAY = 3,
	    LEIF_PERCENT_CHANCE = 1/75,
	    LEIF_MAXSPAWNDIST = 15,
	    
	    LEIF_PINECONE_CHILL_CHANCE_CLOSE = .33,
	    LEIF_PINECONE_CHILL_CHANCE_FAR = .15,
	    LEIF_PINECONE_CHILL_CLOSE_RADIUS = 5,
	    LEIF_PINECONE_CHILL_RADIUS = 16,
	    LEIF_REAWAKEN_RADIUS = 20,
	    
	    LEIF_BURN_TIME = 10,
	    LEIF_BURN_DAMAGE_PERCENT = 1/8,
	    
	    DEERCLOPS_HEALTH = 2000,
	    DEERCLOPS_DAMAGE = 150,
	    DEERCLOPS_ATTACK_PERIOD = 3,
	    
	    BIRD_SPAWN_MAX = 4,
	    BIRD_SPAWN_DELAY = {min=5, max=15},
	    BIRD_SPAWN_MAX_FEATHERHAT = 7,
	    BIRD_SPAWN_DELAY_FEATHERHAT = {min=2, max=10},
	    
	    BEE_HEALTH = 100,
	    BEE_DAMAGE = 10,
	    BEE_ATTACK_PERIOD = 2,
	    BEE_TARGET_DIST = 8,
	    
	    BEEMINE_BEES = 4,
	    BEEMINE_RADIUS = 3,
	    
	    SPIDERDEN_GROW_TIME = {day_time*8, day_time*8, day_time*20},
	    SPIDERDEN_HEALTH = {50*5, 50*10, 50*20},
	    SPIDERDEN_SPIDERS = {3, 6, 9},
	    SPIDERDEN_WARRIORS = {0, 1, 3},  -- every hit, release up to this many warriors, and fill remainder with regular spiders
	    SPIDERDEN_SPIDER_TYPE = {"spider", "spider_warrior", "spider_warrior"},
		SPIDERDEN_REGEN_TIME = 3*seg_time,
		SPIDERDEN_RELEASE_TIME = 5,
	    
		POND_FROGS = 4,
		POND_REGEN_TIME = day_time/2,
		POND_SPAWN_TIME = day_time/4,
		POND_RETURN_TIME = day_time*3/4,
	    FISH_RESPAWN_TIME = day_time/3,
	    
	    BEEHIVE_BEES = 6,
	    BEEHIVE_RELEASE_TIME = day_time/6,
	    BEEHIVE_REGEN_TIME = seg_time,
	    BEEBOX_BEES = 4,
	    BEEBOX_RELEASE_TIME = (0.5*day_time)/4,
	    BEEBOX_HONEY_TIME = day_time,
	    BEEBOX_REGEN_TIME = seg_time*4,
	    
	    TENTACLE_DAMAGE = 34,
	    TENTACLE_ATTACK_PERIOD = 2,
	    TENTACLE_ATTACK_DIST = 4,
	    TENTACLE_STOPATTACK_DIST = 6,
	    TENTACLE_HEALTH = 500,
	    
	    TALLBIRD_HEALTH = 400,
	    TALLBIRD_DAMAGE = 50,
	    TALLBIRD_ATTACK_PERIOD = 2,
	    TALLBIRD_HATEPIGS_DIST = 16,
	    TALLBIRD_TARGET_DIST = 8,
	    TALLBIRD_DEFEND_DIST = 12,
	    TALLBIRD_ATTACK_RANGE = 3,
	
	    TEENBIRD_HEALTH = 400*.75,
	    TEENBIRD_DAMAGE = 50*.75,
	    TEENBIRD_ATTACK_PERIOD = 2,
	    TEENBIRD_ATTACK_RANGE = 3,
	    TEENBIRD_DAMAGE_PECK = 2,
	    TEENBIRD_PECK_PERIOD = 4,
	    TEENBIRD_HUNGER = 60,
	    TEENBIRD_STARVE_TIME = total_day_time * 1,
	    TEENBIRD_STARVE_KILL_TIME = 240,
	    TEENBIRD_GROW_TIME = total_day_time*18,
	    TEENBIRD_TARGET_DIST = 8,
	
	    SMALLBIRD_HEALTH = 50,
	    SMALLBIRD_DAMAGE = 10,
	    SMALLBIRD_ATTACK_PERIOD = 1,
	    SMALLBIRD_ATTACK_RANGE = 3,
	    SMALLBIRD_HUNGER = 20,
	    SMALLBIRD_STARVE_TIME = total_day_time * 1,
	    SMALLBIRD_STARVE_KILL_TIME = 120,
	    SMALLBIRD_GROW_TIME = total_day_time*10,
	    
	    SMALLBIRD_HATCH_CRACK_TIME = 10, -- set by fire for this much time to start hatching progress
	    SMALLBIRD_HATCH_TIME = total_day_time * 3, -- must be content for this amount of cumulative time to hatch
	    SMALLBIRD_HATCH_FAIL_TIME = night_time * .5, -- being too hot or too cold this long will kill the egg
	
	    HATCH_UPDATE_PERIOD = 3,
	    HATCH_CAMPFIRE_RADIUS = 4,
	   
	    CHESTER_HEALTH = 100,
	    CHESTER_RESPAWN_TIME = total_day_time * 7,
	    CHESTER_HEALTH_REGEN_AMOUNT = (100/60) * 3,
	    CHESTER_HEALTH_REGEN_PERIOD = 3,
	
	 
	    RABBIT_HEALTH = 25,
	    
	    FROG_HEALTH = 100,
	    FROG_DAMAGE = 10,
	    FROG_ATTACK_PERIOD = 1,
	    FROG_TARGET_DIST = 4,
	
	    HOUND_HEALTH = 150,
	    HOUND_DAMAGE = 20,
	    HOUND_ATTACK_PERIOD = 2,
	    HOUND_TARGET_DIST = 20,
	    HOUND_SPEED = 10,

        HOUND_FOLLOWER_TARGET_DIST = 10,
	
	    FIREHOUND_HEALTH = 100,
	    FIREHOUND_DAMAGE = 30,
	    FIREHOUND_ATTACK_PERIOD = 2,
	    FIREHOUND_SPEED = 10,
	    
	    ICEHOUND_HEALTH = 100,
	    ICEHOUND_DAMAGE = 30,
	    ICEHOUND_ATTACK_PERIOD = 2,
	    ICEHOUND_SPEED = 10,
	    
		MOSQUITO_WALKSPEED = 8,
		MOSQUITO_RUNSPEED = 12,
		MOSQUITO_DAMAGE = 3,
		MOSQUITO_HEALTH = 100,
		MOSQUITO_ATTACK_PERIOD = 7,
		MOSQUITO_MAX_DRINKS = 4,
		MOSQUITO_BURST_DAMAGE = 34,
		MOSQUITO_BURST_RANGE = 4,
	
	    KRAMPUS_HEALTH = 200,
	    KRAMPUS_DAMAGE = 50,
	    KRAMPUS_ATTACK_PERIOD = 1.2,
	    KRAMPUS_SPEED = 7,
	
	    TERRORBEAK_SPEED = 7,
	    TERRORBEAK_HEALTH = 400,
	    TERRORBEAK_DAMAGE = 50,
	    TERRORBEAK_ATTACK_PERIOD= 1.5,
	
	    CRAWLINGHORROR_SPEED = 3,
	    CRAWLINGHORROR_HEALTH = 300,
	    CRAWLINGHORROR_DAMAGE = 20,
	    CRAWLINGHORROR_ATTACK_PERIOD= 2.5,
	    
	    SHADOWCREATURE_TARGET_DIST = 20,
	    
		FROSTY_BREATH = -5,
	    
	    SEEDS_GROW_TIME = day_time*6,
	    FARM1_GROW_BONUS = 1,
	    FARM2_GROW_BONUS = .6667,
	    FARM3_GROW_BONUS = .333,
	    POOP_FERTILIZE = day_time,
	    POOP_SOILCYCLES = 10,
	
	    SPOILEDFOOD_FERTILIZE = day_time/4,
	    SPOILEDFOOD_SOILCYCLES = 2,
	    
	    
	    
	    FISHING_CATCH_CHANCE = 0.4,
	    FISHING_LOSEROD_CHANCE = 0.4,
	
	    
	    TINY_FUEL = seg_time*.25,
	    SMALL_FUEL = seg_time * .5,
	    MED_FUEL = seg_time * 1.5,
	    LARGE_FUEL = seg_time * 6,
	    
	    TINY_BURNTIME = seg_time*.1,
	    SMALL_BURNTIME = seg_time*.25,
	    MED_BURNTIME = seg_time*0.5,
	    LARGE_BURNTIME = seg_time,
	    
	    CAMPFIRE_FUEL_MAX = (night_time+dusk_time)*1.5,
	    CAMPFIRE_FUEL_START = (night_time+dusk_time)*.75,
	
	    FIREPIT_FUEL_MAX = (night_time+dusk_time)*2,
	    FIREPIT_FUEL_START = night_time+dusk_time,
	    FIREPIT_BONUS_MULT = 2,
	    
	    NIGHTLIGHT_FUEL_MAX = (night_time+dusk_time)*3,
	    NIGHTLIGHT_FUEL_START = (night_time+dusk_time),
	    
	    TORCH_FUEL = night_time*2.50,
	    MINERHAT_LIGHTTIME = (night_time+dusk_time)*2.6,
	    SPIDERHAT_PERISHTIME = 4*seg_time,
	    SPIDERHAT_RANGE = 12,
	    
	    GRASS_REGROW_TIME = total_day_time*3,
	    SAPLING_REGROW_TIME = total_day_time*4,
	    
	    BERRY_REGROW_TIME = total_day_time*3,
	    BERRY_REGROW_INCREASE = total_day_time*.5,
	    BERRY_REGROW_VARIANCE = total_day_time*2,
	    BERRYBUSH_CYCLES = 3,
	    
	    REEDS_REGROW_TIME = total_day_time*3,
	    
	    CROW_LEAVINGS_CHANCE = .3333,
	    BIRD_TRAP_CHANCE = 0.025,
	    BIRD_HEALTH = 25,
	    
	    RABBIT_RESPAWN_TIME = day_time*4,
	    
	    ARMORWOOD = wilson_health*3,
		ARMORWOOD_ABSORPTION = .8,
	    ARMOR_FOOTBALLHAT = wilson_health*3,
		ARMOR_FOOTBALLHAT_ABSORPTION = .8,
	    ARMOR_BEEHAT = wilson_health*5,
		ARMOR_BEEHAT_ABSORPTION = .8,
		ARMOR_SANITY = wilson_health * 5,
		ARMOR_SANITY_ABSORPTION = .95,
		ARMOR_SANITY_DMG_AS_SANITY = 0.10,
	    
	    PANFLUTE_SLEEPTIME = 20,
	    PANFLUTE_SLEEPRANGE = 15,
	    PANFLUTE_USES = 10,
	    HORN_RANGE = 25,
	    HORN_USES = 10,
	    HORN_EFFECTIVE_TIME = 20,
	    HORN_MAX_FOLLOWERS = 5,
	    MANDRAKE_SLEEP_TIME = 10,
	    MANDRAKE_SLEEP_RANGE = 15,
	    MANDRAKE_SLEEP_RANGE_COOKED = 25,
	    
	    GOLD_VALUES=
	    {
	        MEAT = 1,
	        TRINKETS=
	        {
	            4,6,4,5,4,5,4,8,7,2,5,8,
	        }
	    },
	
		RESEARCH_COST_CHEAP = 30,
		RESEARCH_COST_MEDIUM = 100,
		RESEARCH_COST_EXPENSIVE = 200,
		    
	    SPIDERQUEEN_WALKSPEED = 1.75,
	    SPIDERQUEEN_HEALTH = 1250,
	    SPIDERQUEEN_DAMAGE = 80,
	    SPIDERQUEEN_ATTACKPERIOD = 3,
	    SPIDERQUEEN_ATTACKRANGE = 5,
	    SPIDERQUEEN_FOLLOWERS = 16,
	    SPIDERQUEEN_GIVEBIRTHPERIOD = 20,
	    SPIDERQUEEN_MINWANDERTIME = total_day_time * 1.5,
	    SPIDERQUEEN_MINDENSPACING = 20,
	    
	    TRAP_TEETH_USES = 10,
	    TRAP_TEETH_DAMAGE = 60,
	    TRAP_TEETH_RADIUS = 1.25,
	    
	    
	    HEALING_TINY = 1,
	    HEALING_SMALL = 3,
	    HEALING_MEDSMALL = 8,
	    HEALING_MED = 20,
	    HEALING_MEDLARGE = 30,
	    HEALING_LARGE = 40,
	    HEALING_HUGE = 60,
	    HEALING_SUPERHUGE = 100,
	    
	    SANITY_SUPERTINY = 1,
	    SANITY_TINY = 5,
	    SANITY_SMALL = 10,
	    SANITY_MED = 15,
	    SANITY_MEDLARGE = 20,
	    SANITY_LARGE = 33,
	    SANITY_HUGE = 50,
	    
		PERISH_SUPERFAST = 3*total_day_time*perish_warp,
		PERISH_FAST = 6*total_day_time*perish_warp,
		PERISH_MED = 10*total_day_time*perish_warp,
		PERISH_SLOW = 15*total_day_time*perish_warp,
		PERISH_PRESERVED = 20*total_day_time*perish_warp,
		PERISH_SUPERSLOW = 40*total_day_time*perish_warp,
	
		CALORIES_TINY = calories_per_day/8, -- berries
		CALORIES_SMALL = calories_per_day/6, -- veggies
		CALORIES_MEDSMALL = calories_per_day/4,
		CALORIES_MED = calories_per_day/3, -- meat
		CALORIES_LARGE = calories_per_day/2, -- cooked meat
		CALORIES_HUGE = calories_per_day, -- crockpot foods?
		CALORIES_SUPERHUGE = calories_per_day*2, -- crockpot foods?
		
	    SPOILED_HEALTH = -1,
	    SPOILED_HUNGER = -10,
	    PERISH_FRIDGE_MULT = .5,
	    PERISH_GROUND_MULT = 1.5,
	    PERISH_GLOBAL_MULT = 1,
	    PERISH_WINTER_MULT = .75,
	    
	    STALE_FOOD_HUNGER = .667,
	    SPOILED_FOOD_HUNGER = .5,
	    
	    STALE_FOOD_HEALTH = .333,
	    SPOILED_FOOD_HEALTH = 0,
	    
		BASE_COOK_TIME = night_time*.3333,
		
	    TALLBIRDEGG_HEALTH = 15;
	    TALLBIRDEGG_HUNGER = 15,
	    TALLBIRDEGG_COOKED_HEALTH = 25;
	    TALLBIRDEGG_COOKED_HUNGER = 30,
		
		REPAIR_CUTSTONE = 50,
		REPAIR_ROCKS = 50/3,
	
		REPAIR_BOARDS = 50,
		REPAIR_LOGS = 50/4,
		REPAIR_STICK = 6,
		REPAIR_CUTGRASS = 6,
		
		HAYWALL_HEALTH = 100,
		WOODWALL_HEALTH = 200,
		STONEWALL_HEALTH = 400,
	
		EFFIGY_HEALTH_PENALTY = 20,
		
		SANITY_HIGH_LIGHT = .6,
		SANITY_LOW_LIGHT =  0.1,
	
		SANITY_DAPPERNESS = 1,
		
		SANITY_BECOME_SANE_THRESH = 35/200,
		SANITY_BECOME_INSANE_THRESH = 30/200,
		
		SANITY_DAY_GAIN = 0,--100/(day_time*32),
		
		SANITY_NIGHT_LIGHT = -100/(night_time*20),
		SANITY_NIGHT_MID = -100/(night_time*20),
		SANITY_NIGHT_DARK = -100/(night_time*2),
		
		SANITYAURA_SMALL = 100/(seg_time*8),
		SANITYAURA_MED = 100/(seg_time*5),
		SANITYAURA_LARGE = 100/(seg_time*2),
		SANITYAURA_HUGE = 100/(seg_time*.5),
		
		DAPPERNESS_TINY = 100/(day_time*15),
		DAPPERNESS_SMALL = 100/(day_time*10),
		DAPPERNESS_MED = 100/(day_time*6),
		DAPPERNESS_LARGE = 100/(day_time*3),
		
		CRAZINESS_SMALL = -100/(day_time*2),
		CRAZINESS_MED = -100/(day_time),
		
		RABBIT_RUN_SPEED = 5,
		SANITY_EFFECT_RANGE	= 10,
		SUMMER_LENGTH = 20,
		WINTER_LENGTH = 15,
		
		--expressed in 'additional time before you freeze to death'
		INSULATION_TINY = seg_time,
		INSULATION_SMALL = seg_time*2,
		INSULATION_MED = seg_time*4,
		INSULATION_LARGE = seg_time*8,
		INSULATION_PER_BEARD_BIT = seg_time*.5,
		
		CROP_BONUS_TEMP = 28,
		MIN_CROP_GROW_TEMP = 5,
		CROP_HEAT_BONUS = 1.5,
		
		TENT_USES = 6,
	}
end

Tune()
