/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.validation.base;

import com.jfoenix.validation.base.ValidatorBase$$Lambda$1;
import com.jfoenix.validation.base.ValidatorBase$$Lambda$2;
import java.util.function.Supplier;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Control;
import javafx.scene.control.Tooltip;

public abstract class ValidatorBase
extends Parent {
    public static final PseudoClass PSEUDO_CLASS_ERROR = PseudoClass.getPseudoClass((String)"error");
    private Tooltip tooltip = null;
    private Tooltip errorTooltip = null;
    protected SimpleObjectProperty<Node> srcControl = new SimpleObjectProperty();
    protected SimpleStringProperty src = new SimpleStringProperty(){

        protected void invalidated() {
            ValidatorBase.this.updateSrcControl();
        }
    };
    protected ReadOnlyBooleanWrapper hasErrors = new ReadOnlyBooleanWrapper(false);
    protected SimpleStringProperty message = new SimpleStringProperty(){

        protected void invalidated() {
            ValidatorBase.this.updateSrcControl();
        }
    };
    protected SimpleObjectProperty<Supplier<Node>> iconSupplier = new SimpleObjectProperty<Supplier<Node>>(){

        protected void invalidated() {
            ValidatorBase.this.updateSrcControl();
        }
    };

    public ValidatorBase(String message) {
        this();
        this.setMessage(message);
    }

    public ValidatorBase() {
        this.parentProperty().addListener(ValidatorBase$$Lambda$1.lambdaFactory$(this));
        this.errorTooltip = new Tooltip();
        this.errorTooltip.getStyleClass().add((Object)"error-tooltip");
    }

    private void parentChanged() {
        this.updateSrcControl();
    }

    private void updateSrcControl() {
        Parent parent = this.getParent();
        if (parent != null) {
            Node control = parent.lookup(this.getSrc());
            this.srcControl.set((Object)control);
        }
    }

    public void validate() {
        this.eval();
        this.onEval();
    }

    protected abstract void eval();

    protected void onEval() {
        Node control = this.getSrcControl();
        if (this.hasErrors.get()) {
            control.pseudoClassStateChanged(PSEUDO_CLASS_ERROR, true);
            if (control instanceof Control) {
                Tooltip controlTooltip = ((Control)control).getTooltip();
                if (controlTooltip != null && !controlTooltip.getStyleClass().contains((Object)"error-tooltip")) {
                    this.tooltip = ((Control)control).getTooltip();
                }
                this.errorTooltip.setText(this.getMessage());
                ((Control)control).setTooltip(this.errorTooltip);
            }
        } else {
            if (control instanceof Control) {
                Tooltip controlTooltip = ((Control)control).getTooltip();
                if (controlTooltip != null && controlTooltip.getStyleClass().contains((Object)"error-tooltip") || controlTooltip == null && this.tooltip != null) {
                    ((Control)control).setTooltip(this.tooltip);
                }
                this.tooltip = null;
            }
            control.pseudoClassStateChanged(PSEUDO_CLASS_ERROR, false);
        }
    }

    public void setSrcControl(Node srcControl) {
        this.srcControl.set((Object)srcControl);
    }

    public Node getSrcControl() {
        return (Node)this.srcControl.get();
    }

    public ObjectProperty<Node> srcControlProperty() {
        return this.srcControl;
    }

    public void setSrc(String src) {
        this.src.set(src);
    }

    public String getSrc() {
        return this.src.get();
    }

    public StringProperty srcProperty() {
        return this.src;
    }

    public boolean getHasErrors() {
        return this.hasErrors.get();
    }

    public ReadOnlyBooleanProperty hasErrorsProperty() {
        return this.hasErrors.getReadOnlyProperty();
    }

    public void setMessage(String msg) {
        this.message.set(msg);
    }

    public String getMessage() {
        return this.message.get();
    }

    public StringProperty messageProperty() {
        return this.message;
    }

    public void setIconSupplier(Supplier<Node> icon) {
        this.iconSupplier.set(icon);
    }

    public SimpleObjectProperty<Supplier<Node>> iconSupplierProperty() {
        return this.iconSupplier;
    }

    public Supplier<Node> getIconSupplier() {
        return (Supplier)this.iconSupplier.get();
    }

    public void setIcon(Node icon) {
        this.iconSupplier.set((Object)ValidatorBase$$Lambda$2.lambdaFactory$(icon));
    }

    public Node getIcon() {
        if (this.iconSupplier.get() == null) {
            return null;
        }
        Node icon = (Node)((Supplier)this.iconSupplier.get()).get();
        if (icon != null) {
            icon.getStyleClass().add((Object)"error-icon");
        }
        return icon;
    }

    static /* synthetic */ Node lambda$setIcon$1(Node icon) {
        return icon;
    }

    static /* synthetic */ void lambda$new$0(ValidatorBase this_, ObservableValue o, Parent oldVal, Parent newVal) {
        this_.parentChanged();
    }
}

