/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXTextArea;
import com.jfoenix.skins.JFXTextAreaSkin$$Lambda$1;
import com.jfoenix.skins.JFXTextAreaSkin$$Lambda$2;
import com.jfoenix.skins.JFXTextAreaSkin$$Lambda$3;
import com.jfoenix.skins.PromptLinesWrapper;
import com.jfoenix.skins.ValidationPane;
import com.sun.javafx.scene.control.skin.TextAreaSkin;
import java.lang.reflect.Field;
import java.util.Arrays;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextArea;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;

public class JFXTextAreaSkin
extends TextAreaSkin {
    private boolean invalid = true;
    private ScrollPane scrollPane = (ScrollPane)this.getChildren().get(0);
    private Text promptText;
    private ValidationPane<JFXTextArea> errorContainer;
    private PromptLinesWrapper<JFXTextArea> linesWrapper;

    public JFXTextAreaSkin(JFXTextArea textArea) {
        super((TextArea)textArea);
        textArea.setWrapText(true);
        this.linesWrapper = new PromptLinesWrapper<JFXTextArea>(textArea, (ObjectProperty<Paint>)this.promptTextFill, (ObservableValue<?>)textArea.textProperty(), (ObservableValue<String>)textArea.promptTextProperty(), JFXTextAreaSkin$$Lambda$1.lambdaFactory$(this));
        this.linesWrapper.init(JFXTextAreaSkin$$Lambda$2.lambdaFactory$(this), new Node[]{this.scrollPane});
        this.errorContainer = new ValidationPane<JFXTextArea>(textArea);
        this.getChildren().addAll((Object[])new Node[]{this.linesWrapper.line, this.linesWrapper.focusedLine, this.linesWrapper.promptContainer, this.errorContainer});
        this.registerChangeListener((ObservableValue)textArea.disableProperty(), "DISABLE_NODE");
        this.registerChangeListener((ObservableValue)textArea.focusColorProperty(), "FOCUS_COLOR");
        this.registerChangeListener((ObservableValue)textArea.unFocusColorProperty(), "UNFOCUS_COLOR");
        this.registerChangeListener((ObservableValue)textArea.disableAnimationProperty(), "DISABLE_ANIMATION");
    }

    protected void handleControlPropertyChanged(String propertyReference) {
        if ("DISABLE_NODE".equals(propertyReference)) {
            this.linesWrapper.updateDisabled();
        } else if ("FOCUS_COLOR".equals(propertyReference)) {
            this.linesWrapper.updateFocusColor();
        } else if ("UNFOCUS_COLOR".equals(propertyReference)) {
            this.linesWrapper.updateUnfocusColor();
        } else if ("DISABLE_ANIMATION".equals(propertyReference)) {
            this.errorContainer.updateClip();
        } else {
            super.handleControlPropertyChanged(propertyReference);
        }
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        super.layoutChildren(x, y, w, h);
        double height = ((TextArea)this.getSkinnable()).getHeight();
        this.linesWrapper.layoutLines(x, y, w, h, height, this.promptText == null ? 0.0 : this.promptText.getLayoutBounds().getHeight() + 3.0);
        this.errorContainer.layoutPane(x, height + this.linesWrapper.focusedLine.getHeight(), w, h);
        this.linesWrapper.updateLabelFloatLayout();
        if (this.invalid) {
            this.invalid = false;
            Region viewPort = (Region)this.scrollPane.getChildrenUnmodifiable().get(0);
            viewPort.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, CornerRadii.EMPTY, Insets.EMPTY)}));
            viewPort.applyCss();
            this.errorContainer.invalid(w);
            this.linesWrapper.invalid();
        }
    }

    private void createPromptNode() {
        if (this.promptText != null || !this.linesWrapper.usePromptText.get()) {
            return;
        }
        this.promptText = new Text();
        this.promptText.setManaged(false);
        this.promptText.getStyleClass().add((Object)"text");
        this.promptText.visibleProperty().bind((ObservableValue)this.linesWrapper.usePromptText);
        this.promptText.fontProperty().bind((ObservableValue)((TextArea)this.getSkinnable()).fontProperty());
        this.promptText.textProperty().bind((ObservableValue)((TextArea)this.getSkinnable()).promptTextProperty());
        this.promptText.fillProperty().bind(this.linesWrapper.animatedPromptTextFill);
        this.promptText.setLayoutX(1.0);
        this.promptText.setTranslateX(1.0);
        this.promptText.getTransforms().add((Object)this.linesWrapper.promptTextScale);
        this.linesWrapper.promptContainer.getChildren().add((Object)this.promptText);
        if (((TextArea)this.getSkinnable()).isFocused() && ((JFXTextArea)this.getSkinnable()).isLabelFloat()) {
            this.promptText.setTranslateY(-Math.floor(this.scrollPane.getHeight()));
            this.linesWrapper.promptTextScale.setX(0.85);
            this.linesWrapper.promptTextScale.setY(0.85);
        }
        try {
            this.reflectionFieldConsumer("promptNode", JFXTextAreaSkin$$Lambda$3.lambdaFactory$(this));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private <T> void reflectionFieldConsumer(String fieldName, CheckedConsumer<Field> consumer) {
        Field field = null;
        try {
            field = TextAreaSkin.class.getDeclaredField(fieldName);
            field.setAccessible(true);
            consumer.accept(field);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static /* synthetic */ void lambda$createPromptNode$2(JFXTextAreaSkin this_, Field field) throws Exception {
        Object oldValue = field.get((Object)this_);
        if (oldValue != null) {
            this_.removeHighlight(Arrays.asList((Node)oldValue));
        }
        field.set((Object)this_, this_.promptText);
    }

    static /* synthetic */ void lambda$new$1(JFXTextAreaSkin this_) {
        this_.createPromptNode();
    }

    static /* synthetic */ Text lambda$new$0(JFXTextAreaSkin this_) {
        return this_.promptText;
    }

    private static interface CheckedConsumer<T> {
        public void accept(T var1) throws Exception;
    }
}

