/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls.cells.editors.base;

import com.jfoenix.controls.JFXTreeTableColumn;
import com.jfoenix.controls.cells.editors.TextFieldEditorBuilder;
import com.jfoenix.controls.cells.editors.base.EditorNodeBuilder;
import com.jfoenix.controls.cells.editors.base.GenericEditableTreeTableCell$$Lambda$1;
import com.jfoenix.controls.cells.editors.base.GenericEditableTreeTableCell$$Lambda$2;
import com.jfoenix.controls.cells.editors.base.GenericEditableTreeTableCell$$Lambda$3;
import com.jfoenix.controls.cells.editors.base.GenericEditableTreeTableCell$$Lambda$4;
import com.jfoenix.controls.cells.editors.base.JFXTreeTableCell;
import com.jfoenix.controls.datamodels.treetable.RecursiveTreeObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Region;

public class GenericEditableTreeTableCell<S, T>
extends JFXTreeTableCell<S, T> {
    protected EditorNodeBuilder builder;
    protected Region editorNode;
    private BiFunction<Integer, Integer, Integer> stepFunction;

    public GenericEditableTreeTableCell(EditorNodeBuilder builder) {
        this.stepFunction = GenericEditableTreeTableCell$$Lambda$1.lambdaFactory$();
        this.builder = builder;
    }

    public GenericEditableTreeTableCell() {
        this.stepFunction = GenericEditableTreeTableCell$$Lambda$2.lambdaFactory$();
        this.builder = new TextFieldEditorBuilder();
    }

    protected void commitHelper(boolean losingFocus) {
        block3: {
            if (this.editorNode == null) {
                return;
            }
            try {
                this.builder.validateValue();
                this.commitEdit(this.builder.getValue());
            }
            catch (Exception ex) {
                if (!losingFocus) break block3;
                this.cancelEdit();
            }
        }
    }

    protected Object getValue() {
        return this.getItem() == null ? "" : this.getItem();
    }

    public void startEdit() {
        if (this.isEditable() && this.checkGroupedColumn()) {
            super.startEdit();
            if (this.editorNode == null) {
                this.createEditorNode();
            } else {
                this.builder.setValue(this.getValue());
            }
            this.builder.startEdit();
            this.setGraphic((Node)this.editorNode);
            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        }
    }

    public void cancelEdit() {
        this.editorNode = null;
        super.cancelEdit();
        this.builder.cancelEdit();
        this.builder.setValue(this.getValue());
        this.setContentDisplay(ContentDisplay.TEXT_ONLY);
    }

    private boolean checkGroupedColumn() {
        boolean allowEdit = true;
        if (this.getTreeTableRow().getTreeItem() != null) {
            Object rowObject = this.getTreeTableRow().getTreeItem().getValue();
            if (rowObject instanceof RecursiveTreeObject && rowObject.getClass() == RecursiveTreeObject.class) {
                allowEdit = false;
            } else if (this.getTableColumn() instanceof JFXTreeTableColumn && ((JFXTreeTableColumn)this.getTableColumn()).isGrouped() && this.getTreeTableRow().getTreeItem().getParent() != null && this.getTreeTableRow().getTreeItem().getParent().getValue().getClass() == RecursiveTreeObject.class) {
                allowEdit = false;
            }
        }
        return allowEdit;
    }

    public void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else if (this.isEditing() && this.checkGroupedColumn()) {
            if (this.editorNode != null) {
                this.builder.setValue(this.getValue());
            }
            this.setGraphic((Node)this.editorNode);
            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            this.builder.updateItem(item, empty);
        } else {
            Object value = this.getValue();
            if (value instanceof Node) {
                this.setGraphic((Node)value);
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            } else {
                this.setText(value.toString());
                this.setContentDisplay(ContentDisplay.TEXT_ONLY);
            }
        }
    }

    private void createEditorNode() {
        EventHandler keyEventsHandler = GenericEditableTreeTableCell$$Lambda$3.lambdaFactory$(this);
        ChangeListener focusChangeListener = GenericEditableTreeTableCell$$Lambda$4.lambdaFactory$(this);
        this.editorNode = this.builder.createNode(this.getValue(), (EventHandler<KeyEvent>)keyEventsHandler, (ChangeListener<Boolean>)focusChangeListener);
    }

    public BiFunction<Integer, Integer, Integer> getStepFunction() {
        return this.stepFunction;
    }

    public void setStepFunction(BiFunction<Integer, Integer, Integer> stepFunction) {
        this.stepFunction = stepFunction;
    }

    private void editNext(boolean forward) {
        ArrayList columns = new ArrayList();
        for (TreeTableColumn column : this.getTreeTableView().getColumns()) {
            columns.addAll(this.getLeaves(column));
        }
        int index = this.getIndex();
        int nextIndex = columns.indexOf(this.getTableColumn());
        if (forward) {
            if (++nextIndex > columns.size() - 1) {
                nextIndex = 0;
                index += this.stepFunction.apply(index, 1).intValue();
            }
        } else if (--nextIndex < 0) {
            nextIndex = columns.size() - 1;
            index += this.stepFunction.apply(index, -1).intValue();
        }
        if (columns.size() < 2 && index == this.getIndex()) {
            return;
        }
        TreeTableColumn nextColumn = (TreeTableColumn)columns.get(nextIndex);
        if (nextColumn != null) {
            this.getTreeTableView().edit(index, nextColumn);
            this.getTreeTableView().scrollToColumn(nextColumn);
        }
    }

    private List<TreeTableColumn<S, ?>> getLeaves(TreeTableColumn<S, ?> root) {
        ArrayList columns = new ArrayList();
        if (root.getColumns().isEmpty()) {
            if (root.isEditable()) {
                columns.add(root);
            }
            return columns;
        }
        for (TreeTableColumn column : root.getColumns()) {
            columns.addAll(this.getLeaves(column));
        }
        return columns;
    }

    static /* synthetic */ Integer lambda$new$2(Integer index, Integer direction) {
        return 0;
    }

    static /* synthetic */ void lambda$createEditorNode$1(GenericEditableTreeTableCell this_, ObservableValue observable, Boolean oldValue, Boolean newValue) {
        if (this_.editorNode != null && !newValue.booleanValue()) {
            this_.commitHelper(true);
        }
    }

    static /* synthetic */ void lambda$createEditorNode$0(GenericEditableTreeTableCell this_, KeyEvent t) {
        if (t.getCode() == KeyCode.ENTER) {
            this_.commitHelper(false);
        } else if (t.getCode() == KeyCode.ESCAPE) {
            this_.cancelEdit();
        } else if (t.getCode() == KeyCode.TAB) {
            this_.commitHelper(false);
            this_.editNext(!t.isShiftDown());
        }
    }
}

