scriptname ImmersiveFPConfig extends SKI_ConfigBase

int Property MaxProfiles = 12 Auto

float[] fpFov1
float[] fpFov2
float[] fpFov3
float[] fpFov4
float[] fpDist1
float[] fpDist2
float[] fpDist3
float[] fpRot1
float[] fpRot2
float[] fpRot3
float[] fpRestrict
float[] fpNearNear
float[] fpNearFar
float[] fpFadeIn
float[] fpFadeOut
int[] fpFlags
int[] fpFlags2
float[] fpSet1
float[] fpSet2
float[] fpSet3
float[] fpSet4
float[] fpSet5
float[] fpSet6
float[] fpSet7
float[] fpSet8
int[] fpKey

int mpKey
int mpClip
int mpRot

int[] OIDs
int iData = 0
int iPage = -1
int iProfile = 0
int pProfile = -1

;/
0 - auto near interior
1 - far mode is flipped
/;

function SetData(int index, bool apply = true)
	if(index < 0 || index >= 32)
		return
	endif

	int j = Math.LeftShift(1, index)
	if(apply)
		if(Math.LogicalAnd(iData, j) != 0)
			return
		endif

		iData = Math.LogicalOr(iData, j)
		c_SetData(iData)
	else
		if(Math.LogicalAnd(iData, j) == 0)
			return
		endif

		iData = Math.LogicalAnd(iData, Math.LogicalNot(j))
		c_SetData(iData)
	endif
endfunction

function ToggleData(int index)
	if(!GetData(index))
		SetData(index, true)
	else
		SetData(index, false)
	endif
endfunction

bool function GetData(int index)
	if(index < 0 || index >= 32)
		return false
	endif

	int j = Math.LeftShift(1, index)
	return Math.LogicalAnd(iData, j) != 0
endfunction

int function GetProfileAction(int index)
	int i = 0
	if(index <= 12)
		int j = Math.LeftShift(4096, index)
		while(i < MaxProfiles)
			if(Math.LogicalAnd(fpFlags[i], j) != 0)
				return i
			endif
			i += 1
		endwhile
	else
		int j = Math.LeftShift(1, index - 13)
		while(i < MaxProfiles)
			if(Math.LogicalAnd(fpFlags2[i], j) != 0)
				return i
			endif
			i += 1
		endwhile
	endif

	return -1
endfunction

function SetProfileAction(int profile, int index)
	int prev = GetProfileAction(index)
	if(prev == profile)
		return
	endif
	
	if(index <= 12)
		int j = Math.LeftShift(4096, index)

		if(prev >= 0)
			fpFlags[prev] = Math.LogicalAnd(fpFlags[prev], Math.LogicalNot(j))
			UpdateConfig(prev)
		endif

		if(profile >= 0)
			fpFlags[profile] = Math.LogicalOr(fpFlags[profile], j)
			UpdateConfig(profile)
		endif
	else
		int j = Math.LeftShift(1, index - 13)

		if(prev >= 0)
			fpFlags2[prev] = Math.LogicalAnd(fpFlags2[prev], Math.LogicalNot(j))
			UpdateConfig(prev)
		endif

		if(profile >= 0)
			fpFlags2[profile] = Math.LogicalOr(fpFlags2[profile], j)
			UpdateConfig(profile)
		endif
	endif
endfunction

function UpdateConfig(int index)
	c_SetConfig1(index, fpFov1[index] * 0.01, fpFov2[index] * 0.01, fpFov3[index] * 0.01, fpDist1[index] * 0.01, fpDist2[index] * 0.01, fpDist3[index] * 0.01, fpRot1[index] * 0.01, fpRot2[index], fpRot3[index])
	c_SetConfig2(index, fpRestrict[index], fpFlags[index], fpFadeIn[index], fpFadeOut[index], fpNearNear[index] * 0.01, fpNearFar[index] * 0.01, fpFov4[index])
	c_SetConfig3(index, fpFlags2[index], fpSet1[index], fpSet2[index], fpSet3[index], fpSet4[index], fpSet5[index], fpSet6[index], fpSet7[index], fpSet8[index])
endfunction

function c_SetFP(ObjectReference owner) global native

bool function c_IsFP() global native

function c_SetConfig1(int index, float fov1, float fov2, float fov3, float dist1, float dist2, float dist3, float rot1, float rot2, float rot3) global native

function c_SetConfig2(int index, float restrict, int flags, float fadein, float fadeout, float near1, float near2, float gameFov) global native

function c_SetConfig3(int index, int flags2, float set1, float set2, float set3, float set4, float set5, float set6, float set7, float set8) global native

function c_SetProfile(int index) global native

function c_SetData(int data) global native

bool function c_SaveFile(bool save) global native

float function c_GetSetting(int index, int index2) global native

float function c_GetFOV() global native

;int function c_DebugFP() global native

int function GetVersion()
	return 2
endFunction

event OnConfigInit()
	fpFov1 = new float[12]
	fpFov2 = new float[12]
	fpFov3 = new float[12]
	fpFov4 = new float[12]
	fpDist1 = new float[12]
	fpDist2 = new float[12]
	fpDist3 = new float[12]
	fpRot1 = new float[12]
	fpRot2 = new float[12]
	fpRot3 = new float[12]
	fpRestrict = new float[12]
	fpNearNear = new float[12]
	fpNearFar = new float[12]
	fpFadeIn = new float[12]
	fpFadeOut = new float[12]
	fpFlags = new int[12]
	fpKey = new int[12]
	fpFlags2 = new int[12]
	fpSet1 = new float[12]
	fpSet2 = new float[12]
	fpSet3 = new float[12]
	fpSet4 = new float[12]
	fpSet5 = new float[12]
	fpSet6 = new float[12]
	fpSet7 = new float[12]
	fpSet8 = new float[12]

	mpKey = 0
	mpClip = 0

	int i = 0
	while(i < MaxProfiles)
		fpFov1[i] = 100.0
		fpFov2[i] = 100.0
		fpFov3[i] = 100.0
		fpFov4[i] = 85.0
		fpDist1[i] = 100.0
		fpDist2[i] = 0.0
		fpDist3[i] = 0.0
		fpRot1[i] = 100.0
		fpRot2[i] = 90.0
		fpRot3[i] = 0.0
		fpRestrict[i] = 90.0
		fpNearNear[i] = 30.0
		fpNearFar[i] = 700.0
		fpFadeIn[i] = 500.0
		fpFadeOut[i] = 0.0
		fpFlags[i] = 0
		fpKey[i] = 0
		fpFlags2[i] = 0
		fpSet1[i] = 0.0
		fpSet2[i] = 0.0
		fpSet3[i] = 0.0
		fpSet4[i] = 100.0
		fpSet5[i] = 0.0
		fpSet6[i] = 0.0
		fpSet7[i] = 0.0
		fpSet8[i] = 0.0

		; profile 2 for running
		if(i == 1)
			fpRot1[i] = 40.0
			fpFadeIn[i] = 200.0

		; profile 3 for sneaking
		elseif(i == 2)
			fpRot1[i] = 20.0

		; profile 4 for killmove
		elseif(i == 3)
			fpNearFar[i] = 30.0
			fpFov4[i] = fpFov4[i] + 20.0
			;fpSet4[i] = 100.0

		; profile 5 for custom
		elseif(i == 4)
			fpNearFar[i] = 30.0

		; profile 6 is for bow
		elseif(i == 5)
			fpNearFar[i] = 30.0
			fpDist3[i] = 50.0
			fpRot1[i] = 0.0
			fpFov4[i] = fpFov4[i] - 20.0

		; profile 7 is for weapon out
		elseif(i == 6)
			fpNearFar[i] = 30.0
			fpRot1[i] = 50.0
			fpFov4[i] = fpFov4[i] + 10.0
		
		; end
		endif

		UpdateConfig(i)

		i += 1
	endwhile

	SetProfileAction(1, 5) ; run
	SetProfileAction(2, 4) ; sneak
	SetProfileAction(3, 0) ; killmove
	SetProfileAction(4, 7) ; custom
	SetProfileAction(5, 8) ; bow
	SetProfileAction(6, 12) ; weapon out

	OIDs = new int[32]

	RegisterForEvents(true)
endevent

event OnPageReset(string page)
	iPage = -1

	if(page == "")
		SetCursorFillMode(LEFT_TO_RIGHT)
		AddTextOption("Camera:", "When to use view and profiles")
		AddEmptyOption()
		AddTextOption("Profiles:", "Change shaking, position, FOV")
	endif

	; General settings
	if(page == Pages[0])
		iPage = 0

	; Profiles
	elseif(page == Pages[1])
		iPage = 1
	elseif(page == Pages[2])
		iPage = 2
	elseif(page == Pages[3])
		iPage = 3
	elseif(page == Pages[4])
		iPage = 4
	elseif(page == Pages[5])
		iPage = 5
	elseif(page == Pages[6])
		iPage = 6
	elseif(page == Pages[7])
		iPage = 7
	elseif(page == Pages[8])
		iPage = 8
	elseif(page == Pages[9])
		iPage = 9
	elseif(page == Pages[10])
		iPage = 10
	endif

	; Show general tab
	if(iPage == 0)
		SetCursorFillMode(LEFT_TO_RIGHT)
		AddHeaderOption("Hotkeys")
		AddEmptyOption()
		OIDs[0] = AddKeyMapOption("Toggle immersive first person view", mpKey, OPTION_FLAG_WITH_UNMAP)
		OIDs[1] = AddKeyMapOption("Toggle flipped near or far view", mpClip, OPTION_FLAG_WITH_UNMAP)
		;OIDs[2] = AddKeyMapOption("Toggle rotation from head temporarily", mpRot, OPTION_FLAG_WITH_UNMAP)
		;AddEmptyOption()
		;SetCursorFillMode(TOP_TO_BOTTOM)
		AddHeaderOption("Profile overrides")
		AddEmptyOption()
		OIDs[3] = AddToggleOption("Auto near view in interior", GetData(0))

		int ov = GetProfileAction(11)
		string ovn = "Default profile"
		if(ov >= 0)
			if(ov == 10)
				ovn = "Vanilla first person"
			elseif(ov == 11)
				ovn = "Vanilla third person"
			else
				ovn = "Profile " + (ov + 1)
			endif
		endif
		OIDs[18] = AddMenuOption("Dead", ovn)

		ov = GetProfileAction(7)
		ovn = "Default profile"
		if(ov >= 0)
			if(ov == 10)
				ovn = "Vanilla first person"
			elseif(ov == 11)
				ovn = "Vanilla third person"
			else
				ovn = "Profile " + (ov + 1)
			endif
		endif
		OIDs[12] = AddMenuOption("Custom", ovn)

		ov = GetProfileAction(0)
		ovn = "Default profile"
		if(ov >= 0)
			if(ov == 10)
				ovn = "Vanilla first person"
			elseif(ov == 11)
				ovn = "Vanilla third person"
			else
				ovn = "Profile " + (ov + 1)
			endif
		endif
		OIDs[4] = AddMenuOption("Killmove", ovn)

		ov = GetProfileAction(9)
		ovn = "Default profile"
		if(ov >= 0)
			if(ov == 10)
				ovn = "Vanilla first person"
			elseif(ov == 11)
				ovn = "Vanilla third person"
			else
				ovn = "Profile " + (ov + 1)
			endif
		endif
		OIDs[14] = AddMenuOption("Werewolf", ovn)

		ov = GetProfileAction(10)
		ovn = "Default profile"
		if(ov >= 0)
			if(ov == 10)
				ovn = "Vanilla first person"
			elseif(ov == 11)
				ovn = "Vanilla third person"
			else
				ovn = "Profile " + (ov + 1)
			endif
		endif
		OIDs[15] = AddMenuOption("Vampire Lord", ovn)

		ov = GetProfileAction(13)
		ovn = "Default profile"
		if(ov >= 0)
			if(ov == 10)
				ovn = "Vanilla first person"
			elseif(ov == 11)
				ovn = "Vanilla third person"
			else
				ovn = "Profile " + (ov + 1)
			endif
		endif
		OIDs[20] = AddMenuOption("Dialogue", ovn)

		ov = GetProfileAction(6)
		ovn = "Default profile"
		if(ov >= 0)
			if(ov == 10)
				ovn = "Vanilla first person"
			elseif(ov == 11)
				ovn = "Vanilla third person"
			else
				ovn = "Profile " + (ov + 1)
			endif
		endif
		OIDs[5] = AddMenuOption("Aim magic", ovn)

		ov = GetProfileAction(8)
		ovn = "Default profile"
		if(ov >= 0)
			if(ov == 10)
				ovn = "Vanilla first person"
			elseif(ov == 11)
				ovn = "Vanilla third person"
			else
				ovn = "Profile " + (ov + 1)
			endif
		endif
		OIDs[13] = AddMenuOption("Aim bow", ovn)

		ov = GetProfileAction(1)
		ovn = "Default profile"
		if(ov >= 0)
			if(ov == 10)
				ovn = "Vanilla first person"
			elseif(ov == 11)
				ovn = "Vanilla third person"
			else
				ovn = "Profile " + (ov + 1)
			endif
		endif
		OIDs[6] = AddMenuOption("On mount", ovn)

		ov = GetProfileAction(2)
		ovn = "Default profile"
		if(ov >= 0)
			if(ov == 10)
				ovn = "Vanilla first person"
			elseif(ov == 11)
				ovn = "Vanilla third person"
			else
				ovn = "Profile " + (ov + 1)
			endif
		endif
		OIDs[7] = AddMenuOption("Sprinting", ovn)

		ov = GetProfileAction(12)
		ovn = "Default profile"
		if(ov >= 0)
			if(ov == 10)
				ovn = "Vanilla first person"
			elseif(ov == 11)
				ovn = "Vanilla third person"
			else
				ovn = "Profile " + (ov + 1)
			endif
		endif
		OIDs[19] = AddMenuOption("Weapon drawn", ovn)

		ov = GetProfileAction(4)
		ovn = "Default profile"
		if(ov >= 0)
			if(ov == 10)
				ovn = "Vanilla first person"
			elseif(ov == 11)
				ovn = "Vanilla third person"
			else
				ovn = "Profile " + (ov + 1)
			endif
		endif
		OIDs[8] = AddMenuOption("Sneaking", ovn)

		ov = GetProfileAction(3)
		ovn = "Default profile"
		if(ov >= 0)
			if(ov == 10)
				ovn = "Vanilla first person"
			elseif(ov == 11)
				ovn = "Vanilla third person"
			else
				ovn = "Profile " + (ov + 1)
			endif
		endif
		OIDs[9] = AddMenuOption("Combat", ovn)

		ov = GetProfileAction(5)
		ovn = "Default profile"
		if(ov >= 0)
			if(ov == 10)
				ovn = "Vanilla first person"
			elseif(ov == 11)
				ovn = "Vanilla third person"
			else
				ovn = "Profile " + (ov + 1)
			endif
		endif
		OIDs[10] = AddMenuOption("Running", ovn)
	
		if(iProfile == 10)
			ovn = "Vanilla first person"
		elseif(iProfile == 11)
			ovn = "Vanilla first person"
		else
			ovn = "Profile " + (iProfile + 1)
		endif
		OIDs[11] = AddMenuOption("Default profile", ovn)
		AddEmptyOption()
		AddHeaderOption("File saving")
		AddEmptyOption()
		OIDs[16] = AddToggleOption("Save current settings to file", false)
		OIDs[17] = AddToggleOption("Load settings from file", false)
	; Show profile options
	elseif(iPage >= 1)
		SetCursorFillMode(LEFT_TO_RIGHT)
		AddHeaderOption("Field of view settings")
		AddEmptyOption()
		OIDs[16] = AddSliderOption("Game FOV", fpFov4[iPage - 1])
		OIDs[0] = AddSliderOption("Debug FOV scale 1", fpFov1[iPage - 1])
		OIDs[1] = AddSliderOption("Debug FOV scale 2", fpFov2[iPage - 1])
		OIDs[2] = AddSliderOption("Debug FOV scale 3", fpFov3[iPage - 1])
		;AddEmptyOption()
		AddHeaderOption("Position offset settings")
		AddEmptyOption()
		OIDs[3] = AddSliderOption("Camera back / forward modifier", fpDist1[iPage - 1])
		OIDs[4] = AddSliderOption("Camera left / right modifier", fpDist2[iPage - 1])
		OIDs[5] = AddSliderOption("Camera down / up modifier", fpDist3[iPage - 1])
		AddEmptyOption()
		AddHeaderOption("Rotation / head bobbing settings")
		AddEmptyOption()
		OIDs[6] = AddSliderOption("Rotation modifier", fpRot1[iPage - 1])
		;OIDs[7] = AddSliderOption("Vertical rotation modifier", fpRot2[iPage - 1])
		;OIDs[8] = AddSliderOption("Tilting rotation modifier", fpRot3[iPage - 1])
		AddEmptyOption()
		AddHeaderOption("Other settings")
		AddEmptyOption()
		OIDs[9] = AddSliderOption("Restricted angle (left/right)", fpRestrict[iPage - 1])
		OIDs[17] = AddSliderOption("Restricted angle (up/down)", fpRot2[iPage - 1])

		OIDs[10] = AddSliderOption("Near distance (near mode)", fpNearNear[iPage - 1])
		OIDs[11] = AddSliderOption("Near distance (far mode)", fpNearFar[iPage - 1])

		OIDs[12] = AddSliderOption("Fade-in duration", fpFadeIn[iPage - 1])
		OIDs[13] = AddSliderOption("Fade-out duration", fpFadeOut[iPage - 1])

		OIDs[14] = AddKeyMapOption("Profile hotkey", fpKey[iPage - 1], OPTION_FLAG_WITH_UNMAP)
		OIDs[15] = AddToggleOption("Disable HUD/menus", Math.LogicalAnd(fpFlags[iPage - 1], 2048) != 0)

		OIDs[18] = AddToggleOption("Disable headtracking", Math.LogicalAnd(fpFlags[iPage - 1], 1024) == 0)
		OIDs[19] = AddToggleOption("Character turns where you look", Math.LogicalAnd(fpFlags[iPage - 1], 512) != 0)

		;OIDs[20] = AddSliderOption("Character turn angle", fpRot3[iPage - 1])
		OIDs[21] = AddToggleOption("Hotkey must be held down", Math.LogicalAnd(fpFlags[iPage - 1], 256) != 0)
		OIDs[25] = AddSliderOption("Time scale", fpSet4[iPage - 1])

		;AddEmptyOption()

		;AddHeaderOption("Rotation offset settings")
		;AddEmptyOption()
		;OIDs[22] = AddSliderOption("Horizontal offset", fpSet1[iPage - 1])
		;OIDs[23] = AddSliderOption("Vertical offset", fpSet2[iPage - 1])
		;OIDs[24] = AddSliderOption("Tilt offset", fpSet3[iPage - 1])
	; End
	endif
endevent

event OnOptionDefault(int option)
	if(option == OIDs[0])
		if(iPage == 0)
			int wkey = mpKey
			bool hadOldKey = HasKeyBind(wkey)
			mpKey = 1
			bool hasOldKey = HasKeyBind(wkey)
			if(hadOldKey && !hasOldKey)
				UnregisterForKey(wkey)
			endif
			SetKeyMapOptionValue(option, mpKey)
		elseif(iPage >= 1)
			fpFov1[iPage - 1] = 100.0
			SetSliderOptionValue(option, 100.0)
			UpdateConfig(iPage - 1)
		endif
	elseif(option == OIDs[1])
		if(iPage == 0)
			int wkey = mpClip
			bool hadOldKey = HasKeyBind(wkey)
			mpClip = 1
			bool hasOldKey = HasKeyBind(wkey)
			if(hadOldKey && !hasOldKey)
				UnregisterForKey(wkey)
			endif
			SetKeyMapOptionValue(option, mpClip)
		elseif(iPage >= 1)
			fpFov2[iPage - 1] = 100.0
			SetSliderOptionValue(option, 100.0)
			UpdateConfig(iPage - 1)
		endif
	elseif(option == OIDs[2])
		if(iPage == 0)
			int wkey = mpRot
			bool hadOldKey = HasKeyBind(wkey)
			mpRot = 1
			bool hasOldKey = HasKeyBind(wkey)
			if(hadOldKey && !hasOldKey)
				UnregisterForKey(wkey)
			endif
			SetKeyMapOptionValue(option, mpRot)
		elseif(iPage >= 1)
			fpFov3[iPage - 1] = 100.0
			SetSliderOptionValue(option, 100.0)
			UpdateConfig(iPage - 1)
		endif
	elseif(option == OIDs[3])
		if(iPage >= 1)
			fpDist1[iPage - 1] = 100.0
			SetSliderOptionValue(option, 100.0)
			UpdateConfig(iPage - 1)
		elseif(iPage == 0)
			SetData(0, false)
			SetToggleOptionValue(option, false)
		endif
	elseif(option == OIDs[4])
		if(iPage >= 1)
			fpDist2[iPage - 1] = 0.0
			SetSliderOptionValue(option, 0.0)
			UpdateConfig(iPage - 1)
		endif
	elseif(option == OIDs[5])
		if(iPage >= 1)
			fpDist3[iPage - 1] = 0.0
			SetSliderOptionValue(option, 0.0)
			UpdateConfig(iPage - 1)
		endif
	elseif(option == OIDs[6])
		if(iPage >= 1)
			fpRot1[iPage - 1] = 100.0
			SetSliderOptionValue(option, 0.0)
			UpdateConfig(iPage - 1)
		endif
	elseif(option == OIDs[7])
		if(iPage >= 1)
			fpRot2[iPage - 1] = 100.0
			SetSliderOptionValue(option, 0.0)
			UpdateConfig(iPage - 1)
		endif
	elseif(option == OIDs[8])
		if(iPage >= 1)
			fpRot3[iPage - 1] = 100.0
			SetSliderOptionValue(option, 0.0)
			UpdateConfig(iPage - 1)
		endif
	elseif(option == OIDs[9])
		if(iPage >= 1)
			fpRestrict[iPage - 1] = 90.0
			SetSliderOptionValue(option, 0.0)
			UpdateConfig(iPage - 1)
		endif
	elseif(option == OIDs[10])
		if(iPage >= 1)
			fpNearNear[iPage - 1] = 30.0
			SetSliderOptionValue(option, 30.0)
			UpdateConfig(iPage - 1)
		endif
	elseif(option == OIDs[11])
		if(iPage >= 1)
			fpNearFar[iPage - 1] = 700.0
			SetSliderOptionValue(option, 700.0)
			UpdateConfig(iPage - 1)
		endif
	elseif(option == OIDs[12])
		if(iPage >= 1)
			fpFadeIn[iPage - 1] = 500
			SetSliderOptionValue(option, 500.0)
			UpdateConfig(iPage - 1)
		endif
	elseif(option == OIDs[13])
		if(iPage >= 1)
			fpFadeOut[iPage - 1] = 0
			SetSliderOptionValue(option, 0.0)
			UpdateConfig(iPage - 1)
		endif
	elseif(option == OIDs[14])
		if(iPage >= 1)
			int wkey = fpKey[iPage - 1]
			bool hadOldKey = HasKeyBind(wkey)
			fpKey[iPage - 1] = 1
			bool hasOldKey = HasKeyBind(wkey)
			if(hadOldKey && !hasOldKey)
				UnregisterForKey(wkey)
			endif
			SetKeyMapOptionValue(option, 1)
		endif
	elseif(option == OIDs[15])
		if(iPage >= 1)
			if(Math.LogicalAnd(fpFlags[iPage - 1], 2048) != 0)
				fpFlags[iPage - 1] = Math.LogicalAnd(fpFlags[iPage - 1], Math.LogicalNot(2048))
				UpdateConfig(iPage - 1)
				SetToggleOptionValue(option, false)
			endif
		endif
	elseif(option == OIDs[16])
		if(iPage >= 1)
			fpFov4[iPage - 1] = 95.0
			SetSliderOptionValue(option, 95.0)
			UpdateConfig(iPage - 1)
		endif
	elseif(option == OIDs[17])
		if(iPage >= 1)
			fpRot2[iPage - 1] = 90.0
			SetSliderOptionValue(option, 90.0)
			UpdateConfig(iPage - 1)
		endif
	elseif(option == OIDs[18])
		if(iPage >= 1)
			fpFlags[iPage - 1] = Math.LogicalAnd(fpFlags[iPage - 1], Math.LogicalNot(1024))
			SetToggleOptionValue(option, true)
			UpdateConfig(iPage - 1)
		endif
	elseif(option == OIDs[19])
		if(iPage >= 1)
			fpFlags[iPage - 1] = Math.LogicalAnd(fpFlags[iPage - 1], Math.LogicalNot(512))
			SetToggleOptionValue(option, false)
			UpdateConfig(iPage - 1)
		endif
	elseif(option == OIDs[20])
		if(iPage >= 1)
			fpRot3[iPage - 1] = 0.0
			SetSliderOptionValue(option, 0.0)
			UpdateConfig(iPage - 1)
		endif
	elseif(option == OIDs[21])
		if(iPage >= 1)
			fpFlags[iPage - 1] = Math.LogicalAnd(fpFlags[iPage - 1], Math.LogicalNot(256))
			SetToggleOptionValue(option, false)
			UpdateConfig(iPage - 1)
		endif
	elseif(option == OIDs[22])
		if(iPage >= 1)
			fpSet1[iPage - 1] = 0.0
			SetSliderOptionValue(option, 0.0)
			UpdateConfig(iPage - 1)
		endif
	elseif(option == OIDs[23])
		if(iPage >= 1)
			fpSet2[iPage - 1] = 0.0
			SetSliderOptionValue(option, 0.0)
			UpdateConfig(iPage - 1)
		endif
	elseif(option == OIDs[24])
		if(iPage >= 1)
			fpSet3[iPage - 1] = 0.0
			SetSliderOptionValue(option, 0.0)
			UpdateConfig(iPage - 1)
		endif
	elseif(option == OIDs[25])
		if(iPage >= 1)
			fpSet4[iPage - 1] = 100.0
			SetSliderOptionValue(option, 100.0)
			UpdateConfig(iPage - 1)
		endif
	endif
endevent

event OnOptionHighlight(int option)
	if(option == OIDs[0])
		if(iPage == 0)
			SetInfoText("Hotkey to toggle between immersive first person and normal camera.\nDefault: not set")
		elseif(iPage >= 1)
			SetInfoText("FOV modifier. All modify scale of camera in different ways. This is for experimental use - it will screw up particles and shadows.\nDefault: 100")
		endif
	elseif(option == OIDs[1])
		if(iPage == 0)
			SetInfoText("Toggle between flipped near mode and far mode.\nDefault: not set")
		elseif(iPage >= 1)
			SetInfoText("FOV modifier. All modify scale of camera in different ways. This is for experimental use - it will screw up particles and shadows.\nDefault: 100")
		endif
	elseif(option == OIDs[2])
		if(iPage == 0)
			SetInfoText("Toggle rotation changes to camera.\nDefault: not set")
		elseif(iPage >= 1)
			SetInfoText("FOV modifier. All modify scale of camera in different ways. This is for experimental use - it will screw up particles and shadows.\nDefault: 100")
		endif
	elseif(option == OIDs[3])
		if(iPage >= 1)
			SetInfoText("Move camera position forward or backward.\nDefault: 100")
		elseif(iPage == 0)
			SetInfoText("Automatically switch to near view mode when in interiors.\nDefault: false")
		endif
	elseif(option == OIDs[4])
		if(iPage >= 1)
			SetInfoText("Move camera position left or right.\nDefault: 0")
		elseif(iPage == 0)
			SetInfoText("Override default profile with this profile while character is performing a kill move.\nDefault: not set")
		endif
	elseif(option == OIDs[5])
		if(iPage >= 1)
			SetInfoText("Move camera position up or down.\nDefault: 0")
		elseif(iPage == 0)
			SetInfoText("Override default profile with this profile while aiming with magic.\nDefault: not set")
		endif
	elseif(option == OIDs[6])
		if(iPage >= 1)
			SetInfoText("Set how much rotation the camera receives from character's head.\nDefault: 100")
		elseif(iPage == 0)
			SetInfoText("Override default profile with this profile while character is on a mount.\nDefault: not set")
		endif
	elseif(option == OIDs[7])
		if(iPage >= 1)
			SetInfoText("Set how much vertical rotation the camera receives from character's head.\nDefault: 100")
		elseif(iPage == 0)
			SetInfoText("Override default profile with this profile while character is sprinting.\nDefault: not set")
		endif
	elseif(option == OIDs[8])
		if(iPage >= 1)
			SetInfoText("Set how much tilting rotation the camera receives from character's head.\nDefault: 100")
		elseif(iPage == 0)
			SetInfoText("Override default profile with this profile while character is sneaking.\nDefault: not set")
		endif
	elseif(option == OIDs[9])
		if(iPage >= 1)
			SetInfoText("Set the angle that restricts looking to your side. 0 means you can't look around at all and 180 means there is no restriction for looking around.\nDefault: 110")
		elseif(iPage == 0)
			SetInfoText("Override default profile with this profile while character is in combat.\nDefault: not set")
		endif
	elseif(option == OIDs[10])
		if(iPage >= 1)
			SetInfoText("If something is closer to the camera than this distance then it will not be drawn. This is the value for near view mode. Setting this too low will cause mountains to flicker in the distance.\nDefault: 30")
		elseif(iPage == 0)
			SetInfoText("Override default profile with this profile while character is running.\nDefault: not set")
		endif
	elseif(option == OIDs[11])
		if(iPage >= 1)
			SetInfoText("If something is closer to the camera than this distance then it will not be drawn. This is the value for far view mode. Setting this too low will cause mountains to flicker in the distance.\nDefault: 700")
		elseif(iPage == 0)
			SetInfoText("Current profile to use when there are no overrides active.\nDefault: not set")
		endif
	elseif(option == OIDs[12])
		if(iPage >= 1)
			SetInfoText("Amount of time in milliseconds it takes to fade into this profile. One second is 1000 milliseconds. Actual fading time is sum of new profile's fade-in time and old profile's fade-out time.\nDefault: 500")
		elseif(iPage == 0)
			SetInfoText("Override default profile with this profile while few custom animations are playing. Right now only SexLab animations are included in this option.\nDefault: not set")
		endif
	elseif(option == OIDs[13])
		if(iPage >= 1)
			SetInfoText("Amount of time in milliseconds it takes to fade out from this profile. One second is 1000 milliseconds. Actual fading time is sum of new profile's fade-in time and old profile's fade-out time.\nDefault: 0")
		elseif(iPage == 0)
			SetInfoText("Override default profile with this profile while aiming with bow.\nDefault: not set")
		endif
	elseif(option == OIDs[14])
		if(iPage >= 1)
			SetInfoText("Hotkey that will set this as default profile. If more than one profile has same hotkey then we will cycle between those profiles each time hotkey is pressed.\nDefault: not set")
		elseif(iPage == 0)
			SetInfoText("Override default profile with this profile while in werewolf form.\nDefault: not set")
		endif
	elseif(option == OIDs[15])
		if(iPage >= 1)
			SetInfoText("Disable all HUD and menus while in this profile. Exiting immersive first person view or choosing another profile without this option re-enables menus.\nDefault: false")
		elseif(iPage == 0)
			SetInfoText("Override default profile with this profile while in vampire lord form.\nDefault: not set")
		endif
	elseif(option == OIDs[16])
		if(iPage >= 1)
			SetInfoText("FOV to use while in this profile.\nDefault: 95")
		elseif(iPage == 0)
			SetInfoText("Save all settings except hotkeys to a file and replace if already exists.")
		endif
	elseif(option == OIDs[17])
		if(iPage >= 1)
			SetInfoText("Set the angle that restricts looking up and down. 0 means you can't look at all and 90 means you can look down and up as in vanilla Skyrim.\nDefault: 90")
		elseif(iPage == 0)
			SetInfoText("Load all settings from file except hotkeys. You will lose all your current settings if you do this!")
		endif
	elseif(option == OIDs[18])
		if(iPage >= 1)
			SetInfoText("Disable headtracking mods while in immersive view.\nDefault: true")
		elseif(iPage == 0)
			SetInfoText("Override default profile with this profile when you die.\nDefault: not set")
		endif
	elseif(option == OIDs[19])
		if(iPage >= 1)
			SetInfoText("Character always turns where you look, as if you had a weapon drawn.\nDefault: false")
		elseif(iPage == 0)
			SetInfoText("Override default profile with this profile when you have weapons out.\nDefault: not set")
		endif
	elseif(option == OIDs[20])
		if(iPage >= 1)
			SetInfoText("Angle when character starts to turn if the always turn option is enabled. If angle is 90 then character will only turn to face camera if you are looking 90 degrees left or right. 0 means always turn.\nDefault: 0")
		elseif(iPage == 0)
			SetInfoText("Override default profile with this profile while you are in dialogue with an NPC.\nDefault: not set")
		endif
	elseif(option == OIDs[21])
		if(iPage >= 1)
			SetInfoText("Profile is only active while the hotkey is held down. If the hotkey is released we switch back to previous default profile.\nDefault: false")
		endif
	elseif(option == OIDs[22])
		if(iPage >= 1)
			SetInfoText("Change the horizontal camera angle.\nDefault: 0")
		endif
	elseif(option == OIDs[23])
		if(iPage >= 1)
			SetInfoText("Change the vertical camera angle.\nDefault: 0")
		endif
	elseif(option == OIDs[24])
		if(iPage >= 1)
			SetInfoText("Change the tilting camera angle.\nDefault: 0")
		endif
	elseif(option == OIDs[25])
		if(iPage >= 1)
			SetInfoText("Speed of time in per cent. 50 means time moves at half speed.\nDefault: 100")
		endif
	endif
endevent

event OnOptionSliderOpen(int option)
	if(option == OIDs[0])
		SetSliderDialogStartValue(fpFov1[iPage - 1])
		SetSliderDialogDefaultValue(100.0)
		SetSliderDialogRange(10.0, 200.0)
		SetSliderDialogInterval(1.0)
	elseif(option == OIDs[1])
		SetSliderDialogStartValue(fpFov2[iPage - 1])
		SetSliderDialogDefaultValue(100.0)
		SetSliderDialogRange(10.0, 200.0)
		SetSliderDialogInterval(1.0)
	elseif(option == OIDs[2])
		SetSliderDialogStartValue(fpFov3[iPage - 1])
		SetSliderDialogDefaultValue(100.0)
		SetSliderDialogRange(10.0, 200.0)
		SetSliderDialogInterval(1.0)
	elseif(option == OIDs[3])
		SetSliderDialogStartValue(fpDist1[iPage - 1])
		SetSliderDialogDefaultValue(100.0)
		SetSliderDialogRange(-2500.0, 2500.0)
		SetSliderDialogInterval(1.0)
	elseif(option == OIDs[4])
		SetSliderDialogStartValue(fpDist2[iPage - 1])
		SetSliderDialogDefaultValue(0.0)
		SetSliderDialogRange(-2500.0, 2500.0)
		SetSliderDialogInterval(1.0)
	elseif(option == OIDs[5])
		SetSliderDialogStartValue(fpDist3[iPage - 1])
		SetSliderDialogDefaultValue(0.0)
		SetSliderDialogRange(-2500.0, 2500.0)
		SetSliderDialogInterval(1.0)
	elseif(option == OIDs[6])
		SetSliderDialogStartValue(fpRot1[iPage - 1])
		SetSliderDialogDefaultValue(100.0)
		SetSliderDialogRange(0.0, 100.0)
		SetSliderDialogInterval(1.0)
	elseif(option == OIDs[7])
		SetSliderDialogStartValue(fpRot2[iPage - 1])
		SetSliderDialogDefaultValue(100.0)
		SetSliderDialogRange(0.0, 100.0)
		SetSliderDialogInterval(1.0)
	elseif(option == OIDs[8])
		SetSliderDialogStartValue(fpRot3[iPage - 1])
		SetSliderDialogDefaultValue(100.0)
		SetSliderDialogRange(0.0, 100.0)
		SetSliderDialogInterval(1.0)
	elseif(option == OIDs[9])
		SetSliderDialogStartValue(fpRestrict[iPage - 1])
		SetSliderDialogDefaultValue(90.0)
		SetSliderDialogRange(0.0, 180.0)
		SetSliderDialogInterval(1.0)
	elseif(option == OIDs[10])
		SetSliderDialogStartValue(fpNearNear[iPage - 1])
		SetSliderDialogDefaultValue(30.0)
		SetSliderDialogRange(0.0, 2000.0)
		SetSliderDialogInterval(1.0)
	elseif(option == OIDs[11])
		SetSliderDialogStartValue(fpNearFar[iPage - 1])
		SetSliderDialogDefaultValue(700.0)
		SetSliderDialogRange(0.0, 2000.0)
		SetSliderDialogInterval(1.0)
	elseif(option == OIDs[12])
		SetSliderDialogStartValue(fpFadeIn[iPage - 1])
		SetSliderDialogDefaultValue(500.0)
		SetSliderDialogRange(0.0, 5000.0)
		SetSliderDialogInterval(100.0)
	elseif(option == OIDs[13])
		SetSliderDialogStartValue(fpFadeOut[iPage - 1])
		SetSliderDialogDefaultValue(0.0)
		SetSliderDialogRange(0.0, 5000.0)
		SetSliderDialogInterval(100.0)
	elseif(option == OIDs[16])
		SetSliderDialogStartValue(fpFov4[iPage - 1])
		SetSliderDialogDefaultValue(95.0)
		SetSliderDialogRange(30.0, 150.0)
		SetSliderDialogInterval(1.0)
	elseif(option == OIDs[17])
		SetSliderDialogStartValue(fpRot2[iPage - 1])
		SetSliderDialogDefaultValue(90.0)
		SetSliderDialogRange(0.0, 90.0)
		SetSliderDialogInterval(1.0)
	elseif(option == OIDs[20])
		SetSliderDialogStartValue(fpRot3[iPage - 1])
		SetSliderDialogDefaultValue(0.0)
		SetSliderDialogRange(0.0, 200.0)
		SetSliderDialogInterval(1.0)
	elseif(option == OIDs[22])
		SetSliderDialogStartValue(fpSet1[iPage - 1])
		SetSliderDialogDefaultValue(0.0)
		SetSliderDialogRange(-180.0, 180.0)
		SetSliderDialogInterval(1.0)
	elseif(option == OIDs[23])
		SetSliderDialogStartValue(fpSet2[iPage - 1])
		SetSliderDialogDefaultValue(0.0)
		SetSliderDialogRange(-180.0, 180.0)
		SetSliderDialogInterval(1.0)
	elseif(option == OIDs[24])
		SetSliderDialogStartValue(fpSet3[iPage - 1])
		SetSliderDialogDefaultValue(0.0)
		SetSliderDialogRange(-180.0, 180.0)
		SetSliderDialogInterval(1.0)
	elseif(option == OIDs[25])
		SetSliderDialogStartValue(fpSet4[iPage - 1])
		SetSliderDialogDefaultValue(100.0)
		SetSliderDialogRange(0.0, 500.0)
		SetSliderDialogInterval(1.0)
	endif
endevent

event OnOptionSliderAccept(int option, float value)
	if(option == OIDs[0])
		fpFov1[iPage - 1] = value
	elseif(option == OIDs[1])
		fpFov2[iPage - 1] = value
	elseif(option == OIDs[2])
		fpFov3[iPage - 1] = value
	elseif(option == OIDs[3])
		fpDist1[iPage - 1] = value
	elseif(option == OIDs[4])
		fpDist2[iPage - 1] = value
	elseif(option == OIDs[5])
		fpDist3[iPage - 1] = value
	elseif(option == OIDs[6])
		fpRot1[iPage - 1] = value
	elseif(option == OIDs[7])
		fpRot2[iPage - 1] = value
	elseif(option == OIDs[8])
		fpRot3[iPage - 1] = value
	elseif(option == OIDs[9])
		fpRestrict[iPage - 1] = value
	elseif(option == OIDs[10])
		fpNearNear[iPage - 1] = value
	elseif(option == OIDs[11])
		fpNearFar[iPage - 1] = value
	elseif(option == OIDs[12])
		fpFadeIn[iPage - 1] = value
	elseif(option == OIDs[13])
		fpFadeOut[iPage - 1] = value
	elseif(option == OIDs[16])
		fpFov4[iPage - 1] = value
	elseif(option == OIDs[17])
		fpRot2[iPage - 1] = value
	elseif(option == OIDs[20])
		fpRot3[iPage - 1] = value
	elseif(option == OIDs[22])
		fpSet1[iPage - 1] = value
	elseif(option == OIDs[23])
		fpSet2[iPage - 1] = value
	elseif(option == OIDs[24])
		fpSet3[iPage - 1] = value
	elseif(option == OIDs[25])
		fpSet4[iPage - 1] = value
	endif

	SetSliderOptionValue(option, value)
	if(iPage >= 1)
		UpdateConfig(iPage - 1)
	endif
endevent

event OnOptionSelect(int option)
	if(option == OIDs[3])
		ToggleData(0)
		SetToggleOptionValue(option, GetData(0))
	elseif(option == OIDs[15])
		if(iPage >= 1)
			if(Math.LogicalAnd(fpFlags[iPage - 1], 2048) != 0)
				fpFlags[iPage - 1] = Math.LogicalAnd(fpFlags[iPage - 1], Math.LogicalNot(2048))
				UpdateConfig(iPage - 1)
				SetToggleOptionValue(option, false)
			else
				fpFlags[iPage - 1] = Math.LogicalOr(fpFlags[iPage - 1], 2048)
				UpdateConfig(iPage - 1)
				SetToggleOptionValue(option, true)
			endif
		endif
	elseif(option == OIDs[16])
		if(iPage == 0)
			if(!SaveToFile())
				Debug.MessageBox("Failed to save settings to file.")
			else
				Debug.MessageBox("Saved all settings to file, except hotkeys.")
			endif
		endif
	elseif(option == OIDs[17])
		if(iPage == 0)
			if(!LoadFromFile())
				Debug.MessageBox("Failed to load settings from file.")
			else
				Debug.MessageBox("Loaded all settings from file. Exit configuration menu!")
			endif
		endif
	elseif(option == OIDs[18])
		if(iPage >= 1)
			if(Math.LogicalAnd(fpFlags[iPage - 1], 1024) != 0)
				fpFlags[iPage - 1] = Math.LogicalAnd(fpFlags[iPage - 1], Math.LogicalNot(1024))
				UpdateConfig(iPage - 1)
				SetToggleOptionValue(option, true)
			else
				fpFlags[iPage - 1] = Math.LogicalOr(fpFlags[iPage - 1], 1024)
				UpdateConfig(iPage - 1)
				SetToggleOptionValue(option, false)
			endif
		endif
	elseif(option == OIDs[19])
		if(iPage >= 1)
			if(Math.LogicalAnd(fpFlags[iPage - 1], 512) != 0)
				fpFlags[iPage - 1] = Math.LogicalAnd(fpFlags[iPage - 1], Math.LogicalNot(512))
				UpdateConfig(iPage - 1)
				SetToggleOptionValue(option, false)
			else
				fpFlags[iPage - 1] = Math.LogicalOr(fpFlags[iPage - 1], 512)
				UpdateConfig(iPage - 1)
				SetToggleOptionValue(option, true)
			endif
		endif
	elseif(option == OIDs[21])
		if(iPage >= 1)
			if(Math.LogicalAnd(fpFlags[iPage - 1], 256) != 0)
				fpFlags[iPage - 1] = Math.LogicalAnd(fpFlags[iPage - 1], Math.LogicalNot(256))
				UpdateConfig(iPage - 1)
				SetToggleOptionValue(option, false)
			else
				fpFlags[iPage - 1] = Math.LogicalOr(fpFlags[iPage - 1], 256)
				UpdateConfig(iPage - 1)
				SetToggleOptionValue(option, true)
			endif
		endif
	endif
endevent

event OnOptionKeyMapChange(int option, int keyCode, string conflictControl, string conflictName)
	if(option == OIDs[0])
		int wkey = mpKey
		bool hadOldKey = HasKeyBind(wkey)
		bool hadNewKey = HasKeyBind(keyCode)
		mpKey = keyCode
		bool hasOldKey = HasKeyBind(wkey)
		bool hasNewKey = HasKeyBind(keyCode)
		if(hadOldKey && !hasOldKey)
			UnregisterForKey(wkey)
		endif
		if(!hadNewKey && hasNewKey)
			RegisterForKey(keyCode)
		endif
		SetKeyMapOptionValue(OIDs[0], mpKey)
	elseif(option == OIDs[1])
		int wkey = mpClip
		bool hadOldKey = HasKeyBind(wkey)
		bool hadNewKey = HasKeyBind(keyCode)
		mpClip = keyCode
		bool hasOldKey = HasKeyBind(wkey)
		bool hasNewKey = HasKeyBind(keyCode)
		if(hadOldKey && !hasOldKey)
			UnregisterForKey(wkey)
		endif
		if(!hadNewKey && hasNewKey)
			RegisterForKey(keyCode)
		endif
		SetKeyMapOptionValue(OIDs[1], mpClip)
	elseif(option == OIDs[2])
		int wkey = mpRot
		bool hadOldKey = HasKeyBind(wkey)
		bool hadNewKey = HasKeyBind(keyCode)
		mpRot = keyCode
		bool hasOldKey = HasKeyBind(wkey)
		bool hasNewKey = HasKeyBind(keyCode)
		if(hadOldKey && !hasOldKey)
			UnregisterForKey(wkey)
		endif
		if(!hadNewKey && hasNewKey)
			RegisterForKey(keyCode)
		endif
		mpRot = keyCode
		SetKeyMapOptionValue(OIDs[2], mpRot)
	elseif(option == OIDs[14])
		int wkey = fpKey[iPage - 1]
		bool hadOldKey = HasKeyBind(wkey)
		bool hadNewKey = HasKeyBind(keyCode)
		fpKey[iPage - 1] = keyCode
		bool hasOldKey = HasKeyBind(wkey)
		bool hasNewKey = HasKeyBind(keyCode)
		if(hadOldKey && !hasOldKey)
			UnregisterForKey(wkey)
		endif
		if(!hadNewKey && hasNewKey)
			RegisterForKey(keyCode)
		endif
		SetKeyMapOptionValue(OIDs[14], fpKey[iPage - 1])
	endif
endevent

event OnGameReload()
	parent.OnGameReload()

	;ExitView()
	if(c_IsFP())
		EnterView()
	endif

	if(mpKey > 1)
		RegisterForKey(mpKey)
	endif
	if(mpClip > 1 && mpKey != mpClip)
		RegisterForKey(mpClip)
	endif
	if(mpRot > 1 && mpClip != mpRot && mpKey != mpRot)
		RegisterForKey(mpRot)
	endif

	int i = 0
	while(i < MaxProfiles)
		if(fpKey[i] > 1)
			int j = 0
			bool didHave = false
			while(j < i)
				if(fpKey[j] == fpKey[i])
					didHave = true
					j = i
				endif
				j += 1
			endwhile

			if(!didHave)
				RegisterForKey(fpKey[i])
			endif
		endif

		i += 1
	endwhile

	i = 0
	while(i < MaxProfiles)
		UpdateConfig(i)
		i += 1
	endwhile
	c_SetData(iData)
	c_SetProfile(iProfile)

	RegisterForEvents()
endevent

function ExitView()
	c_SetFP(none)
endfunction

function EnterView()
	if(!c_IsFP())
		if(Game.GetCameraState() == 0)
			Game.ForceThirdPerson()
		endif
		SetData(1, false)
	endif

	c_SetFP(Game.GetPlayer())
endfunction

event OnKeyDown(int keyCode)
	if(Utility.IsInMenuMode() || UI.IsTextInputEnabled())
		return
	endif

	int i = 0
	while(i < MaxProfiles)
		if(fpKey[i] == keyCode && Math.LogicalAnd(fpFlags[i], 256) != 0)
			pProfile = iProfile
			iProfile = i
			c_SetProfile(iProfile)
			i = MaxProfiles
		endif
		i += 1
	endwhile
endevent

event OnKeyUp(int keyCode, float holdTime)
	bool isMenu = Utility.IsInMenuMode() || UI.IsTextInputEnabled()
	if(!isMenu && keyCode == mpKey)
		if(c_IsFP())
			ExitView()
		else
			EnterView()
		endif
	endif
	if(!isMenu && keyCode == mpClip)
		ToggleData(1)
	endif
	if(!isMenu && keyCode == mpRot)
		; nothing now
	endif

	if(pProfile >= 0 && Math.LogicalAnd(fpFlags[iProfile], 256) != 0 && keyCode == fpKey[iProfile])
		iProfile = pProfile
		pProfile = -1
		c_SetProfile(iProfile)
	endif

	if(!isMenu)
		int i = iProfile
		int j = i
		i += 1
		while(i < MaxProfiles)
			if(fpKey[i] == keyCode && Math.LogicalAnd(fpFlags[i], 256) == 0)
				pProfile = -1
				iProfile = i
				c_SetProfile(i)
				i = MaxProfiles
			endif
			i += 1
		endwhile

		if(j == iProfile && j > 0)
			i = 0
			while(i < j)
				if(fpKey[i] == keyCode && Math.LogicalAnd(fpFlags[i], 256) == 0)
					pProfile = -1
					iProfile = i
					c_SetProfile(i)
					i = MaxProfiles
				endif
				i += 1
			endwhile
		endif
	endif
endevent

event OnOptionMenuOpen(int option)
	int plrAction = -1
	if(option == OIDs[4])
		plrAction = 0
	elseif(option == OIDs[5])
		plrAction = 6
	elseif(option == OIDs[6])
		plrAction = 1
	elseif(option == OIDs[7])
		plrAction = 2
	elseif(option == OIDs[8])
		plrAction = 4
	elseif(option == OIDs[9])
		plrAction = 3
	elseif(option == OIDs[10])
		plrAction = 5
	elseif(option == OIDs[11])
		plrAction = -2
	elseif(option == OIDs[12])
		plrAction = 7
	elseif(option == OIDs[13])
		plrAction = 8
	elseif(option == OIDs[14])
		plrAction = 9
	elseif(option == OIDs[15])
		plrAction = 10
	elseif(option == OIDs[18])
		plrAction = 11
	elseif(option == OIDs[19])
		plrAction = 12
	elseif(option == OIDs[20])
		plrAction = 13
	endif
	
	int curIndex = 0
	if(plrAction == -2)
		curIndex = iProfile
	elseif(plrAction >= 0)
		curIndex = GetProfileAction(plrAction) + 1
	endif

	SetMenuDialogStartIndex(curIndex)
	SetMenuDialogDefaultIndex(0)

	if(plrAction >= 0)
		string[] showOptions = new string[13]
		showOptions[0] = "Default profile"
		showOptions[1] = "Profile 1"
		showOptions[2] = "Profile 2"
		showOptions[3] = "Profile 3"
		showOptions[4] = "Profile 4"
		showOptions[5] = "Profile 5"
		showOptions[6] = "Profile 6"
		showOptions[7] = "Profile 7"
		showOptions[8] = "Profile 8"
		showOptions[9] = "Profile 9"
		showOptions[10] = "Profile 10"
		showOptions[11] = "Vanilla first person"
		showOptions[12] = "Vanilla third person"
		SetMenuDialogOptions(showOptions)
	else
		string[] showOptions = new string[12]
		showOptions[0] = "Profile 1"
		showOptions[1] = "Profile 2"
		showOptions[2] = "Profile 3"
		showOptions[3] = "Profile 4"
		showOptions[4] = "Profile 5"
		showOptions[5] = "Profile 6"
		showOptions[6] = "Profile 7"
		showOptions[7] = "Profile 8"
		showOptions[8] = "Profile 9"
		showOptions[9] = "Profile 10"
		showOptions[10] = "Vanilla first person"
		showOptions[11] = "Vanilla third person"
		SetMenuDialogOptions(showOptions)
	endif
endevent

event OnOptionMenuAccept(int option, int index)
	int plrAction = -1
	if(option == OIDs[4])
		plrAction = 0
	elseif(option == OIDs[5])
		plrAction = 6
	elseif(option == OIDs[6])
		plrAction = 1
	elseif(option == OIDs[7])
		plrAction = 2
	elseif(option == OIDs[8])
		plrAction = 4
	elseif(option == OIDs[9])
		plrAction = 3
	elseif(option == OIDs[10])
		plrAction = 5
	elseif(option == OIDs[11])
		plrAction = -2
	elseif(option == OIDs[12])
		plrAction = 7
	elseif(option == OIDs[13])
		plrAction = 8
	elseif(option == OIDs[14])
		plrAction = 9
	elseif(option == OIDs[15])
		plrAction = 10
	elseif(option == OIDs[18])
		plrAction = 11
	elseif(option == OIDs[19])
		plrAction = 12
	elseif(option == OIDs[20])
		plrAction = 13
	endif

	if(plrAction == -2)
		iProfile = index
		c_SetProfile(iProfile)
		if(index <= 9)
			SetMenuOptionValue(option, "Profile " + (index + 1))
		elseif(index == 10)
			SetMenuOptionValue(option, "Vanilla first person")
		elseif(index == 11)
			SetMenuOptionValue(option, "Vanilla third person")
		endif
	elseif(plrAction >= 0)
		if(index == 0)
			SetMenuOptionValue(option, "Default profile")
			SetProfileAction(-1, plrAction)
		elseif(index <= 10)
			SetMenuOptionValue(option, "Profile " + index)
			SetProfileAction(index - 1, plrAction)
		elseif(index == 11)
			SetMenuOptionValue(option, "Vanilla first person")
			SetProfileAction(index - 1, plrAction)
		elseif(index == 12)
			SetMenuOptionValue(option, "Vanilla third person")
			SetProfileAction(index - 1, plrAction)
		endif
	endif
endevent

function RegisterForEvents(bool isFirst = false)
	RegisterForModEvent("AnimationStart", "animStart")
	RegisterForModEvent("AnimationEnd", "animEnd")

	RegisterForModEvent("FP_SetProfile", "eSetProfile")
	RegisterForModEvent("FP_SetView", "eSetView")

	SetData(4, false)
endfunction

event eSetProfile(string eventName, string argString, float argNum, form sender)
	int prof = -1
	if(argString)
		prof = argString as int
	else
		prof = argNum as int
	endif

	if(prof < 1 || prof > 10)
		return
	endif

	iProfile = prof
	c_SetProfile(iProfile)
endevent

event eSetView(string eventName, string argString, float argNum, form sender)
	int view = -1
	if(argString)
		view = argString as int
	else
		view = argNum as int
	endif

	if(view == 0)
		ExitView()
	elseif(view == 1)
		EnterView()
	endif
endevent

event animStart(string eventName, string argString, float argNum, form sender)
	sslThreadController thread = SexLabUtil.GetAPI().HookController(argString)
	if(thread && thread.HasPlayer)
		SetData(4, true)
	endif
endevent

event animEnd(string eventName, string argString, float argNum, form sender)
	sslThreadController thread = SexLabUtil.GetAPI().HookController(argString)
	if(thread && thread.HasPlayer)
		SetData(4, false)
	endif
endevent

bool function HasKeyBind(int keyCode)
	if(keyCode <= 1)
		return false
	endif
	int i = 0
	while(i < MaxProfiles)
		if(fpKey[i] == keyCode)
			return true
		endif
		i += 1
	endwhile

	return mpKey == keyCode || mpClip == keyCode || mpRot == keyCode
endfunction

bool function SaveToFile()
	return c_SaveFile(true)
endfunction

bool function LoadFromFile()
	if(!c_SaveFile(false))
		return false
	endif

	iData = c_GetSetting(MaxProfiles, 1) as int
	iProfile = c_GetSetting(MaxProfiles, 2) as int

	int i = 0
	while(i < MaxProfiles)
		fpDist1[i] = c_GetSetting(i, 1) * 100.0
		fpDist2[i] = c_GetSetting(i, 2) * 100.0
		fpDist3[i] = c_GetSetting(i, 3) * 100.0
		fpFadeIn[i] = c_GetSetting(i, 4)
		fpFadeOut[i] = c_GetSetting(i, 5)
		fpFlags[i] = c_GetSetting(i, 6) as int
		fpFov1[i] = c_GetSetting(i, 7) * 100.0
		fpFov2[i] = c_GetSetting(i, 8) * 100.0
		fpFov3[i] = c_GetSetting(i, 9) * 100.0
		fpFov4[i] = c_GetSetting(i, 10)
		fpNearNear[i] = c_GetSetting(i, 11) * 100.0
		fpNearFar[i] = c_GetSetting(i, 12) * 100.0
		fpRestrict[i] = c_GetSetting(i, 13)
		fpRot1[i] = c_GetSetting(i, 14) * 100.0
		fpRot2[i] = c_GetSetting(i, 15)
		fpRot3[i] = c_GetSetting(i, 16)
		fpFlags2[i] = c_GetSetting(i, 17) as int
		fpSet1[i] = c_GetSetting(i, 18)
		fpSet2[i] = c_GetSetting(i, 19)
		fpSet3[i] = c_GetSetting(i, 20)
		fpSet4[i] = c_GetSetting(i, 21)
		fpSet5[i] = c_GetSetting(i, 22)
		fpSet6[i] = c_GetSetting(i, 23)
		fpSet7[i] = c_GetSetting(i, 24)
		fpSet8[i] = c_GetSetting(i, 25)
		i += 1
	endwhile

	return true
endfunction
