local assets=
{
    Asset("ANIM", "anim/swap_ua_staves.zip"),
    Asset("ANIM", "anim/ua_staves.zip"), 
}

local prefabs = 
{
    "ice_projectile",
    "fire_projectile",
    "staffcastfx",
    "stafflight",
}

-------GREEN STAFF-----------


local function candestroy(staff, caster, target)

end

local function SpawnLootPrefab(inst, lootprefab)

end

local function destroystructure(staff, target)

end



---------COMMON FUNCTIONS---------

local function onfinished(inst)
    inst.SoundEmitter:PlaySound("dontstarve/common/gem_shatter")
    inst:Remove()
end

local function unimplementeditem(inst)
    local player = GetPlayer()
    player.components.talker:Say(GetString(player.prefab, "ANNOUNCE_UNIMPLEMENTED"))
    if player.components.health.currenthealth > 1 then
        player.components.health:DoDelta(-player.components.health.currenthealth * 0.5)
    end

    if inst.components.useableitem then
        inst.components.useableitem:StopUsingItem()
    end
end

local function commonfn(colour)

    local onequip = function(inst, owner) 
        owner.AnimState:OverrideSymbol("swap_object", "swap_ua_staves", "symbol0")
        owner.AnimState:Show("ARM_carry") 
        owner.AnimState:Hide("ARM_normal") 
    end

    local onunequip = function(inst, owner) 
        owner.AnimState:Hide("ARM_carry") 
        owner.AnimState:Show("ARM_normal") 
    end

    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()
    local sound = inst.entity:AddSoundEmitter()
    MakeInventoryPhysics(inst)
    
    anim:SetBank("ua_staves")
    anim:SetBuild("ua_staves")
    anim:PlayAnimation("idle")
    -------   
    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetOnFinished( onfinished )

    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "whitestaff"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/whitestaff.xml"
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )


    
    return inst
end


---------COLOUR SPECIFIC CONSTRUCTIONS---------

local function canshrink(target)
	if target then
			return not target.components.combat or target.components.combat.defaultdamage == 0
		end
end


local function white_activate(staff, target, pos)
		if target and target:IsValid() then
			local targetpos = target:GetPosition()
    		local package = SpawnPrefab("package")
    		if package then
				package.components.packer:SetCanPackFn(canshrink)
				if package.components.packer:Pack(target) then
					package.Transform:SetPosition( targetpos:Get() )
					staff.components.finiteuses:Use(3)
					local doer = staff.components.inventoryitem and staff.components.inventoryitem.owner or GetPlayer()
					if doer.SoundEmitter then
						doer.SoundEmitter:PlaySound("dontstarve/rain/thunder_close")
					end
				else
					package:Remove()
				end
			end
		end    
end

local function cancastspell(staff, caster, target, pos)
	return canshrink(target) and  staff.components.packer:CanPack(target)
end

local function green()
    local inst = commonfn("green")
    inst:AddTag("nopunch")
    --inst.fxcolour = {51/255,153/255,51/255}
    inst:AddComponent("spellcaster")
    inst.components.spellcaster.canuseontargets = true
    inst.components.spellcaster.canusefrominventory = true
    inst.components.spellcaster:SetSpellTestFn(cancastspell)
    inst.components.spellcaster:SetSpellFn(white_activate)


	inst:AddComponent("packer")


	
    return inst
end

STRINGS.NAMES.WHITESTAFF = "Stasis staff"
STRINGS.RECIPE_DESC.WHITESTAFF = "One moment"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.WHITESTAFF = {	
	"Hide and seek with time",
}

return
Prefab("common/inventory/whitestaff", green, assets, prefabs)
