local assets=
{
	Asset("ANIM", "anim/whitegem.zip"),
    Asset("ATLAS", "images/inventoryimages/whitegem.xml"),
    Asset("IMAGE", "images/inventoryimages/whitegem.tex"),
}

local function fn(Sim)
    
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	MakeInventoryPhysics(inst)

	local light = inst.entity:AddLight()
    inst.Light:Enable(true)
	inst.Light:SetRadius(0.4)
    inst.Light:SetFalloff(1)
    inst.Light:SetIntensity(.7)
    inst.Light:SetColour(32/255,229/255,153/255)
	
    inst.AnimState:SetBank("whitegem")
    inst.AnimState:SetBuild("whitegem")
    inst.AnimState:PlayAnimation("idle", true)
    
    inst:AddComponent("inspectable")
		

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "whitegem"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/whitegem.xml"
	
    return inst
end

STRINGS.NAMES.WHITEGEM = "Radiant"

STRINGS.CHARACTERS.GENERIC.DESCRIBE.WHITEGEM = {	
	"This is not from Earth...",
}

return Prefab( "common/inventory/whitegem", fn, assets) 