local assets=
{
     Asset("ANIM", "anim/scarf.zip"),
     Asset("ATLAS", "images/inventoryimages/scarf.xml"),
     Asset("IMAGE", "images/inventoryimages/scarf.tex"),
}



local function onperish(inst)
	inst:Remove()
            inst.components.lootdropper:DropLoot(Vector3(inst.Transform:GetWorldPosition()))
end



local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_body", "santa_vest", "swap_body")
    inst.components.fueled:StartConsuming()
end

local function onunequip(inst, owner) 
    owner.AnimState:ClearOverrideSymbol("swap_body")
    inst.components.fueled:StopConsuming()
end

local function fn()
	local inst = CreateEntity()
    	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    
    inst.AnimState:SetBank("armor_trunkvest_summer")
    inst.AnimState:SetBuild("santa_vest")
    inst.AnimState:PlayAnimation("anim")


       inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
      inst.components.inventoryitem.imagename = "scarf"
      inst.components.inventoryitem.atlasname = "images/inventoryimages/scarf.xml"
    inst.components.inventoryitem.foleysound = "dontstarve/movement/foley/trunksuit"
    
    inst:AddComponent("dapperness")
    inst.components.dapperness.dapperness = TUNING.SCARF_DAPPERNESS

    inst:AddComponent("lootdropper")


    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.BODY

    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )

    inst:AddComponent("insulator")
    inst.components.insulator.insulation = TUNING.SCARF_INSULATION

    inst:AddComponent("fueled")
    inst.components.fueled.fueltype = "USAGE"
    inst.components.fueled:InitializeFuelLevel(TUNING.SCARF_PERISHTIME)
    inst.components.fueled:SetDepletedFn(onperish)
    
    return inst
end

return Prefab( "common/inventory/scarf", fn, assets) 
