local assets=
{
	Asset("ANIM", "anim/cube.zip"),
    Asset("ATLAS", "images/inventoryimages/cube.xml"),
    Asset("IMAGE", "images/inventoryimages/cube.tex"),
}

local function fn(Sim)
    
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	MakeInventoryPhysics(inst) 

	--local light = inst.entity:AddLight()
    --inst.Light:Enable(true)
	--inst.Light:SetRadius(0.4)
    --inst.Light:SetFalloff(1)
    --inst.Light:SetIntensity(.7)
    --inst.Light:SetColour(32/255,229/255,153/255)
	
    inst.AnimState:SetBank("cube")
    inst.AnimState:SetBuild("cube")
    inst.AnimState:PlayAnimation("idle", true)
    
    inst:AddComponent("inspectable")
		

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "cube"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/cube.xml"
	
    return inst
end

STRINGS.NAMES.CUBE = "Stasis Cube"

STRINGS.CHARACTERS.GENERIC.DESCRIBE.CUBE = {	
	"This is not from Earth...",
}

return Prefab( "common/inventory/cube", fn, assets) 