/*
 * Decompiled with CFR 0.152.
 */
package jajo_11.ShadowWorld.World.Structure;

import jajo_11.ShadowWorld.Entity.EntityDwarf;
import jajo_11.ShadowWorld.ShadowWorld;
import jajo_11.ShadowWorld.World.Structure.WorldGenShadowDungeon;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;

public class StructureShadowVillagePieces {
    private static final PieceWeight[] pieceWeightArray = new PieceWeight[]{new PieceWeight(Straight.class, 40, 0), new PieceWeight(Farm.class, 5, 5), new PieceWeight(LeftTurn.class, 20, 0), new PieceWeight(RightTurn.class, 20, 0), new PieceWeight(RoomCrossing.class, 10, 6), new PieceWeight(StairsStraight.class, 5, 5), new PieceWeight(Stairs.class, 5, 5), new PieceWeight(Crossing.class, 5, 4), new PieceWeight(LibaryCorridor.class, 5, 4), new PieceWeight((Class)Hall.class, 15, 3){

        @Override
        public boolean canSpawnMoreStructuresOfType(int par1) {
            return super.canSpawnMoreStructuresOfType(par1) && par1 > 4;
        }
    }, new PieceWeight((Class)Market.class, 20, 2){

        @Override
        public boolean canSpawnMoreStructuresOfType(int par1) {
            return super.canSpawnMoreStructuresOfType(par1) && par1 > 5;
        }
    }};
    private static List<PieceWeight> structurePieceList;
    private static Class<?> strongComponentType;
    static int totalWeight;
    private static final Stones ShadowVillageStones;

    public static void registerShadowVillagePieces() {
        MapGenStructureIO.func_143031_a(LibaryCorridor.class, (String)"shadowworld:SVLC");
        MapGenStructureIO.func_143031_a(Corridor.class, (String)"shadowworld:SVC");
        MapGenStructureIO.func_143031_a(Crossing.class, (String)"shadowworld:SVCR");
        MapGenStructureIO.func_143031_a(LeftTurn.class, (String)"shadowworld:SVLT");
        MapGenStructureIO.func_143031_a(Hall.class, (String)"shadowworld:SVHA");
        MapGenStructureIO.func_143031_a(Market.class, (String)"shadowworld:SVM");
        MapGenStructureIO.func_143031_a(Farm.class, (String)"shadowworld:SVF");
        MapGenStructureIO.func_143031_a(RightTurn.class, (String)"shadowworld:SVRT");
        MapGenStructureIO.func_143031_a(RoomCrossing.class, (String)"shadowworld:SVRC");
        MapGenStructureIO.func_143031_a(Stairs.class, (String)"shadowworld:SVST");
        MapGenStructureIO.func_143031_a(Stairs2.class, (String)"shadowworld:SVStart");
        MapGenStructureIO.func_143031_a(Straight.class, (String)"shadowworld:SVS");
        MapGenStructureIO.func_143031_a(StairsStraight.class, (String)"shadowworld:SVSS");
    }

    public static void prepareStructurePieces() {
        structurePieceList = new ArrayList<PieceWeight>();
        for (PieceWeight pieceweight : pieceWeightArray) {
            pieceweight.instancesSpawned = 0;
            structurePieceList.add(pieceweight);
        }
        strongComponentType = null;
    }

    private static boolean canAddStructurePieces() {
        boolean flag = false;
        totalWeight = 0;
        for (PieceWeight pieceweight : structurePieceList) {
            if (pieceweight.instancesLimit > 0 && pieceweight.instancesSpawned < pieceweight.instancesLimit) {
                flag = true;
            }
            totalWeight += pieceweight.pieceWeight;
        }
        return flag;
    }

    private static ShadowVillage getShadowVillageComponentFromWeightedPiece(Class<?> par0Class, List<ShadowVillage> par1List, Random par2Random, int par3, int par4, int par5, int par6, int par7) {
        ShadowVillage object = null;
        if (par0Class == Straight.class) {
            object = Straight.findValidPlacement(par1List, par2Random, par3, par4, par5, par6, par7);
        } else if (par0Class == Farm.class) {
            object = Farm.findValidPlacement(par1List, par2Random, par3, par4, par5, par6, par7);
        } else if (par0Class == LeftTurn.class) {
            object = LeftTurn.findValidPlacement(par1List, par2Random, par3, par4, par5, par6, par7);
        } else if (par0Class == RightTurn.class) {
            object = RightTurn.findValidPlacement(par1List, par2Random, par3, par4, par5, par6, par7);
        } else if (par0Class == RoomCrossing.class) {
            object = RoomCrossing.findValidPlacement(par1List, par2Random, par3, par4, par5, par6, par7);
        } else if (par0Class == StairsStraight.class) {
            object = StairsStraight.findValidPlacement(par1List, par2Random, par3, par4, par5, par6, par7);
        } else if (par0Class == Stairs.class) {
            object = Stairs.getShadowVillageStairsComponent(par1List, par2Random, par3, par4, par5, par6, par7);
        } else if (par0Class == Crossing.class) {
            object = Crossing.findValidPlacement(par1List, par2Random, par3, par4, par5, par6, par7);
        } else if (par0Class == LibaryCorridor.class) {
            object = LibaryCorridor.findValidPlacement(par1List, par2Random, par3, par4, par5, par6, par7);
        } else if (par0Class == Hall.class) {
            object = Hall.findValidPlacement(par1List, par2Random, par3, par4, par5, par6, par7);
        } else if (par0Class == Market.class) {
            object = Market.findValidPlacement(par1List, par2Random, par3, par4, par5, par6, par7);
        }
        return object;
    }

    private static ShadowVillage getNextComponent(Stairs2 par0ComponentShadowVillageStairs2, List<ShadowVillage> par1List, Random par2Random, int par3, int par4, int par5, int par6, int par7) {
        if (!StructureShadowVillagePieces.canAddStructurePieces()) {
            return null;
        }
        if (strongComponentType != null) {
            ShadowVillage ShadowVillage2 = StructureShadowVillagePieces.getShadowVillageComponentFromWeightedPiece(strongComponentType, par1List, par2Random, par3, par4, par5, par6, par7);
            strongComponentType = null;
            if (ShadowVillage2 != null) {
                return ShadowVillage2;
            }
        }
        int k1 = 0;
        block0: while (k1 < 5) {
            ++k1;
            int j1 = par2Random.nextInt(totalWeight);
            for (PieceWeight pieceweight : structurePieceList) {
                if ((j1 -= pieceweight.pieceWeight) >= 0) continue;
                if (!pieceweight.canSpawnMoreStructuresOfType(par7) || pieceweight == par0ComponentShadowVillageStairs2.ShadowVillagePieceWeight) continue block0;
                ShadowVillage ShadowVillage1 = StructureShadowVillagePieces.getShadowVillageComponentFromWeightedPiece(pieceweight.pieceClass, par1List, par2Random, par3, par4, par5, par6, par7);
                if (ShadowVillage1 == null) continue;
                ++pieceweight.instancesSpawned;
                par0ComponentShadowVillageStairs2.ShadowVillagePieceWeight = pieceweight;
                if (!pieceweight.canSpawnMoreStructures()) {
                    structurePieceList.remove(pieceweight);
                }
                return ShadowVillage1;
            }
        }
        StructureBoundingBox structureboundingbox = Corridor.func_74992_a(par1List, par2Random, par3, par4, par5, par6);
        if (structureboundingbox != null && structureboundingbox.field_78895_b > 1) {
            return new Corridor(par7, par2Random, structureboundingbox, par6);
        }
        return null;
    }

    private static StructureComponent getNextValidComponent(Stairs2 par0ComponentShadowVillageStairs2, List<ShadowVillage> par1List, Random par2Random, int par3, int par4, int par5, int par6, int par7) {
        if (par7 > 50) {
            return null;
        }
        if (Math.abs(par3 - par0ComponentShadowVillageStairs2.func_74874_b().field_78897_a) <= 112 && Math.abs(par5 - par0ComponentShadowVillageStairs2.func_74874_b().field_78896_c) <= 112) {
            ShadowVillage ShadowVillage2 = StructureShadowVillagePieces.getNextComponent(par0ComponentShadowVillageStairs2, par1List, par2Random, par3, par4, par5, par6, par7 + 1);
            if (ShadowVillage2 != null) {
                par1List.add(ShadowVillage2);
                par0ComponentShadowVillageStairs2.field_75026_c.add(ShadowVillage2);
            }
            return ShadowVillage2;
        }
        return null;
    }

    static {
        ShadowVillageStones = new Stones(null);
    }

    static class PieceWeight {
        public Class<?> pieceClass;
        public final int pieceWeight;
        public int instancesSpawned;
        public int instancesLimit;

        public PieceWeight(Class<?> par1Class, int par2, int par3) {
            this.pieceClass = par1Class;
            this.pieceWeight = par2;
            this.instancesLimit = par3;
        }

        public boolean canSpawnMoreStructuresOfType(int par1) {
            return this.instancesLimit == 0 || this.instancesSpawned < this.instancesLimit;
        }

        public boolean canSpawnMoreStructures() {
            return this.instancesLimit == 0 || this.instancesSpawned < this.instancesLimit;
        }
    }

    static final class SwitchDoor {
        static final int[] doorEnum = new int[ShadowVillage.Door.values().length];

        SwitchDoor() {
        }

        static {
            try {
                SwitchDoor.doorEnum[ShadowVillage.Door.OPENING.ordinal()] = 1;
            }
            catch (NoSuchFieldError var4) {
                // empty catch block
            }
            try {
                SwitchDoor.doorEnum[ShadowVillage.Door.WOOD_DOOR.ordinal()] = 2;
            }
            catch (NoSuchFieldError var3) {
                // empty catch block
            }
            try {
                SwitchDoor.doorEnum[ShadowVillage.Door.GRATES.ordinal()] = 3;
            }
            catch (NoSuchFieldError var2) {
                // empty catch block
            }
            try {
                SwitchDoor.doorEnum[ShadowVillage.Door.IRON_DOOR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    public static class Corridor
    extends ShadowVillage {
        private int field_74993_a;

        public Corridor() {
        }

        public Corridor(int par1, Random par2Random, StructureBoundingBox par3StructureBoundingBox, int par4) {
            super(par1);
            this.field_74885_f = par4;
            this.field_74887_e = par3StructureBoundingBox;
            this.field_74993_a = par4 != 2 && par4 != 0 ? par3StructureBoundingBox.func_78883_b() : par3StructureBoundingBox.func_78880_d();
        }

        @Override
        protected void func_143012_a(NBTTagCompound par1NBTTagCompound) {
            super.func_143012_a(par1NBTTagCompound);
            par1NBTTagCompound.func_74768_a("Steps", this.field_74993_a);
        }

        @Override
        protected void func_143011_b(NBTTagCompound par1NBTTagCompound) {
            super.func_143011_b(par1NBTTagCompound);
            this.field_74993_a = par1NBTTagCompound.func_74762_e("Steps");
        }

        public static StructureBoundingBox func_74992_a(List<ShadowVillage> par0List, Random par1Random, int par2, int par3, int par4, int par5) {
            boolean flag = true;
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)par2, (int)par3, (int)par4, (int)-1, (int)-1, (int)0, (int)5, (int)5, (int)4, (int)par5);
            StructureComponent structurecomponent = StructureComponent.func_74883_a(par0List, (StructureBoundingBox)structureboundingbox);
            if (structurecomponent == null) {
                return null;
            }
            if (structurecomponent.func_74874_b().field_78895_b == structureboundingbox.field_78895_b) {
                for (int i1 = 3; i1 >= 1; --i1) {
                    structureboundingbox = StructureBoundingBox.func_78889_a((int)par2, (int)par3, (int)par4, (int)-1, (int)-1, (int)0, (int)5, (int)5, (int)(i1 - 1), (int)par5);
                    if (structurecomponent.func_74874_b().func_78884_a(structureboundingbox)) continue;
                    return StructureBoundingBox.func_78889_a((int)par2, (int)par3, (int)par4, (int)-1, (int)-1, (int)0, (int)5, (int)5, (int)i1, (int)par5);
                }
            }
            return null;
        }

        public boolean func_74875_a(World par1World, Random par2Random, StructureBoundingBox par3StructureBoundingBox) {
            if (this.func_74860_a(par1World, par3StructureBoundingBox)) {
                return false;
            }
            for (int i = 0; i < this.field_74993_a; ++i) {
                this.func_151550_a(par1World, ShadowWorld.ShadowStoneBricks, 0, 0, 0, i, par3StructureBoundingBox);
                this.func_151550_a(par1World, ShadowWorld.ShadowStoneBricks, 0, 1, 0, i, par3StructureBoundingBox);
                this.func_151550_a(par1World, ShadowWorld.ShadowStoneBricks, 0, 2, 0, i, par3StructureBoundingBox);
                this.func_151550_a(par1World, ShadowWorld.ShadowStoneBricks, 0, 3, 0, i, par3StructureBoundingBox);
                this.func_151550_a(par1World, ShadowWorld.ShadowStoneBricks, 0, 4, 0, i, par3StructureBoundingBox);
                for (int j = 1; j <= 3; ++j) {
                    this.func_151550_a(par1World, ShadowWorld.ShadowStoneBricks, 0, 0, j, i, par3StructureBoundingBox);
                    this.func_151550_a(par1World, Blocks.field_150350_a, 0, 1, j, i, par3StructureBoundingBox);
                    this.func_151550_a(par1World, Blocks.field_150350_a, 0, 2, j, i, par3StructureBoundingBox);
                    this.func_151550_a(par1World, Blocks.field_150350_a, 0, 3, j, i, par3StructureBoundingBox);
                    this.func_151550_a(par1World, ShadowWorld.ShadowStoneBricks, 0, 4, j, i, par3StructureBoundingBox);
                }
                this.func_151550_a(par1World, ShadowWorld.ShadowStoneBricks, 0, 0, 4, i, par3StructureBoundingBox);
                this.func_151550_a(par1World, ShadowWorld.ShadowStoneBricks, 0, 1, 4, i, par3StructureBoundingBox);
                this.func_151550_a(par1World, ShadowWorld.ShadowStoneBricks, 0, 2, 4, i, par3StructureBoundingBox);
                this.func_151550_a(par1World, ShadowWorld.ShadowStoneBricks, 0, 3, 4, i, par3StructureBoundingBox);
                this.func_151550_a(par1World, ShadowWorld.ShadowStoneBricks, 0, 4, 4, i, par3StructureBoundingBox);
            }
            return true;
        }
    }

    public static class Crossing
    extends ShadowVillage {
        private boolean field_74996_b;
        private boolean field_74997_c;
        private boolean field_74995_d;
        private boolean field_74999_h;

        public Crossing() {
        }

        public Crossing(int par1, Random par2Random, StructureBoundingBox par3StructureBoundingBox, int par4) {
            super(par1);
            this.field_74885_f = par4;
            this.field_143013_d = this.getRandomDoor(par2Random);
            this.field_74887_e = par3StructureBoundingBox;
            this.field_74996_b = par2Random.nextBoolean();
            this.field_74997_c = par2Random.nextBoolean();
            this.field_74995_d = par2Random.nextBoolean();
            this.field_74999_h = par2Random.nextInt(3) > 0;
        }

        @Override
        protected void func_143012_a(NBTTagCompound par1NBTTagCompound) {
            super.func_143012_a(par1NBTTagCompound);
            par1NBTTagCompound.func_74757_a("leftLow", this.field_74996_b);
            par1NBTTagCompound.func_74757_a("leftHigh", this.field_74997_c);
            par1NBTTagCompound.func_74757_a("rightLow", this.field_74995_d);
            par1NBTTagCompound.func_74757_a("rightHigh", this.field_74999_h);
        }

        @Override
        protected void func_143011_b(NBTTagCompound par1NBTTagCompound) {
            super.func_143011_b(par1NBTTagCompound);
            this.field_74996_b = par1NBTTagCompound.func_74767_n("leftLow");
            this.field_74997_c = par1NBTTagCompound.func_74767_n("leftHigh");
            this.field_74995_d = par1NBTTagCompound.func_74767_n("rightLow");
            this.field_74999_h = par1NBTTagCompound.func_74767_n("rightHigh");
        }

        public void func_74861_a(StructureComponent par1StructureComponent, List par2List, Random par3Random) {
            int i = 3;
            int j = 5;
            if (this.field_74885_f == 1 || this.field_74885_f == 2) {
                i = 8 - i;
                j = 8 - j;
            }
            this.getNextComponentNormal((Stairs2)par1StructureComponent, par2List, par3Random, 5, 1);
            if (this.field_74996_b) {
                this.getNextComponentX((Stairs2)par1StructureComponent, par2List, par3Random, i, 1);
            }
            if (this.field_74997_c) {
                this.getNextComponentX((Stairs2)par1StructureComponent, par2List, par3Random, j, 7);
            }
            if (this.field_74995_d) {
                this.getNextComponentZ((Stairs2)par1StructureComponent, par2List, par3Random, i, 1);
            }
            if (this.field_74999_h) {
                this.getNextComponentZ((Stairs2)par1StructureComponent, par2List, par3Random, j, 7);
            }
        }

        public static Crossing findValidPlacement(List<ShadowVillage> par0List, Random par1Random, int par2, int par3, int par4, int par5, int par6) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)par2, (int)par3, (int)par4, (int)-4, (int)-3, (int)0, (int)10, (int)9, (int)11, (int)par5);
            return Crossing.canShadowVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(par0List, (StructureBoundingBox)structureboundingbox) == null ? new Crossing(par6, par1Random, structureboundingbox, par5) : null;
        }

        public boolean func_74875_a(World par1World, Random par2Random, StructureBoundingBox par3StructureBoundingBox) {
            if (this.func_74860_a(par1World, par3StructureBoundingBox)) {
                return false;
            }
            this.func_74882_a(par1World, par3StructureBoundingBox, 0, 0, 0, 9, 8, 10, false, par2Random, ShadowVillageStones);
            this.placeDoor(par1World, par2Random, par3StructureBoundingBox, this.field_143013_d, 4, 3, 0);
            if (this.field_74996_b) {
                this.func_151549_a(par1World, par3StructureBoundingBox, 0, 3, 1, 0, 5, 3, Blocks.field_150350_a, Blocks.field_150350_a, false);
            }
            if (this.field_74995_d) {
                this.func_151549_a(par1World, par3StructureBoundingBox, 9, 3, 1, 9, 5, 3, Blocks.field_150350_a, Blocks.field_150350_a, false);
            }
            if (this.field_74997_c) {
                this.func_151549_a(par1World, par3StructureBoundingBox, 0, 5, 7, 0, 7, 9, Blocks.field_150350_a, Blocks.field_150350_a, false);
            }
            if (this.field_74999_h) {
                this.func_151549_a(par1World, par3StructureBoundingBox, 9, 5, 7, 9, 7, 9, Blocks.field_150350_a, Blocks.field_150350_a, false);
            }
            this.func_151549_a(par1World, par3StructureBoundingBox, 5, 1, 10, 7, 3, 10, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_74882_a(par1World, par3StructureBoundingBox, 1, 2, 1, 8, 2, 6, false, par2Random, ShadowVillageStones);
            this.func_74882_a(par1World, par3StructureBoundingBox, 4, 1, 5, 4, 4, 9, false, par2Random, ShadowVillageStones);
            this.func_74882_a(par1World, par3StructureBoundingBox, 8, 1, 5, 8, 4, 9, false, par2Random, ShadowVillageStones);
            this.func_74882_a(par1World, par3StructureBoundingBox, 1, 4, 7, 3, 4, 9, false, par2Random, ShadowVillageStones);
            this.func_74882_a(par1World, par3StructureBoundingBox, 1, 3, 5, 3, 3, 6, false, par2Random, ShadowVillageStones);
            this.func_151549_a(par1World, par3StructureBoundingBox, 1, 3, 4, 3, 3, 4, (Block)Blocks.field_150333_U, (Block)Blocks.field_150333_U, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 1, 4, 6, 3, 4, 6, (Block)Blocks.field_150333_U, (Block)Blocks.field_150333_U, false);
            this.func_74882_a(par1World, par3StructureBoundingBox, 5, 1, 7, 7, 1, 8, false, par2Random, ShadowVillageStones);
            this.func_151549_a(par1World, par3StructureBoundingBox, 5, 1, 9, 7, 1, 9, (Block)Blocks.field_150333_U, (Block)Blocks.field_150333_U, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 5, 2, 7, 7, 2, 7, (Block)Blocks.field_150333_U, (Block)Blocks.field_150333_U, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 4, 5, 7, 4, 5, 9, (Block)Blocks.field_150333_U, (Block)Blocks.field_150333_U, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 8, 5, 7, 8, 5, 9, (Block)Blocks.field_150333_U, (Block)Blocks.field_150333_U, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 5, 5, 7, 7, 5, 9, (Block)Blocks.field_150334_T, (Block)Blocks.field_150334_T, false);
            this.func_151550_a(par1World, ShadowWorld.GlowStoneTorch, 0, 6, 5, 6, par3StructureBoundingBox);
            return true;
        }
    }

    public static abstract class ShadowVillage
    extends StructureComponent {
        protected Door field_143013_d;
        Random random = new Random();
        private int villagersSpawned;

        public ShadowVillage() {
            this.field_143013_d = Door.OPENING;
        }

        protected ShadowVillage(int par1) {
            super(par1);
            this.field_143013_d = Door.OPENING;
        }

        protected void func_143012_a(NBTTagCompound par1NBTTagCompound) {
            par1NBTTagCompound.func_74778_a("EntryDoor", this.field_143013_d.name());
        }

        protected void func_143011_b(NBTTagCompound par1NBTTagCompound) {
            this.field_143013_d = Door.valueOf(par1NBTTagCompound.func_74779_i("EntryDoor"));
        }

        protected void placeDoor(World par1World, Random par2Random, StructureBoundingBox par3StructureBoundingBox, Door par4EnumDoor, int par5, int par6, int par7) {
            switch (SwitchDoor.doorEnum[par4EnumDoor.ordinal()]) {
                default: {
                    this.func_151549_a(par1World, par3StructureBoundingBox, par5, par6, par7, par5 + 3 - 1, par6 + 3 - 1, par7, Blocks.field_150350_a, Blocks.field_150350_a, false);
                    break;
                }
                case 2: {
                    this.placeBlockAtCurrentPosition2(par1World, ShadowWorld.ShadowStoneBricks, 0, par5, par6, par7, par3StructureBoundingBox);
                    this.placeBlockAtCurrentPosition2(par1World, ShadowWorld.ShadowStoneBricks, 0, par5, par6 + 1, par7, par3StructureBoundingBox);
                    this.placeBlockAtCurrentPosition2(par1World, ShadowWorld.ShadowStoneBricks, 0, par5, par6 + 2, par7, par3StructureBoundingBox);
                    this.placeBlockAtCurrentPosition2(par1World, ShadowWorld.ShadowStoneBricks, 0, par5 + 1, par6 + 2, par7, par3StructureBoundingBox);
                    this.placeBlockAtCurrentPosition2(par1World, ShadowWorld.ShadowStoneBricks, 0, par5 + 2, par6 + 2, par7, par3StructureBoundingBox);
                    this.placeBlockAtCurrentPosition2(par1World, ShadowWorld.ShadowStoneBricks, 0, par5 + 2, par6 + 1, par7, par3StructureBoundingBox);
                    this.placeBlockAtCurrentPosition2(par1World, ShadowWorld.ShadowStoneBricks, 0, par5 + 2, par6, par7, par3StructureBoundingBox);
                    this.placeBlockAtCurrentPosition2(par1World, Blocks.field_150466_ao, 0, par5 + 1, par6, par7, par3StructureBoundingBox);
                    this.placeBlockAtCurrentPosition2(par1World, Blocks.field_150466_ao, 8, par5 + 1, par6 + 1, par7, par3StructureBoundingBox);
                    this.placeBlockAtCurrentPosition2(par1World, ShadowWorld.GlowStoneTorch, 0, par5 + 1, par6 + 2, par7 + 1, par3StructureBoundingBox);
                    break;
                }
                case 3: {
                    this.placeBlockAtCurrentPosition2(par1World, Blocks.field_150350_a, 0, par5 + 1, par6, par7, par3StructureBoundingBox);
                    this.placeBlockAtCurrentPosition2(par1World, Blocks.field_150350_a, 0, par5 + 1, par6 + 1, par7, par3StructureBoundingBox);
                    this.placeBlockAtCurrentPosition2(par1World, ShadowWorld.ShadowFence, 0, par5, par6, par7, par3StructureBoundingBox);
                    this.placeBlockAtCurrentPosition2(par1World, ShadowWorld.ShadowFence, 0, par5, par6 + 1, par7, par3StructureBoundingBox);
                    this.placeBlockAtCurrentPosition2(par1World, ShadowWorld.ShadowPlanks, 0, par5, par6 + 2, par7, par3StructureBoundingBox);
                    this.placeBlockAtCurrentPosition2(par1World, ShadowWorld.ShadowPlanks, 0, par5 + 1, par6 + 2, par7, par3StructureBoundingBox);
                    this.placeBlockAtCurrentPosition2(par1World, ShadowWorld.ShadowPlanks, 0, par5 + 2, par6 + 2, par7, par3StructureBoundingBox);
                    this.placeBlockAtCurrentPosition2(par1World, ShadowWorld.ShadowFence, 0, par5 + 2, par6 + 1, par7, par3StructureBoundingBox);
                    this.placeBlockAtCurrentPosition2(par1World, ShadowWorld.ShadowFence, 0, par5 + 2, par6, par7, par3StructureBoundingBox);
                    break;
                }
                case 4: {
                    this.placeBlockAtCurrentPosition2(par1World, ShadowWorld.ShadowStoneBricks, 0, par5, par6, par7, par3StructureBoundingBox);
                    this.placeBlockAtCurrentPosition2(par1World, ShadowWorld.ShadowStoneBricks, 0, par5, par6 + 1, par7, par3StructureBoundingBox);
                    this.placeBlockAtCurrentPosition2(par1World, ShadowWorld.ShadowStoneBricks, 0, par5, par6 + 2, par7, par3StructureBoundingBox);
                    this.placeBlockAtCurrentPosition2(par1World, ShadowWorld.ShadowStoneBricks, 0, par5 + 1, par6 + 2, par7, par3StructureBoundingBox);
                    this.placeBlockAtCurrentPosition2(par1World, ShadowWorld.ShadowStoneBricks, 0, par5 + 2, par6 + 2, par7, par3StructureBoundingBox);
                    this.placeBlockAtCurrentPosition2(par1World, ShadowWorld.ShadowStoneBricks, 0, par5 + 2, par6 + 1, par7, par3StructureBoundingBox);
                    this.placeBlockAtCurrentPosition2(par1World, ShadowWorld.ShadowStoneBricks, 0, par5 + 2, par6, par7, par3StructureBoundingBox);
                    this.placeBlockAtCurrentPosition2(par1World, Blocks.field_150466_ao, 0, par5 + 1, par6, par7, par3StructureBoundingBox);
                    this.placeBlockAtCurrentPosition2(par1World, Blocks.field_150466_ao, 8, par5 + 1, par6 + 1, par7, par3StructureBoundingBox);
                    this.placeBlockAtCurrentPosition2(par1World, ShadowWorld.GlowStoneTorch, 0, par5 + 1, par6 + 2, par7 + 1, par3StructureBoundingBox);
                }
            }
        }

        protected Door getRandomDoor(Random par1Random) {
            int i = par1Random.nextInt(5);
            switch (i) {
                case 0: {
                    return Door.WOOD_DOOR;
                }
                case 1: {
                    return Door.WOOD_DOOR;
                }
                default: {
                    return Door.OPENING;
                }
                case 2: {
                    return Door.WOOD_DOOR;
                }
                case 3: {
                    return Door.GRATES;
                }
                case 4: 
            }
            return Door.IRON_DOOR;
        }

        protected StructureComponent getNextComponentNormal(Stairs2 par1ComponentShadowVillageStairs2, List<ShadowVillage> par2List, Random par3Random, int par4, int par5) {
            switch (this.field_74885_f) {
                case 0: {
                    return StructureShadowVillagePieces.getNextValidComponent(par1ComponentShadowVillageStairs2, par2List, par3Random, this.field_74887_e.field_78897_a + par4, this.field_74887_e.field_78895_b + par5, this.field_74887_e.field_78892_f + 1, this.field_74885_f, this.func_74877_c());
                }
                case 1: {
                    return StructureShadowVillagePieces.getNextValidComponent(par1ComponentShadowVillageStairs2, par2List, par3Random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + par5, this.field_74887_e.field_78896_c + par4, this.field_74885_f, this.func_74877_c());
                }
                case 2: {
                    return StructureShadowVillagePieces.getNextValidComponent(par1ComponentShadowVillageStairs2, par2List, par3Random, this.field_74887_e.field_78897_a + par4, this.field_74887_e.field_78895_b + par5, this.field_74887_e.field_78896_c - 1, this.field_74885_f, this.func_74877_c());
                }
                case 3: {
                    return StructureShadowVillagePieces.getNextValidComponent(par1ComponentShadowVillageStairs2, par2List, par3Random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + par5, this.field_74887_e.field_78896_c + par4, this.field_74885_f, this.func_74877_c());
                }
            }
            return null;
        }

        protected StructureComponent getNextComponentX(Stairs2 par1ComponentShadowVillageStairs2, List<ShadowVillage> par2List, Random par3Random, int par4, int par5) {
            switch (this.field_74885_f) {
                case 0: {
                    return StructureShadowVillagePieces.getNextValidComponent(par1ComponentShadowVillageStairs2, par2List, par3Random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + par4, this.field_74887_e.field_78896_c + par5, 1, this.func_74877_c());
                }
                case 1: {
                    return StructureShadowVillagePieces.getNextValidComponent(par1ComponentShadowVillageStairs2, par2List, par3Random, this.field_74887_e.field_78897_a + par5, this.field_74887_e.field_78895_b + par4, this.field_74887_e.field_78896_c - 1, 2, this.func_74877_c());
                }
                case 2: {
                    return StructureShadowVillagePieces.getNextValidComponent(par1ComponentShadowVillageStairs2, par2List, par3Random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + par4, this.field_74887_e.field_78896_c + par5, 1, this.func_74877_c());
                }
                case 3: {
                    return StructureShadowVillagePieces.getNextValidComponent(par1ComponentShadowVillageStairs2, par2List, par3Random, this.field_74887_e.field_78897_a + par5, this.field_74887_e.field_78895_b + par4, this.field_74887_e.field_78896_c - 1, 2, this.func_74877_c());
                }
            }
            return null;
        }

        protected StructureComponent getNextComponentZ(Stairs2 par1ComponentShadowVillageStairs2, List<ShadowVillage> par2List, Random par3Random, int par4, int par5) {
            switch (this.field_74885_f) {
                case 0: {
                    return StructureShadowVillagePieces.getNextValidComponent(par1ComponentShadowVillageStairs2, par2List, par3Random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + par4, this.field_74887_e.field_78896_c + par5, 3, this.func_74877_c());
                }
                case 1: {
                    return StructureShadowVillagePieces.getNextValidComponent(par1ComponentShadowVillageStairs2, par2List, par3Random, this.field_74887_e.field_78897_a + par5, this.field_74887_e.field_78895_b + par4, this.field_74887_e.field_78892_f + 1, 0, this.func_74877_c());
                }
                case 2: {
                    return StructureShadowVillagePieces.getNextValidComponent(par1ComponentShadowVillageStairs2, par2List, par3Random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + par4, this.field_74887_e.field_78896_c + par5, 3, this.func_74877_c());
                }
                case 3: {
                    return StructureShadowVillagePieces.getNextValidComponent(par1ComponentShadowVillageStairs2, par2List, par3Random, this.field_74887_e.field_78897_a + par5, this.field_74887_e.field_78895_b + par4, this.field_74887_e.field_78892_f + 1, 0, this.func_74877_c());
                }
            }
            return null;
        }

        protected static boolean canShadowVillageGoDeeper(StructureBoundingBox par0StructureBoundingBox) {
            return par0StructureBoundingBox != null && par0StructureBoundingBox.field_78895_b > 10;
        }

        protected void spawnVillagers(World par1World, StructureBoundingBox par2StructureBoundingBox, int par3, int par4, int par5, int par6) {
            if (this.villagersSpawned < par6) {
                for (int i1 = this.villagersSpawned; i1 < par6; ++i1) {
                    int j1 = this.func_74865_a(par3 + i1, par5);
                    int k1 = this.func_74862_a(par4);
                    int l1 = this.func_74873_b(par3 + i1, par5);
                    ++this.villagersSpawned;
                    int i = this.getVillagerType(i1);
                    EntityDwarf entityvillager = new EntityDwarf(par1World, i);
                    if (i == 0) {
                        entityvillager.func_70062_b(0, new ItemStack(ShadowWorld.AncientHoe));
                        entityvillager.func_70062_b(3, new ItemStack(ShadowWorld.plateAncient));
                        entityvillager.func_70062_b(2, new ItemStack(ShadowWorld.legsAncient));
                        entityvillager.func_70062_b(1, new ItemStack(ShadowWorld.bootsAncient));
                    } else if (i == 1) {
                        entityvillager.func_70062_b(0, new ItemStack(Items.field_151122_aG));
                        entityvillager.func_70062_b(3, new ItemStack(ShadowWorld.plateAncient));
                        entityvillager.func_70062_b(2, new ItemStack(ShadowWorld.legsAncient));
                        entityvillager.func_70062_b(1, new ItemStack(ShadowWorld.bootsAncient));
                    } else if (i == 2) {
                        entityvillager.func_70062_b(0, new ItemStack(ShadowWorld.MagicalPaper));
                    } else if (i == 3) {
                        entityvillager.func_70062_b(0, new ItemStack(ShadowWorld.AncientSword));
                        entityvillager.func_70062_b(4, new ItemStack(ShadowWorld.helmetAncient));
                        entityvillager.func_70062_b(3, new ItemStack(ShadowWorld.plateAncient));
                        entityvillager.func_70062_b(2, new ItemStack(ShadowWorld.legsAncient));
                        entityvillager.func_70062_b(1, new ItemStack(ShadowWorld.bootsAncient));
                    } else if (i >= 4) {
                        entityvillager.func_70062_b(0, new ItemStack(ShadowWorld.AncientPickaxe));
                        entityvillager.func_70062_b(4, new ItemStack(ShadowWorld.helmetAncient));
                        entityvillager.func_70062_b(3, new ItemStack(ShadowWorld.plateAncient));
                        entityvillager.func_70062_b(2, new ItemStack(ShadowWorld.legsAncient));
                        entityvillager.func_70062_b(1, new ItemStack(ShadowWorld.bootsAncient));
                    }
                    entityvillager.setRandomName();
                    entityvillager.func_70012_b((double)j1 + 0.5, k1, (double)l1 + 0.5, 0.0f, 0.0f);
                    par1World.func_72838_d((Entity)entityvillager);
                    par1World.field_72982_D.func_75551_a(j1, k1, l1);
                }
            }
        }

        protected int getVillagerType(int par1) {
            return 0;
        }

        protected void fillWithRandomizedBlocks2(World par1World, StructureBoundingBox par2StructureBoundingBox, int par3, int par4, int par5, int par6, int par7, int par8, boolean par9, Random par10Random, StructureComponent.BlockSelector par11StructurePieceBlockSelector) {
            for (int k1 = par4; k1 <= par7; ++k1) {
                for (int l1 = par3; l1 <= par6; ++l1) {
                    for (int i2 = par5; i2 <= par8; ++i2) {
                        if (par9 && this.func_151548_a(par1World, l1, k1, i2, par2StructureBoundingBox).func_149688_o() == Material.field_151579_a) continue;
                        par11StructurePieceBlockSelector.func_75062_a(par10Random, l1, k1, i2, k1 == par4 || k1 == par7 || l1 == par3 || l1 == par6 || i2 == par5 || i2 == par8);
                        this.placeBlockAtCurrentPosition2(par1World, par11StructurePieceBlockSelector.func_151561_a(), par11StructurePieceBlockSelector.func_75064_b(), l1, k1, i2, par2StructureBoundingBox);
                    }
                }
            }
        }

        protected void placeBlockAtCurrentPosition2(World p_151550_1_, Block p_151550_2_, int p_151550_3_, int p_151550_4_, int p_151550_5_, int p_151550_6_, StructureBoundingBox p_151550_7_) {
            int i1 = this.func_74865_a(p_151550_4_, p_151550_6_);
            int j1 = this.func_74862_a(p_151550_5_);
            int k1 = this.func_74873_b(p_151550_4_, p_151550_6_);
            p_151550_1_.func_147465_d(i1, j1, k1, p_151550_2_, p_151550_3_, 2);
        }

        protected void fillWithBlocks2(World p_151549_1_, StructureBoundingBox p_151549_2_, int p_151549_3_, int p_151549_4_, int p_151549_5_, int p_151549_6_, int p_151549_7_, int p_151549_8_, Block p_151549_9_, Block p_151549_10_, boolean p_151549_11_) {
            for (int k1 = p_151549_4_; k1 <= p_151549_7_; ++k1) {
                for (int l1 = p_151549_3_; l1 <= p_151549_6_; ++l1) {
                    for (int i2 = p_151549_5_; i2 <= p_151549_8_; ++i2) {
                        if (p_151549_11_ && this.func_151548_a(p_151549_1_, l1, k1, i2, p_151549_2_).func_149688_o() == Material.field_151579_a) continue;
                        if (k1 != p_151549_4_ && k1 != p_151549_7_ && l1 != p_151549_3_ && l1 != p_151549_6_ && i2 != p_151549_5_ && i2 != p_151549_8_) {
                            this.placeBlockAtCurrentPosition2(p_151549_1_, p_151549_10_, 0, l1, k1, i2, p_151549_2_);
                            continue;
                        }
                        this.placeBlockAtCurrentPosition2(p_151549_1_, p_151549_9_, 0, l1, k1, i2, p_151549_2_);
                    }
                }
            }
        }

        public static enum Door {
            OPENING,
            WOOD_DOOR,
            GRATES,
            IRON_DOOR;

        }
    }

    static class Crops
    extends StructureComponent.BlockSelector {
        private Crops() {
        }

        public void func_75062_a(Random par1Random, int par2, int par3, int par4, boolean par5) {
            if (par5) {
                this.field_151562_a = Blocks.field_150338_P;
                float f = par1Random.nextFloat();
                if (f < 0.1f) {
                    this.field_151562_a = ShadowWorld.Glowshroom;
                } else if (f < 0.7f) {
                    this.field_151562_a = Blocks.field_150337_Q;
                }
            } else {
                this.field_151562_a = Blocks.field_150350_a;
            }
        }

        Crops(Object par1StructureShadowVillagePieceWeight2) {
            this();
        }
    }

    static class RuineStones
    extends StructureComponent.BlockSelector {
        private RuineStones() {
        }

        public void func_75062_a(Random par1Random, int par2, int par3, int par4, boolean par5) {
            if (par5) {
                this.field_151562_a = ShadowWorld.ShadowStoneBricks;
                float f = par1Random.nextFloat();
                this.field_151562_a = f < 0.65f ? ShadowWorld.CrackedShadowStoneBricks : (f < 0.95f ? ShadowWorld.MossyShadowStoneBricks : ShadowWorld.ShadowStoneBricks);
            } else {
                this.field_151562_a = Blocks.field_150350_a;
                this.field_75065_b = 0;
            }
        }

        RuineStones(Object par1StructureShadowVillagePieceWeight2) {
            this();
        }
    }

    static class Planks
    extends StructureComponent.BlockSelector {
        private Planks() {
        }

        public void func_75062_a(Random par1Random, int par2, int par3, int par4, boolean par5) {
            if (par5) {
                this.field_151562_a = ShadowWorld.ShadowPlanks;
                float f = par1Random.nextFloat();
                if (f < 0.2f) {
                    this.field_151562_a = ShadowWorld.MossyShadowPlanks;
                }
            } else {
                this.field_151562_a = Blocks.field_150350_a;
            }
        }

        Planks(Object par1StructureShadowVillagePieceWeight2) {
            this();
        }
    }

    static class Stones
    extends StructureComponent.BlockSelector {
        private Stones() {
        }

        public void func_75062_a(Random par1Random, int par2, int par3, int par4, boolean par5) {
            if (par5) {
                this.field_151562_a = ShadowWorld.ShadowStoneBricks;
                float f = par1Random.nextFloat();
                if (f < 0.2f) {
                    this.field_151562_a = ShadowWorld.MossyShadowStoneBricks;
                } else if (f < 0.5f) {
                    this.field_151562_a = ShadowWorld.CrackedShadowStoneBricks;
                } else if (f < 0.55f) {
                    this.field_151562_a = ShadowWorld.ShadowStoneBricks;
                } else {
                    this.field_75065_b = 0;
                }
            } else {
                this.field_151562_a = Blocks.field_150350_a;
                this.field_75065_b = 0;
            }
        }

        Stones(Object par1StructureShadowVillagePieceWeight2) {
            this();
        }
    }

    public static class RightTurn
    extends LeftTurn {
        @Override
        public void func_74861_a(StructureComponent par1StructureComponent, List par2List, Random par3Random) {
            if (this.field_74885_f != 2 && this.field_74885_f != 3) {
                this.getNextComponentX((Stairs2)par1StructureComponent, par2List, par3Random, 1, 1);
            } else {
                this.getNextComponentZ((Stairs2)par1StructureComponent, par2List, par3Random, 1, 1);
            }
        }

        @Override
        public boolean func_74875_a(World par1World, Random par2Random, StructureBoundingBox par3StructureBoundingBox) {
            if (this.func_74860_a(par1World, par3StructureBoundingBox)) {
                return false;
            }
            this.func_74882_a(par1World, par3StructureBoundingBox, 0, 0, 0, 4, 4, 4, false, par2Random, ShadowVillageStones);
            this.placeDoor(par1World, par2Random, par3StructureBoundingBox, this.field_143013_d, 1, 1, 0);
            if (this.field_74885_f != 2 && this.field_74885_f != 3) {
                this.func_151549_a(par1World, par3StructureBoundingBox, 0, 1, 1, 0, 3, 3, Blocks.field_150350_a, Blocks.field_150350_a, false);
            } else {
                this.func_151549_a(par1World, par3StructureBoundingBox, 4, 1, 1, 4, 3, 3, Blocks.field_150350_a, Blocks.field_150350_a, false);
            }
            return true;
        }
    }

    public static class LeftTurn
    extends ShadowVillage {
        public LeftTurn() {
        }

        public LeftTurn(int par1, Random par2Random, StructureBoundingBox par3StructureBoundingBox, int par4) {
            super(par1);
            this.field_74885_f = par4;
            this.field_143013_d = this.getRandomDoor(par2Random);
            this.field_74887_e = par3StructureBoundingBox;
        }

        public void func_74861_a(StructureComponent par1StructureComponent, List par2List, Random par3Random) {
            if (this.field_74885_f != 2 && this.field_74885_f != 3) {
                this.getNextComponentZ((Stairs2)par1StructureComponent, par2List, par3Random, 1, 1);
            } else {
                this.getNextComponentX((Stairs2)par1StructureComponent, par2List, par3Random, 1, 1);
            }
        }

        public static LeftTurn findValidPlacement(List<ShadowVillage> par0List, Random par1Random, int par2, int par3, int par4, int par5, int par6) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)par2, (int)par3, (int)par4, (int)-1, (int)-1, (int)0, (int)5, (int)5, (int)5, (int)par5);
            return LeftTurn.canShadowVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(par0List, (StructureBoundingBox)structureboundingbox) == null ? new LeftTurn(par6, par1Random, structureboundingbox, par5) : null;
        }

        public boolean func_74875_a(World par1World, Random par2Random, StructureBoundingBox par3StructureBoundingBox) {
            if (this.func_74860_a(par1World, par3StructureBoundingBox)) {
                return false;
            }
            this.func_74882_a(par1World, par3StructureBoundingBox, 0, 0, 0, 4, 4, 4, false, par2Random, ShadowVillageStones);
            this.placeDoor(par1World, par2Random, par3StructureBoundingBox, this.field_143013_d, 1, 1, 0);
            if (this.field_74885_f != 2 && this.field_74885_f != 3) {
                this.func_151549_a(par1World, par3StructureBoundingBox, 4, 1, 1, 4, 3, 3, Blocks.field_150350_a, Blocks.field_150350_a, false);
            } else {
                this.func_151549_a(par1World, par3StructureBoundingBox, 0, 1, 1, 0, 3, 3, Blocks.field_150350_a, Blocks.field_150350_a, false);
            }
            return true;
        }
    }

    public static class Farm
    extends ShadowVillage {
        public Farm() {
        }

        public Farm(int par1, Random par2Random, StructureBoundingBox par3StructureBoundingBox, int par4) {
            super(par1);
            this.field_74885_f = par4;
            this.field_143013_d = this.getRandomDoor(par2Random);
            this.field_74887_e = par3StructureBoundingBox;
        }

        public void func_74861_a(StructureComponent par1StructureComponent, List par2List, Random par3Random) {
            this.getNextComponentNormal((Stairs2)par1StructureComponent, par2List, par3Random, 1, 1);
        }

        public static Farm findValidPlacement(List<ShadowVillage> par0List, Random par1Random, int par2, int par3, int par4, int par5, int par6) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)par2, (int)par3, (int)par4, (int)-1, (int)-1, (int)0, (int)9, (int)5, (int)11, (int)par5);
            return Farm.canShadowVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(par0List, (StructureBoundingBox)structureboundingbox) == null ? new Farm(par6, par1Random, structureboundingbox, par5) : null;
        }

        public boolean func_74875_a(World par1World, Random par2Random, StructureBoundingBox par3StructureBoundingBox) {
            if (this.func_74860_a(par1World, par3StructureBoundingBox)) {
                return false;
            }
            this.func_74882_a(par1World, par3StructureBoundingBox, 0, 0, 0, 8, 4, 10, false, par2Random, ShadowVillageStones);
            this.placeDoor(par1World, par2Random, par3StructureBoundingBox, this.field_143013_d, 1, 1, 0);
            this.func_151549_a(par1World, par3StructureBoundingBox, 1, 1, 10, 3, 3, 10, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 3, 0, 1, 7, 0, 9, ShadowWorld.ShadowDirt, Blocks.field_150350_a, false);
            this.func_74882_a(par1World, par3StructureBoundingBox, 3, 1, 1, 7, 1, 9, false, par2Random, new Crops());
            this.spawnVillagers(par1World, par3StructureBoundingBox, 2, 1, 2, 1 + this.random.nextInt(2));
            return true;
        }

        @Override
        protected int getVillagerType(int par1) {
            return 0;
        }
    }

    public static class Stairs2
    extends Stairs {
        public PieceWeight ShadowVillagePieceWeight;
        public Market ShadowVillagePortalRoom;
        public List<ShadowVillage> field_75026_c = new ArrayList<ShadowVillage>();

        public Stairs2() {
        }

        public Stairs2(int par1, Random par2Random, int par3, int par4) {
            super(0, par2Random, par3, par4);
        }

        public ChunkPosition func_151553_a() {
            return this.ShadowVillagePortalRoom != null ? this.ShadowVillagePortalRoom.func_151553_a() : super.func_151553_a();
        }
    }

    public static class StairsStraight
    extends ShadowVillage {
        public StairsStraight() {
        }

        public StairsStraight(int par1, Random par2Random, StructureBoundingBox par3StructureBoundingBox, int par4) {
            super(par1);
            this.field_74885_f = par4;
            this.field_143013_d = this.getRandomDoor(par2Random);
            this.field_74887_e = par3StructureBoundingBox;
        }

        public void func_74861_a(StructureComponent par1StructureComponent, List par2List, Random par3Random) {
            this.getNextComponentNormal((Stairs2)par1StructureComponent, par2List, par3Random, 1, 1);
        }

        public static StairsStraight findValidPlacement(List<ShadowVillage> par0List, Random par1Random, int par2, int par3, int par4, int par5, int par6) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)par2, (int)par3, (int)par4, (int)-1, (int)-7, (int)0, (int)5, (int)11, (int)8, (int)par5);
            return StairsStraight.canShadowVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(par0List, (StructureBoundingBox)structureboundingbox) == null ? new StairsStraight(par6, par1Random, structureboundingbox, par5) : null;
        }

        public boolean func_74875_a(World par1World, Random par2Random, StructureBoundingBox par3StructureBoundingBox) {
            if (this.func_74860_a(par1World, par3StructureBoundingBox)) {
                return false;
            }
            this.func_74882_a(par1World, par3StructureBoundingBox, 0, 0, 0, 4, 10, 7, false, par2Random, ShadowVillageStones);
            this.placeDoor(par1World, par2Random, par3StructureBoundingBox, this.field_143013_d, 1, 7, 0);
            this.placeDoor(par1World, par2Random, par3StructureBoundingBox, ShadowVillage.Door.OPENING, 1, 1, 7);
            int i = 2;
            if (this.field_74885_f == 0) {
                i = 3;
            } else if (this.field_74885_f == 1) {
                i = 0;
            } else if (this.field_74885_f == 3) {
                i = 1;
            }
            for (int j = 0; j < 6; ++j) {
                this.func_151550_a(par1World, ShadowWorld.stairsShadowStoneBricks, i, 1, 6 - j, 1 + j, par3StructureBoundingBox);
                this.func_151550_a(par1World, ShadowWorld.stairsShadowStoneBricks, i, 2, 6 - j, 1 + j, par3StructureBoundingBox);
                this.func_151550_a(par1World, ShadowWorld.stairsShadowStoneBricks, i, 3, 6 - j, 1 + j, par3StructureBoundingBox);
                if (j >= 5) continue;
                this.func_151550_a(par1World, ShadowWorld.ShadowStoneBricks, 0, 1, 5 - j, 1 + j, par3StructureBoundingBox);
                this.func_151550_a(par1World, ShadowWorld.ShadowStoneBricks, 0, 2, 5 - j, 1 + j, par3StructureBoundingBox);
                this.func_151550_a(par1World, ShadowWorld.ShadowStoneBricks, 0, 3, 5 - j, 1 + j, par3StructureBoundingBox);
            }
            return true;
        }
    }

    public static class RoomCrossing
    extends ShadowVillage {
        protected int roomType;

        public RoomCrossing() {
        }

        public RoomCrossing(int par1, Random par2Random, StructureBoundingBox par3StructureBoundingBox, int par4) {
            super(par1);
            this.field_74885_f = par4;
            this.field_143013_d = this.getRandomDoor(par2Random);
            this.field_74887_e = par3StructureBoundingBox;
            this.roomType = par2Random.nextInt(5);
        }

        @Override
        protected void func_143012_a(NBTTagCompound par1NBTTagCompound) {
            super.func_143012_a(par1NBTTagCompound);
            par1NBTTagCompound.func_74768_a("Type", this.roomType);
        }

        @Override
        protected void func_143011_b(NBTTagCompound par1NBTTagCompound) {
            super.func_143011_b(par1NBTTagCompound);
            this.roomType = par1NBTTagCompound.func_74762_e("Type");
        }

        public void func_74861_a(StructureComponent par1StructureComponent, List par2List, Random par3Random) {
            this.getNextComponentNormal((Stairs2)par1StructureComponent, par2List, par3Random, 4, 1);
            this.getNextComponentX((Stairs2)par1StructureComponent, par2List, par3Random, 1, 4);
            this.getNextComponentZ((Stairs2)par1StructureComponent, par2List, par3Random, 1, 4);
        }

        public static RoomCrossing findValidPlacement(List<ShadowVillage> par0List, Random par1Random, int par2, int par3, int par4, int par5, int par6) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)par2, (int)par3, (int)par4, (int)-4, (int)-1, (int)0, (int)11, (int)7, (int)11, (int)par5);
            return RoomCrossing.canShadowVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(par0List, (StructureBoundingBox)structureboundingbox) == null ? new RoomCrossing(par6, par1Random, structureboundingbox, par5) : null;
        }

        public boolean func_74875_a(World par1World, Random par2Random, StructureBoundingBox par3StructureBoundingBox) {
            if (this.func_74860_a(par1World, par3StructureBoundingBox)) {
                return false;
            }
            this.func_74882_a(par1World, par3StructureBoundingBox, 0, 0, 0, 10, 6, 10, false, par2Random, ShadowVillageStones);
            this.placeDoor(par1World, par2Random, par3StructureBoundingBox, this.field_143013_d, 4, 1, 0);
            this.func_151549_a(par1World, par3StructureBoundingBox, 4, 1, 10, 6, 3, 10, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 0, 1, 4, 0, 3, 6, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 10, 1, 4, 10, 3, 6, Blocks.field_150350_a, Blocks.field_150350_a, false);
            switch (this.roomType) {
                case 0: {
                    this.func_74882_a(par1World, par3StructureBoundingBox, 3, 1, 3, 7, 1, 7, false, par2Random, ShadowVillageStones);
                    this.func_151549_a(par1World, par3StructureBoundingBox, 3, 2, 3, 7, 2, 7, ShadowWorld.ShadowStoneBricksSingleSlab, ShadowWorld.ShadowStoneBricksSingleSlab, false);
                    this.func_151549_a(par1World, par3StructureBoundingBox, 4, 1, 4, 6, 2, 6, Blocks.field_150353_l, Blocks.field_150353_l, false);
                    this.func_151550_a(par1World, Blocks.field_150467_bQ, 0, 5, 1, 2, par3StructureBoundingBox);
                    this.spawnVillagers(par1World, par3StructureBoundingBox, 5, 1, 5, 2);
                    break;
                }
                case 1: {
                    for (int i = 0; i < 5; ++i) {
                        this.func_151550_a(par1World, ShadowWorld.ShadowStoneBricks, 0, 3, 1, 3 + i, par3StructureBoundingBox);
                        this.func_151550_a(par1World, ShadowWorld.ShadowStoneBricks, 0, 7, 1, 3 + i, par3StructureBoundingBox);
                        this.func_151550_a(par1World, ShadowWorld.ShadowStoneBricks, 0, 3 + i, 1, 3, par3StructureBoundingBox);
                        this.func_151550_a(par1World, ShadowWorld.ShadowStoneBricks, 0, 3 + i, 1, 7, par3StructureBoundingBox);
                    }
                    this.func_151550_a(par1World, (Block)Blocks.field_150358_i, 0, 5, 4, 5, par3StructureBoundingBox);
                    this.spawnVillagers(par1World, par3StructureBoundingBox, 4, 1, 4, 2);
                    break;
                }
                case 2: {
                    this.func_151549_a(par1World, par3StructureBoundingBox, 0, 3, 0, 10, 3, 10, ShadowWorld.ShadowPlanks, ShadowWorld.ShadowPlanks, false);
                    this.func_151550_a(par1World, Blocks.field_150468_ap, this.func_151555_a(Blocks.field_150468_ap, 4), 9, 1, 3, par3StructureBoundingBox);
                    this.func_151550_a(par1World, Blocks.field_150468_ap, this.func_151555_a(Blocks.field_150468_ap, 4), 9, 2, 3, par3StructureBoundingBox);
                    this.func_151550_a(par1World, Blocks.field_150468_ap, this.func_151555_a(Blocks.field_150468_ap, 4), 9, 3, 3, par3StructureBoundingBox);
                    this.func_74879_a(par1World, par3StructureBoundingBox, par2Random, 3, 4, 8, WorldGenShadowDungeon.ShadowLoot, 4 + par2Random.nextInt(8));
                    this.spawnVillagers(par1World, par3StructureBoundingBox, 2, 1, 2, 2);
                }
            }
            return true;
        }

        @Override
        protected int getVillagerType(int par1) {
            if (this.roomType == 1) {
                return 2;
            }
            if (this.roomType == 1) {
                return 0;
            }
            if (this.roomType == 2) {
                return 3;
            }
            return 4;
        }
    }

    public static class LibaryCorridor
    extends ShadowVillage {
        public LibaryCorridor() {
        }

        public LibaryCorridor(int par1, Random par2Random, StructureBoundingBox par3StructureBoundingBox, int par4) {
            super(par1);
            this.field_74885_f = par4;
            this.field_143013_d = this.getRandomDoor(par2Random);
            this.field_74887_e = par3StructureBoundingBox;
        }

        public void func_74861_a(StructureComponent par1StructureComponent, List par2List, Random par3Random) {
            this.getNextComponentNormal((Stairs2)par1StructureComponent, par2List, par3Random, 1, 1);
        }

        public static LibaryCorridor findValidPlacement(List<ShadowVillage> par0List, Random par1Random, int par2, int par3, int par4, int par5, int par6) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)par2, (int)par3, (int)par4, (int)-1, (int)-1, (int)0, (int)5, (int)5, (int)7, (int)par5);
            return LibaryCorridor.canShadowVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(par0List, (StructureBoundingBox)structureboundingbox) == null ? new LibaryCorridor(par6, par1Random, structureboundingbox, par5) : null;
        }

        public boolean func_74875_a(World par1World, Random par2Random, StructureBoundingBox par3StructureBoundingBox) {
            if (this.func_74860_a(par1World, par3StructureBoundingBox)) {
                return false;
            }
            this.func_74882_a(par1World, par3StructureBoundingBox, 0, 0, 0, 4, 4, 6, false, par2Random, ShadowVillageStones);
            this.placeDoor(par1World, par2Random, par3StructureBoundingBox, this.field_143013_d, 1, 1, 0);
            this.placeDoor(par1World, par2Random, par3StructureBoundingBox, ShadowVillage.Door.OPENING, 1, 1, 6);
            this.func_151549_a(par1World, par3StructureBoundingBox, 0, 1, 0, 4, 3, 5, Blocks.field_150342_X, Blocks.field_150342_X, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 1, 1, 1, 3, 3, 4, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 2, 1, 1, 2, 2, 1, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 2, 1, 5, 2, 2, 5, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.spawnVillagers(par1World, par3StructureBoundingBox, 2, 1, 2, 1);
            return true;
        }

        @Override
        protected int getVillagerType(int par1) {
            return 2;
        }
    }

    public static class Market
    extends ShadowVillage {
        public Market() {
        }

        public Market(int par1, Random par2Random, StructureBoundingBox par3StructureBoundingBox, int par4) {
            super(par1);
            this.field_74885_f = par4;
            this.field_74887_e = par3StructureBoundingBox;
        }

        public void func_74861_a(StructureComponent par1StructureComponent, List par2List, Random par3Random) {
            if (par1StructureComponent != null) {
                ((Stairs2)par1StructureComponent).ShadowVillagePortalRoom = this;
            }
        }

        public static Market findValidPlacement(List<ShadowVillage> par0List, Random par1Random, int par2, int par3, int par4, int par5, int par6) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)par2, (int)par3, (int)par4, (int)-4, (int)-1, (int)0, (int)11, (int)64, (int)16, (int)par5);
            return Market.canShadowVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(par0List, (StructureBoundingBox)structureboundingbox) == null ? new Market(par6, par1Random, structureboundingbox, par5) : null;
        }

        public boolean func_74875_a(World par1World, Random par2Random, StructureBoundingBox par3StructureBoundingBox) {
            int i;
            this.func_74882_a(par1World, par3StructureBoundingBox, 0, 0, 0, 10, 7, 15, false, par2Random, ShadowVillageStones);
            this.placeDoor(par1World, par2Random, par3StructureBoundingBox, ShadowVillage.Door.WOOD_DOOR, 4, 1, 0);
            int b0 = 6;
            this.func_74882_a(par1World, par3StructureBoundingBox, 1, b0, 1, 1, b0, 14, false, par2Random, ShadowVillageStones);
            this.func_74882_a(par1World, par3StructureBoundingBox, 9, b0, 1, 9, b0, 14, false, par2Random, ShadowVillageStones);
            this.func_74882_a(par1World, par3StructureBoundingBox, 2, b0, 1, 8, b0, 2, false, par2Random, ShadowVillageStones);
            this.func_74882_a(par1World, par3StructureBoundingBox, 2, b0, 14, 8, b0, 14, false, par2Random, ShadowVillageStones);
            this.func_74882_a(par1World, par3StructureBoundingBox, 3, 1, 8, 7, 1, 12, false, par2Random, ShadowVillageStones);
            this.func_151549_a(par1World, par3StructureBoundingBox, 4, 1, 9, 6, 1, 11, (Block)Blocks.field_150358_i, (Block)Blocks.field_150358_i, false);
            for (i = 3; i < 14; i += 2) {
                this.func_151549_a(par1World, par3StructureBoundingBox, 0, 3, i, 0, 4, i, ShadowWorld.ShadowPlanks, ShadowWorld.ShadowPlanks, false);
                this.func_151549_a(par1World, par3StructureBoundingBox, 10, 3, i, 10, 4, i, ShadowWorld.ShadowPlanks, ShadowWorld.ShadowPlanks, false);
            }
            for (i = 2; i < 9; i += 2) {
                this.func_151549_a(par1World, par3StructureBoundingBox, i, 3, 15, i, 4, 15, ShadowWorld.ShadowPlanks, ShadowWorld.ShadowPlanks, false);
            }
            this.func_151550_a(par1World, ShadowWorld.ShadowFence, 0, 1, 3, 14, par3StructureBoundingBox);
            this.func_151550_a(par1World, ShadowWorld.DwarvenLamp, 0, 1, 4, 14, par3StructureBoundingBox);
            this.func_151550_a(par1World, ShadowWorld.ShadowFence, 0, 9, 3, 14, par3StructureBoundingBox);
            this.func_151550_a(par1World, ShadowWorld.DwarvenLamp, 0, 9, 4, 14, par3StructureBoundingBox);
            this.func_151550_a(par1World, ShadowWorld.ShadowFence, 0, 9, 3, 1, par3StructureBoundingBox);
            this.func_151550_a(par1World, ShadowWorld.DwarvenLamp, 0, 9, 4, 1, par3StructureBoundingBox);
            int i1 = this.func_151555_a(Blocks.field_150468_ap, 2);
            this.func_151556_a(par1World, par3StructureBoundingBox, 1, 1, 1, 1, 7, 1, Blocks.field_150468_ap, i1, Blocks.field_150468_ap, i1, false);
            i = 6;
            while (this.func_151548_a(par1World, 1, i, 1, par3StructureBoundingBox) != Blocks.field_150350_a || this.func_151548_a(par1World, 1, i + 5, 1, par3StructureBoundingBox) != Blocks.field_150350_a) {
                this.func_151550_a(par1World, Blocks.field_150468_ap, i1, 1, i, 1, par3StructureBoundingBox);
                ++i;
            }
            if (i > 6) {
                this.fillWithBlocks2(par1World, par3StructureBoundingBox, -3, i, -3, 5, i, 5, ShadowWorld.ShadowFence, ShadowWorld.ShadowFence, false);
                this.fillWithBlocks2(par1World, par3StructureBoundingBox, -3, i + 5, -3, 5, i + 5, 5, ShadowWorld.ShadowFence, ShadowWorld.ShadowFence, false);
                this.fillWithRandomizedBlocks2(par1World, par3StructureBoundingBox, -2, i, -2, 4, i + 5, 4, false, par2Random, new RuineStones());
                this.fillWithBlocks2(par1World, par3StructureBoundingBox, -1, i + 1, -1, 3, i + 4, 3, Blocks.field_150350_a, Blocks.field_150350_a, false);
                this.fillWithRandomizedBlocks2(par1World, par3StructureBoundingBox, 0, i, -3, 2, i, -3, false, par2Random, ShadowVillageStones);
                this.fillWithRandomizedBlocks2(par1World, par3StructureBoundingBox, 0, 6, 1, 0, i, 1, false, par2Random, ShadowVillageStones);
                this.fillWithRandomizedBlocks2(par1World, par3StructureBoundingBox, 1, 6, 0, 1, i, 0, false, par2Random, ShadowVillageStones);
                this.fillWithRandomizedBlocks2(par1World, par3StructureBoundingBox, 2, 6, 1, 2, i, 1, false, par2Random, ShadowVillageStones);
                this.fillWithRandomizedBlocks2(par1World, par3StructureBoundingBox, 1, 6, 2, 1, i, 2, false, par2Random, ShadowVillageStones);
                this.fillWithRandomizedBlocks2(par1World, par3StructureBoundingBox, 0, 6, 0, 0, i, 0, false, par2Random, ShadowVillageStones);
                this.fillWithRandomizedBlocks2(par1World, par3StructureBoundingBox, 2, 6, 0, 2, i, 0, false, par2Random, ShadowVillageStones);
                this.fillWithRandomizedBlocks2(par1World, par3StructureBoundingBox, 0, 6, 2, 0, i, 2, false, par2Random, ShadowVillageStones);
                this.fillWithRandomizedBlocks2(par1World, par3StructureBoundingBox, 2, 6, 2, 2, i, 2, false, par2Random, ShadowVillageStones);
                this.placeBlockAtCurrentPosition2(par1World, Blocks.field_150406_ce, 4, 1, i + 5, 1, par3StructureBoundingBox);
                this.placeBlockAtCurrentPosition2(par1World, Blocks.field_150406_ce, 4, 0, i + 5, 0, par3StructureBoundingBox);
                this.placeBlockAtCurrentPosition2(par1World, Blocks.field_150406_ce, 4, 2, i + 5, 2, par3StructureBoundingBox);
                this.placeBlockAtCurrentPosition2(par1World, Blocks.field_150406_ce, 4, 0, i + 5, 2, par3StructureBoundingBox);
                this.placeBlockAtCurrentPosition2(par1World, Blocks.field_150406_ce, 4, 2, i + 5, 0, par3StructureBoundingBox);
                this.placeBlockAtCurrentPosition2(par1World, Blocks.field_150406_ce, 4, 1, i + 3, 4, par3StructureBoundingBox);
                this.placeBlockAtCurrentPosition2(par1World, Blocks.field_150406_ce, 4, 0, i + 2, 4, par3StructureBoundingBox);
                this.placeBlockAtCurrentPosition2(par1World, Blocks.field_150406_ce, 4, 2, i + 2, 4, par3StructureBoundingBox);
                this.placeBlockAtCurrentPosition2(par1World, Blocks.field_150406_ce, 4, -2, i + 3, 1, par3StructureBoundingBox);
                this.placeBlockAtCurrentPosition2(par1World, Blocks.field_150406_ce, 4, -2, i + 2, 0, par3StructureBoundingBox);
                this.placeBlockAtCurrentPosition2(par1World, Blocks.field_150406_ce, 4, -2, i + 2, 2, par3StructureBoundingBox);
                this.placeBlockAtCurrentPosition2(par1World, Blocks.field_150406_ce, 4, 4, i + 3, 1, par3StructureBoundingBox);
                this.placeBlockAtCurrentPosition2(par1World, Blocks.field_150406_ce, 4, 4, i + 2, 0, par3StructureBoundingBox);
                this.placeBlockAtCurrentPosition2(par1World, Blocks.field_150406_ce, 4, 4, i + 2, 2, par3StructureBoundingBox);
                this.placeBlockAtCurrentPosition2(par1World, Blocks.field_150415_aT, 8, 1, i, 1, par3StructureBoundingBox);
                this.placeDoor(par1World, par2Random, par3StructureBoundingBox, ShadowVillage.Door.WOOD_DOOR, 0, i + 1, -2);
                this.placeDoor(par1World, par2Random, par3StructureBoundingBox, ShadowVillage.Door.GRATES, 0, i + 1, -3);
                this.placeBlockAtCurrentPosition2(par1World, Blocks.field_150350_a, 0, 1, i + 3, -1, par3StructureBoundingBox);
                this.placeBlockAtCurrentPosition2(par1World, ShadowWorld.ShadowFence, 0, -1, i + 2, -1, par3StructureBoundingBox);
                this.placeBlockAtCurrentPosition2(par1World, ShadowWorld.DwarvenLamp, 0, -1, i + 3, -1, par3StructureBoundingBox);
                this.placeBlockAtCurrentPosition2(par1World, ShadowWorld.ShadowFence, 0, -1, i + 2, 3, par3StructureBoundingBox);
                this.placeBlockAtCurrentPosition2(par1World, ShadowWorld.DwarvenLamp, 0, -1, i + 3, 3, par3StructureBoundingBox);
                this.placeBlockAtCurrentPosition2(par1World, ShadowWorld.ShadowFence, 0, 3, i + 2, -1, par3StructureBoundingBox);
                this.placeBlockAtCurrentPosition2(par1World, ShadowWorld.DwarvenLamp, 0, 3, i + 3, -1, par3StructureBoundingBox);
                this.placeBlockAtCurrentPosition2(par1World, ShadowWorld.ShadowFence, 0, 3, i + 2, 3, par3StructureBoundingBox);
                this.placeBlockAtCurrentPosition2(par1World, ShadowWorld.DwarvenLamp, 0, 3, i + 3, 3, par3StructureBoundingBox);
                this.spawnVillagers(par1World, par3StructureBoundingBox, 1, i + 2, 1, 2);
            }
            this.spawnVillagers(par1World, par3StructureBoundingBox, 2, 1, 2, 4);
            return true;
        }

        @Override
        protected int getVillagerType(int par1) {
            return par1 < 3 ? 3 : 4;
        }
    }

    public static class Hall
    extends ShadowVillage {
        private boolean isLargeRoom;

        public Hall() {
        }

        public Hall(int par1, Random par2Random, StructureBoundingBox par3StructureBoundingBox, int par4) {
            super(par1);
            this.field_74885_f = par4;
            this.field_143013_d = this.getRandomDoor(par2Random);
            this.field_74887_e = par3StructureBoundingBox;
            this.isLargeRoom = par3StructureBoundingBox.func_78882_c() > 6;
        }

        @Override
        protected void func_143012_a(NBTTagCompound par1NBTTagCompound) {
            super.func_143012_a(par1NBTTagCompound);
            par1NBTTagCompound.func_74757_a("Tall", this.isLargeRoom);
        }

        @Override
        protected void func_143011_b(NBTTagCompound par1NBTTagCompound) {
            super.func_143011_b(par1NBTTagCompound);
            this.isLargeRoom = par1NBTTagCompound.func_74767_n("Tall");
        }

        public static Hall findValidPlacement(List<ShadowVillage> par0List, Random par1Random, int par2, int par3, int par4, int par5, int par6) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)par2, (int)par3, (int)par4, (int)-4, (int)-1, (int)0, (int)14, (int)11, (int)15, (int)par5);
            if (!(Hall.canShadowVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(par0List, (StructureBoundingBox)structureboundingbox) == null || Hall.canShadowVillageGoDeeper(structureboundingbox = StructureBoundingBox.func_78889_a((int)par2, (int)par3, (int)par4, (int)-4, (int)-1, (int)0, (int)14, (int)6, (int)15, (int)par5)) && StructureComponent.func_74883_a(par0List, (StructureBoundingBox)structureboundingbox) == null)) {
                return null;
            }
            return new Hall(par6, par1Random, structureboundingbox, par5);
        }

        public boolean func_74875_a(World par1World, Random par2Random, StructureBoundingBox par3StructureBoundingBox) {
            int i;
            if (this.func_74860_a(par1World, par3StructureBoundingBox)) {
                return false;
            }
            int b0 = 11;
            if (!this.isLargeRoom) {
                b0 = 6;
            }
            this.func_74882_a(par1World, par3StructureBoundingBox, 0, 0, 0, 13, b0 - 1, 14, false, par2Random, ShadowVillageStones);
            this.placeDoor(par1World, par2Random, par3StructureBoundingBox, this.field_143013_d, 4, 1, 0);
            for (i = 1; i <= 13; ++i) {
                if ((i - 1) % 4 == 0) {
                    this.func_74882_a(par1World, par3StructureBoundingBox, 1, 1, i, 1, 4, i, false, par2Random, new Planks());
                    this.func_74882_a(par1World, par3StructureBoundingBox, 12, 1, i, 12, 4, i, false, par2Random, new Planks());
                    if (!this.isLargeRoom) continue;
                    this.func_74882_a(par1World, par3StructureBoundingBox, 1, 6, i, 1, 9, i, false, par2Random, new Planks());
                    this.func_74882_a(par1World, par3StructureBoundingBox, 12, 6, i, 12, 9, i, false, par2Random, new Planks());
                    continue;
                }
                this.func_74882_a(par1World, par3StructureBoundingBox, 1, 1, i, 1, 4, i, false, par2Random, new Planks());
                this.func_74882_a(par1World, par3StructureBoundingBox, 12, 1, i, 12, 4, i, false, par2Random, new Planks());
                if (!this.isLargeRoom) continue;
                this.func_74882_a(par1World, par3StructureBoundingBox, 1, 6, i, 1, 9, i, false, par2Random, new Planks());
                this.func_74882_a(par1World, par3StructureBoundingBox, 12, 6, i, 12, 9, i, false, par2Random, new Planks());
            }
            this.func_151550_a(par1World, ShadowWorld.ShadowFence, 0, 2, 2, 1, par3StructureBoundingBox);
            this.func_151550_a(par1World, ShadowWorld.DwarvenLamp, 0, 2, 3, 1, par3StructureBoundingBox);
            this.func_151550_a(par1World, ShadowWorld.ShadowFence, 0, 11, 2, 1, par3StructureBoundingBox);
            this.func_151550_a(par1World, ShadowWorld.DwarvenLamp, 0, 11, 3, 1, par3StructureBoundingBox);
            this.func_151550_a(par1World, ShadowWorld.ShadowFence, 0, 11, 2, 13, par3StructureBoundingBox);
            this.func_151550_a(par1World, ShadowWorld.DwarvenLamp, 0, 11, 3, 13, par3StructureBoundingBox);
            this.func_151550_a(par1World, ShadowWorld.ShadowFence, 0, 2, 2, 13, par3StructureBoundingBox);
            this.func_151550_a(par1World, ShadowWorld.DwarvenLamp, 0, 2, 3, 13, par3StructureBoundingBox);
            int i1 = 0;
            int i2 = 1;
            if (this.field_74885_f == 0) {
                i1 = 1;
                i2 = 2;
            } else if (this.field_74885_f == 1) {
                i1 = 2;
                i2 = 3;
            } else if (this.field_74885_f == 3) {
                i1 = 2;
                i2 = 3;
            }
            this.func_151549_a(par1World, par3StructureBoundingBox, 6, 1, 4, 7, 1, 11, ShadowWorld.ShadowFence, ShadowWorld.ShadowFence, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 6, 2, 4, 7, 2, 11, ShadowWorld.ShadowPlanksSingleSlab, ShadowWorld.ShadowPlanksSingleSlab, false);
            this.func_151556_a(par1World, par3StructureBoundingBox, 4, 1, 5, 4, 1, 10, ShadowWorld.stairsShadowWood, i2, ShadowWorld.stairsShadowWood, i1, false);
            this.func_151556_a(par1World, par3StructureBoundingBox, 9, 1, 5, 9, 1, 10, ShadowWorld.stairsShadowWood, i1, ShadowWorld.stairsShadowWood, i2, false);
            this.func_151550_a(par1World, ShadowWorld.ShadowPlanks, 0, 4, 1, 4, par3StructureBoundingBox);
            this.func_151550_a(par1World, ShadowWorld.ShadowPlanks, 0, 4, 1, 11, par3StructureBoundingBox);
            this.func_151550_a(par1World, ShadowWorld.ShadowPlanks, 0, 9, 1, 4, par3StructureBoundingBox);
            this.func_151550_a(par1World, ShadowWorld.ShadowPlanks, 0, 9, 1, 11, par3StructureBoundingBox);
            if (this.isLargeRoom) {
                this.func_151549_a(par1World, par3StructureBoundingBox, 1, 5, 1, 3, 5, 13, ShadowWorld.ShadowPlanks, ShadowWorld.ShadowPlanks, false);
                this.func_151549_a(par1World, par3StructureBoundingBox, 10, 5, 1, 12, 5, 13, ShadowWorld.ShadowPlanks, ShadowWorld.ShadowPlanks, false);
                this.func_151549_a(par1World, par3StructureBoundingBox, 4, 5, 1, 9, 5, 2, ShadowWorld.ShadowPlanks, ShadowWorld.ShadowPlanks, false);
                this.func_151549_a(par1World, par3StructureBoundingBox, 4, 5, 12, 9, 5, 13, ShadowWorld.ShadowPlanks, ShadowWorld.ShadowPlanks, false);
                i = this.func_151555_a(Blocks.field_150468_ap, 3);
                this.func_151550_a(par1World, Blocks.field_150468_ap, i, 10, 1, 13, par3StructureBoundingBox);
                this.func_151550_a(par1World, Blocks.field_150468_ap, i, 10, 2, 13, par3StructureBoundingBox);
                this.func_151550_a(par1World, Blocks.field_150468_ap, i, 10, 3, 13, par3StructureBoundingBox);
                this.func_151550_a(par1World, Blocks.field_150468_ap, i, 10, 4, 13, par3StructureBoundingBox);
                this.func_151550_a(par1World, Blocks.field_150468_ap, i, 10, 5, 13, par3StructureBoundingBox);
                this.func_151550_a(par1World, Blocks.field_150468_ap, i, 10, 6, 13, par3StructureBoundingBox);
                this.func_151550_a(par1World, Blocks.field_150468_ap, i, 10, 7, 13, par3StructureBoundingBox);
                this.func_151549_a(par1World, par3StructureBoundingBox, 4, 5, 3, 9, 5, 11, ShadowWorld.ShadowFence, ShadowWorld.ShadowFence, false);
                this.func_151549_a(par1World, par3StructureBoundingBox, 5, 5, 4, 8, 5, 10, Blocks.field_150350_a, Blocks.field_150350_a, false);
                int b1 = 7;
                int b2 = 7;
                this.func_151550_a(par1World, ShadowWorld.ShadowFence, 0, b1 - 1, 9, b2, par3StructureBoundingBox);
                this.func_151550_a(par1World, ShadowWorld.ShadowFence, 0, b1, 9, b2, par3StructureBoundingBox);
                this.func_151550_a(par1World, ShadowWorld.ShadowFence, 0, b1 - 1, 8, b2, par3StructureBoundingBox);
                this.func_151550_a(par1World, ShadowWorld.ShadowFence, 0, b1, 8, b2, par3StructureBoundingBox);
                this.func_151550_a(par1World, ShadowWorld.ShadowFence, 0, b1 - 1, 7, b2, par3StructureBoundingBox);
                this.func_151550_a(par1World, ShadowWorld.ShadowFence, 0, b1, 7, b2, par3StructureBoundingBox);
                this.func_151550_a(par1World, ShadowWorld.ShadowFence, 0, b1 - 2, 7, b2, par3StructureBoundingBox);
                this.func_151550_a(par1World, ShadowWorld.ShadowFence, 0, b1 + 1, 7, b2, par3StructureBoundingBox);
                this.func_151550_a(par1World, ShadowWorld.ShadowFence, 0, b1 - 1, 7, b2 - 1, par3StructureBoundingBox);
                this.func_151550_a(par1World, ShadowWorld.ShadowFence, 0, b1 - 1, 7, b2 + 1, par3StructureBoundingBox);
                this.func_151550_a(par1World, ShadowWorld.ShadowFence, 0, b1, 7, b2 - 1, par3StructureBoundingBox);
                this.func_151550_a(par1World, ShadowWorld.ShadowFence, 0, b1, 7, b2 + 1, par3StructureBoundingBox);
                this.func_151550_a(par1World, ShadowWorld.GlowStoneTorch, 0, b1 - 2, 8, b2, par3StructureBoundingBox);
                this.func_151550_a(par1World, ShadowWorld.GlowStoneTorch, 0, b1 + 1, 8, b2, par3StructureBoundingBox);
                this.func_151550_a(par1World, ShadowWorld.GlowStoneTorch, 0, b1 - 1, 8, b2 - 1, par3StructureBoundingBox);
                this.func_151550_a(par1World, ShadowWorld.GlowStoneTorch, 0, b1 - 1, 8, b2 + 1, par3StructureBoundingBox);
                this.func_151550_a(par1World, ShadowWorld.GlowStoneTorch, 0, b1, 8, b2 - 1, par3StructureBoundingBox);
                this.func_151550_a(par1World, ShadowWorld.GlowStoneTorch, 0, b1, 8, b2 + 1, par3StructureBoundingBox);
            }
            this.spawnVillagers(par1World, par3StructureBoundingBox, 2, 1, 2, 5);
            return true;
        }

        @Override
        protected int getVillagerType(int par1) {
            return 4;
        }
    }

    public static class Straight
    extends ShadowVillage {
        private boolean expandsX;
        private boolean expandsZ;

        public Straight() {
        }

        public Straight(int par1, Random par2Random, StructureBoundingBox par3StructureBoundingBox, int par4) {
            super(par1);
            this.field_74885_f = par4;
            this.field_143013_d = this.getRandomDoor(par2Random);
            this.field_74887_e = par3StructureBoundingBox;
            this.expandsX = par2Random.nextInt(2) == 0;
            this.expandsZ = par2Random.nextInt(2) == 0;
        }

        @Override
        protected void func_143012_a(NBTTagCompound par1NBTTagCompound) {
            super.func_143012_a(par1NBTTagCompound);
            par1NBTTagCompound.func_74757_a("Left", this.expandsX);
            par1NBTTagCompound.func_74757_a("Right", this.expandsZ);
        }

        @Override
        protected void func_143011_b(NBTTagCompound par1NBTTagCompound) {
            super.func_143011_b(par1NBTTagCompound);
            this.expandsX = par1NBTTagCompound.func_74767_n("Left");
            this.expandsZ = par1NBTTagCompound.func_74767_n("Right");
        }

        public void func_74861_a(StructureComponent par1StructureComponent, List par2List, Random par3Random) {
            this.getNextComponentNormal((Stairs2)par1StructureComponent, par2List, par3Random, 1, 1);
            if (this.expandsX) {
                this.getNextComponentX((Stairs2)par1StructureComponent, par2List, par3Random, 1, 2);
            }
            if (this.expandsZ) {
                this.getNextComponentZ((Stairs2)par1StructureComponent, par2List, par3Random, 1, 2);
            }
        }

        public static Straight findValidPlacement(List par0List, Random par1Random, int par2, int par3, int par4, int par5, int par6) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)par2, (int)par3, (int)par4, (int)-1, (int)-1, (int)0, (int)5, (int)5, (int)7, (int)par5);
            return Straight.canShadowVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a((List)par0List, (StructureBoundingBox)structureboundingbox) == null ? new Straight(par6, par1Random, structureboundingbox, par5) : null;
        }

        public boolean func_74875_a(World par1World, Random par2Random, StructureBoundingBox par3StructureBoundingBox) {
            if (this.func_74860_a(par1World, par3StructureBoundingBox)) {
                return false;
            }
            this.func_74882_a(par1World, par3StructureBoundingBox, 0, 0, 0, 4, 4, 6, false, par2Random, ShadowVillageStones);
            this.placeDoor(par1World, par2Random, par3StructureBoundingBox, this.field_143013_d, 1, 1, 0);
            this.placeDoor(par1World, par2Random, par3StructureBoundingBox, ShadowVillage.Door.OPENING, 1, 1, 6);
            this.func_151552_a(par1World, par3StructureBoundingBox, par2Random, 0.1f, 1, 2, 1, ShadowWorld.GlowStoneTorch, 0);
            this.func_151552_a(par1World, par3StructureBoundingBox, par2Random, 0.1f, 3, 2, 1, ShadowWorld.GlowStoneTorch, 0);
            this.func_151552_a(par1World, par3StructureBoundingBox, par2Random, 0.1f, 1, 2, 5, ShadowWorld.GlowStoneTorch, 0);
            this.func_151552_a(par1World, par3StructureBoundingBox, par2Random, 0.1f, 3, 2, 5, ShadowWorld.GlowStoneTorch, 0);
            this.spawnVillagers(par1World, par3StructureBoundingBox, 2, 1, 2, this.random.nextInt(1) + 1);
            if (this.expandsX) {
                this.func_151549_a(par1World, par3StructureBoundingBox, 0, 1, 2, 0, 3, 4, Blocks.field_150350_a, Blocks.field_150350_a, false);
            }
            if (this.expandsZ) {
                this.func_151549_a(par1World, par3StructureBoundingBox, 4, 1, 2, 4, 3, 4, Blocks.field_150350_a, Blocks.field_150350_a, false);
            }
            return true;
        }

        @Override
        protected int getVillagerType(int par1) {
            return this.random.nextInt(4);
        }
    }

    public static class Stairs
    extends ShadowVillage {
        private boolean field_75024_a;

        public Stairs() {
        }

        public Stairs(int par1, Random par2Random, int par3, int par4) {
            super(par1);
            this.field_75024_a = true;
            this.field_74885_f = par2Random.nextInt(4);
            this.field_143013_d = ShadowVillage.Door.OPENING;
            switch (this.field_74885_f) {
                case 0: 
                case 2: {
                    this.field_74887_e = new StructureBoundingBox(par3, 64, par4, par3 + 5 - 1, 74, par4 + 5 - 1);
                    break;
                }
                default: {
                    this.field_74887_e = new StructureBoundingBox(par3, 64, par4, par3 + 5 - 1, 74, par4 + 5 - 1);
                }
            }
        }

        public Stairs(int par1, Random par2Random, StructureBoundingBox par3StructureBoundingBox, int par4) {
            super(par1);
            this.field_75024_a = false;
            this.field_74885_f = par4;
            this.field_143013_d = this.getRandomDoor(par2Random);
            this.field_74887_e = par3StructureBoundingBox;
        }

        @Override
        protected void func_143012_a(NBTTagCompound par1NBTTagCompound) {
            super.func_143012_a(par1NBTTagCompound);
            par1NBTTagCompound.func_74757_a("Source", this.field_75024_a);
        }

        @Override
        protected void func_143011_b(NBTTagCompound par1NBTTagCompound) {
            super.func_143011_b(par1NBTTagCompound);
            this.field_75024_a = par1NBTTagCompound.func_74767_n("Source");
        }

        public void func_74861_a(StructureComponent par1StructureComponent, List par2List, Random par3Random) {
            if (this.field_75024_a) {
                strongComponentType = Crossing.class;
            }
            this.getNextComponentNormal((Stairs2)par1StructureComponent, par2List, par3Random, 1, 1);
        }

        public static Stairs getShadowVillageStairsComponent(List<ShadowVillage> par0List, Random par1Random, int par2, int par3, int par4, int par5, int par6) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)par2, (int)par3, (int)par4, (int)-1, (int)-7, (int)0, (int)5, (int)11, (int)5, (int)par5);
            return Stairs.canShadowVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(par0List, (StructureBoundingBox)structureboundingbox) == null ? new Stairs(par6, par1Random, structureboundingbox, par5) : null;
        }

        public boolean func_74875_a(World par1World, Random par2Random, StructureBoundingBox par3StructureBoundingBox) {
            if (this.func_74860_a(par1World, par3StructureBoundingBox)) {
                return false;
            }
            this.func_74882_a(par1World, par3StructureBoundingBox, 0, 0, 0, 4, 10, 4, false, par2Random, ShadowVillageStones);
            this.placeDoor(par1World, par2Random, par3StructureBoundingBox, this.field_143013_d, 1, 7, 0);
            this.placeDoor(par1World, par2Random, par3StructureBoundingBox, ShadowVillage.Door.OPENING, 1, 1, 4);
            this.func_151550_a(par1World, ShadowWorld.ShadowStoneBricks, 0, 2, 6, 1, par3StructureBoundingBox);
            this.func_151550_a(par1World, ShadowWorld.ShadowStoneBricks, 0, 1, 5, 1, par3StructureBoundingBox);
            this.func_151550_a(par1World, (Block)Blocks.field_150333_U, 0, 1, 6, 1, par3StructureBoundingBox);
            this.func_151550_a(par1World, ShadowWorld.ShadowStoneBricks, 0, 1, 5, 2, par3StructureBoundingBox);
            this.func_151550_a(par1World, ShadowWorld.ShadowStoneBricks, 0, 1, 4, 3, par3StructureBoundingBox);
            this.func_151550_a(par1World, (Block)Blocks.field_150333_U, 0, 1, 5, 3, par3StructureBoundingBox);
            this.func_151550_a(par1World, ShadowWorld.ShadowStoneBricks, 0, 2, 4, 3, par3StructureBoundingBox);
            this.func_151550_a(par1World, ShadowWorld.ShadowStoneBricks, 0, 3, 3, 3, par3StructureBoundingBox);
            this.func_151550_a(par1World, (Block)Blocks.field_150333_U, 0, 3, 4, 3, par3StructureBoundingBox);
            this.func_151550_a(par1World, ShadowWorld.ShadowStoneBricks, 0, 3, 3, 2, par3StructureBoundingBox);
            this.func_151550_a(par1World, ShadowWorld.ShadowStoneBricks, 0, 3, 2, 1, par3StructureBoundingBox);
            this.func_151550_a(par1World, (Block)Blocks.field_150333_U, 0, 3, 3, 1, par3StructureBoundingBox);
            this.func_151550_a(par1World, ShadowWorld.ShadowStoneBricks, 0, 2, 2, 1, par3StructureBoundingBox);
            this.func_151550_a(par1World, ShadowWorld.ShadowStoneBricks, 0, 1, 1, 1, par3StructureBoundingBox);
            this.func_151550_a(par1World, (Block)Blocks.field_150333_U, 0, 1, 2, 1, par3StructureBoundingBox);
            this.func_151550_a(par1World, ShadowWorld.ShadowStoneBricks, 0, 1, 1, 2, par3StructureBoundingBox);
            this.func_151550_a(par1World, (Block)Blocks.field_150333_U, 0, 1, 1, 3, par3StructureBoundingBox);
            return true;
        }
    }
}

