/*
 * Decompiled with CFR 0.152.
 */
package jajo_11.ShadowWorld.Utils;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import jajo_11.ShadowWorld.ClientProxy;
import jajo_11.ShadowWorld.Entity.EntityTravellingDwarf;
import jajo_11.ShadowWorld.ShadowWorld;
import jajo_11.ShadowWorld.Utils.NBTHelper;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.C17PacketCustomPayload;

public class Quest {
    private String name = "<unnamed>";
    private String type = "";
    private String desc = "<description>";
    private int xplevel = 0;
    private ItemStack requires;
    private ItemStack reward;
    private boolean finished;
    private String thanks = "Thank You!";
    private NBTTagList story = new NBTTagList();
    private NBTTagList story2 = new NBTTagList();
    private NBTTagList entities;
    private int posX = 0;
    private int posY = -1;
    private int posZ = 0;
    private Class<? extends EntityLivingBase> entityType;
    private String nextquest = "";
    private boolean isStoryQuest;
    private ItemStack[] items;

    public Quest() {
    }

    public Quest(String name, String description, ItemStack needed, ItemStack reward, int xplevel, String thanks, NBTTagList story) {
        this.setName(name);
        this.setType("item");
        this.setDesc(description);
        this.setRequires(needed);
        this.setReward(reward);
        this.setXplevel(xplevel);
        this.setFinished(false);
        this.setThanks(thanks);
        this.setStory(story);
        NBTTagList list = new NBTTagList();
        list.func_74742_a((NBTBase)new NBTTagString("Do you have " + needed.field_77994_a + " " + needed.func_77973_b().func_77653_i(needed) + "?"));
        this.setStory2(list);
    }

    public Quest(String name, String description, ItemStack[] requirements, ItemStack reward, int xplevel, String thanks) {
        this.setName(name);
        this.setType("items");
        this.setDesc(description);
        this.setItems(requirements);
        this.setReward(reward);
        this.setXplevel(xplevel);
        this.setFinished(false);
        this.setThanks(thanks);
        this.setStory(this.story);
        NBTTagList list = new NBTTagList();
        StringBuilder sb = new StringBuilder();
        if (requirements.length > 1) {
            for (int i = 0; i < requirements.length - 1; ++i) {
                sb.append((i > 0 ? ", " : "") + requirements[i].field_77994_a + " " + requirements[i].func_77973_b().func_77653_i(requirements[i]));
            }
        }
        sb.append((requirements.length > 1 ? " and " : "") + requirements[requirements.length - 1].field_77994_a + " " + requirements[requirements.length - 1].func_77973_b().func_77653_i(requirements[requirements.length - 1]));
        list.func_74742_a((NBTBase)new NBTTagString("Do you have " + sb + "?"));
        this.setStory2(list);
        this.story = new NBTTagList();
        this.story.func_74742_a((NBTBase)new NBTTagString("Give me " + sb));
        this.setStory(this.story);
    }

    public Quest(String name, String description, ItemStack[] requirements, ItemStack reward, int xplevel) {
        this(name, description, requirements, reward, xplevel, "Thank You!");
    }

    public Quest(String name, String description, ItemStack[] requirements, ItemStack reward, int xplevel, String thanks, NBTTagList story) {
        this.setName(name);
        this.setType("items");
        this.setDesc(description);
        this.setItems(requirements);
        this.setReward(reward);
        this.setXplevel(xplevel);
        this.setFinished(false);
        this.setThanks(thanks);
        this.setStory(story);
        NBTTagList list = new NBTTagList();
        StringBuilder sb = new StringBuilder();
        if (requirements.length > 1) {
            for (int i = 0; i < requirements.length - 1; ++i) {
                sb.append((i > 0 ? ", " : "") + requirements[i].field_77994_a + " " + requirements[i].func_77973_b().func_77653_i(requirements[i]));
            }
        }
        sb.append((requirements.length > 1 ? " and " : "") + requirements[requirements.length - 1].field_77994_a + " " + requirements[requirements.length - 1].func_77973_b().func_77653_i(requirements[requirements.length - 1]));
        list.func_74742_a((NBTBase)new NBTTagString("Do you have " + sb + "?"));
        this.setStory2(list);
    }

    public Quest(String name, String description, ItemStack needed, ItemStack reward, int xplevel) {
        this.setName(name);
        this.setType("item");
        this.setDesc(description);
        this.setRequires(needed);
        this.setReward(reward);
        this.setXplevel(xplevel);
        this.setFinished(false);
        this.story = new NBTTagList();
        this.story.func_74742_a((NBTBase)new NBTTagString("Give me " + needed.field_77994_a + " " + needed.func_77973_b().func_77653_i(needed)));
        this.setStory(this.story);
        NBTTagList list = new NBTTagList();
        list.func_74742_a((NBTBase)new NBTTagString("Do you have " + needed.field_77994_a + " " + needed.func_77973_b().func_77653_i(needed) + "?"));
        this.setStory2(list);
    }

    public Quest(String name, String description, NBTTagList story, ItemStack needed, ItemStack reward) {
        this(description, description, needed, reward, 0);
    }

    public Quest(String name, String description, NBTTagList entities, ItemStack reward, int xplevel, String thanks, NBTTagList story) {
        this.setName(name);
        this.setType("entities");
        this.setDesc(description);
        this.setEntities(entities);
        this.setReward(reward);
        this.setXplevel(xplevel);
        this.setFinished(false);
        this.setThanks(thanks);
        this.setStory(story);
        NBTTagList list = new NBTTagList();
        list.func_74742_a((NBTBase)new NBTTagString("Have you killed them already?"));
        this.setStory2(list);
    }

    public Quest(String name, String description, Class<? extends EntityLivingBase> type, ItemStack reward, int xplevel, String thanks, NBTTagList story) {
        this(name, description, type, reward, xplevel);
        this.setThanks(thanks);
        this.setStory(story);
    }

    public Quest(String name, String description, Class<? extends EntityLivingBase> type, ItemStack reward, int xplevel) {
        this.setName(name);
        this.setType("entities-pre");
        this.setDesc(description);
        this.setReward(reward);
        this.setXplevel(xplevel);
        this.setFinished(false);
        this.setThanks(this.thanks);
        this.setStory(this.story);
        this.setEntityType(type);
    }

    public String getName() {
        return this.name;
    }

    public Quest setName(String name) {
        this.name = name;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public Quest setType(String type) {
        this.type = type;
        return this;
    }

    public String getDesc() {
        return this.desc;
    }

    public Quest setDesc(String desc) {
        this.desc = desc;
        return this;
    }

    public int getXplevel() {
        return this.xplevel;
    }

    public Quest setXplevel(int xplevel) {
        this.xplevel = xplevel;
        return this;
    }

    public ItemStack getRequires() {
        return this.requires;
    }

    public Quest setRequires(ItemStack requires) {
        this.requires = requires;
        return this;
    }

    public ItemStack getReward() {
        return this.reward;
    }

    public Quest setReward(ItemStack reward) {
        this.reward = reward;
        return this;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public Quest setFinished(boolean finished) {
        this.finished = finished;
        return this;
    }

    public String getThanks() {
        return this.thanks;
    }

    public Quest setThanks(String thanks) {
        this.thanks = thanks;
        return this;
    }

    public NBTTagList getStory() {
        return this.story;
    }

    public Quest setStory(NBTTagList story) {
        this.story = story;
        return this;
    }

    public NBTTagList getStory2() {
        return this.story2;
    }

    public Quest setStory2(NBTTagList story) {
        this.story2 = story;
        return this;
    }

    public NBTTagList getEntities() {
        return this.entities;
    }

    public Quest setEntities(NBTTagList entities) {
        this.entities = entities;
        return this;
    }

    public int getPosX() {
        return this.posX;
    }

    public Quest setPosX(int posX) {
        this.posX = posX;
        return this;
    }

    public int getPosY() {
        return this.posY;
    }

    public Quest setPosY(int posY) {
        this.posY = posY;
        return this;
    }

    public int getPosZ() {
        return this.posZ;
    }

    public Quest setPosZ(int posZ) {
        this.posZ = posZ;
        return this;
    }

    public Class<? extends EntityLivingBase> getEntityType() {
        return this.entityType;
    }

    public Quest setEntityType(Class<? extends EntityLivingBase> entityType) {
        this.entityType = entityType;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addQuest(Entity entity, EntityPlayer player, Quest q) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            ByteBuf bytebuf = Unpooled.buffer();
            try {
                PacketBuffer b = new PacketBuffer(bytebuf);
                b.func_150785_a(player.func_70005_c_());
                b.writeInt(entity.func_145782_y());
                NBTTagCompound quest = new NBTTagCompound();
                b.func_150786_a(q.writeToNBT(quest));
                Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new C17PacketCustomPayload("SW|Quest", bytebuf));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                bytebuf.release();
            }
        }
        if (player.getEntityData() != null) {
            if (!NBTHelper.getPersistentTag(player).func_74764_b("shadowworld/quests")) {
                NBTHelper.getPersistentTag(player).func_74782_a("shadowworld/quests", (NBTBase)new NBTTagList());
                if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                    ClientProxy.entry.showQuest();
                }
            }
            for (int i = 0; i < NBTHelper.getQuests(player).func_74745_c(); ++i) {
                if (!NBTHelper.getQuests(player).func_150305_b(i).func_74779_i("name").equals(q.getName())) continue;
                return Quest.finishQuest(entity, player, q.getName(), q.getThanks());
            }
            NBTTagCompound quest = new NBTTagCompound();
            if (q.getType().equals("entities")) {
                for (Object o : player.func_130014_f_().field_72996_f) {
                    for (int count = 0; count < q.getEntities().func_74745_c(); ++count) {
                        if (o == null || !(o instanceof EntityLiving) || !((Entity)o).getPersistentID().equals(UUID.fromString(q.getEntities().func_150307_f(count)))) continue;
                        ((EntityLiving)o).func_94058_c("##Quest##");
                    }
                }
            }
            NBTHelper.getQuests(player).func_74742_a((NBTBase)q.writeToNBT(quest));
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                ClientProxy.quest.show(q.getName());
            }
            if (entity != null && entity instanceof EntityTravellingDwarf) {
                ((EntityTravellingDwarf)entity).func_110171_b((int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v, 20);
                ((EntityTravellingDwarf)entity).func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
                if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                    ((EntityTravellingDwarf)entity).setSecondaryStory(q.getName(), q.getStory2());
                }
            }
        }
        return false;
    }

    public static boolean finishQuest(Entity entity, EntityPlayer player, String name, String thankyou) {
        boolean flag = false;
        if (player.getEntityData() != null) {
            if (!NBTHelper.getPersistentTag(player).func_74764_b("shadowworld/quests")) {
                NBTHelper.getPersistentTag(player).func_74782_a("shadowworld/quests", (NBTBase)new NBTTagList());
                if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                    ClientProxy.entry.showQuest();
                }
            }
            for (int i = 0; i < NBTHelper.getQuests(player).func_74745_c(); ++i) {
                if (!NBTHelper.getQuests(player).func_150305_b(i).func_74779_i("name").equals(name)) continue;
                NBTTagCompound quest = NBTHelper.getQuests(player).func_150305_b(i);
                if (quest.func_74767_n("finished")) {
                    return false;
                }
                if (quest.func_74779_i("type").equals("item")) {
                    ItemStack needed = ItemStack.func_77949_a((NBTTagCompound)quest.func_74775_l("requires"));
                    if (Quest.readFromNBT(quest).canBeFinished(player)) {
                        for (int i1 = 0; i1 < needed.field_77994_a; ++i1) {
                            player.field_71071_by.func_146026_a(needed.func_77973_b());
                        }
                        flag = true;
                    }
                } else if (quest.func_74779_i("type").equals("items")) {
                    ItemStack[] requirements = new ItemStack[quest.func_150295_c("requirements", 10).func_74745_c()];
                    if (Quest.readFromNBT(quest).canBeFinished(player)) {
                        for (int i1 = 0; i1 < requirements.length; ++i1) {
                            ItemStack needed = ItemStack.func_77949_a((NBTTagCompound)quest.func_150295_c("requirements", 10).func_150305_b(i1));
                            for (int i2 = 0; i2 < needed.field_77994_a; ++i2) {
                                player.field_71071_by.func_146026_a(needed.func_77973_b());
                            }
                        }
                        flag = true;
                    }
                } else if (quest.func_74779_i("type").equals("entities") && FMLCommonHandler.instance().getEffectiveSide().isServer()) {
                    NBTTagList ids = quest.func_150295_c("entities", 8);
                    flag = true;
                    for (Object o : player.func_130014_f_().field_72996_f) {
                        for (int count = 0; count < ids.func_74745_c(); ++count) {
                            if (o == null || !(o instanceof Entity) || !((Entity)o).getPersistentID().equals(UUID.fromString(ids.func_150307_f(count)))) continue;
                            flag = false;
                        }
                    }
                }
                if (flag) {
                    quest.func_74757_a("finished", true);
                    quest.func_74757_a("active", false);
                    if (quest.func_74764_b("xp")) {
                        player.func_82242_a(quest.func_74762_e("xp"));
                    }
                    if (!player.field_71071_by.func_70441_a(ItemStack.func_77949_a((NBTTagCompound)quest.func_74775_l("reward")))) {
                        player.func_71019_a(ItemStack.func_77949_a((NBTTagCompound)quest.func_74775_l("reward")), false);
                    }
                    if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                        ClientProxy.quest.showFinished(name);
                        player.func_85030_a("shadowworld:quest_finished", 1.0f, 1.0f);
                    }
                    if (entity != null && entity instanceof EntityTravellingDwarf) {
                        Quest nextQuest = null;
                        if (!quest.func_74779_i("nextQuest").isEmpty()) {
                            for (Quest q : ShadowWorld.secondaryquests) {
                                if (!q.name.replaceAll("[0-9]", "").equals(quest.func_74779_i("nextQuest"))) continue;
                                nextQuest = q;
                            }
                        }
                        if (nextQuest != null) {
                            nextQuest.setName(nextQuest.getName() + ((EntityTravellingDwarf)entity).func_145782_y());
                            ((EntityTravellingDwarf)entity).setQuest(nextQuest);
                            ((EntityTravellingDwarf)entity).setStory();
                        } else {
                            ((EntityTravellingDwarf)entity).setQuest(null);
                            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                                ((EntityTravellingDwarf)entity).setThankYouStory(quest.func_74779_i("name"), thankyou);
                            }
                            ((EntityTravellingDwarf)entity).func_110177_bN();
                            ((EntityTravellingDwarf)entity).func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
                        }
                    }
                    if (quest.func_74779_i("type").equals("entities") && FMLCommonHandler.instance().getEffectiveSide().isServer()) {
                        ByteBuf bytebuf = Unpooled.buffer();
                        try {
                            PacketBuffer p = new PacketBuffer(bytebuf);
                            p.func_150786_a(quest);
                            p.writeInt(entity.func_145782_y());
                            p.func_150785_a(thankyou);
                            ShadowWorld.channel5.sendToAll(new FMLProxyPacket(bytebuf, "SW|SyncEntityQuest"));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                return flag;
            }
        }
        return false;
    }

    public boolean hasNextQuest() {
        return this.nextquest.isEmpty();
    }

    public String getNextQuest() {
        return this.nextquest;
    }

    public Quest setNextQuest(String nextquest) {
        this.nextquest = nextquest;
        return this;
    }

    public boolean isStoryQuest() {
        return this.isStoryQuest;
    }

    public Quest setStoryQuest(boolean isStoryQuest) {
        this.isStoryQuest = isStoryQuest;
        return this;
    }

    public ItemStack[] getItems() {
        return this.items;
    }

    public void setItems(ItemStack[] items) {
        this.items = items;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound quest) {
        if (quest == null) {
            return quest;
        }
        quest.func_74778_a("name", this.getName());
        quest.func_74778_a("type", this.getType());
        quest.func_74778_a("desc", this.getDesc());
        quest.func_74768_a("xp", this.getXplevel());
        quest.func_74757_a("finished", this.isFinished());
        quest.func_74778_a("thanks", this.getThanks());
        quest.func_74782_a("story", (NBTBase)this.getStory());
        quest.func_74778_a("nextQuest", this.getNextQuest());
        quest.func_74757_a("storyquest", this.isStoryQuest());
        quest.func_74782_a("notFinishedStory", (NBTBase)this.getStory2());
        if (this.getPosY() != -1) {
            quest.func_74768_a("posX", this.getPosX());
            quest.func_74768_a("posY", this.getPosY());
            quest.func_74768_a("posZ", this.getPosZ());
        }
        if (this.getType().equals("item")) {
            NBTTagCompound requires = new NBTTagCompound();
            quest.func_74782_a("requires", (NBTBase)this.getRequires().func_77955_b(requires));
        } else if (this.getType().equals("entities")) {
            quest.func_74782_a("entities", (NBTBase)this.getEntities());
        } else if (this.getType().equals("items")) {
            NBTTagList items = new NBTTagList();
            for (ItemStack stack : this.getItems()) {
                if (stack == null) continue;
                NBTTagCompound tag = new NBTTagCompound();
                stack.func_77955_b(tag);
                items.func_74742_a((NBTBase)tag);
            }
            quest.func_74782_a("requirements", (NBTBase)items);
        }
        NBTTagCompound reward = new NBTTagCompound();
        quest.func_74782_a("reward", (NBTBase)this.getReward().func_77955_b(reward));
        return quest;
    }

    public static Quest readFromNBT(NBTTagCompound quest) {
        Quest result;
        if (quest == null || !quest.func_74764_b("name")) {
            return null;
        }
        String name = quest.func_74779_i("name");
        String type = quest.func_74779_i("type");
        String desc = quest.func_74779_i("desc");
        int xplevel = quest.func_74762_e("xp");
        boolean finished = quest.func_74767_n("finished");
        String thanks = quest.func_74779_i("thanks");
        NBTTagList story = quest.func_150295_c("story", 8);
        String nextQuest = quest.func_74779_i("nextQuest");
        boolean isStoryQuest = quest.func_74767_n("storyquest");
        NBTTagList story2 = quest.func_150295_c("notFinishedStory", 8);
        NBTTagList entities = null;
        ItemStack requires = null;
        ItemStack reward = null;
        reward = ItemStack.func_77949_a((NBTTagCompound)quest.func_74775_l("reward"));
        if (type.equals("item")) {
            requires = ItemStack.func_77949_a((NBTTagCompound)quest.func_74775_l("requires"));
            Quest q = new Quest(name, desc, requires, reward, xplevel);
            q.setFinished(finished);
            q.setThanks(thanks);
            q.setStory(story);
            q.setType(type);
            q.setNextQuest(nextQuest);
            q.setStoryQuest(isStoryQuest);
            q.setStory2(story2);
            if (quest.func_74764_b("posX")) {
                q.setPosX(quest.func_74762_e("posX"));
                q.setPosY(quest.func_74762_e("posY"));
                q.setPosZ(quest.func_74762_e("posZ"));
            }
            result = q;
        } else if (type.equals("entities")) {
            entities = quest.func_150295_c("entities", 8);
            Quest q = new Quest(name, desc, entities, reward, xplevel, thanks, story);
            q.setFinished(finished);
            q.setNextQuest(nextQuest);
            q.setStoryQuest(isStoryQuest);
            q.setStory2(story2);
            if (quest.func_74764_b("posX")) {
                q.setPosX(quest.func_74762_e("posX"));
                q.setPosY(quest.func_74762_e("posY"));
                q.setPosZ(quest.func_74762_e("posZ"));
            }
            result = q;
        } else if (type.equals("items")) {
            ItemStack[] requirements = new ItemStack[quest.func_150295_c("requirements", 10).func_74745_c()];
            for (int i = 0; i < requirements.length; ++i) {
                requirements[i] = ItemStack.func_77949_a((NBTTagCompound)quest.func_150295_c("requirements", 10).func_150305_b(i));
            }
            Quest q = new Quest(name, desc, requirements, reward, xplevel);
            q.setFinished(finished);
            q.setThanks(thanks);
            q.setStory(story);
            q.setType(type);
            q.setNextQuest(nextQuest);
            q.setStoryQuest(isStoryQuest);
            q.setStory2(story2);
            if (quest.func_74764_b("posX")) {
                q.setPosX(quest.func_74762_e("posX"));
                q.setPosY(quest.func_74762_e("posY"));
                q.setPosZ(quest.func_74762_e("posZ"));
            }
            result = q;
        } else {
            result = null;
        }
        return result;
    }

    public boolean canBeFinished(EntityPlayer player) {
        if (this.isFinished()) {
            return false;
        }
        if (this.type.equals("item")) {
            ItemStack needed = this.requires;
            if (player.field_71071_by.func_146028_b(needed.func_77973_b())) {
                int count = 0;
                for (ItemStack stack : player.field_71071_by.field_70462_a) {
                    if (stack == null || !stack.func_77969_a(needed)) continue;
                    count += stack.field_77994_a;
                }
                if (count >= needed.field_77994_a) {
                    return true;
                }
            }
        } else if (this.type.equals("items")) {
            int items = 0;
            for (int i1 = 0; i1 < this.getItems().length; ++i1) {
                ItemStack needed = this.getItems()[i1];
                if (!player.field_71071_by.func_146028_b(needed.func_77973_b())) continue;
                int count = 0;
                for (ItemStack stack : player.field_71071_by.field_70462_a) {
                    if (stack == null || !stack.func_77969_a(needed)) continue;
                    count += stack.field_77994_a;
                }
                if (count < needed.field_77994_a) continue;
                ++items;
            }
            if (items == this.getItems().length) {
                return true;
            }
        }
        return false;
    }
}

