/*
 * Decompiled with CFR 0.152.
 */
package jajo_11.ShadowWorld.Utils;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public class NBTHelper {
    private static String[] NBTNames = new String[]{"End", "Byte", "Short", "Int", "Long", "Float", "Double", "Byte Array", "String", "List", "Compound", "Int Array"};

    public static NBTTagCompound getPersistentTag(EntityPlayer player) {
        if (player.getEntityData() != null) {
            if (!player.getEntityData().func_74764_b("PlayerPersisted")) {
                player.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)new NBTTagCompound());
            }
            return player.getEntityData().func_74775_l("PlayerPersisted");
        }
        return new NBTTagCompound();
    }

    public static NBTTagList getQuests(EntityPlayer player) {
        if (player.getEntityData() != null) {
            return NBTHelper.getPersistentTag(player).func_150295_c("shadowworld/quests", 10);
        }
        return new NBTTagList();
    }

    public static boolean wasInShadowWorld(EntityPlayer player) {
        if (player.getEntityData() != null) {
            return NBTHelper.getPersistentTag(player).func_74764_b("shadowworld");
        }
        return false;
    }

    public static boolean wasInCookieWorld(EntityPlayer player) {
        if (player.getEntityData() != null) {
            return NBTHelper.getPersistentTag(player).func_74764_b("cookieworld");
        }
        return false;
    }

    public static void printNBTTagCompound(NBTTagCompound tag) {
        NBTHelper.printNBTTagCompound("Root", tag, 0, false);
    }

    public static void printNBTTagCompound(NBTTagCompound tag, String name) {
        NBTHelper.printNBTTagCompound(name, tag, 0, false);
    }

    private static void printNBTTagCompound(String name, NBTTagCompound tag, int offset, boolean list) {
        NBTHelper.print(name + " (Compound):", offset, list);
        for (Object o : tag.func_150296_c()) {
            NBTBase entry = tag.func_74781_a((String)o);
            NBTHelper.printTag((String)o, entry, offset + 1, false);
        }
    }

    private static void printNBTTagList(String name, NBTTagList tag, int offset) {
        NBTTagList list = (NBTTagList)tag.func_74737_b();
        NBTHelper.print(name + " (List, " + NBTNames[list.func_150303_d()] + ", " + list.func_74745_c() + (list.func_74745_c() == 1 ? " Entry" : " Entries") + "):", offset);
        int count = list.func_74745_c();
        for (int i = 0; i < count; ++i) {
            NBTBase entry = list.func_74744_a(0);
            NBTHelper.printTag("" + i, entry, offset + 1, true);
        }
    }

    private static void printTag(String name, NBTBase tag, int offset, boolean list) {
        if (tag.func_74732_a() == 0) {
            NBTHelper.print(name + ": " + "End", offset, list);
        } else if (tag.func_74732_a() == 1) {
            NBTHelper.print(name + " (Byte): " + ((NBTTagByte)tag).func_150290_f(), offset, list);
        } else if (tag.func_74732_a() == 2) {
            NBTHelper.print(name + " (Short): " + ((NBTTagShort)tag).func_150289_e(), offset, list);
        } else if (tag.func_74732_a() == 3) {
            NBTHelper.print(name + " (Int): " + ((NBTTagInt)tag).func_150287_d(), offset, list);
        } else if (tag.func_74732_a() == 4) {
            NBTHelper.print(name + " (Long): " + ((NBTTagLong)tag).func_150291_c(), offset, list);
        } else if (tag.func_74732_a() == 5) {
            NBTHelper.print(name + " (Float): " + ((NBTTagFloat)tag).func_150288_h(), offset, list);
        } else if (tag.func_74732_a() == 6) {
            NBTHelper.print(name + " (Double): " + ((NBTTagDouble)tag).func_150286_g(), offset, list);
        } else if (tag.func_74732_a() == 7) {
            NBTHelper.print(name + " (Byte Array): " + ((NBTTagByteArray)tag).func_150292_c(), offset, list);
        } else if (tag.func_74732_a() == 8) {
            NBTHelper.print(name + " (String): " + ((NBTTagString)tag).func_150285_a_(), offset, list);
        } else if (tag.func_74732_a() == 9) {
            NBTHelper.printNBTTagList(name, (NBTTagList)tag, offset);
        } else if (tag.func_74732_a() == 10) {
            NBTHelper.printNBTTagCompound(name, (NBTTagCompound)tag, offset, list);
        } else if (tag.func_74732_a() == 11) {
            NBTHelper.print(name + " (Int Array): " + ((NBTTagIntArray)tag).func_150302_c(), offset, list);
        }
    }

    private static void print(String s, int offset) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < offset; ++i) {
            sb.append("  ");
        }
        sb.append("-" + s);
        s = sb.toString();
        s = s.replace("\n", "\\n").replace("\r", "\\r");
        System.out.println(s);
    }

    private static void print(String s, int offset, boolean b) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < offset; ++i) {
            sb.append("  ");
        }
        if (b) {
            sb.append(s);
        } else {
            sb.append("-" + s);
        }
        s = sb.toString();
        s = s.replace("\n", "\\n").replace("\r", "\\r");
        System.out.println(s);
    }
}

