/*
 * Decompiled with CFR 0.152.
 */
package jajo_11.ShadowWorld.Utils;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import jajo_11.ShadowWorld.Block.AzuriteRune;
import jajo_11.ShadowWorld.Entity.EntityDemon;
import jajo_11.ShadowWorld.Handlers.ExtendedPlayer;
import jajo_11.ShadowWorld.ShadowWorld;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.C17PacketCustomPayload;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;

public class Demon
implements Comparable<Demon> {
    public static String[] demons1 = new String[]{"Mosndas", "Sosxael", "Adapen", "Lisatasiel", "Zemsotapael", "Narziel", "Pamnbes", "Arahecd", "Asontakit", "Onalazr", "Homus", "Ozutol", "Lerapaihhan", "Zezosepiel", "Omadanael", "Errtas", "Anurab", "Raax", "Trasal", "Deharep"};
    public static String[] demons2 = new String[]{"", ""};
    public static String[] demons3 = new String[]{"", ""};
    public static String[] demons4 = new String[]{"", ""};
    public static String[] demons5 = new String[]{"TEST", "TEST2"};
    public static String[] demons6 = new String[]{"", ""};
    public static String[] demons7 = new String[]{"", ""};
    public static String[] types = new String[]{"BUG", "Unnamed", "Imp", "Foliot", "Djinni", "Afrit", "Marid", "?"};
    public static int[] levelColors = new int[]{3347711, 60017, 16755239, 13762304, 0xC60000, 15663339, 7405803};
    public static String[] abilities = new String[]{"It's a bug :D", "Very weak, can only perform simple tasks", "Common demon, easy to summon and suitable for normal tasks", "Not very inteligent, moderate attack power", "A normal demon, very useful", "A bit stronger than a djinn, good at fighting", "A very strong demon. Hard to summon, but very powerful", "Incredibly strong"};
    private String name;
    private int level;
    private boolean wasSummoned;
    private boolean inWorld;
    private String UUID = "";
    private int skin = -1;

    public Demon(String name, int level) {
        this.name = name;
        this.level = level;
        this.wasSummoned = false;
        this.inWorld = false;
    }

    public String getUUID() {
        return this.UUID;
    }

    public String getName() {
        return this.name;
    }

    public int getLevel() {
        return this.level;
    }

    public int getSkin() {
        return this.skin;
    }

    public boolean wasSummoned() {
        return this.wasSummoned;
    }

    public boolean inWorld() {
        return this.inWorld;
    }

    public Demon setUUID(String UUID2) {
        this.UUID = UUID2;
        return this;
    }

    public Demon setName(String name) {
        this.name = name;
        return this;
    }

    public Demon setLevel(int level) {
        this.level = level;
        return this;
    }

    public Demon setSummoned(boolean summoned) {
        this.wasSummoned = summoned;
        return this;
    }

    public Demon setInWorld(boolean inWorld) {
        this.inWorld = inWorld;
        return this;
    }

    public Demon setSkin(int skin) {
        this.skin = skin;
        return this;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74778_a("name", this.name);
        tag.func_74768_a("level", this.level);
        tag.func_74757_a("wasSummoned", this.wasSummoned);
        tag.func_74757_a("inWorld", this.inWorld);
        tag.func_74778_a("UUID", this.UUID);
        tag.func_74768_a("skin", this.skin);
        return tag;
    }

    public static Demon readFromNBT(NBTTagCompound tag) {
        if (!tag.func_74764_b("name")) {
            return null;
        }
        String name = tag.func_74779_i("name");
        int level = tag.func_74762_e("level");
        boolean wasSummoned = tag.func_74767_n("wasSummoned");
        boolean inWorld = tag.func_74767_n("inWorld");
        String UUID2 = tag.func_74779_i("UUID");
        int skin = tag.func_74762_e("skin");
        Demon d = new Demon(name, level).setSummoned(wasSummoned).setInWorld(inWorld).setUUID(UUID2).setSkin(skin);
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SideOnly(value=Side.CLIENT)
    public void call() {
        Minecraft.func_71410_x().func_147108_a(null);
        int index = ExtendedPlayer.get((EntityPlayer)Minecraft.func_71410_x().field_71439_g).getDemons().indexOf(this);
        String name = Minecraft.func_71410_x().field_71439_g.func_70005_c_();
        ByteBuf bytebuf = Unpooled.buffer();
        try {
            PacketBuffer p = new PacketBuffer(bytebuf);
            p.writeInt(index);
            p.func_150785_a(name);
            Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new C17PacketCustomPayload("SW|Call", bytebuf));
        }
        catch (Exception exception) {
            LogManager.getLogger().error("Couldn't call demon: " + this.toString(), (Throwable)exception);
        }
        finally {
            bytebuf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SideOnly(value=Side.CLIENT)
    public void summon() {
        Minecraft.func_71410_x().func_147108_a(null);
        this.wasSummoned = true;
        this.inWorld = true;
        int index = ExtendedPlayer.get((EntityPlayer)Minecraft.func_71410_x().field_71439_g).getDemons().indexOf(this);
        String name = Minecraft.func_71410_x().field_71439_g.func_70005_c_();
        ByteBuf bytebuf = Unpooled.buffer();
        try {
            PacketBuffer p = new PacketBuffer(bytebuf);
            p.writeInt(index);
            p.func_150785_a(name);
            Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new C17PacketCustomPayload("SW|Summon", bytebuf));
        }
        catch (Exception exception) {
            LogManager.getLogger().error("Couldn't summon demon: " + this.toString(), (Throwable)exception);
        }
        finally {
            bytebuf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SideOnly(value=Side.CLIENT)
    public void dismiss() {
        Minecraft.func_71410_x().func_147108_a(null);
        int index = ExtendedPlayer.get((EntityPlayer)Minecraft.func_71410_x().field_71439_g).getDemons().indexOf(this);
        String name = Minecraft.func_71410_x().field_71439_g.func_70005_c_();
        ByteBuf bytebuf = Unpooled.buffer();
        try {
            PacketBuffer p = new PacketBuffer(bytebuf);
            p.writeInt(index);
            p.func_150785_a(name);
            Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new C17PacketCustomPayload("SW|Dismiss", bytebuf));
        }
        catch (Exception exception) {
            LogManager.getLogger().error("Couldn't dismiss demon: " + this.toString(), (Throwable)exception);
        }
        finally {
            bytebuf.release();
        }
    }

    public static void summon(World world, EntityPlayer player, Demon demon) {
        demon.wasSummoned = true;
        demon.inWorld = true;
        EntityDemon d = new EntityDemon(world);
        d.func_94058_c(demon.name);
        d.setSummoner(player.func_70005_c_());
        d.onSummoned();
        d.setFlying(true);
        d.func_70624_b((EntityLivingBase)player);
        if (demon.skin == -1) {
            demon.skin = world.field_73012_v.nextInt(5);
        }
        d.setSkin(demon.skin);
        int x = MathHelper.func_76128_c((double)player.field_70165_t);
        int y = MathHelper.func_76128_c((double)player.field_70163_u);
        int z = MathHelper.func_76128_c((double)player.field_70161_v);
        int t = 0;
        if (world.func_147439_a(x + 2, y, z) == ShadowWorld.SoulRune && AzuriteRune.isMiddleofCircle((IBlockAccess)world, x + 4, y, z)) {
            ++t;
            d.func_70012_b((double)(x + 4) + 0.5, (double)y + 0.5, (double)z + 0.5, 0.0f, 0.0f);
        }
        if (world.func_147439_a(x, y, z + 2) == ShadowWorld.SoulRune && AzuriteRune.isMiddleofCircle((IBlockAccess)world, x, y, z + 4)) {
            ++t;
            d.func_70012_b((double)x + 0.5, (double)y + 0.5, (double)(z + 4) + 0.5, 0.0f, 0.0f);
        }
        if (world.func_147439_a(x - 2, y, z) == ShadowWorld.SoulRune && AzuriteRune.isMiddleofCircle((IBlockAccess)world, x - 4, y, z)) {
            ++t;
            d.func_70012_b((double)(x - 4) + 0.5, (double)y + 0.5, (double)z + 0.5, 0.0f, 0.0f);
        }
        if (world.func_147439_a(x, y, z - 2) == ShadowWorld.SoulRune && AzuriteRune.isMiddleofCircle((IBlockAccess)world, x, y, z - 4)) {
            ++t;
            d.func_70012_b((double)x + 0.5, (double)y + 0.5, (double)(z - 4) + 0.5, 0.0f, 0.0f);
        }
        if (t != 1) {
            int i = MathHelper.func_76128_c((double)player.field_70165_t) - 2;
            int j = MathHelper.func_76128_c((double)player.field_70161_v) - 2;
            int k = MathHelper.func_76128_c((double)player.field_70121_D.field_72338_b);
            block0: for (int l = 0; l <= 4; ++l) {
                for (int i1 = 0; i1 <= 4; ++i1) {
                    if (l >= 1 && i1 >= 1 && l <= 3 && i1 <= 3 || world.func_147439_a(i + l, k, j + i1).func_149721_r() || world.func_147439_a(i + l, k + 1, j + i1).func_149721_r() || !world.func_72855_b(AxisAlignedBB.func_72330_a((double)(i + l), (double)(k + 1), (double)(j + i1), (double)(i + l + 1), (double)(k + 2), (double)(j + i1 + 1)))) continue;
                    d.func_70012_b((float)(i + l) + 0.5f, (double)k + 0.5, (float)(j + i1) + 0.5f, 0.0f, 0.0f);
                    d.endSummoning(false);
                    break block0;
                }
            }
        }
        d.func_70625_a((Entity)player, 10.0f, d.func_70646_bf());
        d.func_70671_ap().func_75651_a((Entity)player, 10.0f, (float)d.func_70646_bf());
        d.setFlightTarget(d.field_70165_t, d.field_70163_u, d.field_70161_v);
        world.func_72838_d((Entity)d);
        demon.setUUID(d.func_110124_au().toString());
    }

    @Override
    public int compareTo(Demon d) {
        return this.inWorld && !d.inWorld ? -1 : (!this.inWorld && d.inWorld ? 1 : (this.level > d.level ? -1 : (this.level < d.level ? 1 : this.name.compareTo(d.name))));
    }

    public static Demon createDemonByName(String name) {
        if (Arrays.asList(demons1).contains(name)) {
            return new Demon(name, 1);
        }
        if (Arrays.asList(demons2).contains(name)) {
            return new Demon(name, 2);
        }
        if (Arrays.asList(demons3).contains(name)) {
            return new Demon(name, 3);
        }
        if (Arrays.asList(demons4).contains(name)) {
            return new Demon(name, 4);
        }
        if (Arrays.asList(demons5).contains(name)) {
            return new Demon(name, 5);
        }
        if (Arrays.asList(demons6).contains(name)) {
            return new Demon(name, 6);
        }
        if (Arrays.asList(demons7).contains(name)) {
            return new Demon(name, 7);
        }
        return null;
    }

    public static String[][] getDemons() {
        return new String[][]{demons1, demons2, demons3, demons4, demons5, demons6, demons7};
    }

    public String toString() {
        return "Demon: " + this.name + ", Level: " + this.level;
    }

    public boolean equals(Object o) {
        if (o instanceof Demon) {
            Demon d = (Demon)o;
            return this.name.equals(d.getName());
        }
        return false;
    }

    public static Demon getDemon(EntityPlayer player, EntityDemon demon) {
        if (player == null || demon == null) {
            return null;
        }
        String name = demon.func_70005_c_();
        int index = ExtendedPlayer.get(player).getDemons().indexOf(Demon.createDemonByName(name));
        if (index == -1) {
            return null;
        }
        return ExtendedPlayer.get(player).getDemons().get(index);
    }

    public EntityDemon findDemon(World world) {
        if (!this.inWorld) {
            return null;
        }
        UUID UUID2 = java.util.UUID.fromString(this.UUID);
        if (UUID2 == null) {
            return null;
        }
        for (Object o : world.field_72996_f) {
            if (!(o instanceof EntityDemon) || !((Entity)o).getPersistentID().equals(UUID2)) continue;
            return (EntityDemon)o;
        }
        return null;
    }
}

