/*
 * Decompiled with CFR 0.152.
 */
package jajo_11.ShadowWorld.GUI;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import jajo_11.ShadowWorld.ClientProxy;
import jajo_11.ShadowWorld.Entity.EntityTravellingDwarf;
import jajo_11.ShadowWorld.GUI.GuiTravellingDwarfInventory;
import jajo_11.ShadowWorld.GUI.GuiTravellingDwarfMerchant;
import jajo_11.ShadowWorld.Handlers.ShadowSound;
import jajo_11.ShadowWorld.ShadowWorld;
import jajo_11.ShadowWorld.Utils.NBTHelper;
import jajo_11.ShadowWorld.Utils.Quest;
import java.util.Collection;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.C17PacketCustomPayload;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiTravellingDwarf
extends GuiScreen {
    private static final ResourceLocation textures = new ResourceLocation("shadowworld:textures/gui/TravellingDwarf.png");
    private static final ResourceLocation textures2 = new ResourceLocation("shadowworld:textures/gui/Partner.png");
    protected static final ResourceLocation field_147001_a = new ResourceLocation("textures/gui/container/inventory.png");
    private int bookImageWidth = 176;
    private int bookImageHeight = 166;
    private int bookTotalPages = 1;
    private int currPage;
    private boolean dialog = false;
    private boolean ask = false;
    private boolean rename = false;
    private String dwarfname;
    private int updateCount;
    private NBTTagList story;
    EntityTravellingDwarf dwarf;
    private DwarvenButton buttonNextPage;
    private DwarvenButton buttonDone;
    private DwarvenButton buttonYes;
    private DwarvenButton buttonNo;
    private RenderItem render;
    private PartnerButton buttonRename;
    private PartnerButton buttonStay;
    private PartnerButton buttonFood;
    private boolean field_147045_u;
    Random rand = new Random();

    public GuiTravellingDwarf(EntityTravellingDwarf dwarf) {
        this.dwarf = dwarf;
        this.render = new RenderItem();
        this.dwarfname = (this.dwarf.func_70631_g_() ? "Tiny " : "") + (this.dwarf.func_94056_bM() ? this.dwarf.func_94057_bL() : "Partner");
        if (!dwarf.isMerchant() && !dwarf.isPartner()) {
            this.story = dwarf.getStory();
        } else if (dwarf.isMerchant()) {
            this.story = new NBTTagList();
            int i = this.rand.nextInt(6);
            if (i == 0) {
                this.story.func_74742_a((NBTBase)new NBTTagString("Do you want to buy something?"));
            } else if (i == 1) {
                this.story.func_74742_a((NBTBase)new NBTTagString("Here are some items I've found on my journeys in the Shadow World. Do you want to buy some of them?"));
            } else if (i == 2) {
                this.story.func_74742_a((NBTBase)new NBTTagString("Sometimes it's really hard to find a dungeon item, here I come into play with my offerings!"));
            } else if (i == 3) {
                this.story.func_74742_a((NBTBase)new NBTTagString("You are searching for rare items? Search no more if the price is right you can buy everything right here."));
            } else if (i == 4) {
                this.story.func_74742_a((NBTBase)new NBTTagString("I am the best merchant in range of thousand of blocks, if you need dungeon loot you are already in the right place!"));
            } else {
                this.story.func_74742_a((NBTBase)new NBTTagString("If you need something, you can buy it from me."));
            }
        } else if (this.dwarf.func_70909_n()) {
            if (this.dwarf.func_152114_e((EntityLivingBase)Minecraft.func_71410_x().field_71439_g)) {
                this.story = new NBTTagList();
                if (this.dwarf.func_110143_aJ() < this.dwarf.func_110138_aP() && this.rand.nextBoolean()) {
                    int i = this.rand.nextInt(3);
                    if (i == 0) {
                        this.story.func_74742_a((NBTBase)new NBTTagString("I'm hungry. Please give me food."));
                    } else if (i == 1) {
                        this.story.func_74742_a((NBTBase)new NBTTagString("Do you have some food? "));
                    } else {
                        this.story.func_74742_a((NBTBase)new NBTTagString("I really have to eat something."));
                    }
                } else {
                    int i = this.rand.nextInt(8);
                    if (i == 0) {
                        this.story.func_74742_a((NBTBase)new NBTTagString("Hello, partner. What do you want?"));
                    } else if (i == 1) {
                        this.story.func_74742_a((NBTBase)new NBTTagString("Always at your service."));
                    } else if (i == 2) {
                        this.story.func_74742_a((NBTBase)new NBTTagString("Your wish is my command."));
                    } else if (i == 3) {
                        this.story.func_74742_a((NBTBase)new NBTTagString("How can I help you?"));
                    } else if (i == 4) {
                        this.story.func_74742_a((NBTBase)new NBTTagString("Why did we stop?"));
                    } else if (i == 5) {
                        this.story.func_74742_a((NBTBase)new NBTTagString("Anything else?"));
                    } else if (i == 6) {
                        this.story.func_74742_a((NBTBase)new NBTTagString("There's something cooking."));
                    } else {
                        this.story.func_74742_a((NBTBase)new NBTTagString("Go on. I'll follow you"));
                    }
                }
            } else {
                this.story = new NBTTagList();
                int i = this.rand.nextInt(4);
                if (i == 0) {
                    this.story.func_74742_a((NBTBase)new NBTTagString("Are you drunk or something? I alredy have a partner."));
                } else if (i == 1) {
                    this.story.func_74742_a((NBTBase)new NBTTagString("Let us face the facts. I am already spoken for."));
                } else if (i == 2 && this.dwarf.func_70902_q() != null) {
                    this.story.func_74742_a((NBTBase)new NBTTagString("I'm glad to meet you, but if you wanted to work with me I will have to disappoint you. I already work with " + this.dwarf.func_70902_q().func_70005_c_()));
                } else if (this.dwarf.func_70902_q() != null) {
                    this.story.func_74742_a((NBTBase)new NBTTagString("Hello, I'm " + this.dwarf.func_70902_q().func_70005_c_() + "'s partner."));
                } else {
                    this.story.func_74742_a((NBTBase)new NBTTagString("Hello, are you my partner? I can't remember anymore."));
                }
            }
        } else {
            this.story = new NBTTagList();
            int i = this.rand.nextInt(5);
            if (i == 0) {
                this.story.func_74742_a((NBTBase)new NBTTagString("Do you need a partner? When you give me 20 Shadow Coins, I'll follow you."));
            } else if (i == 1) {
                this.story.func_74742_a((NBTBase)new NBTTagString("Once I was an adventurer like you ... And when you give me some money I'll help you on your own adventure!"));
            } else if (i == 2) {
                this.story.func_74742_a((NBTBase)new NBTTagString("For a small fee I could be the adventurer at your side!"));
            } else if (i == 3) {
                this.story.func_74742_a((NBTBase)new NBTTagString("Aren't you lonely? Man does not live by bread alone."));
            } else {
                this.story.func_74742_a((NBTBase)new NBTTagString("I'm looking for work. If you want I can become your partner. But of course you have to pay something..."));
            }
        }
        if (this.story != null) {
            this.story = (NBTTagList)this.story.func_74737_b();
            this.bookTotalPages = this.story.func_74745_c();
            if (this.bookTotalPages < 1) {
                this.bookTotalPages = 1;
            }
        }
        if (this.story == null || this.story.func_74745_c() == 0) {
            this.story = new NBTTagList();
            this.story.func_74742_a((NBTBase)new NBTTagString("I don't have anything to tell you."));
            this.bookTotalPages = 1;
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73876_c() {
        super.func_73876_c();
        ++this.updateCount;
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (this.dwarf.getHasQuest()) {
            if (player.getEntityData() != null) {
                if (!NBTHelper.getPersistentTag((EntityPlayer)player).func_74764_b("shadowworld/quests")) {
                    NBTHelper.getPersistentTag((EntityPlayer)player).func_74782_a("shadowworld/quests", (NBTBase)new NBTTagList());
                    ClientProxy.entry.showQuest();
                }
                for (int i = 0; i < NBTHelper.getQuests((EntityPlayer)player).func_74745_c(); ++i) {
                    if (!NBTHelper.getQuests((EntityPlayer)player).func_150305_b(i).func_74779_i("name").equals(this.dwarf.getQuest().getName()) || !this.dwarf.getQuest().canBeFinished((EntityPlayer)player)) continue;
                    this.dialog = true;
                    this.updateButtons();
                }
            }
        } else if (this.dwarf.isPartner() && this.ask) {
            if (player.field_71071_by.func_146028_b(ShadowWorld.ShadowCoin)) {
                int count = 0;
                for (ItemStack stack : player.field_71071_by.field_70462_a) {
                    if (stack == null || !stack.func_77969_a(new ItemStack(ShadowWorld.ShadowCoin))) continue;
                    count += stack.field_77994_a;
                }
                if (count >= 20) {
                    this.dialog = true;
                    this.ask = false;
                    this.updateButtons();
                } else {
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new ShadowSound("mob.villager.no", 2.0f, ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f) * -1.0f));
                    this.ask = false;
                    this.setMoneyStory();
                }
            } else {
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new ShadowSound("mob.villager.no", 2.0f, ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f) * -1.0f));
                this.ask = false;
                this.setMoneyStory();
            }
        }
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        this.buttonDone = new DwarvenButton(0, this.field_146294_l / 2 - 80, this.bookImageHeight - 25, this.randomMessage(true));
        this.field_146292_n.add(this.buttonDone);
        this.buttonNextPage = new DwarvenButton(1, this.field_146294_l / 2 - 80, this.bookImageHeight - 50, "Mhm...");
        this.field_146292_n.add(this.buttonNextPage);
        this.buttonYes = new DwarvenButton(2, this.field_146294_l / 2 - 80, this.bookImageHeight - 50, "Yes");
        this.field_146292_n.add(this.buttonYes);
        this.buttonNo = new DwarvenButton(3, this.field_146294_l / 2 - 80, this.bookImageHeight - 25, "No");
        this.field_146292_n.add(this.buttonNo);
        this.buttonRename = new PartnerButton(4, this.field_146294_l / 2 + 94, 10, "Rename");
        this.field_146292_n.add(this.buttonRename);
        this.buttonStay = new PartnerButton(5, this.field_146294_l / 2 + 94, 35, "Stay");
        this.field_146292_n.add(this.buttonStay);
        this.buttonFood = new PartnerButton(6, this.field_146294_l / 2 + 94, 60, "Inventory");
        this.field_146292_n.add(this.buttonFood);
        this.buttonStay.field_146126_j = this.dwarf.func_70906_o() ? "Follow" : "Stay";
        int r = this.rand.nextInt(5);
        if (this.dwarf.isPartner()) {
            String s = r == 0 ? "Here you are. Follow me" : (r == 1 ? "Yes, I really need a partner" : (r == 2 ? "Let's go!" : (r == 3 ? "Are you ready?" : "OK, let's go.")));
            this.buttonNextPage.field_146126_j = s;
        } else if (this.dwarf.isMerchant()) {
            String s = r == 0 ? "Show me what you have to sell" : (r == 1 ? "Let's see what you have" : (r == 2 ? "Show me your goods." : (r == 3 ? "Sounds good." : "I want to buy something")));
            this.buttonNextPage.field_146126_j = s;
        }
        this.updateButtons();
        if (!this.dwarf.func_70651_bq().isEmpty()) {
            this.field_147045_u = true;
        }
    }

    private void updateButtons() {
        this.buttonNextPage.field_146125_m = (this.currPage < this.bookTotalPages - 1 && !this.dwarf.isPartner() || this.dwarf.isPartner() && !this.dwarf.func_70909_n() || this.dwarf.isMerchant()) && !this.dialog;
        this.buttonDone.field_146125_m = !this.dialog && !this.rename;
        this.buttonYes.field_146125_m = this.dialog || this.rename;
        this.buttonNo.field_146125_m = this.dialog || this.rename;
        this.buttonStay.field_146125_m = this.buttonRename.field_146125_m = this.dwarf.isPartner() && this.dwarf.func_70909_n() && this.dwarf.func_152114_e((EntityLivingBase)Minecraft.func_71410_x().field_71439_g) && !this.rename && !this.dialog;
        this.buttonFood.field_146125_m = this.buttonRename.field_146125_m;
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
        if (this.dwarf.getHasQuest() && this.currPage >= this.bookTotalPages - 1 && !this.dialog && this.dwarf.getQuest() != null && !this.dwarf.getQuest().isFinished()) {
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            if (player.getEntityData() != null && !NBTHelper.getPersistentTag((EntityPlayer)player).func_74764_b("shadowworld/quests")) {
                NBTHelper.getPersistentTag((EntityPlayer)player).func_74782_a("shadowworld/quests", (NBTBase)new NBTTagList());
                ClientProxy.entry.showQuest();
            }
            Quest quest = this.dwarf.getQuest();
            quest.setPosX((int)this.dwarf.field_70165_t);
            quest.setPosY((int)this.dwarf.field_70163_u);
            quest.setPosZ((int)this.dwarf.field_70161_v);
            Quest.addQuest((Entity)this.dwarf, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, quest);
        } else if (this.currPage < this.bookTotalPages - 1) {
            String name = (this.dwarf.func_70631_g_() ? "Tiny " : "") + (this.dwarf.func_94056_bM() ? this.dwarf.func_94057_bL() : (this.dwarf.isPartner() ? "Partner" : (this.dwarf.isMerchant() ? "Merchant" : "Traveller")));
            String message = "Hey!";
            int i = this.rand.nextInt(5);
            if (i == 0) {
                message = "Let me finish speaking!";
            } else if (i == 1) {
                message = "Hey, come back!";
            } else if (i == 2) {
                message = "You're not interested?!";
            } else if (i == 3) {
                message = "...";
            }
            Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("<" + name + "> " + message));
            for (i = 0; i < 5; ++i) {
                double d0 = this.rand.nextGaussian() * 0.02;
                double d1 = this.rand.nextGaussian() * 0.02;
                double d2 = this.rand.nextGaussian() * 0.02;
                this.field_146297_k.field_71441_e.func_72869_a("angryVillager", this.dwarf.field_70165_t + (double)(this.rand.nextFloat() * this.dwarf.field_70130_N * 2.0f) - (double)this.dwarf.field_70130_N, this.dwarf.field_70163_u + 1.0 + (double)(this.rand.nextFloat() * this.dwarf.field_70131_O), this.dwarf.field_70161_v + (double)(this.rand.nextFloat() * this.dwarf.field_70130_N * 2.0f) - (double)this.dwarf.field_70130_N, d0, d1, d2);
            }
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new ShadowSound("mob.villager.no", 2.0f, ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f) * -1.0f));
        }
        if (this.dialog) {
            this.dialog = false;
        }
        if (this.ask) {
            this.ask = false;
        }
        if (this.rename) {
            this.ask = false;
        }
    }

    private void closeGui() {
        this.field_146297_k.func_147108_a((GuiScreen)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void func_146284_a(GuiButton p_146284_1_) {
        if (p_146284_1_.field_146124_l) {
            if (p_146284_1_.field_146127_k == 0) {
                this.closeGui();
            } else if (p_146284_1_.field_146127_k == 1) {
                if (this.dwarf.isPartner()) {
                    this.ask = true;
                } else if (this.dwarf.isMerchant()) {
                    Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiTravellingDwarfMerchant((EntityPlayer)Minecraft.func_71410_x().field_71439_g, this.dwarf, (this.dwarf.func_70631_g_() ? "Tiny " : "") + (this.dwarf.func_94056_bM() ? this.dwarf.func_94057_bL() : "Merchant")));
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new ShadowSound("mob.villager.yes", 1.0f, ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f) * -1.0f));
                    ByteBuf bytebuf = Unpooled.buffer();
                    try {
                        PacketBuffer b = new PacketBuffer(bytebuf);
                        b.writeInt(this.dwarf.func_145782_y());
                        b.writeInt(this.dwarf.field_71093_bK);
                        b.func_150785_a(Minecraft.func_71410_x().field_71439_g.func_70005_c_());
                        Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new C17PacketCustomPayload("SW|Merchant", bytebuf));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    finally {
                        bytebuf.release();
                    }
                } else if (this.currPage < this.bookTotalPages - 1) {
                    ++this.currPage;
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new ShadowSound("mob.villager.yes", 1.0f, ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f) * -1.0f));
                    this.buttonNextPage.field_146126_j = this.randomMessage(false);
                    this.buttonDone.field_146126_j = this.randomMessage(true);
                }
            } else if (p_146284_1_.field_146127_k == 2) {
                if (this.dwarf.isPartner()) {
                    if (this.rename) {
                        this.changeName();
                    } else {
                        this.story = new NBTTagList();
                        this.story.func_74742_a((NBTBase)new NBTTagString("Ok. I'll follow you"));
                        for (int i = 20; i > 0; --i) {
                            Minecraft.func_71410_x().field_71439_g.field_71071_by.func_146026_a(ShadowWorld.ShadowCoin);
                        }
                        this.dwarf.func_70903_f(true);
                        this.dwarf.func_70778_a(null);
                        this.dwarf.func_70624_b(null);
                        this.dwarf.func_70606_j(20.0f);
                        this.dwarf.func_152115_b(Minecraft.func_71410_x().field_71439_g.func_110124_au().toString());
                        this.dwarf.field_70170_p.func_72960_a((Entity)this.dwarf, (byte)7);
                        Minecraft.func_71410_x().field_71439_g.func_71064_a((StatBase)ShadowWorld.friend, 1);
                        ByteBuf bytebuf = Unpooled.buffer();
                        try {
                            PacketBuffer b = new PacketBuffer(bytebuf);
                            b.writeInt(this.dwarf.func_145782_y());
                            b.writeInt(this.dwarf.field_71093_bK);
                            b.func_150785_a(Minecraft.func_71410_x().field_71439_g.func_70005_c_());
                            b.func_150785_a(Minecraft.func_71410_x().field_71439_g.func_110124_au().toString());
                            Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new C17PacketCustomPayload("SW|Partner", bytebuf));
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        finally {
                            bytebuf.release();
                        }
                        this.dialog = false;
                        if (this.story != null) {
                            this.story = (NBTTagList)this.story.func_74737_b();
                            this.bookTotalPages = this.story.func_74745_c();
                            if (this.bookTotalPages < 1) {
                                this.bookTotalPages = 1;
                            }
                        }
                    }
                } else {
                    Quest quest = this.dwarf.getQuest();
                    quest.setPosX((int)this.dwarf.field_70165_t);
                    quest.setPosY((int)this.dwarf.field_70163_u);
                    quest.setPosZ((int)this.dwarf.field_70161_v);
                    Quest.addQuest((Entity)this.dwarf, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, quest);
                    this.dialog = false;
                    this.story = this.dwarf.getStory();
                    if (this.story != null) {
                        this.story = (NBTTagList)this.story.func_74737_b();
                        this.bookTotalPages = this.story.func_74745_c();
                        if (this.bookTotalPages < 1) {
                            this.bookTotalPages = 1;
                        }
                    }
                }
                if (this.story == null || this.story.func_74745_c() == 0) {
                    this.story = new NBTTagList();
                    this.story.func_74742_a((NBTBase)new NBTTagString("I don't have anything to tell you."));
                    this.bookTotalPages = 1;
                }
            } else if (p_146284_1_.field_146127_k == 3) {
                if (this.rename) {
                    this.rename = false;
                    this.updateButtons();
                } else {
                    this.closeGui();
                }
            } else if (p_146284_1_.field_146127_k == 4) {
                this.rename = true;
            } else if (p_146284_1_.field_146127_k == 5) {
                ByteBuf bytebuf = Unpooled.buffer();
                try {
                    PacketBuffer b = new PacketBuffer(bytebuf);
                    b.writeInt(this.dwarf.func_145782_y());
                    b.writeInt(this.dwarf.field_71093_bK);
                    Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new C17PacketCustomPayload("SW|PartnerSit", bytebuf));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                finally {
                    bytebuf.release();
                }
                this.buttonStay.field_146126_j = this.buttonStay.field_146126_j.equals("Stay") ? "Follow" : "Stay";
            } else if (p_146284_1_.field_146127_k == 6) {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiTravellingDwarfInventory((EntityPlayer)Minecraft.func_71410_x().field_71439_g, this.dwarf, (this.dwarf.func_70631_g_() ? "Tiny " : "") + (this.dwarf.func_94056_bM() ? this.dwarf.func_94057_bL() : "Partner")));
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new ShadowSound("mob.villager.yes", 1.0f, ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f) * -1.0f));
                ByteBuf bytebuf = Unpooled.buffer();
                try {
                    PacketBuffer b = new PacketBuffer(bytebuf);
                    b.writeInt(this.dwarf.func_145782_y());
                    b.writeInt(this.dwarf.field_71093_bK);
                    b.func_150785_a(Minecraft.func_71410_x().field_71439_g.func_70005_c_());
                    Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new C17PacketCustomPayload("SW|PartnerInv", bytebuf));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                finally {
                    bytebuf.release();
                }
            }
            this.updateButtons();
        }
    }

    private String randomMessage(boolean b) {
        String s;
        int r = this.rand.nextInt(7);
        if (b) {
            boolean b1;
            boolean bl = b1 = this.dwarf.isPartner() && this.dwarf.func_70909_n() && this.dwarf.func_152114_e((EntityLivingBase)Minecraft.func_71410_x().field_71439_g);
            if (this.dwarf.getHasQuest() && this.currPage >= this.bookTotalPages - 1) {
                s = "OK, I'll help you";
                if (r == 0) {
                    s = "I think I can do this";
                } else if (r == 1) {
                    s = "OK";
                }
            } else if (b1) {
                s = "Let's go";
                if (r == 0) {
                    s = "Follow me";
                } else if (r == 1) {
                    s = "Come on, let's go";
                } else if (r == 2) {
                    s = "We have to go";
                } else if (r == 3) {
                    s = "We should go now";
                }
            } else {
                s = "Good bye";
                if (this.dwarf.isPartner() && !this.dwarf.func_70909_n()) {
                    if (r == 0) {
                        s = "I don't need a partner.";
                    } else if (r == 1) {
                        s = "I'll come back later";
                    } else if (r == 2) {
                        s = "I'm not interested";
                    } else if (r == 3) {
                        s = "I don't have enough money";
                    } else if (r == 4) {
                        s = "Sorry, but I have to move on.";
                    }
                } else if (this.dwarf.isMerchant()) {
                    if (r == 0) {
                        s = "I don't want to buy anything";
                    } else if (r == 1) {
                        s = "This is too expensive.";
                    } else if (r == 2) {
                        s = "Mhhm ... I don't need this stuff";
                    } else if (r == 3) {
                        s = "I don't have enough money";
                    } else if (r == 4) {
                        s = "I'll come back later";
                    }
                } else if (r == 0) {
                    s = "I have to go.";
                } else if (r == 1) {
                    s = "That's enough";
                } else if (r == 2) {
                    s = "See you...";
                } else if (r == 3) {
                    s = "Bye bye";
                } else if (r == 4) {
                    s = "Sorry, but I have to move on.";
                } else if (r == 5) {
                    s = "I'll come back later.";
                }
            }
        } else {
            s = "Mhm...";
            if (r == 0) {
                s = "...";
            } else if (r == 1) {
                s = "...oh...";
            } else if (r == 2) {
                s = "And than?";
            } else if (r == 3) {
                s = "Go on";
            } else if (r == 4) {
                s = "Tell me more!";
            } else if (r == 5) {
                s = "Yes?";
            }
        }
        return s;
    }

    private void setMoneyStory() {
        int r = this.rand.nextInt(7);
        String s = "That's not enough.";
        if (r == 0) {
            s = "Are you kidding me? You don't have enough coins!";
        } else if (r == 1) {
            s = "Is this a joke?! Give me more money!";
        } else if (r == 2) {
            s = "I'm sorry, but I really need this money. I'll help you if you give me enough.";
        } else if (r == 3) {
            s = "Come back when you have enough Shadow Coins. I'll wait for you.";
        } else if (r == 4) {
            s = "No money, no partner. Sorry.";
        } else if (r == 5) {
            s = "NO. I want to have exactly 20 Shadow Coins.";
        }
        this.story = new NBTTagList();
        this.story.func_74742_a((NBTBase)new NBTTagString(s));
        this.buttonNextPage.field_146126_j = "Is this enough money?";
    }

    public void func_73863_a(int par1, int par2, float par3) {
        boolean b;
        this.buttonYes.field_146129_i = this.bookImageHeight - 50;
        this.buttonNo.field_146129_i = this.bookImageHeight - 25;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int k = (this.field_146294_l - this.bookImageWidth) / 2;
        int b0 = 2;
        boolean bl = b = this.dwarf.isPartner() && this.dwarf.func_70909_n() && this.dwarf.func_152114_e((EntityLivingBase)Minecraft.func_71410_x().field_71439_g);
        if (b) {
            this.field_146297_k.func_110434_K().func_110577_a(textures2);
        } else {
            this.field_146297_k.func_110434_K().func_110577_a(textures);
        }
        if (this.dialog) {
            GuiTravellingDwarf.func_73734_a((int)0, (int)0, (int)this.field_146294_l, (int)this.field_146295_m, (int)Integer.MIN_VALUE);
            ItemStack stack = new ItemStack(ShadowWorld.ShadowCoin);
            ItemStack[] stacks = new ItemStack[1];
            boolean flag = false;
            if (this.dwarf.isPartner()) {
                stack = new ItemStack(ShadowWorld.ShadowCoin, 20);
            } else if (this.dwarf.getQuest().getType().equals("items")) {
                flag = true;
                stacks = this.dwarf.getQuest().getItems();
            } else {
                stack = this.dwarf.getQuest().getRequires();
            }
            if (flag) {
                int i;
                String name = "\"" + (this.dwarf.func_70631_g_() ? "Tiny " : "") + (this.dwarf.func_94056_bM() ? this.dwarf.func_94057_bL() + "\" " : (this.dwarf.isMerchant() ? "Merchant\" " : (this.dwarf.isPartner() ? "Partner\" " : "Traveller\" ")));
                String s1 = "Do you really want to give " + name + "the following items?";
                int d = (this.field_146294_l - this.field_146289_q.func_78256_a(s1)) / 2;
                this.field_146289_q.func_78261_a(s1, d, b0 + 64, -256);
                this.buttonYes.field_146129_i = this.bookImageHeight - 70 + stacks.length * 20;
                this.buttonNo.field_146129_i = this.bookImageHeight - 45 + stacks.length * 20;
                super.func_73863_a(par1, par2, par3);
                for (i = 0; i < stacks.length; ++i) {
                    stack = stacks[i];
                    this.field_146289_q.func_78261_a(stack.field_77994_a + " x ", this.field_146294_l / 2 - 22, b0 + 92 + i * 20, 0xFFFFFF);
                }
                for (i = 0; i < stacks.length; ++i) {
                    stack = stacks[i];
                    this.render.func_77015_a(this.field_146297_k.field_71466_p, this.field_146297_k.func_110434_K(), stack, this.field_146294_l / 2, b0 + 88 + i * 20);
                }
            } else {
                String name = "\"" + (this.dwarf.func_70631_g_() ? "Tiny " : "") + (this.dwarf.func_94056_bM() ? this.dwarf.func_94057_bL() + "\" " : (this.dwarf.isMerchant() ? "Merchant\" " : (this.dwarf.isPartner() ? "Partner\" " : "Traveller\" ")));
                String s1 = "Do you really want to give " + name + stack.field_77994_a + " " + stack.func_77973_b().func_77653_i(stack) + "?";
                int d = (this.field_146294_l - this.field_146289_q.func_78256_a(s1)) / 2;
                this.field_146289_q.func_78261_a(s1, d, b0 + 64, -256);
                super.func_73863_a(par1, par2, par3);
                this.field_146289_q.func_78261_a(stack.field_77994_a + " x ", this.field_146294_l / 2 - 22, b0 + 92, 0xFFFFFF);
                this.render.func_77015_a(this.field_146297_k.field_71466_p, this.field_146297_k.func_110434_K(), stack, this.field_146294_l / 2, b0 + 88);
            }
        } else if (this.rename) {
            GuiTravellingDwarf.func_73734_a((int)0, (int)0, (int)this.field_146294_l, (int)this.field_146295_m, (int)Integer.MIN_VALUE);
            String s1 = "Enter a new name for your partner";
            int d = (this.field_146294_l - this.field_146289_q.func_78256_a(s1)) / 2;
            this.field_146289_q.func_78261_a(s1, d, b0 + 64, -256);
            String s = this.dwarfname;
            s = this.updateCount / 6 % 2 == 0 ? s + "" + EnumChatFormatting.BLACK + "_" : s + "" + EnumChatFormatting.GRAY + "_";
            int l = 0xE0E0E0;
            d = (this.field_146294_l - this.field_146289_q.func_78256_a(s)) / 2;
            this.field_146289_q.func_78261_a(s, d, b0 + 90, l);
            super.func_73863_a(par1, par2, par3);
        } else {
            if (b) {
                this.func_73729_b(k, b0, 0, 0, 244, this.bookImageHeight);
            } else {
                this.func_73729_b(k, b0, 0, 0, this.bookImageWidth, this.bookImageHeight);
            }
            String s1 = "";
            if (this.story != null && this.currPage >= 0 && this.currPage < this.story.func_74745_c()) {
                s1 = "\"" + this.story.func_150307_f(this.currPage) + "\"";
            }
            String name = "\"" + (this.dwarf.func_70631_g_() ? "Tiny " : "") + (this.dwarf.func_94056_bM() ? this.dwarf.func_94057_bL() + "\" " : (this.dwarf.isMerchant() ? "Merchant\"" : (this.dwarf.isPartner() ? "Partner\"" : "Traveller\"")));
            this.field_146289_q.func_78276_b(name, k + 67, b0 + 16, 0);
            this.field_146289_q.func_78279_b(s1, k + 70, b0 + 16 + 16, 95, 0);
            super.func_73863_a(par1, par2, par3);
            GuiInventory.func_147046_a((int)(k + 30), (int)(b0 + 70), (int)30, (float)-20.0f, (float)0.0f, (EntityLivingBase)this.dwarf);
        }
        if (b && !this.dialog && !this.rename) {
            if (this.field_147045_u) {
                this.func_147044_g();
            }
            this.drawHealth();
        }
    }

    private void drawHealth() {
        boolean flag;
        this.field_146297_k.func_110434_K().func_110577_a(textures2);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        int k = (this.field_146294_l - this.bookImageWidth) / 2;
        int b0 = 2;
        this.func_73729_b(k - 13, b0 + 2, 0, 168, 13, 88);
        boolean bl = flag = this.field_146297_k.field_71439_g.field_70172_ad / 3 % 2 == 1;
        if (this.field_146297_k.field_71439_g.field_70172_ad < 10) {
            flag = false;
        }
        this.field_146297_k.func_110434_K().func_110577_a(field_110324_m);
        int k1 = k - 10;
        int i2 = b0 + 5;
        float f = this.dwarf.func_110138_aP();
        int j2 = MathHelper.func_76123_f((float)(f / 2.0f / 10.0f));
        int k2 = Math.max(10 - (j2 - 2), 3);
        k = MathHelper.func_76123_f((float)this.dwarf.func_110143_aJ());
        for (int k3 = MathHelper.func_76123_f((float)(f / 2.0f)) - 1; k3 >= 0; --k3) {
            int l3 = 16;
            if (this.dwarf.func_70644_a(Potion.field_76436_u)) {
                l3 += 36;
            } else if (this.dwarf.func_70644_a(Potion.field_82731_v)) {
                l3 += 72;
            }
            b0 = 0;
            if (flag) {
                b0 = 1;
            }
            int i4 = MathHelper.func_76123_f((float)((float)(k3 + 1) / 10.0f)) - 1;
            int j4 = k1;
            int k4 = i2 - i4 * k2 + k3 % 10 * 8;
            if (k <= 4) {
                k4 += this.rand.nextInt(2);
            }
            this.func_73729_b(j4, k4, 16 + b0 * 9, 0, 9, 9);
            if (k3 * 2 + 1 < k) {
                this.func_73729_b(j4, k4, l3 + 36, 0, 9, 9);
            }
            if (k3 * 2 + 1 != k) continue;
            this.func_73729_b(j4, k4, l3 + 45, 0, 9, 9);
        }
        k = (this.field_146294_l - this.bookImageWidth) / 2;
        b0 = 2;
    }

    private void func_147044_g() {
        int i = (this.field_146294_l - this.bookImageWidth) / 2 - 124;
        int j = 2;
        Collection collection = this.dwarf.func_70651_bq();
        if (!collection.isEmpty()) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            int k = 33;
            if (collection.size() > 5) {
                k = 132 / (collection.size() - 1);
            }
            for (PotionEffect potioneffect : this.dwarf.func_70651_bq()) {
                Potion potion = Potion.field_76425_a[potioneffect.func_76456_a()];
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146297_k.func_110434_K().func_110577_a(field_147001_a);
                this.func_73729_b(i, j, 0, 166, 140, 32);
                if (potion.func_76400_d()) {
                    int l = potion.func_76392_e();
                    this.func_73729_b(i + 6, j + 7, 0 + l % 8 * 18, 198 + l / 8 * 18, 18, 18);
                }
                potion.renderInventoryEffect(i, j, potioneffect, this.field_146297_k);
                if (potion.shouldRenderInvText(potioneffect)) {
                    String s1 = I18n.func_135052_a((String)potion.func_76393_a(), (Object[])new Object[0]);
                    if (potioneffect.func_76458_c() == 1) {
                        s1 = s1 + " " + I18n.func_135052_a((String)"enchantment.level.2", (Object[])new Object[0]);
                    } else if (potioneffect.func_76458_c() == 2) {
                        s1 = s1 + " " + I18n.func_135052_a((String)"enchantment.level.3", (Object[])new Object[0]);
                    } else if (potioneffect.func_76458_c() == 3) {
                        s1 = s1 + " " + I18n.func_135052_a((String)"enchantment.level.4", (Object[])new Object[0]);
                    }
                    this.field_146289_q.func_78261_a(s1, i + 10 + 18, j + 6, 0xFFFFFF);
                    String s = Potion.func_76389_a((PotionEffect)potioneffect);
                    this.field_146289_q.func_78261_a(s, i + 10 + 18, j + 6 + 10, 0x7F7F7F);
                }
                j += k;
            }
        }
    }

    protected void func_73869_a(char par1, int par2) {
        if (this.rename) {
            this.func_146460_c(par1, par2);
        }
        super.func_73869_a(par1, par2);
    }

    private void func_146460_c(char p_146460_1_, int p_146460_2_) {
        switch (p_146460_2_) {
            case 1: {
                this.rename = false;
                this.updateButtons();
                return;
            }
            case 14: {
                if (!this.dwarfname.isEmpty()) {
                    this.dwarfname = this.dwarfname.substring(0, this.dwarfname.length() - 1);
                    this.updateButtons();
                }
                return;
            }
            case 28: 
            case 156: {
                if (!this.dwarfname.isEmpty()) {
                    this.changeName();
                }
                return;
            }
        }
        if (this.dwarfname.length() < 16 && ChatAllowedCharacters.func_71566_a((char)p_146460_1_)) {
            this.dwarfname = this.dwarfname + Character.toString(p_146460_1_);
            this.updateButtons();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeName() {
        this.rename = false;
        this.updateButtons();
        ByteBuf bytebuf = Unpooled.buffer();
        try {
            PacketBuffer b = new PacketBuffer(bytebuf);
            b.writeInt(this.dwarf.func_145782_y());
            b.writeInt(this.dwarf.field_71093_bK);
            b.func_150785_a(this.dwarfname);
            Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new C17PacketCustomPayload("SW|PartnerRename", bytebuf));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            bytebuf.release();
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class PartnerButton
    extends GuiButton {
        public PartnerButton(int par1, int par2, int par3, String s) {
            super(par1, par2, par3, 56, 20, s);
        }

        public void func_146112_a(Minecraft p_146112_1_, int p_146112_2_, int p_146112_3_) {
            if (this.field_146125_m) {
                FontRenderer fontrenderer = p_146112_1_.field_71466_p;
                p_146112_1_.func_110434_K().func_110577_a(textures);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146123_n = p_146112_2_ >= this.field_146128_h && p_146112_3_ >= this.field_146129_i && p_146112_2_ < this.field_146128_h + this.field_146120_f && p_146112_3_ < this.field_146129_i + this.field_146121_g;
                int k = this.func_146114_a(this.field_146123_n);
                GL11.glEnable((int)3042);
                OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                GL11.glBlendFunc((int)770, (int)771);
                this.func_73729_b(this.field_146128_h, this.field_146129_i, 0, 147 + k * 20, this.field_146120_f / 2, this.field_146121_g);
                this.func_73729_b(this.field_146128_h + this.field_146120_f / 2, this.field_146129_i, 161 - this.field_146120_f / 2, 147 + k * 20, this.field_146120_f / 2, this.field_146121_g);
                this.func_146119_b(p_146112_1_, p_146112_2_, p_146112_3_);
                int l = 0xE0E0E0;
                if (this.packedFGColour != 0) {
                    l = this.packedFGColour;
                } else if (!this.field_146124_l) {
                    l = 0xA0A0A0;
                } else if (this.field_146123_n) {
                    l = 0xFFFFA0;
                }
                this.func_73732_a(fontrenderer, this.field_146126_j, this.field_146128_h + this.field_146120_f / 2, this.field_146129_i + (this.field_146121_g - 8) / 2, l);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class DwarvenButton
    extends GuiButton {
        public DwarvenButton(int par1, int par2, int par3, String s) {
            super(par1, par2, par3, 161, 20, s);
        }

        public void func_146112_a(Minecraft p_146112_1_, int p_146112_2_, int p_146112_3_) {
            if (this.field_146125_m) {
                FontRenderer fontrenderer = p_146112_1_.field_71466_p;
                p_146112_1_.func_110434_K().func_110577_a(textures);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146123_n = p_146112_2_ >= this.field_146128_h && p_146112_3_ >= this.field_146129_i && p_146112_2_ < this.field_146128_h + this.field_146120_f && p_146112_3_ < this.field_146129_i + this.field_146121_g;
                int k = this.func_146114_a(this.field_146123_n);
                GL11.glEnable((int)3042);
                OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                GL11.glBlendFunc((int)770, (int)771);
                this.func_73729_b(this.field_146128_h, this.field_146129_i, 0, 147 + k * 20, this.field_146120_f / 2, this.field_146121_g);
                this.func_73729_b(this.field_146128_h + this.field_146120_f / 2, this.field_146129_i, 161 - this.field_146120_f / 2, 147 + k * 20, this.field_146120_f / 2, this.field_146121_g);
                this.func_146119_b(p_146112_1_, p_146112_2_, p_146112_3_);
                int l = 0xE0E0E0;
                if (this.packedFGColour != 0) {
                    l = this.packedFGColour;
                } else if (!this.field_146124_l) {
                    l = 0xA0A0A0;
                } else if (this.field_146123_n) {
                    l = 0xFFFFA0;
                }
                this.func_73732_a(fontrenderer, this.field_146126_j, this.field_146128_h + this.field_146120_f / 2, this.field_146129_i + (this.field_146121_g - 8) / 2, l);
            }
        }
    }
}

