/*
 * Decompiled with CFR 0.152.
 */
package jajo_11.ShadowWorld.GUI;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import jajo_11.ShadowWorld.GUI.GuiBackpack;
import jajo_11.ShadowWorld.GUI.GuiDiaryEntry;
import jajo_11.ShadowWorld.Handlers.ShadowSound;
import jajo_11.ShadowWorld.Utils.NBTHelper;
import jajo_11.ShadowWorld.Utils.TextureHelper;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.C17PacketCustomPayload;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiDiary
extends GuiScreen {
    private static final Logger logger = LogManager.getLogger();
    private static final ResourceLocation bookGuiTextures = new ResourceLocation("shadowworld:textures/gui/Diary_double.png");
    private static final ResourceLocation bookGuiTexturesTitle = new ResourceLocation("shadowworld:textures/gui/DiaryTitle.png");
    private static final ResourceLocation bookGuiTextures2 = new ResourceLocation("shadowworld:textures/gui/Diary_double2.png");
    private static final ResourceLocation bookGuiTextures3 = new ResourceLocation("shadowworld:textures/gui/Diary_double3.png");
    private static final ResourceLocation bookGuiTextures4 = new ResourceLocation("shadowworld:textures/gui/Diary_double4.png");
    private static final ResourceLocation bookGuiTextures5 = new ResourceLocation("shadowworld:textures/gui/Diary_double5.png");
    private static final ResourceLocation bookGuiTexturesQuest = new ResourceLocation("shadowworld:textures/gui/Diary_doubleQuests.png");
    private int bookImageWidth = 192;
    private int bookImageHeight = 192;
    private int bookTotalPages = 1;
    private int currPage;
    private NBTTagList bookPages;
    private NextPageButton buttonNextPage;
    private NextPageButton buttonPreviousPage;
    private CategoryButton buttonAll;
    private CategoryButton buttonItems;
    private CategoryButton buttonBlocks;
    private CategoryButton buttonEntities;
    private CategoryButton buttonOther;
    private CategoryButton LeftbuttonAll;
    private CategoryButton LeftbuttonItems;
    private CategoryButton LeftbuttonBlocks;
    private CategoryButton LeftbuttonEntities;
    private CategoryButton LeftbuttonOther;
    private QuestButton buttonQuests;
    private SelectedButton selected1;
    private SelectedButton selected2;
    private RemoveButton remove1;
    private RemoveButton remove2;
    private GuiBackpack.ResizableButton buttonYes;
    private GuiBackpack.ResizableButton buttonNo;
    private ItemStack diary;
    public int type = 0;
    private World world;
    private EntityLivingBase entity;
    private int rotationx;
    private int rotationy;
    private int prevmouseposx;
    private int prevmouseposy;
    private int size = 20;
    private boolean readOnly;
    EntityPlayer player;
    private boolean active1;
    private boolean active2;
    private boolean dialog;
    private int removePage;
    private boolean dwarven;

    public GuiDiary(EntityPlayer par1EntityPlayer, ItemStack par2ItemStack, boolean readOnly) {
        this.world = par1EntityPlayer.field_70170_p;
        this.diary = par2ItemStack;
        this.player = par1EntityPlayer;
        this.readOnly = readOnly;
        this.dwarven = this.diary.func_77978_p().func_74764_b("dwarven");
        if (this.dwarven) {
            NBTTagCompound nbttagcompound = par2ItemStack.func_77978_p();
            this.bookPages = nbttagcompound.func_150295_c("pages", 8);
            if (this.bookPages != null) {
                this.bookPages = (NBTTagList)this.bookPages.func_74737_b();
                this.bookTotalPages = this.bookPages.func_74745_c() + 3;
                if (this.bookTotalPages < 3) {
                    this.bookTotalPages = 5;
                }
                this.type = 0;
            }
        } else {
            if (par2ItemStack.func_77942_o()) {
                NBTTagCompound nbttagcompound = par2ItemStack.func_77978_p();
                this.bookPages = nbttagcompound.func_150295_c("all", 8);
                if (this.bookPages != null) {
                    this.bookPages = (NBTTagList)this.bookPages.func_74737_b();
                    this.bookTotalPages = this.bookPages.func_74745_c() + 3;
                    if (this.bookTotalPages < 3) {
                        this.bookTotalPages = 5;
                    }
                    this.type = 0;
                }
            }
            if (this.bookPages == null) {
                this.bookPages = new NBTTagList();
                this.bookPages.func_74742_a((NBTBase)new NBTTagString(""));
                this.bookPages.func_74742_a((NBTBase)new NBTTagString(""));
                this.bookPages.func_74742_a((NBTBase)new NBTTagString(""));
                this.bookPages.func_74742_a((NBTBase)new NBTTagString(""));
                this.bookTotalPages = 5;
            }
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146292_n.add(new GuiButton(0, this.field_146294_l / 2 - 100, 4 + this.bookImageHeight, 200, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
        int i = (this.field_146294_l - this.bookImageWidth) / 2;
        int b0 = 2;
        this.buttonNextPage = new NextPageButton(1, i + 120, b0 + 154, true);
        this.field_146292_n.add(this.buttonNextPage);
        this.buttonPreviousPage = new NextPageButton(2, i + 38, b0 + 154, false);
        this.field_146292_n.add(this.buttonPreviousPage);
        this.buttonAll = new CategoryButton(3, i + 213, b0 + 8, 0, false);
        this.field_146292_n.add(this.buttonAll);
        this.buttonItems = new CategoryButton(4, i + 214, b0 + 26, 1, false);
        this.field_146292_n.add(this.buttonItems);
        this.buttonBlocks = new CategoryButton(5, i + 215, b0 + 44, 2, false);
        this.field_146292_n.add(this.buttonBlocks);
        this.buttonEntities = new CategoryButton(6, i + 216, b0 + 62, 3, false);
        this.field_146292_n.add(this.buttonEntities);
        this.buttonOther = new CategoryButton(7, i + 217, b0 + 80, 4, false);
        this.field_146292_n.add(this.buttonOther);
        this.LeftbuttonAll = new CategoryButton(8, i - 38, b0 + 8, 0, true);
        this.field_146292_n.add(this.LeftbuttonAll);
        this.LeftbuttonItems = new CategoryButton(9, i - 37, b0 + 26, 1, true);
        this.field_146292_n.add(this.LeftbuttonItems);
        this.LeftbuttonBlocks = new CategoryButton(10, i - 36, b0 + 44, 2, true);
        this.field_146292_n.add(this.LeftbuttonBlocks);
        this.LeftbuttonEntities = new CategoryButton(11, i - 35, b0 + 62, 3, true);
        this.field_146292_n.add(this.LeftbuttonEntities);
        this.LeftbuttonOther = new CategoryButton(13, i - 34, b0 + 80, 4, true);
        this.field_146292_n.add(this.LeftbuttonOther);
        this.buttonQuests = new QuestButton(12, i + 216, b0 + 110);
        this.field_146292_n.add(this.buttonQuests);
        this.selected1 = new SelectedButton(14, i + 71, b0 + 159);
        this.field_146292_n.add(this.selected1);
        this.selected2 = new SelectedButton(15, i + 169, b0 + 159);
        this.field_146292_n.add(this.selected2);
        this.remove1 = new RemoveButton(16, i + 75, b0 + 9);
        this.field_146292_n.add(this.remove1);
        this.remove2 = new RemoveButton(17, i + 200, b0 + 9);
        this.field_146292_n.add(this.remove2);
        this.buttonYes = new GuiBackpack.ResizableButton(18, this.field_146294_l / 2 - 80, this.bookImageHeight - 50, 161, 20, "Yes");
        this.field_146292_n.add(this.buttonYes);
        this.buttonNo = new GuiBackpack.ResizableButton(19, this.field_146294_l / 2 - 80, this.bookImageHeight - 25, 161, 20, "No");
        this.field_146292_n.add(this.buttonNo);
        this.updateButtons();
    }

    private void updateButtons() {
        this.buttonNextPage.field_146125_m = this.currPage < this.bookTotalPages - 1;
        this.buttonPreviousPage.field_146125_m = this.currPage > 0;
        this.buttonAll.field_146125_m = this.currPage != 0 && this.type == 0 && !this.dwarven;
        this.buttonItems.field_146125_m = this.currPage != 0 && this.type <= 1 && !this.dwarven;
        this.buttonBlocks.field_146125_m = this.currPage != 0 && this.type <= 2 && !this.dwarven;
        this.buttonEntities.field_146125_m = this.currPage != 0 && this.type <= 3 && !this.dwarven;
        this.buttonOther.field_146125_m = this.currPage != 0 && this.type <= 4 && !this.dwarven;
        this.LeftbuttonAll.field_146125_m = this.currPage != 0 && this.type != 0 && !this.dwarven;
        this.LeftbuttonItems.field_146125_m = this.currPage != 0 && this.type > 1 && !this.dwarven;
        this.LeftbuttonBlocks.field_146125_m = this.currPage != 0 && this.type > 2 && !this.dwarven;
        this.LeftbuttonEntities.field_146125_m = this.currPage != 0 && this.type > 3 && !this.dwarven;
        this.LeftbuttonOther.field_146125_m = this.currPage != 0 && this.type > 4 && !this.dwarven;
        this.buttonQuests.field_146125_m = this.currPage != 0 && !this.dwarven;
        this.selected1.field_146125_m = this.currPage != 0 && this.type == 5 && this.currPage < this.bookTotalPages - 1 && !this.dwarven;
        this.selected2.field_146125_m = this.currPage != 0 && this.type == 5 && this.currPage + 1 < this.bookTotalPages - 1 && !this.dwarven;
        this.remove1.field_146125_m = this.currPage != 0 && this.type == 5 && this.currPage < this.bookTotalPages - 1 && !this.bookPages.func_150305_b(this.currPage - 2).func_74767_n("storyquest") && !this.dwarven;
        this.remove2.field_146125_m = this.currPage != 0 && this.type == 5 && this.currPage + 1 < this.bookTotalPages - 1 && !this.bookPages.func_150305_b(this.currPage - 1).func_74767_n("storyquest") && !this.dwarven;
        this.buttonYes.field_146125_m = this.dialog;
        this.buttonNo.field_146125_m = this.dialog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(int i) {
        if (this.readOnly) {
            return;
        }
        ByteBuf bytebuf = Unpooled.buffer();
        try {
            this.diary.func_77983_a("player", (NBTBase)new NBTTagString(this.player.func_70005_c_()));
            this.diary.func_77978_p().func_74768_a("open", i);
            new PacketBuffer(bytebuf).func_150788_a(this.diary);
            this.field_146297_k.func_147114_u().func_147297_a((Packet)new C17PacketCustomPayload("SW|DOpen", bytebuf));
        }
        catch (Exception exception) {
            logger.error("Couldn't open/close diary", (Throwable)exception);
        }
        finally {
            bytebuf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flip(float f) {
        if (this.readOnly) {
            return;
        }
        ByteBuf bytebuf = Unpooled.buffer();
        try {
            this.diary.func_77983_a("player", (NBTBase)new NBTTagString(this.player.func_70005_c_()));
            this.diary.func_77978_p().func_74776_a("flip", f);
            new PacketBuffer(bytebuf).func_150788_a(this.diary);
            this.field_146297_k.func_147114_u().func_147297_a((Packet)new C17PacketCustomPayload("SW|DFlip", bytebuf));
        }
        catch (Exception exception) {
            logger.error("Couldn't flip page", (Throwable)exception);
        }
        finally {
            bytebuf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flip2(float f) {
        if (this.readOnly) {
            return;
        }
        ByteBuf bytebuf = Unpooled.buffer();
        try {
            this.diary.func_77983_a("player", (NBTBase)new NBTTagString(this.player.func_70005_c_()));
            this.diary.func_77978_p().func_74776_a("flip2", f);
            new PacketBuffer(bytebuf).func_150788_a(this.diary);
            this.field_146297_k.func_147114_u().func_147297_a((Packet)new C17PacketCustomPayload("SW|DFlip2", bytebuf));
        }
        catch (Exception exception) {
            logger.error("Couldn't flip pages", (Throwable)exception);
        }
        finally {
            bytebuf.release();
        }
    }

    protected void func_73869_a(char par1, int par2) {
        if (par2 == 1) {
            this.open(0);
            this.flip(1.0f);
            this.flip2(1.0f);
        }
        if (this.dialog && par2 == 1) {
            this.dialog = false;
        } else {
            super.func_73869_a(par1, par2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void func_146284_a(GuiButton p_146284_1_) {
        if (p_146284_1_.field_146124_l && !this.dialog) {
            if (p_146284_1_.field_146127_k == 0) {
                this.field_146297_k.func_147108_a((GuiScreen)null);
                this.open(0);
                this.flip(1.0f);
                this.flip2(1.0f);
            } else if (p_146284_1_.field_146127_k == 1) {
                if (this.currPage < this.bookTotalPages) {
                    if (this.currPage != 0) {
                        this.flip(1.5f);
                    }
                    if (this.type != 3 && this.type != 4) {
                        this.currPage += 2;
                    } else {
                        ++this.currPage;
                        if (this.type == 3) {
                            if (this.diary.func_77978_p().func_150295_c("entitydata", 10).func_74745_c() > 0 && this.currPage < this.diary.func_77978_p().func_150295_c("entitydata", 10).func_74745_c() + 1) {
                                this.entity = (EntityLivingBase)EntityList.func_75615_a((NBTTagCompound)this.diary.func_77978_p().func_150295_c("entitydata", 10).func_150305_b(this.currPage - 1), (World)this.world);
                            } else {
                                this.entity = null;
                                this.rotationx = 0;
                                this.rotationy = 0;
                            }
                        }
                    }
                    this.active1 = false;
                    this.active2 = false;
                    if (this.type == 5) {
                        this.active1 = this.bookPages.func_150305_b(this.currPage - 2).func_74767_n("active");
                        this.active2 = this.bookPages.func_150305_b(this.currPage - 1).func_74767_n("active");
                        this.selected1.finished = this.bookPages.func_150305_b(this.currPage - 2).func_74767_n("finished");
                        this.selected2.finished = this.bookPages.func_150305_b(this.currPage - 1).func_74767_n("finished");
                    }
                }
            } else if (p_146284_1_.field_146127_k == 2) {
                if (this.currPage > 0) {
                    if (this.type != 3 && this.type != 4) {
                        this.currPage -= 2;
                    } else {
                        --this.currPage;
                        if (this.type == 3) {
                            if (this.currPage > 0 && this.diary.func_77978_p().func_150295_c("entitydata", 10).func_74745_c() > 0 && this.currPage < this.diary.func_77978_p().func_150295_c("entitydata", 10).func_74745_c() + 1) {
                                this.entity = (EntityLivingBase)EntityList.func_75615_a((NBTTagCompound)this.diary.func_77978_p().func_150295_c("entitydata", 10).func_150305_b(this.currPage - 1), (World)this.world);
                            } else {
                                this.entity = null;
                                this.rotationx = 0;
                                this.rotationy = 0;
                            }
                        }
                    }
                    if (this.currPage != 0) {
                        this.flip(0.0f);
                    }
                    this.active1 = false;
                    this.active2 = false;
                    if (this.type == 5) {
                        this.active1 = this.bookPages.func_150305_b(this.currPage - 2).func_74767_n("active");
                        this.active2 = this.bookPages.func_150305_b(this.currPage - 1).func_74767_n("active");
                        this.selected1.finished = this.bookPages.func_150305_b(this.currPage - 2).func_74767_n("finished");
                        this.selected2.finished = this.bookPages.func_150305_b(this.currPage - 1).func_74767_n("finished");
                    }
                }
            } else if (p_146284_1_.field_146127_k == 3 || p_146284_1_.field_146127_k == 8) {
                this.type = 0;
                this.currPage = 2;
                NBTTagCompound nbttagcompound = this.diary.func_77978_p();
                this.bookPages = nbttagcompound.func_150295_c("all", 8);
                if (this.bookPages != null) {
                    this.bookPages = (NBTTagList)this.bookPages.func_74737_b();
                    this.bookTotalPages = this.bookPages.func_74745_c() + 3;
                    if (this.bookTotalPages < 3) {
                        this.bookTotalPages = 5;
                    }
                }
            } else if (p_146284_1_.field_146127_k == 4 || p_146284_1_.field_146127_k == 9) {
                this.type = 1;
                this.currPage = 2;
                NBTTagCompound nbttagcompound = this.diary.func_77978_p();
                this.bookPages = nbttagcompound.func_150295_c("items", 8);
                if (this.bookPages != null) {
                    this.bookPages = (NBTTagList)this.bookPages.func_74737_b();
                    this.bookTotalPages = this.bookPages.func_74745_c() + 3;
                    if (this.bookTotalPages < 3) {
                        this.bookTotalPages = 5;
                    }
                }
            } else if (p_146284_1_.field_146127_k == 5 || p_146284_1_.field_146127_k == 10) {
                this.type = 2;
                this.currPage = 2;
                NBTTagCompound nbttagcompound = this.diary.func_77978_p();
                this.bookPages = nbttagcompound.func_150295_c("blocks", 8);
                if (this.bookPages != null) {
                    this.bookPages = (NBTTagList)this.bookPages.func_74737_b();
                    this.bookTotalPages = this.bookPages.func_74745_c() + 3;
                    if (this.bookTotalPages < 3) {
                        this.bookTotalPages = 5;
                    }
                }
            } else if (p_146284_1_.field_146127_k == 6 || p_146284_1_.field_146127_k == 11) {
                this.type = 3;
                this.currPage = 1;
                NBTTagCompound nbttagcompound = this.diary.func_77978_p();
                this.bookPages = nbttagcompound.func_150295_c("entities", 8);
                if (this.bookPages != null) {
                    this.bookPages = (NBTTagList)this.bookPages.func_74737_b();
                    this.bookTotalPages = this.bookPages.func_74745_c() + 2;
                    if (this.bookTotalPages < 2) {
                        this.bookTotalPages = 2;
                    }
                    if (this.diary.func_77978_p().func_150295_c("entitydata", 10).func_74745_c() > 0 && this.currPage < this.diary.func_77978_p().func_150295_c("entitydata", 10).func_74745_c() + 1) {
                        this.entity = (EntityLivingBase)EntityList.func_75615_a((NBTTagCompound)this.diary.func_77978_p().func_150295_c("entitydata", 10).func_150305_b(this.currPage - 1), (World)this.world);
                    } else {
                        this.entity = null;
                        this.rotationx = 0;
                        this.rotationy = 0;
                    }
                }
            } else if (p_146284_1_.field_146127_k == 7 || p_146284_1_.field_146127_k == 13) {
                this.type = 4;
                this.currPage = 1;
                NBTTagCompound nbttagcompound = this.diary.func_77978_p();
                this.bookPages = nbttagcompound.func_150295_c("other", 8);
                if (this.bookPages != null) {
                    this.bookPages = (NBTTagList)this.bookPages.func_74737_b();
                    this.bookTotalPages = this.bookPages.func_74745_c() + 2;
                    if (this.bookTotalPages < 2) {
                        this.bookTotalPages = 2;
                    }
                }
            } else if (p_146284_1_.field_146127_k == 12) {
                NBTTagList nbttagcompound;
                this.type = 5;
                this.currPage = 2;
                this.bookPages = nbttagcompound = NBTHelper.getQuests(this.player);
                if (this.bookPages != null) {
                    this.bookPages = (NBTTagList)this.bookPages.func_74737_b();
                    this.bookTotalPages = this.bookPages.func_74745_c() + 3;
                    if (this.bookTotalPages < 3) {
                        this.bookTotalPages = 5;
                    }
                }
                this.active1 = false;
                this.active2 = false;
                this.active1 = this.bookPages.func_150305_b(this.currPage - 2).func_74767_n("active");
                this.active2 = this.bookPages.func_150305_b(this.currPage - 1).func_74767_n("active");
                this.selected1.finished = this.bookPages.func_150305_b(this.currPage - 2).func_74767_n("finished");
                this.selected2.finished = this.bookPages.func_150305_b(this.currPage - 1).func_74767_n("finished");
            } else if (p_146284_1_.field_146127_k == 14) {
                if (!this.bookPages.func_150305_b(this.currPage - 2).func_74767_n("finished")) {
                    NBTTagList nbttagcompound;
                    this.active1 = !this.active1;
                    ByteBuf bytebuf = Unpooled.buffer();
                    try {
                        PacketBuffer p = new PacketBuffer(bytebuf);
                        p.func_150785_a(this.player.func_70005_c_());
                        p.func_150785_a(this.bookPages.func_150305_b(this.currPage - 2).func_74779_i("name"));
                        p.writeBoolean(this.active1);
                        this.field_146297_k.func_147114_u().func_147297_a((Packet)new C17PacketCustomPayload("SW|ActiveQuest", bytebuf));
                    }
                    catch (Exception exception) {
                        logger.error("Couldn't send active Quest to Server", (Throwable)exception);
                    }
                    finally {
                        bytebuf.release();
                    }
                    for (int i = 0; i < NBTHelper.getQuests(this.player).func_74745_c(); ++i) {
                        if (!NBTHelper.getQuests(this.player).func_150305_b(i).func_74779_i("name").equals(this.bookPages.func_150305_b(this.currPage - 2).func_74779_i("name"))) continue;
                        NBTHelper.getQuests(this.player).func_150305_b(i).func_74757_a("active", this.active1);
                    }
                    this.bookPages = nbttagcompound = NBTHelper.getQuests(this.player);
                    if (this.bookPages != null) {
                        this.bookPages = (NBTTagList)this.bookPages.func_74737_b();
                        this.bookTotalPages = this.bookPages.func_74745_c() + 3;
                        if (this.bookTotalPages < 3) {
                            this.bookTotalPages = 5;
                        }
                    }
                }
            } else if (p_146284_1_.field_146127_k == 15 && !this.bookPages.func_150305_b(this.currPage - 1).func_74767_n("finished")) {
                NBTTagList nbttagcompound;
                this.active2 = !this.active2;
                ByteBuf bytebuf = Unpooled.buffer();
                try {
                    PacketBuffer p = new PacketBuffer(bytebuf);
                    p.func_150785_a(this.player.func_70005_c_());
                    p.func_150785_a(this.bookPages.func_150305_b(this.currPage - 1).func_74779_i("name"));
                    p.writeBoolean(this.active2);
                    this.field_146297_k.func_147114_u().func_147297_a((Packet)new C17PacketCustomPayload("SW|ActiveQuest", bytebuf));
                }
                catch (Exception exception) {
                    logger.error("Couldn't send active Quest to Server", (Throwable)exception);
                }
                finally {
                    bytebuf.release();
                }
                for (int i = 0; i < NBTHelper.getQuests(this.player).func_74745_c(); ++i) {
                    if (!NBTHelper.getQuests(this.player).func_150305_b(i).func_74779_i("name").equals(this.bookPages.func_150305_b(this.currPage - 1).func_74779_i("name"))) continue;
                    NBTHelper.getQuests(this.player).func_150305_b(i).func_74757_a("active", this.active2);
                }
                this.bookPages = nbttagcompound = NBTHelper.getQuests(this.player);
                if (this.bookPages != null) {
                    this.bookPages = (NBTTagList)this.bookPages.func_74737_b();
                    this.bookTotalPages = this.bookPages.func_74745_c() + 3;
                    if (this.bookTotalPages < 3) {
                        this.bookTotalPages = 5;
                    }
                }
            }
            if (p_146284_1_.field_146127_k == 3 || p_146284_1_.field_146127_k == 4 || p_146284_1_.field_146127_k == 5 || p_146284_1_.field_146127_k == 6 || p_146284_1_.field_146127_k == 7 || p_146284_1_.field_146127_k == 12) {
                this.flip2(1.5f);
            } else if (p_146284_1_.field_146127_k == 8 || p_146284_1_.field_146127_k == 9 || p_146284_1_.field_146127_k == 10 || p_146284_1_.field_146127_k == 11 || p_146284_1_.field_146127_k == 13) {
                this.flip2(0.0f);
            }
            if (p_146284_1_.field_146127_k == 16) {
                if (!this.bookPages.func_150305_b(this.currPage - 2).func_74767_n("storyquest")) {
                    this.dialog = true;
                    this.removePage = this.currPage - 2;
                }
            } else if (p_146284_1_.field_146127_k == 17 && !this.bookPages.func_150305_b(this.currPage - 1).func_74767_n("storyquest")) {
                this.dialog = true;
                this.removePage = this.currPage - 1;
            }
            this.updateButtons();
        } else if (p_146284_1_.field_146124_l) {
            if (p_146284_1_.field_146127_k == 18) {
                this.dialog = false;
                this.bookPages.func_74744_a(this.removePage);
                this.bookTotalPages = this.bookPages.func_74745_c() + 3;
                if (this.bookTotalPages < 3) {
                    this.bookTotalPages = 5;
                }
                this.field_146297_k.func_147118_V().func_147682_a((ISound)new ShadowSound("shadowworld:diary.remove_page", 1.0f, 0.9f));
                NBTHelper.getPersistentTag((EntityPlayer)this.field_146297_k.field_71439_g).func_74782_a("shadowworld/quests", (NBTBase)this.bookPages);
                ByteBuf bytebuf = Unpooled.buffer();
                try {
                    PacketBuffer p = new PacketBuffer(bytebuf);
                    p.func_150785_a(this.field_146297_k.field_71439_g.func_70005_c_());
                    p.func_150786_a(NBTHelper.getPersistentTag((EntityPlayer)this.field_146297_k.field_71439_g));
                    this.field_146297_k.func_147114_u().func_147297_a((Packet)new C17PacketCustomPayload("SW|RemoveQuest", bytebuf));
                }
                catch (Exception exception) {
                    logger.error("Couldn't flip page", (Throwable)exception);
                }
                finally {
                    bytebuf.release();
                }
            } else if (p_146284_1_.field_146127_k == 19) {
                this.dialog = false;
            }
            this.updateButtons();
        }
    }

    public void func_73863_a(int par1, int par2, float par3) {
        if (this.diary.func_77978_p().func_74762_e("open") <= 80 && this.currPage != 0) {
            this.open(this.diary.func_77978_p().func_74762_e("open") + 2);
        }
        if (this.diary.func_77978_p().func_74760_g("flip") < 1.0f) {
            if ((double)this.diary.func_77978_p().func_74760_g("flip") > 9.99) {
                this.flip(1.0f);
            } else {
                this.flip(this.diary.func_77978_p().func_74760_g("flip") + 0.01f);
            }
        } else if (this.diary.func_77978_p().func_74760_g("flip") > 1.0f) {
            if ((double)this.diary.func_77978_p().func_74760_g("flip") < 1.01) {
                this.flip(1.0f);
            } else {
                this.flip(this.diary.func_77978_p().func_74760_g("flip") - 0.01f);
            }
        }
        if (this.diary.func_77978_p().func_74760_g("flip2") < 1.0f) {
            if ((double)this.diary.func_77978_p().func_74760_g("flip2") > 9.99) {
                this.flip2(1.0f);
            } else {
                this.flip2(this.diary.func_77978_p().func_74760_g("flip2") + 0.01f);
            }
        } else if (this.diary.func_77978_p().func_74760_g("flip2") > 1.0f) {
            if ((double)this.diary.func_77978_p().func_74760_g("flip2") < 1.01) {
                this.flip2(1.0f);
            } else {
                this.flip2(this.diary.func_77978_p().func_74760_g("flip2") - 0.01f);
            }
        }
        if (this.currPage == 0) {
            this.open(0);
            this.flip(1.0f);
            this.flip2(1.0f);
        }
        this.selected1.selected = this.active1;
        this.selected2.selected = this.active2;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int k = (this.field_146294_l - this.bookImageWidth) / 2;
        if (this.currPage == 0) {
            this.bookImageWidth = 192;
            this.field_146297_k.func_110434_K().func_110577_a(bookGuiTexturesTitle);
            this.buttonNextPage.field_146128_h = k + 120;
            this.buttonPreviousPage.field_146128_h = k + 38;
        } else {
            this.bookImageWidth = 254;
            if (this.type == 0) {
                this.field_146297_k.func_110434_K().func_110577_a(bookGuiTextures);
            } else if (this.type == 1) {
                this.field_146297_k.func_110434_K().func_110577_a(bookGuiTextures2);
            } else if (this.type == 2) {
                this.field_146297_k.func_110434_K().func_110577_a(bookGuiTextures3);
            } else if (this.type == 3) {
                this.field_146297_k.func_110434_K().func_110577_a(bookGuiTextures4);
            } else if (this.type == 4) {
                this.field_146297_k.func_110434_K().func_110577_a(bookGuiTextures5);
            } else if (this.type == 5) {
                this.field_146297_k.func_110434_K().func_110577_a(bookGuiTexturesQuest);
            }
            this.buttonNextPage.field_146128_h = k + 210;
            this.buttonPreviousPage.field_146128_h = k + 20;
            this.buttonAll.field_146128_h = k + 244;
            this.buttonItems.field_146128_h = k + 245;
            this.buttonBlocks.field_146128_h = k + 246;
            this.buttonEntities.field_146128_h = k + 247;
            this.buttonOther.field_146128_h = k + 248;
            this.LeftbuttonAll.field_146128_h = k - 7;
            this.LeftbuttonItems.field_146128_h = k - 6;
            this.LeftbuttonBlocks.field_146128_h = k - 5;
            this.LeftbuttonEntities.field_146128_h = k - 4;
            this.LeftbuttonOther.field_146128_h = k - 3;
            this.buttonQuests.field_146128_h = k + 247;
            this.selected1.field_146128_h = k + 102;
            this.selected2.field_146128_h = k + 200;
            this.selected1.field_146128_h = k + 102;
            this.selected2.field_146128_h = k + 200;
            this.remove1.field_146128_h = k + 106;
            this.remove2.field_146128_h = k + 231;
        }
        int b0 = 2;
        this.func_73729_b(k, b0, 0, 0, this.bookImageWidth, this.bookImageHeight);
        String s1 = "";
        String s2 = "";
        if (this.bookPages != null && this.currPage >= 2 && this.currPage - 2 < this.bookPages.func_74745_c()) {
            s1 = this.bookPages.func_150307_f(this.currPage - 2);
        }
        if (this.bookPages != null && this.currPage > 1 && this.currPage - 1 < this.bookPages.func_74745_c()) {
            s2 = this.bookPages.func_150307_f(this.currPage - 1);
        }
        if (this.type == 5 && this.currPage != 0) {
            if (this.bookPages != null && this.currPage >= 2 && this.currPage - 2 < this.bookPages.func_74745_c()) {
                s1 = this.bookPages.func_150305_b(this.currPage - 2).func_74779_i("desc");
            }
            if (this.bookPages != null && this.currPage > 1 && this.currPage - 1 < this.bookPages.func_74745_c()) {
                s2 = this.bookPages.func_150305_b(this.currPage - 1).func_74779_i("desc");
            }
            this.field_146289_q.func_78279_b(this.bookPages.func_150305_b(this.currPage - 2).func_74779_i("name").replaceAll("[0-9]", ""), k + 16 + 16 + 12, b0 + 16, 70, 0);
            this.field_146289_q.func_78279_b(this.bookPages.func_150305_b(this.currPage - 1).func_74779_i("name").replaceAll("[0-9]", ""), k + 143 + 18, b0 + 16, 70, 0);
            if (this.bookPages.func_150305_b(this.currPage - 2).func_74767_n("finished")) {
                this.field_146289_q.func_78279_b(EnumChatFormatting.ITALIC + "(finished)", k + 16 + 16 + 12, this.field_146289_q.func_78256_a(this.bookPages.func_150305_b(this.currPage - 2).func_74779_i("name").replaceAll("[0-9]", "")) > 70 ? b0 + 34 : b0 + 16 + 8, 70, 0);
            } else if (this.currPage < this.bookTotalPages - 1) {
                this.field_146289_q.func_78279_b(EnumChatFormatting.ITALIC + "(selected)", k + 48, b0 + 158, 80, 0);
            }
            if (this.bookPages.func_150305_b(this.currPage - 1).func_74767_n("finished")) {
                this.field_146289_q.func_78279_b(EnumChatFormatting.ITALIC + "(finished)", k + 143 + 18, this.field_146289_q.func_78256_a(this.bookPages.func_150305_b(this.currPage - 1).func_74779_i("name").replaceAll("[0-9]", "")) > 70 ? b0 + 34 : b0 + 16 + 8, 70, 0);
            } else if (this.currPage + 1 < this.bookTotalPages - 1) {
                this.field_146289_q.func_78279_b(EnumChatFormatting.ITALIC + "(selected)", k + 146, b0 + 158, 80, 0);
            }
        }
        if (this.currPage == 0) {
            s1 = "\n  " + this.diary.func_77978_p().func_74779_i("title");
            this.field_146289_q.func_78279_b(s1, k + 36, b0 + 16 + 16, 116, 0);
        } else {
            if ((this.currPage == 2 && this.type != 3 && this.type != 4 || this.currPage == 1 && this.type == 3 || this.currPage == 1 && this.type == 4) && this.type != 5 && !this.dwarven) {
                String s3 = "";
                if (this.type == 0) {
                    s3 = "All";
                } else if (this.type == 1) {
                    s3 = "Items";
                } else if (this.type == 2) {
                    s3 = "Blocks";
                } else if (this.type == 3) {
                    s3 = "Entities";
                } else if (this.type == 4) {
                    s3 = "Other";
                }
                this.field_146289_q.func_78276_b(s3 + " (" + (this.bookPages.func_74745_c() == 1 ? "1 Entry)" : this.bookPages.func_74745_c() + " Entries)"), k + 16 + this.type * 2, b0 + 16, 0);
            }
            if (this.type != 3 && this.type != 4) {
                if (this.dwarven && s2.startsWith("<picture>")) {
                    TextureUtil.func_152777_a((boolean)false, (boolean)false, (float)1.0f);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    this.field_146297_k.func_110434_K().func_110577_a(TextureHelper.getAnimatedTexture("shadowworld:textures/gui/" + s2.substring(9) + ".png"));
                    this.func_73729_b(k + 145, b0 + 20, 0, 0, 90, 140);
                    TextureUtil.func_147945_b();
                } else {
                    this.field_146289_q.func_78279_b(s2, k + 143, this.type == 5 ? b0 + 48 : b0 + 16 + 16, 98, 0);
                }
            }
            if (this.type == 3 || this.type == 4) {
                s1 = this.bookPages != null && this.currPage >= 1 && this.currPage - 1 < this.bookPages.func_74745_c() ? this.bookPages.func_150307_f(this.currPage - 1) : "";
            }
            if (this.dwarven && s1.startsWith("<picture>")) {
                TextureUtil.func_152777_a((boolean)false, (boolean)false, (float)1.0f);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146297_k.func_110434_K().func_110577_a(TextureHelper.getAnimatedTexture("shadowworld:textures/gui/" + s1.substring(9) + ".png"));
                this.func_73729_b(k + 18, b0 + 20, 0, 0, 90, 140);
                TextureUtil.func_147945_b();
            } else {
                this.field_146289_q.func_78279_b(s1, k + 16 + this.type * 2, this.type == 5 ? b0 + 48 : b0 + 16 + 16, 98 - this.type * 2, 0);
            }
            if (this.type == 4 && this.diary.func_77978_p().func_150295_c("pictures", 8).func_74745_c() == this.bookPages.func_74745_c() && !this.diary.func_77978_p().func_150295_c("pictures", 8).func_150307_f(this.currPage - 1).isEmpty()) {
                TextureUtil.func_152777_a((boolean)false, (boolean)false, (float)1.0f);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146297_k.func_110434_K().func_110577_a(TextureHelper.getAnimatedTexture("shadowworld:textures/gui/" + this.diary.func_77978_p().func_150295_c("pictures", 8).func_150307_f(this.currPage - 1) + ".png"));
                this.func_73729_b(k + 145, b0 + 20, 0, 0, 90, 130);
                TextureUtil.func_147945_b();
            }
        }
        super.func_73863_a(par1, par2, par3);
        if (this.currPage != 0 && this.type == 3 && this.entity != null) {
            if (!(Mouse.isButtonDown((int)1) || Mouse.isButtonDown((int)0) || Mouse.isButtonDown((int)2))) {
                ++this.rotationy;
            }
            this.entity.field_70122_E = true;
            GuiDiaryEntry.renderEntity(k + 190, b0 + 128, this.size + 15, this.rotationy / 2, this.rotationx, this.entity);
            if (this.rotationx >= 360) {
                this.rotationx = 0;
            }
            if (this.rotationy >= 720) {
                this.rotationy = 0;
            }
            if (this.rotationx <= -360) {
                this.rotationx = 0;
            }
            if (this.rotationy <= -720) {
                this.rotationy = 0;
            }
        }
        if (this.dialog) {
            GuiDiary.func_73734_a((int)0, (int)0, (int)this.field_146297_k.field_71443_c, (int)this.field_146297_k.field_71440_d, (int)Integer.MIN_VALUE);
            GuiDiary.func_73734_a((int)0, (int)0, (int)this.field_146297_k.field_71443_c, (int)this.field_146297_k.field_71440_d, (int)Integer.MIN_VALUE);
            String text = "Do you really want to remove this page?";
            int d = (this.field_146294_l - this.field_146289_q.func_78256_a(text)) / 2;
            this.field_146289_q.func_78261_a(text, d, b0 + 90, -256);
            this.buttonYes.func_146112_a(this.field_146297_k, par1, par2);
            this.buttonNo.func_146112_a(this.field_146297_k, par1, par2);
        }
        if (this.currPage != 0 && !this.dialog) {
            for (int i = 0; i < this.field_146292_n.size(); ++i) {
                String[] tooltip;
                if (!(this.field_146292_n.get(i) instanceof GuiButton)) continue;
                GuiButton btn = (GuiButton)this.field_146292_n.get(i);
                if (par1 < btn.field_146128_h || par2 < btn.field_146129_i || par1 >= btn.field_146128_h + btn.field_146120_f || par2 >= btn.field_146129_i + btn.field_146121_g || !btn.field_146125_m) continue;
                if (i == 3 || i == 8) {
                    tooltip = new String[]{"Show all"};
                } else if (i == 4 || i == 9) {
                    tooltip = new String[]{"Show Items"};
                } else if (i == 5 || i == 10) {
                    tooltip = new String[]{"Show Blocks"};
                } else if (i == 6 || i == 11) {
                    tooltip = new String[]{"Show Entities"};
                } else if (i == 7 || i == 12) {
                    tooltip = new String[]{"Show other"};
                } else if (i == 13) {
                    tooltip = new String[]{"Show Quests"};
                } else if (i == 14 || i == 15) {
                    tooltip = new String[]{"Select Quest"};
                } else {
                    if (i != 16 && i != 17) continue;
                    tooltip = new String[]{"Remove Quest from list"};
                }
                List<String> list = Arrays.asList(tooltip);
                this.drawHoveringText(list, btn.field_146128_h + (btn.field_146128_h < 100 ? -72 : btn.field_146120_f), btn.field_146129_i + btn.field_146121_g, this.field_146289_q);
            }
        }
    }

    protected void func_146273_a(int p_146273_1_, int p_146273_2_, int p_146273_3_, long p_146273_4_) {
        if (this.type == 3) {
            if (p_146273_1_ > this.prevmouseposx) {
                this.rotationy -= 5;
            } else if (p_146273_1_ < this.prevmouseposx) {
                this.rotationy += 5;
            }
            if (p_146273_2_ > this.prevmouseposy && this.rotationx > -91) {
                if (!GuiDiary.func_146271_m() || this.size < 10 || this.size > 30) {
                    this.rotationx -= 5;
                }
            } else if (p_146273_2_ < this.prevmouseposy && this.rotationx < 91) {
                this.rotationx += 5;
            }
            this.prevmouseposx = p_146273_1_;
            this.prevmouseposy = p_146273_2_;
        }
    }

    public void func_146274_d() {
        super.func_146274_d();
        int i = Mouse.getEventDWheel();
        if (i != 0 && this.type == 3) {
            if (i > 0) {
                i = 2;
            }
            if (i < 0) {
                i = -2;
            }
            if (this.size >= 10 && i < 0) {
                this.size += i;
            } else if (this.size <= 25 && i > 0) {
                this.size += i;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class RemoveButton
    extends GuiButton {
        public RemoveButton(int par1, int par2, int par3) {
            super(par1, par2, par3, 9, 9, "");
        }

        public void func_146112_a(Minecraft p_146112_1_, int p_146112_2_, int p_146112_3_) {
            if (this.field_146125_m) {
                boolean flag = p_146112_2_ >= this.field_146128_h && p_146112_3_ >= this.field_146129_i && p_146112_2_ < this.field_146128_h + this.field_146120_f && p_146112_3_ < this.field_146129_i + this.field_146121_g;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                p_146112_1_.func_110434_K().func_110577_a(bookGuiTextures);
                int k = 105;
                int l = 240;
                if (flag) {
                    k += 9;
                }
                this.func_73729_b(this.field_146128_h, this.field_146129_i, k, l, 9, 9);
            }
        }

        public void func_146113_a(SoundHandler p_146113_1_) {
            p_146113_1_.func_147682_a((ISound)new ShadowSound("shadowworld:diary.diary_next_page", 1.0f, 0.75f));
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class SelectedButton
    extends GuiButton {
        public boolean selected;
        public boolean finished;

        public SelectedButton(int par1, int par2, int par3) {
            super(par1, par2, par3, 6, 6, "");
        }

        public void func_146112_a(Minecraft p_146112_1_, int p_146112_2_, int p_146112_3_) {
            if (this.field_146125_m) {
                boolean flag = p_146112_2_ >= this.field_146128_h && p_146112_3_ >= this.field_146129_i && p_146112_2_ < this.field_146128_h + this.field_146120_f && p_146112_3_ < this.field_146129_i + this.field_146121_g;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                p_146112_1_.func_110434_K().func_110577_a(bookGuiTextures);
                int k = 3;
                int l = 220;
                if (flag) {
                    l += 7;
                }
                if (this.selected) {
                    k += 8;
                }
                if (this.finished) {
                    k = 19;
                }
                this.func_73729_b(this.field_146128_h, this.field_146129_i, k, l, 6, 6);
            }
        }

        public void func_146113_a(SoundHandler p_146113_1_) {
            p_146113_1_.func_147682_a((ISound)new ShadowSound("shadowworld:diary.diary_next_page", 1.0f, 0.75f));
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class QuestButton
    extends GuiButton {
        public QuestButton(int par1, int par2, int par3) {
            super(par1, par2, par3, 19, 17, "");
        }

        public void func_146112_a(Minecraft p_146112_1_, int p_146112_2_, int p_146112_3_) {
            if (this.field_146125_m) {
                boolean flag = p_146112_2_ >= this.field_146128_h && p_146112_3_ >= this.field_146129_i && p_146112_2_ < this.field_146128_h + this.field_146120_f && p_146112_3_ < this.field_146129_i + this.field_146121_g;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                p_146112_1_.func_110434_K().func_110577_a(bookGuiTextures);
                int k = 48;
                int l = 238;
                if (flag) {
                    k += 20;
                }
                this.func_73729_b(this.field_146128_h, this.field_146129_i, k, l, 19, 17);
            }
        }

        public void func_146113_a(SoundHandler p_146113_1_) {
            p_146113_1_.func_147682_a((ISound)new ShadowSound("shadowworld:diary.diary_next_page", 1.0f, 0.75f));
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class CategoryButton
    extends GuiButton {
        private int number;
        private boolean left;

        public CategoryButton(int par1, int par2, int par3, int par4, boolean left) {
            super(par1, par2, par3, 23, 13, "");
            this.number = par4;
            this.left = left;
        }

        public void func_146112_a(Minecraft p_146112_1_, int p_146112_2_, int p_146112_3_) {
            if (this.field_146125_m) {
                boolean flag = p_146112_2_ >= this.field_146128_h && p_146112_3_ >= this.field_146129_i && p_146112_2_ < this.field_146128_h + this.field_146120_f && p_146112_3_ < this.field_146129_i + this.field_146121_g;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                p_146112_1_.func_110434_K().func_110577_a(bookGuiTextures);
                int k = 48;
                int l = 192;
                if (this.left) {
                    k = 210;
                }
                if (flag) {
                    l += 18;
                }
                for (int i = 1; i <= this.number; ++i) {
                    if (this.left) {
                        k -= 18;
                        continue;
                    }
                    k += 18;
                }
                this.func_73729_b(this.field_146128_h, this.field_146129_i, k, l, 18, 18);
            }
        }

        public void func_146113_a(SoundHandler p_146113_1_) {
            p_146113_1_.func_147682_a((ISound)new ShadowSound("shadowworld:diary.diary_next_page", 1.0f, 0.75f));
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class NextPageButton
    extends GuiButton {
        private final boolean field_146151_o;

        public NextPageButton(int par1, int par2, int par3, boolean par4) {
            super(par1, par2, par3, 23, 13, "");
            this.field_146151_o = par4;
        }

        public void func_146112_a(Minecraft p_146112_1_, int p_146112_2_, int p_146112_3_) {
            if (this.field_146125_m) {
                boolean flag = p_146112_2_ >= this.field_146128_h && p_146112_3_ >= this.field_146129_i && p_146112_2_ < this.field_146128_h + this.field_146120_f && p_146112_3_ < this.field_146129_i + this.field_146121_g;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                p_146112_1_.func_110434_K().func_110577_a(bookGuiTextures);
                int k = 0;
                int l = 192;
                if (flag) {
                    k += 23;
                }
                if (!this.field_146151_o) {
                    l += 13;
                }
                this.func_73729_b(this.field_146128_h, this.field_146129_i, k, l, 23, 13);
            }
        }

        public void func_146113_a(SoundHandler p_146113_1_) {
            p_146113_1_.func_147682_a((ISound)new ShadowSound("shadowworld:diary.diary_next_page", 1.0f, 0.85f));
        }
    }
}

