Scriptname HellBMagicHellLauncherScript extends activemagiceffect  

import Math
import Utility

Int index

; initial position vector
float xPos
float yPos
float zPos

; fly vector
float dx
float dy
float dz

; private
float ang
float xAng
float yAng
float zAng  
float x1
float x2
float sin
float cos

Idle Property HellBIdle01  Auto  

Perk Property HellBPerkResetFallDamage  Auto

Activator Property HellBActivatorAirWalk  Auto
ObjectReference AirWalk

Activator Property HellBActivatorHellLauncher  Auto
ObjectReference HellBuster

GlobalVariable Property HellBxAng  Auto 
GlobalVariable Property HellByAng  Auto
GlobalVariable Property HellBzAng  Auto

Event OnEffectStart(Actor Target, Actor Caster)

	Actor PlayerActor =  Game.GetPlayer()

		xAng = PlayerActor.getAngleX()
		yAng = PlayerActor.getAngleY()
		zAng = PlayerActor.getAngleZ()

		HellBxAng.setValue(xAng)
		HellByAng.setValue(yAng)
		HellBzAng.setValue(zAng)

		ang = PlayerActor.GetAngleZ()
		zang = ang

		if ang > 180
			ang = ang - 360
		endif

		x1 = ang*0.0174532925
		x2 = x1*x1
		sin = x1*(1-(x2/6)*(1-(x2/20)*(1-(x2/42)*(1-(x2/72)*(1-x2/110)))))
		cos = 1-(0.5)*x2*(1-(x2/12)*(1-(x2/30)*(1-(x2/56)*(1-x2/90))))
		dx = 10*sin
		dy = 10*cos

		; vertical fly vector
		ang = PlayerActor.GetAngleX()
		x1 = ang*0.0174532925
		x2 = x1*x1
		xang = ang*cos ; uses settings from Horizontal Vector
		yang = -ang*sin

		Caster.AddPerk(HellBPerkResetFallDamage)

		Airwalk = Caster.PlaceAtMe(HellBActivatorAirWalk)

		Airwalk.MoveTo(Caster,0,0,0,True)
		Airwalk.Activate(Caster)

		HellBuster = Caster.PlaceAtMe(HellBActivatorHellLauncher)

		HellBuster.MoveTo(Caster,0,0,78,True)
		HellBuster.setAngle(xAng, yAng, zAng)
		HellBuster.Activate(Caster)

		Debug.ToggleCollisions()
		Caster.PlayIdle(HellBIdle01)
		Debug.ToggleCollisions()

		Caster.RemovePerk(HellBPerkResetFallDamage)

EndEvent

Event OnEffectFinish(Actor Target, Actor Caster)

endEvent
