Scriptname HellBActivatorHellLauncherScript extends ObjectReference  

import Utility

int BusterHit

float ftimeStart
float ftimeEnd
float Energy

float xAng
float yAng
float zAng  

Spell Property  HellBSpellBarrelShot  Auto

WEAPON Property HellBWeaponBuster  Auto
Ammo Property HellBAmmoBuster  Auto

Sound Property HellbFXHellBuster  Auto
Int SFXHellBuster

Activator Property HellBActivatorHellLauncherCast  Auto
ObjectReference Cast

GlobalVariable Property HellBStamina  Auto
GlobalVariable Property HellBHit  Auto
GlobalVariable Property HellBDelay  Auto
GlobalVariable Property HellBxAng  Auto 
GlobalVariable Property HellByAng  Auto
GlobalVariable Property HellBzAng  Auto

EVENT onActivate(objectReference akActivator)

	Actor PlayerActor =  Game.GetPlayer()
	ftimeStart = 0.0
	ftimeEnd = 0.0
	BusterHit = 0

	xAng = HellBxAng.getValue()  
	yAng = HellByAng.getValue()
	zAng = HellBzAng.getValue()

	wait(0.1)
	self.PlayAnimation("PlayAnim02")

	Cast= PlayerActor.PlaceAtMe(HellBActivatorHellLauncherCast)
	Cast.moveTo(self ,0 ,0 ,0 ,True)
	Cast.setAngle(xAng, yAng, zAng)

	Energy = HellBStamina.getValue()
	ftimeStart = GetCurrentRealTime()
	ftimeEnd = GetCurrentRealTime()

	While( ftimeStart + 0.5 > ftimeEnd)
		ftimeEnd = GetCurrentRealTime()
	endWhile

	SFXHellBuster = HellbFXHellBuster.play(self)

	While( ftimeStart + 2.0 > ftimeEnd)
		ftimeEnd = GetCurrentRealTime()
	endWhile

	While(BusterHit < HellBHit.getValue())

		ftimeEnd = GetCurrentRealTime()

		if ftimeStart + HellBDelay.getValue() < ftimeEnd

			ftimeStart = GetCurrentRealTime()
			BusterHit += 1

			if PlayerActor.getav("Stamina") as float >= Energy
				HellBSpellBarrelShot.RemoteCast(self,PlayerActor)
				HellBWeaponBuster.fire(Cast, HellBAmmoBuster)
				PlayerActor.damageAV("Stamina", Energy)
			else
				Sound.StopInstance(SFXHellBuster)
				Cast.disable()
				disable()
				return
			endif
		
		endif

	endWhile

	Cast.disable()
	disable()

endEvent
