Scriptname HellBActivatorHellBusterScript extends ObjectReference  

import Utility

int BusterHit

float ftimeStart
float ftimeEnd
float Energy

Spell Property  HellBSpellHellBurst  Auto

Sound Property HellbFXHellBuster  Auto
Int SFXHellBuster

GlobalVariable Property HellBStamina  Auto
GlobalVariable Property HellBHit  Auto
GlobalVariable Property HellBDelay  Auto

EVENT onActivate(objectReference akActivator)

	Actor PlayerActor =  Game.GetPlayer()
	ftimeStart = 0.0
	ftimeEnd = 0.0
	BusterHit = 0

	wait(0.1)
	self.PlayAnimation("PlayAnim02")

	Energy = HellBStamina.getValue()
	ftimeStart = GetCurrentRealTime()
	ftimeEnd = GetCurrentRealTime()

	While( ftimeStart + 0.5 > ftimeEnd)
		ftimeEnd = GetCurrentRealTime()
	endWhile

	SFXHellBuster = HellbFXHellBuster.play(self)

	While( ftimeStart + 1.0 > ftimeEnd)
		ftimeEnd = GetCurrentRealTime()
	endWhile

	While(BusterHit < HellBHit.getValue())

		ftimeEnd = GetCurrentRealTime()

		if ftimeStart + HellBDelay.getValue() < ftimeEnd

			ftimeStart = GetCurrentRealTime()
			BusterHit += 1

			if PlayerActor.getav("Stamina") as float >= Energy
				HellBSpellHellBurst.RemoteCast(self,PlayerActor)
				PlayerActor.damageAV("Stamina", Energy)
			else
				Sound.StopInstance(SFXHellBuster)  
				disable()
				return
			endif
		
		endif

	endWhile

	disable()

endEvent