/*
 * Decompiled with CFR 0.152.
 */
package com.android.traceview;

import com.android.traceview.Call;
import com.android.traceview.MethodData;
import com.android.traceview.Selection;
import com.android.traceview.SelectionController;
import com.android.traceview.TickScaler;
import com.android.traceview.TraceReader;
import com.android.traceview.TraceUnits;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeLineView
extends Composite
implements Observer {
    private HashMap<String, RowData> mRowByName;
    private double mTotalElapsed;
    private RowData[] mRows;
    private Segment[] mSegments;
    private ArrayList<Segment> mSegmentList = new ArrayList();
    private HashMap<Integer, String> mThreadLabels;
    private Timescale mTimescale;
    private Surface mSurface;
    private RowLabels mLabels;
    private SashForm mSashForm;
    private int mScrollOffsetY;
    public static final int PixelsPerTick = 50;
    private TickScaler mScaleInfo = new TickScaler(0.0, 0.0, 0, 50);
    private static final int LeftMargin = 10;
    private static final int RightMargin = 60;
    private Color mColorBlack;
    private Color mColorGray;
    private Color mColorDarkGray;
    private Color mColorForeground;
    private Color mColorRowBack;
    private Color mColorZoomSelection;
    private FontRegistry mFontRegistry;
    private static final int rowHeight = 20;
    private static final int rowYMargin = 12;
    private static final int rowYMarginHalf = 6;
    private static final int rowYSpace = 32;
    private static final int majorTickLength = 8;
    private static final int minorTickLength = 4;
    private static final int timeLineOffsetY = 38;
    private static final int tickToFontSpacing = 2;
    private static final int topMargin = 70;
    private int mMouseRow = -1;
    private int mNumRows;
    private int mStartRow;
    private int mEndRow;
    private TraceUnits mUnits;
    private int mSmallFontWidth;
    private int mSmallFontHeight;
    private int mMediumFontWidth;
    private SelectionController mSelectionController;
    private MethodData mHighlightMethodData;
    private Call mHighlightCall;
    private static final int MinInclusiveRange = 3;
    private boolean mSetFonts = false;

    public TimeLineView(Composite parent, TraceReader reader, SelectionController selectionController) {
        super(parent, 0);
        this.mRowByName = new HashMap();
        this.mSelectionController = selectionController;
        selectionController.addObserver(this);
        this.mUnits = reader.getTraceUnits();
        this.mThreadLabels = reader.getThreadLabels();
        Display display = this.getDisplay();
        this.mColorGray = display.getSystemColor(15);
        this.mColorDarkGray = display.getSystemColor(16);
        this.mColorBlack = display.getSystemColor(2);
        this.mColorForeground = display.getSystemColor(2);
        this.mColorRowBack = new Color((Device)display, 240, 240, 255);
        this.mColorZoomSelection = new Color((Device)display, 230, 230, 230);
        this.mFontRegistry = new FontRegistry(display);
        this.mFontRegistry.put("small", new FontData[]{new FontData("Arial", 8, 0)});
        this.mFontRegistry.put("courier8", new FontData[]{new FontData("Courier New", 8, 1)});
        this.mFontRegistry.put("medium", new FontData[]{new FontData("Courier New", 10, 0)});
        Image image = new Image((Device)display, new Rectangle(100, 100, 100, 100));
        GC gc = new GC((Drawable)image);
        if (this.mSetFonts) {
            gc.setFont(this.mFontRegistry.get("small"));
        }
        this.mSmallFontWidth = gc.getFontMetrics().getAverageCharWidth();
        this.mSmallFontHeight = gc.getFontMetrics().getHeight();
        if (this.mSetFonts) {
            gc.setFont(this.mFontRegistry.get("medium"));
        }
        this.mMediumFontWidth = gc.getFontMetrics().getAverageCharWidth();
        image.dispose();
        gc.dispose();
        this.setLayout((Layout)new FillLayout());
        this.mSashForm = new SashForm((Composite)this, 256);
        this.mSashForm.setBackground(this.mColorGray);
        this.mSashForm.SASH_WIDTH = 3;
        Composite composite = new Composite((Composite)this.mSashForm, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 1;
        composite.setLayout((Layout)layout);
        BlankCorner corner = new BlankCorner(composite);
        GridData gridData = new GridData(768);
        gridData.heightHint = 70;
        corner.setLayoutData(gridData);
        this.mLabels = new RowLabels(composite);
        gridData = new GridData(1808);
        this.mLabels.setLayoutData(gridData);
        composite = new Composite((Composite)this.mSashForm, 0);
        layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 1;
        composite.setLayout((Layout)layout);
        this.mTimescale = new Timescale(composite);
        gridData = new GridData(768);
        gridData.heightHint = 70;
        this.mTimescale.setLayoutData(gridData);
        this.mSurface = new Surface(composite);
        gridData = new GridData(1808);
        this.mSurface.setLayoutData(gridData);
        this.mSashForm.setWeights(new int[]{1, 5});
        final ScrollBar vBar = this.mSurface.getVerticalBar();
        vBar.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TimeLineView.this.mScrollOffsetY = vBar.getSelection();
                Point dim = TimeLineView.this.mSurface.getSize();
                int newScrollOffsetY = TimeLineView.this.computeVisibleRows(dim.y);
                if (newScrollOffsetY != TimeLineView.this.mScrollOffsetY) {
                    TimeLineView.this.mScrollOffsetY = newScrollOffsetY;
                    vBar.setSelection(newScrollOffsetY);
                }
                TimeLineView.this.mLabels.redraw();
                TimeLineView.this.mSurface.redraw();
            }
        });
        this.mSurface.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                Point dim = TimeLineView.this.mSurface.getSize();
                if (dim.y >= TimeLineView.this.mNumRows * 32) {
                    vBar.setVisible(false);
                } else {
                    vBar.setVisible(true);
                }
                int newScrollOffsetY = TimeLineView.this.computeVisibleRows(dim.y);
                if (newScrollOffsetY != TimeLineView.this.mScrollOffsetY) {
                    TimeLineView.this.mScrollOffsetY = newScrollOffsetY;
                    vBar.setSelection(newScrollOffsetY);
                }
                int spaceNeeded = TimeLineView.this.mNumRows * 32;
                vBar.setMaximum(spaceNeeded);
                vBar.setThumb(dim.y);
                TimeLineView.this.mLabels.redraw();
                TimeLineView.this.mSurface.redraw();
            }
        });
        this.mSurface.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent me) {
                TimeLineView.this.mSurface.mouseUp(me);
            }

            public void mouseDown(MouseEvent me) {
                TimeLineView.this.mSurface.mouseDown(me);
            }

            public void mouseDoubleClick(MouseEvent me) {
                TimeLineView.this.mSurface.mouseDoubleClick(me);
            }
        });
        this.mSurface.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent me) {
                TimeLineView.this.mSurface.mouseMove(me);
            }
        });
        this.mTimescale.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent me) {
                TimeLineView.this.mTimescale.mouseUp(me);
            }

            public void mouseDown(MouseEvent me) {
                TimeLineView.this.mTimescale.mouseDown(me);
            }

            public void mouseDoubleClick(MouseEvent me) {
                TimeLineView.this.mTimescale.mouseDoubleClick(me);
            }
        });
        this.mTimescale.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent me) {
                TimeLineView.this.mTimescale.mouseMove(me);
            }
        });
        this.mLabels.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent me) {
                TimeLineView.this.mLabels.mouseMove(me);
            }
        });
        this.setData(reader.getThreadTimeRecords());
    }

    @Override
    public void update(Observable objservable, Object arg) {
        if (arg == "TimeLineView") {
            return;
        }
        boolean foundHighlight = false;
        ArrayList<Selection> selections = this.mSelectionController.getSelections();
        for (Selection selection : selections) {
            Selection.Action action = selection.getAction();
            if (action != Selection.Action.Highlight) continue;
            String name = selection.getName();
            if (name == "MethodData") {
                foundHighlight = true;
                this.mHighlightMethodData = (MethodData)selection.getValue();
                this.mHighlightCall = null;
                this.startHighlighting();
                continue;
            }
            if (name != "Call") continue;
            foundHighlight = true;
            this.mHighlightCall = (Call)selection.getValue();
            this.mHighlightMethodData = null;
            this.startHighlighting();
        }
        if (!foundHighlight) {
            this.mSurface.clearHighlights();
        }
    }

    public void setData(ArrayList<Record> records) {
        int ii;
        if (records == null) {
            records = new ArrayList();
        }
        Collections.sort(records, new Comparator<Record>(){

            @Override
            public int compare(Record r1, Record r2) {
                long end2;
                long start2;
                long start1 = r1.block.getStartTime();
                if (start1 > (start2 = r2.block.getStartTime())) {
                    return 1;
                }
                if (start1 < start2) {
                    return -1;
                }
                long end1 = r1.block.getEndTime();
                if (end1 > (end2 = r2.block.getEndTime())) {
                    return -1;
                }
                if (end1 < end2) {
                    return 1;
                }
                return 0;
            }
        });
        double minVal = 0.0;
        if (records.size() > 0) {
            minVal = records.get((int)0).block.getStartTime();
        }
        double maxVal = 0.0;
        for (Record rec : records) {
            Block top;
            Row row = rec.row;
            Block block = rec.block;
            String rowName = row.getName();
            RowData rd = this.mRowByName.get(rowName);
            if (rd == null) {
                rd = new RowData(row);
                this.mRowByName.put(rowName, rd);
            }
            long blockStartTime = block.getStartTime();
            long blockEndTime = block.getEndTime();
            if (blockEndTime > rd.mEndTime) {
                long start = Math.max(blockStartTime, rd.mEndTime);
                rd.mElapsed += blockEndTime - start;
                this.mTotalElapsed += (double)(blockEndTime - start);
                rd.mEndTime = blockEndTime;
            }
            if ((double)blockEndTime > maxVal) {
                maxVal = blockEndTime;
            }
            if ((top = rd.top()) == null) {
                rd.push(block);
                continue;
            }
            long topStartTime = top.getStartTime();
            long topEndTime = top.getEndTime();
            if (topEndTime >= blockStartTime) {
                if (topStartTime < blockStartTime) {
                    Segment segment = new Segment(rd, top, topStartTime, blockStartTime);
                    this.mSegmentList.add(segment);
                }
                if (topEndTime == blockStartTime) {
                    rd.pop();
                }
                rd.push(block);
                continue;
            }
            this.popFrames(rd, top, blockStartTime);
            rd.push(block);
        }
        for (RowData rd : this.mRowByName.values()) {
            Block top = rd.top();
            this.popFrames(rd, top, Integer.MAX_VALUE);
        }
        this.mSurface.setRange(minVal, maxVal);
        this.mSurface.setLimitRange(minVal, maxVal);
        Collection<RowData> rv = this.mRowByName.values();
        this.mRows = rv.toArray(new RowData[rv.size()]);
        Arrays.sort(this.mRows, new Comparator<RowData>(){

            @Override
            public int compare(RowData rd1, RowData rd2) {
                return (int)(rd2.mElapsed - rd1.mElapsed);
            }
        });
        for (ii = 0; ii < this.mRows.length; ++ii) {
            this.mRows[ii].mRank = ii;
        }
        this.mNumRows = 0;
        for (ii = 0; ii < this.mRows.length && this.mRows[ii].mElapsed != 0L; ++ii) {
            ++this.mNumRows;
        }
        this.mSegments = this.mSegmentList.toArray(new Segment[this.mSegmentList.size()]);
        Arrays.sort(this.mSegments, new Comparator<Segment>(){

            @Override
            public int compare(Segment bd1, Segment bd2) {
                RowData rd1 = bd1.mRowData;
                RowData rd2 = bd2.mRowData;
                int diff = rd1.mRank - rd2.mRank;
                if (diff == 0) {
                    long timeDiff = bd1.mStartTime - bd2.mStartTime;
                    if (timeDiff == 0L) {
                        timeDiff = bd1.mEndTime - bd2.mEndTime;
                    }
                    return (int)timeDiff;
                }
                return diff;
            }
        });
    }

    private void popFrames(RowData rd, Block top, long startTime) {
        long topEndTime = top.getEndTime();
        long lastEndTime = top.getStartTime();
        while (topEndTime <= startTime) {
            if (topEndTime > lastEndTime) {
                Segment segment = new Segment(rd, top, lastEndTime, topEndTime);
                this.mSegmentList.add(segment);
                lastEndTime = topEndTime;
            }
            rd.pop();
            top = rd.top();
            if (top == null) {
                return;
            }
            topEndTime = top.getEndTime();
        }
        if (lastEndTime < startTime) {
            Segment bd = new Segment(rd, top, lastEndTime, startTime);
            this.mSegmentList.add(bd);
        }
    }

    private int computeVisibleRows(int ydim) {
        int offsetY = this.mScrollOffsetY;
        int spaceNeeded = this.mNumRows * 32;
        if (offsetY + ydim > spaceNeeded && (offsetY = spaceNeeded - ydim) < 0) {
            offsetY = 0;
        }
        this.mStartRow = offsetY / 32;
        this.mEndRow = (offsetY + ydim) / 32;
        if (this.mEndRow >= this.mNumRows) {
            this.mEndRow = this.mNumRows - 1;
        }
        return offsetY;
    }

    private void startHighlighting() {
        this.mSurface.mHighlightStep = 0;
        this.mSurface.mFadeColors = true;
        this.mSurface.mCachedEndRow = -1;
        this.getDisplay().timerExec(0, this.mSurface.mHighlightAnimator);
    }

    private static class Range {
        Point mXdim = new Point(0, 0);
        int mY;
        Color mColor;

        Range(int xStart, int width, int y, Color color) {
            this.mXdim.x = xStart;
            this.mXdim.y = width;
            this.mY = y;
            this.mColor = color;
        }
    }

    private static class Pixel {
        int mStart = -2;
        double mMaxWeight;
        Segment mSegment;
        Color mColor;
        RowData mRowData;

        private Pixel() {
        }

        public void setFields(int start, double weight, Segment segment, Color color, RowData rowData) {
            this.mStart = start;
            this.mMaxWeight = weight;
            this.mSegment = segment;
            this.mColor = color;
            this.mRowData = rowData;
        }
    }

    private static class Strip {
        int mX;
        int mY;
        int mWidth;
        int mHeight;
        RowData mRowData;
        Segment mSegment;
        Color mColor;

        Strip(int x, int y, int width, int height, RowData rowData, Segment segment, Color color) {
            this.mX = x;
            this.mY = y;
            this.mWidth = width;
            this.mHeight = height;
            this.mRowData = rowData;
            this.mSegment = segment;
            this.mColor = color;
        }
    }

    private static class Segment {
        private RowData mRowData;
        private Block mBlock;
        private long mStartTime;
        private long mEndTime;

        Segment(RowData rowData, Block block, long startTime, long endTime) {
            this.mRowData = rowData;
            this.mBlock = block;
            this.mStartTime = startTime;
            this.mEndTime = endTime;
        }
    }

    private static class RowData {
        private String mName;
        private int mRank;
        private long mElapsed;
        private long mEndTime;
        private ArrayList<Block> mStack;

        RowData(Row row) {
            this.mName = row.getName();
            this.mStack = new ArrayList();
        }

        public void push(Block block) {
            this.mStack.add(block);
        }

        public Block top() {
            if (this.mStack.size() == 0) {
                return null;
            }
            return this.mStack.get(this.mStack.size() - 1);
        }

        public void pop() {
            if (this.mStack.size() == 0) {
                return;
            }
            this.mStack.remove(this.mStack.size() - 1);
        }
    }

    private class Surface
    extends Canvas {
        private static final int TotalXMargin = 70;
        private static final int yMargin = 1;
        private static final int MinZoomPixelMargin = 10;
        private GraphicsState mGraphicsState;
        private Point mMouse;
        private int mMouseMarkStartX;
        private int mMouseMarkEndX;
        private boolean mDebug;
        private ArrayList<Strip> mStripList;
        private ArrayList<Range> mHighlightExclusive;
        private ArrayList<Range> mHighlightInclusive;
        private int mMinStripHeight;
        private double mCachedMinVal;
        private double mCachedMaxVal;
        private int mCachedStartRow;
        private int mCachedEndRow;
        private double mScalePixelsPerRange;
        private double mScaleMinVal;
        private double mScaleMaxVal;
        private double mLimitMinVal;
        private double mLimitMaxVal;
        private double mMinDataVal;
        private double mMaxDataVal;
        private Cursor mNormalCursor;
        private Cursor mIncreasingCursor;
        private Cursor mDecreasingCursor;
        private static final int ZOOM_TIMER_INTERVAL = 10;
        private static final int HIGHLIGHT_TIMER_INTERVAL = 50;
        private static final int ZOOM_STEPS = 8;
        private int highlightHeight;
        private final int[] highlightHeights;
        private final int HIGHLIGHT_STEPS;
        private boolean mFadeColors;
        private boolean mShowHighlightName;
        private double[] mZoomFractions;
        private int mZoomStep;
        private int mZoomMouseStart;
        private int mZoomMouseEnd;
        private int mMouseStartDistance;
        private int mMouseEndDistance;
        private Point mMouseSelect;
        private double mZoomFixed;
        private double mZoomFixedPixel;
        private double mFixedPixelStartDistance;
        private double mFixedPixelEndDistance;
        private double mZoomMin2Fixed;
        private double mMin2ZoomMin;
        private double mFixed2ZoomMax;
        private double mZoomMax2Max;
        private double mZoomMin;
        private double mZoomMax;
        private Runnable mZoomAnimator;
        private Runnable mHighlightAnimator;
        private int mHighlightStep;

        public Surface(Composite parent) {
            super(parent, 262656);
            this.mGraphicsState = GraphicsState.Normal;
            this.mMouse = new Point(10, 0);
            this.mDebug = false;
            this.mStripList = new ArrayList();
            this.mHighlightExclusive = new ArrayList();
            this.mHighlightInclusive = new ArrayList();
            this.mMinStripHeight = 2;
            this.highlightHeight = 4;
            this.highlightHeights = new int[]{0, 2, 4, 5, 6, 5, 4, 2, 4, 5, 6};
            this.HIGHLIGHT_STEPS = this.highlightHeights.length;
            this.mMouseSelect = new Point(0, 0);
            Display display = this.getDisplay();
            this.mNormalCursor = new Cursor((Device)display, 2);
            this.mIncreasingCursor = new Cursor((Device)display, 12);
            this.mDecreasingCursor = new Cursor((Device)display, 13);
            this.initZoomFractionsWithExp();
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent pe) {
                    Surface.this.draw(pe.display, pe.gc);
                }
            });
            this.mZoomAnimator = new Runnable(){

                public void run() {
                    Surface.this.animateZoom();
                }
            };
            this.mHighlightAnimator = new Runnable(){

                public void run() {
                    Surface.this.animateHighlight();
                }
            };
        }

        private void initZoomFractionsWithExp() {
            this.mZoomFractions = new double[8];
            int next = 0;
            int ii = 0;
            while (ii < 4) {
                this.mZoomFractions[next] = (double)(1 << ii) / 16.0;
                ++ii;
                ++next;
            }
            ii = 2;
            while (ii < 6) {
                this.mZoomFractions[next] = (double)((1 << ii) - 1) / (double)(1 << ii);
                ++ii;
                ++next;
            }
        }

        private void initZoomFractionsWithSinWave() {
            this.mZoomFractions = new double[8];
            for (int ii = 0; ii < 8; ++ii) {
                double offset = Math.PI * (double)ii / 8.0;
                this.mZoomFractions[ii] = (Math.sin(4.71238898038469 + offset) + 1.0) / 2.0;
            }
        }

        public void setRange(double minVal, double maxVal) {
            this.mMinDataVal = minVal;
            this.mMaxDataVal = maxVal;
            TimeLineView.this.mScaleInfo.setMinVal(minVal);
            TimeLineView.this.mScaleInfo.setMaxVal(maxVal);
        }

        public void setLimitRange(double minVal, double maxVal) {
            this.mLimitMinVal = minVal;
            this.mLimitMaxVal = maxVal;
        }

        public void resetScale() {
            TimeLineView.this.mScaleInfo.setMinVal(this.mLimitMinVal);
            TimeLineView.this.mScaleInfo.setMaxVal(this.mLimitMaxVal);
        }

        private void draw(Display display, GC gc) {
            if (TimeLineView.this.mSegments.length == 0) {
                return;
            }
            Image image = new Image((Device)display, this.getBounds());
            GC gcImage = new GC((Drawable)image);
            if (TimeLineView.this.mSetFonts) {
                gcImage.setFont(TimeLineView.this.mFontRegistry.get("small"));
            }
            if (this.mGraphicsState == GraphicsState.Scaling) {
                double diff = this.mMouse.x - this.mMouseMarkStartX;
                if (diff > 0.0) {
                    double newMinVal = this.mScaleMinVal - diff / this.mScalePixelsPerRange;
                    if (newMinVal < this.mLimitMinVal) {
                        newMinVal = this.mLimitMinVal;
                    }
                    TimeLineView.this.mScaleInfo.setMinVal(newMinVal);
                } else if (diff < 0.0) {
                    double newMaxVal = this.mScaleMaxVal - diff / this.mScalePixelsPerRange;
                    if (newMaxVal > this.mLimitMaxVal) {
                        newMaxVal = this.mLimitMaxVal;
                    }
                    TimeLineView.this.mScaleInfo.setMaxVal(newMaxVal);
                }
            }
            Point dim = this.getSize();
            if (TimeLineView.this.mStartRow != this.mCachedStartRow || TimeLineView.this.mEndRow != this.mCachedEndRow || TimeLineView.this.mScaleInfo.getMinVal() != this.mCachedMinVal || TimeLineView.this.mScaleInfo.getMaxVal() != this.mCachedMaxVal) {
                this.mCachedStartRow = TimeLineView.this.mStartRow;
                this.mCachedEndRow = TimeLineView.this.mEndRow;
                int xdim = dim.x - 70;
                TimeLineView.this.mScaleInfo.setNumPixels(xdim);
                boolean forceEndPoints = this.mGraphicsState == GraphicsState.Scaling || this.mGraphicsState == GraphicsState.Animating;
                TimeLineView.this.mScaleInfo.computeTicks(forceEndPoints);
                this.mCachedMinVal = TimeLineView.this.mScaleInfo.getMinVal();
                this.mCachedMaxVal = TimeLineView.this.mScaleInfo.getMaxVal();
                if (this.mLimitMinVal > TimeLineView.this.mScaleInfo.getMinVal()) {
                    this.mLimitMinVal = TimeLineView.this.mScaleInfo.getMinVal();
                }
                if (this.mLimitMaxVal < TimeLineView.this.mScaleInfo.getMaxVal()) {
                    this.mLimitMaxVal = TimeLineView.this.mScaleInfo.getMaxVal();
                }
                this.computeStrips();
            }
            if (TimeLineView.this.mNumRows > 2) {
                gcImage.setBackground(TimeLineView.this.mColorRowBack);
                for (int ii = 1; ii < TimeLineView.this.mNumRows; ii += 2) {
                    RowData rd = TimeLineView.this.mRows[ii];
                    int y1 = rd.mRank * 32 - TimeLineView.this.mScrollOffsetY;
                    gcImage.fillRectangle(0, y1, dim.x, 32);
                }
            }
            if (this.drawingSelection()) {
                this.drawSelection(display, gcImage);
            }
            String blockName = null;
            Color blockColor = null;
            if (this.mDebug) {
                double pixelsPerRange = TimeLineView.this.mScaleInfo.getPixelsPerRange();
                System.out.printf("dim.x %d pixels %d minVal %f, maxVal %f ppr %f rpp %f\n", dim.x, dim.x - 70, TimeLineView.this.mScaleInfo.getMinVal(), TimeLineView.this.mScaleInfo.getMaxVal(), pixelsPerRange, 1.0 / pixelsPerRange);
            }
            Block selectBlock = null;
            for (Strip strip : this.mStripList) {
                if (strip.mColor == null) continue;
                gcImage.setBackground(strip.mColor);
                gcImage.fillRectangle(strip.mX, strip.mY - TimeLineView.this.mScrollOffsetY, strip.mWidth, strip.mHeight);
                if (TimeLineView.this.mMouseRow != strip.mRowData.mRank) continue;
                if (this.mMouse.x >= strip.mX && this.mMouse.x < strip.mX + strip.mWidth) {
                    blockName = strip.mSegment.mBlock.getName();
                    blockColor = strip.mColor;
                }
                if (this.mMouseSelect.x < strip.mX || this.mMouseSelect.x >= strip.mX + strip.mWidth) continue;
                selectBlock = strip.mSegment.mBlock;
            }
            this.mMouseSelect.x = 0;
            this.mMouseSelect.y = 0;
            if (selectBlock != null) {
                ArrayList<Selection> selections = new ArrayList<Selection>();
                RowData rd = TimeLineView.this.mRows[TimeLineView.this.mMouseRow];
                selections.add(Selection.highlight("Thread", rd.mName));
                selections.add(Selection.highlight("Call", selectBlock));
                int mouseX = this.mMouse.x - 10;
                double mouseXval = TimeLineView.this.mScaleInfo.pixelToValue(mouseX);
                selections.add(Selection.highlight("Time", mouseXval));
                TimeLineView.this.mSelectionController.change(selections, "TimeLineView");
                TimeLineView.this.mHighlightMethodData = null;
                TimeLineView.this.mHighlightCall = (Call)selectBlock;
                TimeLineView.this.startHighlighting();
            }
            if (TimeLineView.this.mMouseRow >= 0 && TimeLineView.this.mMouseRow < TimeLineView.this.mNumRows && this.mHighlightStep == 0) {
                gcImage.setForeground(TimeLineView.this.mColorGray);
                int y1 = TimeLineView.this.mMouseRow * 32 - TimeLineView.this.mScrollOffsetY;
                gcImage.drawLine(0, y1, dim.x, y1);
                gcImage.drawLine(0, y1 + 32, dim.x, y1 + 32);
            }
            this.drawHighlights(gcImage, dim);
            gcImage.setForeground(TimeLineView.this.mColorDarkGray);
            int lineEnd = Math.min(dim.y, TimeLineView.this.mNumRows * 32);
            gcImage.drawLine(this.mMouse.x, 0, this.mMouse.x, lineEnd);
            if (blockName != null) {
                TimeLineView.this.mTimescale.setMethodName(blockName);
                TimeLineView.this.mTimescale.setMethodColor(blockColor);
                this.mShowHighlightName = false;
            } else if (this.mShowHighlightName) {
                MethodData md = TimeLineView.this.mHighlightMethodData;
                if (md == null && TimeLineView.this.mHighlightCall != null) {
                    md = TimeLineView.this.mHighlightCall.getMethodData();
                }
                if (md == null) {
                    System.out.printf("null highlight?\n", new Object[0]);
                }
                if (md != null) {
                    TimeLineView.this.mTimescale.setMethodName(md.getProfileName());
                    TimeLineView.this.mTimescale.setMethodColor(md.getColor());
                }
            } else {
                TimeLineView.this.mTimescale.setMethodName(null);
                TimeLineView.this.mTimescale.setMethodColor(null);
            }
            TimeLineView.this.mTimescale.redraw();
            gc.drawImage(image, 0, 0);
            image.dispose();
            gcImage.dispose();
        }

        private void drawHighlights(GC gc, Point dim) {
            int height = this.highlightHeight;
            if (height <= 0) {
                return;
            }
            for (Range range : this.mHighlightExclusive) {
                gc.setBackground(range.mColor);
                int xStart = range.mXdim.x;
                int width = range.mXdim.y;
                gc.fillRectangle(xStart, range.mY - height - TimeLineView.this.mScrollOffsetY, width, height);
            }
            if (--height <= 0) {
                height = 1;
            }
            gc.setForeground(TimeLineView.this.mColorDarkGray);
            gc.setBackground(TimeLineView.this.mColorDarkGray);
            for (Range range : this.mHighlightInclusive) {
                int[] points;
                int x1 = range.mXdim.x;
                int x2 = range.mXdim.y;
                boolean drawLeftEnd = false;
                boolean drawRightEnd = false;
                if (x1 >= 10) {
                    drawLeftEnd = true;
                } else {
                    x1 = 10;
                }
                if (x2 >= 10) {
                    drawRightEnd = true;
                } else {
                    x2 = dim.x - 60;
                }
                int y1 = range.mY + 20 + 2 - TimeLineView.this.mScrollOffsetY;
                if (x2 - x1 < 3) {
                    int width = x2 - x1;
                    if (width < 2) {
                        width = 2;
                    }
                    gc.fillRectangle(x1, y1, width, height);
                    continue;
                }
                if (drawLeftEnd) {
                    if (drawRightEnd) {
                        points = new int[]{x1, y1, x1, y1 + height, x2, y1 + height, x2, y1};
                        gc.drawPolyline(points);
                    } else {
                        points = new int[]{x1, y1, x1, y1 + height, x2, y1 + height};
                        gc.drawPolyline(points);
                    }
                } else if (drawRightEnd) {
                    points = new int[]{x1, y1 + height, x2, y1 + height, x2, y1};
                    gc.drawPolyline(points);
                } else {
                    points = new int[]{x1, y1 + height, x2, y1 + height};
                    gc.drawPolyline(points);
                }
                if (!drawLeftEnd) {
                    points = new int[]{x1 + 7, y1 + height - 4, x1, y1 + height, x1 + 7, y1 + height + 4};
                    gc.fillPolygon(points);
                }
                if (drawRightEnd) continue;
                points = new int[]{x2 - 7, y1 + height - 4, x2, y1 + height, x2 - 7, y1 + height + 4};
                gc.fillPolygon(points);
            }
        }

        private boolean drawingSelection() {
            return this.mGraphicsState == GraphicsState.Marking || this.mGraphicsState == GraphicsState.Animating;
        }

        private void drawSelection(Display display, GC gc) {
            int width;
            int x;
            int mouseX;
            Point dim = this.getSize();
            gc.setForeground(TimeLineView.this.mColorGray);
            gc.drawLine(this.mMouseMarkStartX, 0, this.mMouseMarkStartX, dim.y);
            gc.setBackground(TimeLineView.this.mColorZoomSelection);
            int n = mouseX = this.mGraphicsState == GraphicsState.Animating ? this.mMouseMarkEndX : this.mMouse.x;
            if (this.mMouseMarkStartX < mouseX) {
                x = this.mMouseMarkStartX;
                width = mouseX - this.mMouseMarkStartX;
            } else {
                x = mouseX;
                width = this.mMouseMarkStartX - mouseX;
            }
            gc.fillRectangle(x, 0, width, dim.y);
        }

        private void computeStrips() {
            Color color;
            int ii;
            double minVal = TimeLineView.this.mScaleInfo.getMinVal();
            double maxVal = TimeLineView.this.mScaleInfo.getMaxVal();
            Pixel[] pixels = new Pixel[TimeLineView.this.mNumRows];
            for (ii = 0; ii < TimeLineView.this.mNumRows; ++ii) {
                pixels[ii] = new Pixel();
            }
            for (ii = 0; ii < TimeLineView.this.mSegments.length; ++ii) {
                TimeLineView.this.mSegments[ii].mBlock.clearWeight();
            }
            this.mStripList.clear();
            this.mHighlightExclusive.clear();
            this.mHighlightInclusive.clear();
            MethodData callMethod = null;
            long callStart = 0L;
            long callEnd = -1L;
            RowData callRowData = null;
            int prevMethodStart = -1;
            int prevCallStart = -1;
            if (TimeLineView.this.mHighlightCall != null) {
                int callPixelStart = -1;
                int callPixelEnd = -1;
                callStart = ((TimeLineView)TimeLineView.this).mHighlightCall.mGlobalStartTime;
                callEnd = ((TimeLineView)TimeLineView.this).mHighlightCall.mGlobalEndTime;
                callMethod = ((TimeLineView)TimeLineView.this).mHighlightCall.mMethodData;
                if ((double)callStart >= minVal) {
                    callPixelStart = TimeLineView.this.mScaleInfo.valueToPixel(callStart);
                }
                if ((double)callEnd <= maxVal) {
                    callPixelEnd = TimeLineView.this.mScaleInfo.valueToPixel(callEnd);
                }
                int threadId = TimeLineView.this.mHighlightCall.getThreadId();
                String threadName = (String)TimeLineView.this.mThreadLabels.get(threadId);
                callRowData = (RowData)TimeLineView.this.mRowByName.get(threadName);
                int y1 = callRowData.mRank * 32 + 6;
                color = callMethod.getColor();
                this.mHighlightInclusive.add(new Range(callPixelStart + 10, callPixelEnd + 10, y1, color));
            }
            for (Segment segment : TimeLineView.this.mSegments) {
                double recordEnd;
                double recordStart;
                Block block;
                if ((double)segment.mEndTime <= minVal || (double)segment.mStartTime >= maxVal || (color = (block = segment.mBlock).getColor()) == null || (recordStart = Math.max((double)segment.mStartTime, minVal)) == (recordEnd = Math.min((double)segment.mEndTime, maxVal))) continue;
                int pixelStart = TimeLineView.this.mScaleInfo.valueToPixel(recordStart);
                int pixelEnd = TimeLineView.this.mScaleInfo.valueToPixel(recordEnd);
                int width = pixelEnd - pixelStart;
                RowData rd = segment.mRowData;
                MethodData md = block.getMethodData();
                int y1 = rd.mRank * 32 + 6;
                if (rd.mRank > TimeLineView.this.mEndRow) break;
                if (TimeLineView.this.mHighlightMethodData != null) {
                    if (TimeLineView.this.mHighlightMethodData == md) {
                        if (prevMethodStart != pixelStart) {
                            prevMethodStart = pixelStart;
                            int rangeWidth = width;
                            if (rangeWidth == 0) {
                                rangeWidth = 1;
                            }
                            this.mHighlightExclusive.add(new Range(pixelStart + 10, rangeWidth, y1, color));
                            Call call = (Call)block;
                            callStart = call.mGlobalStartTime;
                            int callPixelStart = -1;
                            if ((double)callStart >= minVal) {
                                callPixelStart = TimeLineView.this.mScaleInfo.valueToPixel(callStart);
                            }
                            if (prevCallStart != callPixelStart) {
                                prevCallStart = callPixelStart;
                                int callPixelEnd = -1;
                                callEnd = call.mGlobalEndTime;
                                if ((double)callEnd <= maxVal) {
                                    callPixelEnd = TimeLineView.this.mScaleInfo.valueToPixel(callEnd);
                                }
                                this.mHighlightInclusive.add(new Range(callPixelStart + 10, callPixelEnd + 10, y1, color));
                            }
                        }
                    } else if (this.mFadeColors) {
                        color = md.getFadedColor();
                    }
                } else if (TimeLineView.this.mHighlightCall != null) {
                    if (segment.mStartTime >= callStart && segment.mEndTime <= callEnd && callMethod == md && callRowData == rd) {
                        if (prevMethodStart != pixelStart) {
                            prevMethodStart = pixelStart;
                            int rangeWidth = width;
                            if (rangeWidth == 0) {
                                rangeWidth = 1;
                            }
                            this.mHighlightExclusive.add(new Range(pixelStart + 10, rangeWidth, y1, color));
                        }
                    } else if (this.mFadeColors) {
                        color = md.getFadedColor();
                    }
                }
                Pixel pix = pixels[rd.mRank];
                if (pix.mStart != pixelStart) {
                    if (pix.mSegment != null) {
                        this.emitPixelStrip(rd, y1, pix);
                    }
                    if (width == 0) {
                        double weight = this.computeWeight(recordStart, recordEnd, pixelStart);
                        weight = block.addWeight(pixelStart, rd.mRank, weight);
                        if (!(weight > pix.mMaxWeight)) continue;
                        pix.setFields(pixelStart, weight, segment, color, rd);
                        continue;
                    }
                    int x1 = pixelStart + 10;
                    Strip strip = new Strip(x1, y1, width, 20, rd, segment, color);
                    this.mStripList.add(strip);
                    continue;
                }
                double weight = this.computeWeight(recordStart, recordEnd, pixelStart);
                weight = block.addWeight(pixelStart, rd.mRank, weight);
                if (weight > pix.mMaxWeight) {
                    pix.setFields(pixelStart, weight, segment, color, rd);
                }
                if (width == 1) {
                    this.emitPixelStrip(rd, y1, pix);
                    weight = this.computeWeight(recordStart, recordEnd, ++pixelStart);
                    weight = block.addWeight(pixelStart, rd.mRank, weight);
                    pix.setFields(pixelStart, weight, segment, color, rd);
                    continue;
                }
                if (width <= 1) continue;
                this.emitPixelStrip(rd, y1, pix);
                int x1 = ++pixelStart + 10;
                Strip strip = new Strip(x1, y1, --width, 20, rd, segment, color);
                this.mStripList.add(strip);
            }
            for (int ii2 = 0; ii2 < TimeLineView.this.mNumRows; ++ii2) {
                Pixel pix = pixels[ii2];
                if (pix.mSegment == null) continue;
                RowData rd = pix.mRowData;
                int y1 = rd.mRank * 32 + 6;
                this.emitPixelStrip(rd, y1, pix);
            }
        }

        private double computeWeight(double start, double end, int pixel) {
            double pixelStartFraction = TimeLineView.this.mScaleInfo.valueToPixelFraction(start);
            double pixelEndFraction = TimeLineView.this.mScaleInfo.valueToPixelFraction(end);
            double leftEndPoint = Math.max(pixelStartFraction, (double)pixel - 0.5);
            double rightEndPoint = Math.min(pixelEndFraction, (double)pixel + 0.5);
            double weight = rightEndPoint - leftEndPoint;
            return weight;
        }

        private void emitPixelStrip(RowData rd, int y, Pixel pixel) {
            Strip strip;
            int remainder;
            if (pixel.mSegment == null) {
                return;
            }
            int x = pixel.mStart + 10;
            int height = (int)(pixel.mMaxWeight * 20.0 * 0.75);
            if (height < this.mMinStripHeight) {
                height = this.mMinStripHeight;
            }
            if ((remainder = 20 - height) > 0) {
                strip = new Strip(x, y, 1, remainder, rd, pixel.mSegment, this.mFadeColors ? TimeLineView.this.mColorGray : TimeLineView.this.mColorBlack);
                this.mStripList.add(strip);
            }
            strip = new Strip(x, y + remainder, 1, height, rd, pixel.mSegment, pixel.mColor);
            this.mStripList.add(strip);
            pixel.mSegment = null;
            pixel.mMaxWeight = 0.0;
        }

        private void mouseMove(MouseEvent me) {
            Point dim = TimeLineView.this.mSurface.getSize();
            int x = me.x;
            if (x < 10) {
                x = 10;
            }
            if (x > dim.x - 60) {
                x = dim.x - 60;
            }
            this.mMouse.x = x;
            this.mMouse.y = me.y;
            TimeLineView.this.mTimescale.setVbarPosition(x);
            if (this.mGraphicsState == GraphicsState.Marking) {
                TimeLineView.this.mTimescale.setMarkEnd(x);
            }
            if (this.mGraphicsState == GraphicsState.Normal) {
                TimeLineView.this.mSurface.setCursor(this.mNormalCursor);
            } else if (this.mGraphicsState == GraphicsState.Marking) {
                if (this.mMouse.x >= this.mMouseMarkStartX) {
                    TimeLineView.this.mSurface.setCursor(this.mIncreasingCursor);
                } else {
                    TimeLineView.this.mSurface.setCursor(this.mDecreasingCursor);
                }
            }
            int rownum = (this.mMouse.y + TimeLineView.this.mScrollOffsetY) / 32;
            if (me.y < 0 || me.y >= dim.y) {
                rownum = -1;
            }
            if (TimeLineView.this.mMouseRow != rownum) {
                TimeLineView.this.mMouseRow = rownum;
                TimeLineView.this.mLabels.redraw();
            }
            this.redraw();
        }

        private void mouseDown(MouseEvent me) {
            Point dim = TimeLineView.this.mSurface.getSize();
            int x = me.x;
            if (x < 10) {
                x = 10;
            }
            if (x > dim.x - 60) {
                x = dim.x - 60;
            }
            this.mMouseMarkStartX = x;
            this.mGraphicsState = GraphicsState.Marking;
            TimeLineView.this.mSurface.setCursor(this.mIncreasingCursor);
            TimeLineView.this.mTimescale.setMarkStart(this.mMouseMarkStartX);
            TimeLineView.this.mTimescale.setMarkEnd(this.mMouseMarkStartX);
            this.redraw();
        }

        private void mouseUp(MouseEvent me) {
            TimeLineView.this.mSurface.setCursor(this.mNormalCursor);
            if (this.mGraphicsState != GraphicsState.Marking) {
                this.mGraphicsState = GraphicsState.Normal;
                return;
            }
            this.mGraphicsState = GraphicsState.Animating;
            Point dim = TimeLineView.this.mSurface.getSize();
            if (me.y <= 0 || me.y >= dim.y) {
                this.mGraphicsState = GraphicsState.Normal;
                this.redraw();
                return;
            }
            int x = me.x;
            if (x < 10) {
                x = 10;
            }
            if (x > dim.x - 60) {
                x = dim.x - 60;
            }
            this.mMouseMarkEndX = x;
            int dist = this.mMouseMarkEndX - this.mMouseMarkStartX;
            if (dist < 0) {
                dist = -dist;
            }
            if (dist <= 2) {
                this.mGraphicsState = GraphicsState.Normal;
                this.mMouseSelect.x = this.mMouseMarkStartX;
                this.mMouseSelect.y = me.y;
                this.redraw();
                return;
            }
            if (this.mMouseMarkEndX < this.mMouseMarkStartX) {
                int temp = this.mMouseMarkEndX;
                this.mMouseMarkEndX = this.mMouseMarkStartX;
                this.mMouseMarkStartX = temp;
            }
            if (this.mMouseMarkStartX <= 20 && this.mMouseMarkEndX >= dim.x - 60 - 10) {
                this.mGraphicsState = GraphicsState.Normal;
                this.redraw();
                return;
            }
            double minVal = TimeLineView.this.mScaleInfo.getMinVal();
            double maxVal = TimeLineView.this.mScaleInfo.getMaxVal();
            double ppr = TimeLineView.this.mScaleInfo.getPixelsPerRange();
            this.mZoomMin = minVal + (double)(this.mMouseMarkStartX - 10) / ppr;
            this.mZoomMax = minVal + (double)(this.mMouseMarkEndX - 10) / ppr;
            if (this.mZoomMin < this.mMinDataVal) {
                this.mZoomMin = this.mMinDataVal;
            }
            if (this.mZoomMax > this.mMaxDataVal) {
                this.mZoomMax = this.mMaxDataVal;
            }
            int xdim = dim.x - 70;
            TickScaler scaler = new TickScaler(this.mZoomMin, this.mZoomMax, xdim, 50);
            scaler.computeTicks(false);
            this.mZoomMin = scaler.getMinVal();
            this.mZoomMax = scaler.getMaxVal();
            this.mMouseMarkStartX = (int)((this.mZoomMin - minVal) * ppr + 10.0);
            this.mMouseMarkEndX = (int)((this.mZoomMax - minVal) * ppr + 10.0);
            TimeLineView.this.mTimescale.setMarkStart(this.mMouseMarkStartX);
            TimeLineView.this.mTimescale.setMarkEnd(this.mMouseMarkEndX);
            this.mMouseEndDistance = dim.x - 60 - this.mMouseMarkEndX;
            this.mMouseStartDistance = this.mMouseMarkStartX - 10;
            this.mZoomMouseStart = this.mMouseMarkStartX;
            this.mZoomMouseEnd = this.mMouseMarkEndX;
            this.mZoomStep = 0;
            this.mMin2ZoomMin = this.mZoomMin - minVal;
            this.mZoomMax2Max = maxVal - this.mZoomMax;
            this.mZoomFixed = this.mZoomMin + (this.mZoomMax - this.mZoomMin) * this.mMin2ZoomMin / (this.mMin2ZoomMin + this.mZoomMax2Max);
            this.mZoomFixedPixel = (this.mZoomFixed - minVal) * ppr + 10.0;
            this.mFixedPixelStartDistance = this.mZoomFixedPixel - 10.0;
            this.mFixedPixelEndDistance = (double)(dim.x - 60) - this.mZoomFixedPixel;
            this.mZoomMin2Fixed = this.mZoomFixed - this.mZoomMin;
            this.mFixed2ZoomMax = this.mZoomMax - this.mZoomFixed;
            this.getDisplay().timerExec(10, this.mZoomAnimator);
            this.redraw();
            this.update();
        }

        private void mouseDoubleClick(MouseEvent me) {
        }

        public void startScaling(int mouseX) {
            Point dim = TimeLineView.this.mSurface.getSize();
            int x = mouseX;
            if (x < 10) {
                x = 10;
            }
            if (x > dim.x - 60) {
                x = dim.x - 60;
            }
            this.mMouseMarkStartX = x;
            this.mGraphicsState = GraphicsState.Scaling;
            this.mScalePixelsPerRange = TimeLineView.this.mScaleInfo.getPixelsPerRange();
            this.mScaleMinVal = TimeLineView.this.mScaleInfo.getMinVal();
            this.mScaleMaxVal = TimeLineView.this.mScaleInfo.getMaxVal();
        }

        public void stopScaling(int mouseX) {
            this.mGraphicsState = GraphicsState.Normal;
        }

        private void animateHighlight() {
            ++this.mHighlightStep;
            if (this.mHighlightStep >= this.HIGHLIGHT_STEPS) {
                this.mFadeColors = false;
                this.mHighlightStep = 0;
                this.mCachedEndRow = -1;
            } else {
                this.mFadeColors = true;
                this.mShowHighlightName = true;
                this.highlightHeight = this.highlightHeights[this.mHighlightStep];
                this.getDisplay().timerExec(50, this.mHighlightAnimator);
            }
            this.redraw();
        }

        private void clearHighlights() {
            this.mShowHighlightName = false;
            this.highlightHeight = 0;
            TimeLineView.this.mHighlightMethodData = null;
            TimeLineView.this.mHighlightCall = null;
            this.mFadeColors = false;
            this.mHighlightStep = 0;
            this.mCachedEndRow = -1;
            this.redraw();
        }

        private void animateZoom() {
            ++this.mZoomStep;
            if (this.mZoomStep > 8) {
                this.mGraphicsState = GraphicsState.Normal;
                this.mCachedMinVal = TimeLineView.this.mScaleInfo.getMinVal() + 1.0;
            } else if (this.mZoomStep == 8) {
                TimeLineView.this.mScaleInfo.setMinVal(this.mZoomMin);
                TimeLineView.this.mScaleInfo.setMaxVal(this.mZoomMax);
                this.mMouseMarkStartX = 10;
                Point dim = this.getSize();
                this.mMouseMarkEndX = dim.x - 60;
                TimeLineView.this.mTimescale.setMarkStart(this.mMouseMarkStartX);
                TimeLineView.this.mTimescale.setMarkEnd(this.mMouseMarkEndX);
                this.getDisplay().timerExec(10, this.mZoomAnimator);
            } else {
                double fraction = this.mZoomFractions[this.mZoomStep];
                this.mMouseMarkStartX = (int)((double)this.mZoomMouseStart - fraction * (double)this.mMouseStartDistance);
                this.mMouseMarkEndX = (int)((double)this.mZoomMouseEnd + fraction * (double)this.mMouseEndDistance);
                TimeLineView.this.mTimescale.setMarkStart(this.mMouseMarkStartX);
                TimeLineView.this.mTimescale.setMarkEnd(this.mMouseMarkEndX);
                double ppr = this.mZoomMin2Fixed >= this.mFixed2ZoomMax ? (this.mZoomFixedPixel - (double)this.mMouseMarkStartX) / this.mZoomMin2Fixed : ((double)this.mMouseMarkEndX - this.mZoomFixedPixel) / this.mFixed2ZoomMax;
                double newMin = this.mZoomFixed - this.mFixedPixelStartDistance / ppr;
                double newMax = this.mZoomFixed + this.mFixedPixelEndDistance / ppr;
                TimeLineView.this.mScaleInfo.setMinVal(newMin);
                TimeLineView.this.mScaleInfo.setMaxVal(newMax);
                this.getDisplay().timerExec(10, this.mZoomAnimator);
            }
            this.redraw();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum GraphicsState {
        Normal,
        Marking,
        Scaling,
        Animating;

    }

    private class Timescale
    extends Canvas {
        private Point mMouse;
        private Cursor mZoomCursor;
        private String mMethodName;
        private Color mMethodColor;
        private int mMethodStartY;
        private int mMarkStartX;
        private int mMarkEndX;
        private static final int METHOD_BLOCK_MARGIN = 10;

        public Timescale(Composite parent) {
            super(parent, 0);
            this.mMouse = new Point(10, 0);
            this.mMethodName = null;
            this.mMethodColor = null;
            Display display = this.getDisplay();
            this.mZoomCursor = new Cursor((Device)display, 9);
            this.setCursor(this.mZoomCursor);
            this.mMethodStartY = TimeLineView.this.mSmallFontHeight + 1;
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent pe) {
                    Timescale.this.draw(pe.display, pe.gc);
                }
            });
        }

        public void setVbarPosition(int x) {
            this.mMouse.x = x;
        }

        public void setMarkStart(int x) {
            this.mMarkStartX = x;
        }

        public void setMarkEnd(int x) {
            this.mMarkEndX = x;
        }

        public void setMethodName(String name) {
            this.mMethodName = name;
        }

        public void setMethodColor(Color color) {
            this.mMethodColor = color;
        }

        private void mouseMove(MouseEvent me) {
            me.y = -1;
            TimeLineView.this.mSurface.mouseMove(me);
        }

        private void mouseDown(MouseEvent me) {
            TimeLineView.this.mSurface.startScaling(me.x);
            TimeLineView.this.mSurface.redraw();
        }

        private void mouseUp(MouseEvent me) {
            TimeLineView.this.mSurface.stopScaling(me.x);
        }

        private void mouseDoubleClick(MouseEvent me) {
            TimeLineView.this.mSurface.resetScale();
            TimeLineView.this.mSurface.redraw();
        }

        private void draw(Display display, GC gc) {
            Point dim = this.getSize();
            Image image = new Image((Device)display, this.getBounds());
            GC gcImage = new GC((Drawable)image);
            if (TimeLineView.this.mSetFonts) {
                gcImage.setFont(TimeLineView.this.mFontRegistry.get("medium"));
            }
            if (TimeLineView.this.mSurface.drawingSelection()) {
                this.drawSelection(display, gcImage);
            }
            this.drawTicks(display, gcImage);
            gcImage.setForeground(TimeLineView.this.mColorDarkGray);
            gcImage.drawLine(this.mMouse.x, 38, this.mMouse.x, dim.y);
            this.drawTickLegend(display, gcImage);
            this.drawMethod(display, gcImage);
            gc.drawImage(image, 0, 0);
            image.dispose();
            gcImage.dispose();
        }

        private void drawSelection(Display display, GC gc) {
            int width;
            int x;
            Point dim = this.getSize();
            gc.setForeground(TimeLineView.this.mColorGray);
            gc.drawLine(this.mMarkStartX, 38, this.mMarkStartX, dim.y);
            gc.setBackground(TimeLineView.this.mColorZoomSelection);
            if (this.mMarkStartX < this.mMarkEndX) {
                x = this.mMarkStartX;
                width = this.mMarkEndX - this.mMarkStartX;
            } else {
                x = this.mMarkEndX;
                width = this.mMarkStartX - this.mMarkEndX;
            }
            if (width > 1) {
                gc.fillRectangle(x, 38, width, dim.y);
            }
        }

        private void drawTickLegend(Display display, GC gc) {
            int mouseX = this.mMouse.x - 10;
            double mouseXval = TimeLineView.this.mScaleInfo.pixelToValue(mouseX);
            String info = TimeLineView.this.mUnits.labelledString(mouseXval);
            gc.setForeground(TimeLineView.this.mColorForeground);
            gc.drawString(info, 12, 1, true);
            double maxVal = TimeLineView.this.mScaleInfo.getMaxVal();
            info = TimeLineView.this.mUnits.labelledString(maxVal);
            info = String.format(" max %s ", info);
            Point extent = gc.stringExtent(info);
            Point dim = this.getSize();
            int x1 = dim.x - 60 - extent.x;
            gc.drawString(info, x1, 1, true);
        }

        private void drawMethod(Display display, GC gc) {
            if (this.mMethodName == null) {
                return;
            }
            int x1 = 10;
            int y1 = this.mMethodStartY;
            gc.setBackground(this.mMethodColor);
            int width = 2 * TimeLineView.this.mSmallFontWidth;
            gc.fillRectangle(x1, y1, width, TimeLineView.this.mSmallFontHeight);
            gc.drawString(this.mMethodName, x1 += width + 10, y1, true);
        }

        private void drawTicks(Display display, GC gc) {
            Point dim = this.getSize();
            int y2 = 46;
            int y3 = 42;
            int y4 = y2 + 2;
            gc.setForeground(TimeLineView.this.mColorForeground);
            gc.drawLine(10, 38, dim.x - 60, 38);
            double minVal = TimeLineView.this.mScaleInfo.getMinVal();
            double maxVal = TimeLineView.this.mScaleInfo.getMaxVal();
            double minMajorTick = TimeLineView.this.mScaleInfo.getMinMajorTick();
            double tickIncrement = TimeLineView.this.mScaleInfo.getTickIncrement();
            double minorTickIncrement = tickIncrement / 5.0;
            double pixelsPerRange = TimeLineView.this.mScaleInfo.getPixelsPerRange();
            if (minVal < minMajorTick) {
                gc.setForeground(TimeLineView.this.mColorGray);
                double xMinor = minMajorTick;
                for (int ii = 1; ii <= 4 && !((xMinor -= minorTickIncrement) < minVal); ++ii) {
                    int x1 = 10 + (int)(0.5 + (xMinor - minVal) * pixelsPerRange);
                    gc.drawLine(x1, 38, x1, y3);
                }
            }
            if (tickIncrement <= 10.0) {
                return;
            }
            for (double x = minMajorTick; x <= maxVal; x += tickIncrement) {
                int x1 = 10 + (int)(0.5 + (x - minVal) * pixelsPerRange);
                gc.setForeground(TimeLineView.this.mColorForeground);
                gc.drawLine(x1, 38, x1, y2);
                if (x > maxVal) break;
                String tickString = TimeLineView.this.mUnits.valueOf(x);
                gc.drawString(tickString, x1, y4, true);
                gc.setForeground(TimeLineView.this.mColorGray);
                double xMinor = x;
                for (int ii = 1; ii <= 4 && !((xMinor += minorTickIncrement) > maxVal); ++ii) {
                    x1 = 10 + (int)(0.5 + (xMinor - minVal) * pixelsPerRange);
                    gc.drawLine(x1, 38, x1, y3);
                }
            }
        }
    }

    private class BlankCorner
    extends Canvas {
        public BlankCorner(Composite parent) {
            super(parent, 0);
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent pe) {
                    BlankCorner.this.draw(pe.display, pe.gc);
                }
            });
        }

        private void draw(Display display, GC gc) {
            Image image = new Image((Device)display, this.getBounds());
            gc.drawImage(image, 0, 0);
            image.dispose();
        }
    }

    private class RowLabels
    extends Canvas {
        private static final int labelMarginX = 2;

        public RowLabels(Composite parent) {
            super(parent, 262144);
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent pe) {
                    RowLabels.this.draw(pe.display, pe.gc);
                }
            });
        }

        private void mouseMove(MouseEvent me) {
            int rownum = (me.y + TimeLineView.this.mScrollOffsetY) / 32;
            if (TimeLineView.this.mMouseRow != rownum) {
                TimeLineView.this.mMouseRow = rownum;
                this.redraw();
                TimeLineView.this.mSurface.redraw();
            }
        }

        private void draw(Display display, GC gc) {
            if (TimeLineView.this.mSegments.length == 0) {
                return;
            }
            Point dim = this.getSize();
            Image image = new Image((Device)display, this.getBounds());
            GC gcImage = new GC((Drawable)image);
            if (TimeLineView.this.mSetFonts) {
                gcImage.setFont(TimeLineView.this.mFontRegistry.get("medium"));
            }
            if (TimeLineView.this.mNumRows > 2) {
                gcImage.setBackground(TimeLineView.this.mColorRowBack);
                for (int ii = 1; ii < TimeLineView.this.mNumRows; ii += 2) {
                    RowData rd = TimeLineView.this.mRows[ii];
                    int y1 = rd.mRank * 32 - TimeLineView.this.mScrollOffsetY;
                    gcImage.fillRectangle(0, y1, dim.x, 32);
                }
            }
            int offsetY = 6 - TimeLineView.this.mScrollOffsetY;
            for (int ii = TimeLineView.this.mStartRow; ii <= TimeLineView.this.mEndRow; ++ii) {
                RowData rd = TimeLineView.this.mRows[ii];
                int y1 = rd.mRank * 32 + offsetY;
                Point extent = gcImage.stringExtent(rd.mName);
                int x1 = dim.x - extent.x - 2;
                gcImage.drawString(rd.mName, x1, y1, true);
            }
            if (TimeLineView.this.mMouseRow >= TimeLineView.this.mStartRow && TimeLineView.this.mMouseRow <= TimeLineView.this.mEndRow) {
                gcImage.setForeground(TimeLineView.this.mColorGray);
                int y1 = TimeLineView.this.mMouseRow * 32 - TimeLineView.this.mScrollOffsetY;
                gcImage.drawRectangle(0, y1, dim.x, 32);
            }
            gc.drawImage(image, 0, 0);
            image.dispose();
            gcImage.dispose();
        }
    }

    public static class Record {
        Row row;
        Block block;

        public Record(Row row, Block block) {
            this.row = row;
            this.block = block;
        }
    }

    public static interface Row {
        public int getId();

        public String getName();
    }

    public static interface Block {
        public String getName();

        public MethodData getMethodData();

        public long getStartTime();

        public long getEndTime();

        public Color getColor();

        public double addWeight(int var1, int var2, double var3);

        public void clearWeight();
    }
}

