/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.handler;

import com.android.ddmlib.SyncService;
import com.android.ddmuilib.SyncProgressMonitor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public abstract class BaseFileHandler {
    protected final Shell mParentShell;

    public BaseFileHandler(Shell parentShell) {
        this.mParentShell = parentShell;
    }

    protected abstract String getDialogTitle();

    protected SyncService.SyncResult promptAndPull(SyncService sync, String localFileName, String remoteFilePath, String title) throws InvocationTargetException, InterruptedException {
        FileDialog fileDialog = new FileDialog(this.mParentShell, 8192);
        fileDialog.setText(title);
        fileDialog.setFileName(localFileName);
        String localFilePath = fileDialog.open();
        if (localFilePath != null) {
            return this.pull(sync, localFilePath, remoteFilePath);
        }
        return null;
    }

    protected boolean promptAndSave(String localFileName, byte[] data, String title) {
        FileDialog fileDialog = new FileDialog(this.mParentShell, 8192);
        fileDialog.setText(title);
        fileDialog.setFileName(localFileName);
        String localFilePath = fileDialog.open();
        if (localFilePath != null) {
            try {
                this.saveFile(data, new File(localFilePath));
                return true;
            }
            catch (IOException e) {
                String errorMsg = e.getMessage();
                this.displayErrorInUiThread("Failed to save file '%1$s'%2$s", localFilePath, errorMsg != null ? ":\n" + errorMsg : ".");
            }
        }
        return false;
    }

    protected SyncService.SyncResult pull(final SyncService sync, final String localFilePath, final String remoteFilePath) throws InvocationTargetException, InterruptedException {
        final SyncService.SyncResult[] res = new SyncService.SyncResult[1];
        new ProgressMonitorDialog(this.mParentShell).run(true, true, new IRunnableWithProgress(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(IProgressMonitor monitor) {
                try {
                    res[0] = sync.pullFile(remoteFilePath, localFilePath, (SyncService.ISyncProgressMonitor)new SyncProgressMonitor(monitor, String.format("Pulling %1$s from the device", remoteFilePath)));
                }
                finally {
                    sync.close();
                }
            }
        });
        return res[0];
    }

    protected void displayErrorInUiThread(final String format, final Object ... args) {
        this.mParentShell.getDisplay().asyncExec(new Runnable(){

            public void run() {
                MessageDialog.openError((Shell)BaseFileHandler.this.mParentShell, (String)BaseFileHandler.this.getDialogTitle(), (String)String.format(format, args));
            }
        });
    }

    protected void displayErrorFromUiThread(String format, Object ... args) {
        MessageDialog.openError((Shell)this.mParentShell, (String)this.getDialogTitle(), (String)String.format(format, args));
    }

    protected File saveTempFile(byte[] data) throws IOException {
        File f = File.createTempFile("ddms", null);
        this.saveFile(data, f);
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveFile(byte[] data, File output) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(output);
            fos.write(data);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }
}

