/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.Client;
import com.android.ddmlib.FileListingService;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.RawImage;
import com.android.ddmlib.SyncService;
import com.android.ddmlib.log.LogReceiver;
import java.io.IOException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface IDevice {
    public static final String PROP_BUILD_VERSION = "ro.build.version.release";
    public static final String PROP_BUILD_API_LEVEL = "ro.build.version.sdk";
    public static final String PROP_BUILD_CODENAME = "ro.build.version.codename";
    public static final String PROP_DEBUGGABLE = "ro.debuggable";
    public static final String FIRST_EMULATOR_SN = "emulator-5554";
    public static final int CHANGE_STATE = 1;
    public static final int CHANGE_CLIENT_LIST = 2;
    public static final int CHANGE_BUILD_INFO = 4;
    public static final String PROP_BUILD_VERSION_NUMBER = "ro.build.version.sdk";

    public String getSerialNumber();

    public String getAvdName();

    public DeviceState getState();

    public Map<String, String> getProperties();

    public int getPropertyCount();

    public String getProperty(String var1);

    public boolean isOnline();

    public boolean isEmulator();

    public boolean isOffline();

    public boolean isBootLoader();

    public boolean hasClients();

    public Client[] getClients();

    public Client getClient(String var1);

    public SyncService getSyncService() throws IOException;

    public FileListingService getFileListingService();

    public RawImage getScreenshot() throws IOException;

    public void executeShellCommand(String var1, IShellOutputReceiver var2) throws IOException;

    public void runEventLogService(LogReceiver var1) throws IOException;

    public void runLogService(String var1, LogReceiver var2) throws IOException;

    public boolean createForward(int var1, int var2);

    public boolean removeForward(int var1, int var2);

    public String getClientName(int var1);

    public String installPackage(String var1, boolean var2) throws IOException;

    public String syncPackageToDevice(String var1) throws IOException;

    public String installRemotePackage(String var1, boolean var2) throws IOException;

    public void removeRemotePackage(String var1) throws IOException;

    public String uninstallPackage(String var1) throws IOException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DeviceState {
        BOOTLOADER("bootloader"),
        OFFLINE("offline"),
        ONLINE("device");

        private String mState;

        private DeviceState(String state) {
            this.mState = state;
        }

        public static DeviceState getState(String state) {
            for (DeviceState deviceState : DeviceState.values()) {
                if (!deviceState.mState.equals(state)) continue;
                return deviceState;
            }
            return null;
        }
    }
}

