/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.report.html.doc;

import com.vladium.emma.report.html.doc.Attribute;
import com.vladium.emma.report.html.doc.HTMLWriter;
import com.vladium.emma.report.html.doc.IContent;
import com.vladium.util.Strings;
import java.util.HashMap;
import java.util.Map;

public abstract class AttributeSet
implements IContent {
    public static AttributeSet create() {
        return new AttributeSetImpl();
    }

    public abstract boolean isEmpty();

    public abstract AttributeSet set(Attribute var1, String var2);

    public abstract AttributeSet set(Attribute var1, int var2);

    AttributeSet() {
    }

    private static final class AttributeSetImpl
    extends AttributeSet {
        private final Map m_attrMap = new HashMap();
        private StringBuffer m_buf;
        private static final int MAX_BUF_LENGTH = 4096;

        public void emit(HTMLWriter out) {
            boolean first = true;
            for (Map.Entry entry : this.m_attrMap.entrySet()) {
                Attribute attr = (Attribute)entry.getKey();
                String value = entry.getValue().toString();
                if (first) {
                    first = false;
                } else {
                    out.write(' ');
                }
                out.write(attr.getName());
                out.write("=\"");
                if (this.m_buf != null && this.m_buf.length() <= 4096) {
                    this.m_buf.setLength(0);
                } else {
                    this.m_buf = new StringBuffer();
                }
                Strings.HTMLEscape(value, this.m_buf);
                out.write(this.m_buf.toString());
                out.write('\"');
            }
        }

        public boolean isEmpty() {
            return this.m_attrMap.isEmpty();
        }

        public AttributeSet set(Attribute attr, String value) {
            this.m_attrMap.put(attr, value);
            return this;
        }

        public AttributeSet set(Attribute attr, int value) {
            this.m_attrMap.put(attr, new Integer(value));
            return this;
        }

        AttributeSetImpl() {
        }
    }
}

