/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.repository;

import com.android.prefs.AndroidLocation;
import com.android.sdklib.ISdkLog;
import com.android.sdkuilib.internal.repository.ISettingsPage;
import com.android.sdkuilib.internal.repository.UpdaterData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class SettingsController {
    private static final String SETTINGS_FILENAME = "androidtool.cfg";
    private final Properties mProperties = new Properties();
    private ISettingsPage mSettingsPage;
    private final UpdaterData mUpdaterData;

    public SettingsController(UpdaterData updaterData) {
        this.mUpdaterData = updaterData;
    }

    public boolean getForceHttp() {
        return Boolean.parseBoolean(this.mProperties.getProperty("sdkman.force.http"));
    }

    public boolean getAskBeforeAdbRestart() {
        String value = this.mProperties.getProperty("sdkman.ask.adb.restart");
        if (value == null) {
            return true;
        }
        return Boolean.parseBoolean(value);
    }

    public boolean getShowUpdateOnly() {
        String value = this.mProperties.getProperty("sdkman.show.update.only");
        if (value == null) {
            return true;
        }
        return Boolean.parseBoolean(value);
    }

    public void setShowUpdateOnly(boolean enabled) {
        this.setSetting("sdkman.show.update.only", enabled);
    }

    public int getMonitorDensity() {
        String value = this.mProperties.getProperty("sdkman.monitor.density", null);
        if (value == null) {
            return -1;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public void setMonitorDensity(int density) {
        this.mProperties.setProperty("sdkman.monitor.density", Integer.toString(density));
    }

    private void setSetting(String key, boolean value) {
        this.mProperties.setProperty(key, Boolean.toString(value));
    }

    public void setSettingsPage(ISettingsPage settingsPage) {
        this.mSettingsPage = settingsPage;
        this.mSettingsPage.loadSettings(this.mProperties);
        settingsPage.setOnSettingsChanged(new ISettingsPage.SettingsChangedCallback(){

            public void onSettingsChanged(ISettingsPage page) {
                SettingsController.this.onSettingsChanged();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadSettings() {
        FileInputStream fis = null;
        String path = null;
        try {
            String folder = AndroidLocation.getFolder();
            File f = new File(folder, SETTINGS_FILENAME);
            path = f.getPath();
            if (f.exists()) {
                fis = new FileInputStream(f);
                this.mProperties.load(fis);
                this.setShowUpdateOnly(this.getShowUpdateOnly());
                this.setSetting("sdkman.ask.adb.restart", this.getAskBeforeAdbRestart());
            }
        }
        catch (Exception e) {
            ISdkLog log = this.mUpdaterData.getSdkLog();
            if (log != null) {
                log.error((Throwable)e, "Failed to load settings from '%1$s'", new Object[]{path});
            }
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSettings() {
        FileOutputStream fos = null;
        String path = null;
        try {
            String folder = AndroidLocation.getFolder();
            File f = new File(folder, SETTINGS_FILENAME);
            path = f.getPath();
            fos = new FileOutputStream(f);
            this.mProperties.store(fos, "## Settings for Android Tool");
        }
        catch (Exception e) {
            ISdkLog log = this.mUpdaterData.getSdkLog();
            if (log != null) {
                log.error((Throwable)e, "Failed to save settings at '%1$s'", new Object[]{path});
            }
            String reason = null;
            reason = e instanceof FileNotFoundException ? "File not found" : (e instanceof AndroidLocation.AndroidLocationException ? ".android folder not found, please define ANDROID_SDK_HOME" : (e.getMessage() != null ? String.format("%1$s: %2$s", e.getClass().getSimpleName(), e.getMessage()) : e.getClass().getName()));
            MessageDialog.openInformation((Shell)this.mUpdaterData.getWindowShell(), (String)"SDK Manager Settings", (String)String.format("The Android SDK and AVD Manager failed to save its settings (%1$s) at %2$s", reason, path));
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void onSettingsChanged() {
        if (this.mSettingsPage == null) {
            return;
        }
        String oldHttpsSetting = this.mProperties.getProperty("sdkman.force.http", Boolean.FALSE.toString());
        this.mSettingsPage.retrieveSettings(this.mProperties);
        this.applySettings();
        this.saveSettings();
        String newHttpsSetting = this.mProperties.getProperty("sdkman.force.http", Boolean.FALSE.toString());
        if (!newHttpsSetting.equals(oldHttpsSetting)) {
            this.mUpdaterData.refreshSources(false);
        }
    }

    public void applySettings() {
        Properties props = System.getProperties();
        props.setProperty("http.proxyHost", this.mProperties.getProperty("http.proxyHost", ""));
        props.setProperty("http.proxyPort", this.mProperties.getProperty("http.proxyPort", ""));
    }
}

