/*
 * Decompiled with CFR 0.152.
 */
package com.android.ant;

import com.android.sdklib.internal.project.ApkConfigurationHelper;
import com.android.sdklib.internal.project.ApkSettings;
import com.android.sdklib.internal.project.ProjectProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.types.Path;

public final class AaptExecLoopTask
extends Task {
    private String mExecutable;
    private String mCommand;
    private String mManifest;
    private String mResources;
    private String mAssets;
    private String mAndroidJar;
    private String mOutFolder;
    private String mBaseName;
    private final ArrayList<NoCompress> mNoCompressList = new ArrayList();

    public void setExecutable(String executable) {
        this.mExecutable = executable;
    }

    public void setCommand(String command) {
        this.mCommand = command;
    }

    public void setManifest(Path manifest) {
        this.mManifest = manifest.toString();
    }

    public void setResources(Path resources) {
        this.mResources = resources.toString();
    }

    public void setAssets(Path assets) {
        this.mAssets = assets.toString();
    }

    public void setAndroidjar(Path androidJar) {
        this.mAndroidJar = androidJar.toString();
    }

    public void setOutfolder(Path outFolder) {
        this.mOutFolder = outFolder.toString();
    }

    public void setBasename(String baseName) {
        this.mBaseName = baseName;
    }

    public Object createNocompress() {
        NoCompress nc = new NoCompress();
        this.mNoCompressList.add(nc);
        return nc;
    }

    public void execute() throws BuildException {
        Map apkFilters;
        Project taskProject = this.getProject();
        this.createPackage(null, null);
        File baseDir = taskProject.getBaseDir();
        ProjectProperties properties = ProjectProperties.load((String)baseDir.getAbsolutePath(), (ProjectProperties.PropertyType)ProjectProperties.PropertyType.DEFAULT);
        ApkSettings apkSettings = ApkConfigurationHelper.getSettings((ProjectProperties)properties);
        if (apkSettings != null && (apkFilters = apkSettings.getResourceFilters()).size() > 0) {
            for (Map.Entry entry : apkFilters.entrySet()) {
                this.createPackage((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    private void createPackage(String configName, String resourceFilter) {
        File assets;
        Project taskProject = this.getProject();
        if (configName == null || resourceFilter == null) {
            System.out.println("Creating full resource package...");
        } else {
            System.out.println(String.format("Creating resource package for config '%1$s' (%2$s)...", configName, resourceFilter));
        }
        ExecTask task = new ExecTask();
        task.setExecutable(this.mExecutable);
        task.setFailonerror(true);
        task.createArg().setValue(this.mCommand);
        task.createArg().setValue("-f");
        if (configName != null && resourceFilter != null) {
            task.createArg().setValue("-c");
            task.createArg().setValue(resourceFilter);
        }
        boolean compressNothing = false;
        for (NoCompress nc : this.mNoCompressList) {
            if (nc.mExtension != null) continue;
            task.createArg().setValue("-0");
            task.createArg().setValue("");
            compressNothing = true;
            break;
        }
        if (!compressNothing) {
            for (NoCompress nc : this.mNoCompressList) {
                task.createArg().setValue("-0");
                task.createArg().setValue(nc.mExtension);
            }
        }
        task.createArg().setValue("-M");
        task.createArg().setValue(this.mManifest);
        File res = new File(this.mResources);
        if (res.isDirectory()) {
            task.createArg().setValue("-S");
            task.createArg().setValue(this.mResources);
        }
        if ((assets = new File(this.mAssets)).isDirectory()) {
            task.createArg().setValue("-A");
            task.createArg().setValue(this.mAssets);
        }
        task.createArg().setValue("-I");
        task.createArg().setValue(this.mAndroidJar);
        String filename = configName != null && resourceFilter != null ? this.mBaseName + "-" + configName + ".ap_" : this.mBaseName + ".ap_";
        File file = new File(this.mOutFolder, filename);
        task.createArg().setValue("-F");
        task.createArg().setValue(file.getAbsolutePath());
        task.setProject(taskProject);
        task.setOwningTarget(this.getOwningTarget());
        task.execute();
    }

    public static final class NoCompress {
        String mExtension;

        public void setExtension(String extention) {
            this.mExtension = extention;
        }
    }
}

